#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include <windows.h>

#define	ASK 0L
#define TELL 1L


#define CPU_IRQ_CALLBACK		0x000
#define CPU_IO_HANDLER			0x001
#define CPU_CYCLE_COUNT			0x002
#define CPU_REG_PC				0x003
#define CPU_REG_SP				0x004
#define CPU_BREAKPOINT			0x005
#define CPU_SPEED				0x006
#define CPU_INPB_CALLBACK		0x007
#define CPU_OUTPB_CALLBACK		0x008
#define CPU_CYCLE_SCALING		0x009
#define CPU_REG					0x00A
#define CPU_CYCLE_PTR			0x00B
#define CPU_ENABLE_IRQ			0x00C
#define CPU_DMA_CALLBACK		0x013

#define MMU_READ_BYTE_CALLBACK	0x100
#define MMU_READ_WORD_CALLBACK	0x101
#define MMU_WRITE_BYTE_CALLBACK	0x102
#define MMU_WRITE_WORD_CALLBACK	0x103
#define MMU_TRANSLATE_ADDRESS_CALLBACK	0x104
#define MMU_MAP_PORT			0x105
#define MMU_READ_DWORD_CALLBACK	0x106
#define MMU_WRITE_DWORD_CALLBACK 0x107
#define MMU_MAP_MEMORY			0x108
#define MMU_GET_CALLBACK		0x109
#define MMU_IRQ_CALLBACK		0x10A
#define MMU_TIMER_OVERFLOW		0x10B
#define MMU_PAGE_TABLE			0x10C
#define MMU_TCM_REMAP			0x110
#define MMU_DTCM				0x111
#define MMU_READ_WORD_CALLBACKS	0x115
#define MMU_IRQ					0x116
#define MMU_IRQ_OVER			0x117
#define MMU_IRQ_OK				0x118

#define GPU_CURRENT_SCANLINE	0x200
#define GPU_SCREEN_WIDTH		0x201
#define GPU_SCREEN_HEIGHT		0x202
#define GPU_FRAME_COMPLETED		0x203
#define GPU_VBLANK_LINES		0x204
#define GPU_HBLANK_PIXELS		0x205
#define GPU_MEMORY				0x206
#define GPU_NUMBER_COLORS		0x207
#define GPU_PALETTE				0x208
#define GPU_VBLANK_ACTION		0x209
#define GPU_HBLANK_ACTION		0x20A
#define GPU_SIZE_MULTIPLIER		0x20B
#define GPU_SET_CALLBACK		0x20D
#define GPU_GET_CALLBACK		0x20F
#define GPU_RENDERER_OK			0x210
#define GPU_SET_RENDERER		0x211

#define APU_WRITE_CALLBACK		0x300

#define	SHELL_WINDOW_HANDLE		0x500
#define SHELL_ROM_BASE			0x501
#define SHELL_KEYSTATE			0x502
#define SHELL_ROM_SIZE			0x503
#define SHELL_EVENT				0x504
#define SHELL_HALT				0x508
#define SHELL_TIME				0x509
#define SHELL_DEBUG_MSG			0x511
#define SHELL_LOG_EVENT			0x512

#define PLUGIN_NAME				0x600
#define LAST_ERROR				0x601
#define	PLUGIN_SETTING			0x602

#define INPUT_KEYDOWN			0x701
#define INPUT_KEYUP				0x702


#define WINDOW_HANDLE_MAIN		0
#define WINDOW_HANDLE_VIDEO		2

#define KEY_UP					0
#define KEY_DOWN				1
#define KEY_LEFT				2
#define KEY_RIGHT				3
#define KEY_A					4
#define KEY_B					5
#define KEY_L					6
#define KEY_R					7
#define KEY_START				8
#define KEY_SELECT				9
#define KEY_X					10
#define KEY_Y					11


#define	EV_HBLANK_START			1
#define	EV_HBLANK_END			2
#define	EV_TIMER_OVERFLOW		6


typedef struct
{
	char *data;
	BITMAPINFOHEADER bih;
	RGBQUAD colors[256];
} palette_dib;

typedef struct
{
	int x,y,z,t;
} touchpad;


typedef int(__stdcall *cpu_init_callback)(void*);
typedef void(__stdcall *cpu_reset_callback)(void);
typedef void(__stdcall *cpu_irq_callback)(int);
typedef void(__stdcall *cpu_dma_callback)(char*,char*,int,int,int);
typedef void(__stdcall *cpu_set_io_handler_callback)(int,int,void*);
typedef int(__stdcall *cpu_inpb_callback)(int);
typedef void(__stdcall *cpu_outpb_callback)(int,int);
typedef unsigned int(__stdcall *cpu_execute_until_callback)(unsigned int);
typedef int(__stdcall *cpu_get_callback)(int);
typedef void(__stdcall *cpu_set_callback)(unsigned int,unsigned int,unsigned int);

typedef int(__stdcall *mmu_init_callback)(void*);
typedef bool(__stdcall *mmu_reset_callback)(void);
typedef short int(__stdcall *mmu_read_word_callback)(int);
typedef short int(__stdcall *mmu_read_dword_callback)(int);
typedef int(__stdcall *mmu_write_byte_callback)(unsigned int,int);
typedef int(__fastcall *mmu_write_dword_callback)(unsigned int,int);
typedef int(__stdcall *mmu_get_callback)(int);
typedef void(__stdcall *mmu_set_callback)(unsigned int,unsigned int,unsigned int);
typedef void(__stdcall *mmu_close_callback)(void);

typedef int(__stdcall *gpu_init_callback)(void*);
typedef void(__stdcall *gpu_reset_callback)(void);
typedef void(__stdcall *gpu_hblank_callback)(void);
typedef void(__stdcall *gpu_advance_line_callback)(void);
typedef int(__stdcall *gpu_get_callback)(int);
typedef void(__stdcall *gpu_set_callback)(unsigned int,unsigned int,unsigned int);
typedef void(__stdcall *gpu_close_callback)(void);

typedef void(__stdcall *apu_write_callback)(unsigned char,unsigned char);

typedef void*(__stdcall *shell_callback)(int,int,DWORD,DWORD);

#endif
