#ifndef __IPC_H__
#define __IPC_H__

typedef unsigned int uint32;
typedef volatile unsigned int vuint32;
typedef short int int16;
typedef unsigned short int uint16;
typedef unsigned char uint8;
typedef unsigned char u8;
typedef volatile unsigned char vuint8;

#pragma pack(2)

typedef struct sTransferRegion {
  uint32 heartbeat;         // counts frames
 
   int16 touchX,  touchY;   // TSC X, Y
   int16 touchZ1, touchZ2;  // TSC x-panel measurements
  uint16 tdiode1, tdiode2;  // TSC temperature diodes
  uint32 temperature;       // TSC computed temperature
 
  uint16 buttons;           // X, Y, /PENIRQ buttons
 
  union {
    uint8 curtime[8];       // current time response from RTC
 
    struct {
      u8 UNKNOWN1;          // always 0x0E ??
      u8 year;
      u8 month;
      u8 day;
 
      u8 UNKNOWN2;          // always 0x00 ??
      u8 hours;
      u8 minutes;
      u8 seconds;
    };
  };
 
  // Don't rely on these below, will change or be removed in the future
  vuint32 mailAddr;
  vuint32 mailData;
  vuint8 mailRead;
  vuint8 mailBusy;
  vuint8 mailSize;
} TransferRegion, * pTransferRegion;

#pragma pack(4)

#endif
