// ARM disassembler
// Mic, 2005

#include "disarm.h"


char conditions[14][3] = {"eq","ne","cs","cc","mi","pl","vs","vc","hi","ls","ge","lt","gt","le"};
char dataproc[16][4] = {
	"and",
	"eor",
	"sub",
	"rsb",
	"add",
	"adc",
	"sbc",
	"rsc",
	"tst",
	"teq",
	"cmp",
	"cmn",
	"orr",
	"mov",
	"bic",
	"mvn"
};
char tmbalu[16][4] = {
	"and",
	"eor",
	"lsl",
	"lsr",
	"asr",
	"adc",
	"sbc",
	"ror",
	"tst",
	"neg",
	"cmp",
	"cmn",
	"orr",
	"mul",
	"bic",
	"mvn"
};
char tmbhiop[3][4] = {
	"add",
	"cmp",
	"mov"
};
char reglist[2][16][4] = {
	{
		"","","","","","","","",
		"","","","","","","",""
	},
	{
		"r0","r1","r2","r3",
		"r4","r5","r6","r7",
		"r8","r9","r10","r11",
		"r12","r13","r14","r15"
	}
};

char ldrstr[2][4] = {"str","ldr"};
char ldmstm[2][4] = {"stm","ldm"};
char ldmmode[4][4] = {"da","ia","db","ib"};
char partreg[3][4] = {"h","sb","sh"};
char shifts[4][4] = {"lsl","lsr","asr","ror"};
char plusminus[2][2] = {"-",""};
char writeback[] = "!";
char wrback[2][2] = {"","!"};
char bytequant[] = "b";
char setflags[] = "s";
char always[] = "";
//char disasm[64];
char stemp[256];
char stemp2[128];
char mrs[2][4] = {"mrs","msr"};
char tmbfmt3[4][4] = {"mov","cmp","add","sub"};


int disassemble(char *disasm,unsigned int address,unsigned int *physadr,bool arm)
{
	unsigned int opcode,foo,rot;
	int offset,i,j,k,l,mask;
	char *condition,*sbit,*s1,*s2,*s3;
	unsigned short int *physadrs = (unsigned short int*)physadr;

	opcode = *physadr; //mmu_read_dword(address);

	if (arm)
	{
		if ((opcode&0xF0000000)==0xE0000000)
			condition = always;
		else
			condition = &conditions[(opcode>>28)&15][0];  //&13

		switch ((opcode>>25)&7)
		{
			case 0:
				if ((opcode&0x12FFF10)==0x12FFF10)
					wsprintf(disasm,"%08X  /%08X  /bx%s /r%d",address,opcode,condition,opcode&15);
				else if ((opcode&0x90)==0x90)
				{
					if (opcode&0x60)
					{
						if (opcode&0x400000)
						{
							if (opcode&0x1000000)
								wsprintf(disasm,"%08X  /%08X  /%s%s /r%d,/[/r%d/,/#%s$%X/]/%s",
								address,opcode,ldrstr[(opcode>>20)&1],partreg[((opcode>>5)&3)-1],
								(opcode>>12)&15,(opcode>>16)&15,plusminus[(opcode>>23)&1],
								(opcode&0x0F)|((opcode>>4)&0xF0),wrback[(opcode>>21)&1]);
							else
								wsprintf(disasm,"%08X  /%08X  /%s%s /r%d/,/[/r%d/]/,/#%s$%X",
								address,opcode,ldrstr[(opcode>>20)&1],partreg[((opcode>>5)&3)-1],
								(opcode>>12)&15,(opcode>>16)&15,plusminus[(opcode>>23)&1],
								(opcode&0x0F)|((opcode>>4)&0xF0));
						} 
					}
				
				}
				else
				{
					if (opcode&0x100000)
						sbit = setflags;
					else
						sbit = always;
					stemp[0] = 0;

					if (opcode&0x10)
					{
						if ((opcode>>8)&15)
							wsprintf(stemp,"/,/%s /r%d",shifts[(opcode>>5)&3],(opcode>>8)&15);
					}
					else
					{
						if ((opcode>>7)&31)
							wsprintf(stemp,"/,/%s/#%d",shifts[(opcode>>5)&3],(opcode>>7)&31);
						else if (((opcode>>5)&3)==3)
							wsprintf(stemp,"/,rrx");
					}

					switch ((opcode>>21)&15)
					{
						case 13:
						case 15:
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/r%d%s",
							address,opcode,dataproc[(opcode>>21)&15],condition,sbit,
							(opcode>>12)&15,opcode&15,stemp);
							break;
						case 8:
						case 9:
						case 10:
						case 11:
							if ((opcode&0x100000)==0)
							{
								if ((opcode>>21)&1)
								{
									if (opcode&0x10000)
									{
										if (opcode&0x2000000)
											wsprintf(disasm,"%08X  /%08X  /msr /CPSR_flg,/#",address,opcode);
										else
											wsprintf(disasm,"%08X  /%08X  /msr /CPSR_flg/,/r%d",
											address,opcode,opcode&15);
									}
									else
										wsprintf(disasm,"%08X  /%08X  /msr /CPSR_all/,/r%d",
										address,opcode,(opcode&15));
								} else
								{
									wsprintf(disasm,"%08X  /%08X  /mrs /r%d/,/CPSR",
										address,opcode,(opcode&15));
								}
							} else
							{
								wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/r%d%s",
								address,opcode,dataproc[(opcode>>21)&15],condition,sbit,
								(opcode>>16)&15,opcode&15,stemp);
							}
							break;
						default:
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/r%d/,/r%d%s",
							address,opcode,dataproc[(opcode>>21)&15],condition,sbit,
							(opcode>>12)&15,(opcode>>16)&15,opcode&15,stemp);
							break;
					}
				}
				break;

			case 1:
					if (opcode&0x100000)
						sbit = setflags;
					else
						sbit = always;
					foo = opcode&0xFF;
					rot = ((opcode>>8)&15)<<1;
					foo = (foo>>rot) | ((foo&((1<<rot)-1))<<(32-rot));
					switch ((opcode>>21)&15)
					{
						case 13:
						case 15:
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/#$%X",
							address,opcode,dataproc[(opcode>>21)&15],condition,sbit,
							(opcode>>12)&15,foo);
							break;
						case 8:
						case 9:
						case 10:
						case 11:
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/#$%X",
							address,opcode,dataproc[(opcode>>21)&15],condition,sbit,
							(opcode>>16)&15,foo);
							break;
												
						default:
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d,/r%d/,/#$%X",
							address,opcode,dataproc[(opcode>>21)&15],condition,sbit,
							(opcode>>12)&15,(opcode>>16)&15,foo);
							break;
					}
					break;

			case 2:
				s1 = ldrstr[(opcode>>20)&1];
				s2 = (opcode&0x200000) ? writeback : always;
				s3 = (opcode&0x400000) ? bytequant : always;
				if (opcode&0x1000000)
				{
					if (opcode&0x800000)
					{
						if (((opcode>>16)&15) == 15)
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/,/#$%X/]/%s  /;(=$%08X)",
									address,opcode,s1,s3,condition,(opcode>>12)&15,
									(opcode>>16)&15,opcode&0xFFF,s2,physadr[((opcode&0xFFF)>>2)+2]);
						else
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/,/#$%X/]/%s",
									address,opcode,s1,s3,condition,(opcode>>12)&15,
									(opcode>>16)&15,opcode&0xFFF,s2);

					} else
					{
						wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/,/#-$%X/]/%s",
								address,opcode,s1,s3,condition,(opcode>>12)&15,
								(opcode>>16)&15,opcode&0xFFF,s2);
					}
				} else
				{
					if (opcode&0x800000)
						wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/]/,/#$%X",
								address,opcode,s1,s3,condition,(opcode>>12)&15,
								(opcode>>16)&15,opcode&0xFFF);
					else
						wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/]/,/#-$%X",
								address,opcode,s1,s3,condition,(opcode>>12)&15,
								(opcode>>16)&15,opcode&0xFFF);
				}
				break;

			case 3:
				stemp[0] = 0;
				if ((opcode>>7)&31)
					wsprintf(stemp,"/,/%s/#%d",shifts[(opcode>>5)&3],(opcode>>7)&31);
				else if (((opcode>>5)&3)==3)
					wsprintf(stemp,"/,rrx");

				s1 = ldrstr[(opcode>>20)&1];
				s2 = (opcode&0x200000) ? writeback : always;
				s3 = (opcode&0x400000) ? bytequant : always;
				if (opcode&0x1000000)
				{
					if (opcode&0x800000)
					{
						if (((opcode>>16)&15) == 15)
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/,/r%d/%s/]/%s  /;(=$%08X)",
									address,opcode,s1,s3,condition,(opcode>>12)&15,
									(opcode>>16)&15,opcode&0xF,stemp,s2,physadr[((opcode&0xFFF)>>2)+2]);
						else
							wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/,/r%d/%s]/%s",
									address,opcode,s1,s3,condition,(opcode>>12)&15,
									(opcode>>16)&15,opcode&0xF,stemp,s2);

					} else
					{
						wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/,/-r%d/%s]/%s",
								address,opcode,s1,s3,condition,(opcode>>12)&15,
								(opcode>>16)&15,opcode&0xF,stemp,s2);
					}
				} else
				{
					if (opcode&0x800000)
						wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/]/,/r%d/%s",
								address,opcode,s1,s3,condition,(opcode>>12)&15,
								(opcode>>16)&15,opcode&0xF,stemp);
					else
						wsprintf(disasm,"%08X  /%08X  /%s%s%s /r%d/,/[/r%d/]/,/-r%d/%s",
								address,opcode,s1,s3,condition,(opcode>>12)&15,
								(opcode>>16)&15,opcode&0xF,stemp);
				}
				
				break;
			
			// LDM/STM
			case 4:
				s2 = (opcode&0x200000) ? writeback : always;
				stemp[0] = '\0';
				j = -1;
				k = -1;
				l = -1;
				mask = 1;
				for (i=0; i<16; i++)
				{
					if ((opcode&mask))
					{
						if (j == -1) j = i;
					} else if (j != -1)
					{
						k = i-1;
						if (k>j)
						{
							if (l != -1) strcat(stemp,",");
							wsprintf(stemp2,"/r%d/-/r%d/",j,k);
							strcat(stemp,stemp2);
						} else
						{
							if (l != -1) strcat(stemp,",");
							wsprintf(stemp2,"/r%d/",j);
							strcat(stemp,stemp2);
						}
						l = 0;
						j = -1;
						k = -1;
					}
					mask += mask;
				}

				if (opcode&0x8000)
				{
					k = 15;
					if (k>j)
					{
						if (l != -1) strcat(stemp,",");
						wsprintf(stemp2,"/r%d/-/r%d/",j,k);
						strcat(stemp,stemp2);
					} else if (j != -1)
					{
						if (l != -1) strcat(stemp,",");
						wsprintf(stemp2,"/r%d/",k);
						strcat(stemp,stemp2);
					}
					l = 0;
					j = -1;
					k = -1;
				}


				wsprintf(disasm,"%08X  /%08X  /%s%s /r%d/%s,/{/%s/}/",
					address,opcode,ldmstm[(opcode>>20)&1],ldmmode[(opcode>>23)&3],
					(opcode>>16)&15,s2,stemp);
				break;

			case 5:
				offset = opcode&0xFFFFFF;
				offset = (offset<<8)>>6;
				offset += address+8;
				if (opcode&0x1000000)
					wsprintf(disasm,"%08X  /%08X  /bl%s /%08X",address,opcode,condition,offset);
				else
					wsprintf(disasm,"%08X  /%08X  /b%s /%08X",address,opcode,condition,offset);
				break;

			case 7:
				if (opcode&0x1000000)
					wsprintf(disasm,"%08X  /%08X  /swi /%06X",address,opcode,opcode&0xFF0000);
				else if (opcode&0x100000)
					wsprintf(disasm,"%08X  /%08X  /mrc /%d/,/%d/,/r%d/,/c%d/,/c%d/,/%d",address,opcode,
					         (opcode>>8)&15,(opcode>>21)&7,(opcode>>12)&15,(opcode>>16)&15,
							 opcode&15,(opcode>>5)&7);
				else
					wsprintf(disasm,"%08X  /%08X  /mcr /%d/,/%d/,/r%d/,/c%d/,/c%d/,/%d",address,opcode,
					         (opcode>>8)&15,(opcode>>21)&7,(opcode>>12)&15,(opcode>>16)&15,
							 opcode&15,(opcode>>5)&7);
				break;

			default:
				wsprintf(disasm,"%08X  /%08X  /<unknown>",address,opcode);
				break;
		}
		return 4;
	} else
	{
		wsprintf(disasm,"%08X  /%04X      /<unknown>",address,opcode&0xFFFF);

		switch ((opcode>>12)&0xF)
		{
			case 0:
				if (opcode&0x800)
					wsprintf(disasm,"%08X  /%04X      /lsr /r%d/,/r%d/,/#%d",
					address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,(opcode>>6)&31);
				else
					wsprintf(disasm,"%08X  /%04X      /lsl /r%d/,/r%d/,/#%d",
					address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,(opcode>>6)&31);
				break;

			case 1:
				if (opcode&0x800)
				{
					if (opcode&0x200)
					{
						if (opcode&0x400)
							wsprintf(disasm,"%08X  /%04X      /sub /r%d/,/r%d/,/#$%X",
							address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,
							(opcode>>6)&7);
						else
							wsprintf(disasm,"%08X  /%04X      /sub /r%d/,/r%d/,/r%d",
							address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,
							(opcode>>6)&7);
					} else
					{
						if (opcode&0x400)
							wsprintf(disasm,"%08X  /%04X      /add /r%d/,/r%d/,/#$%X",
							address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,
							(opcode>>6)&7);
						else
							wsprintf(disasm,"%08X  /%04X      /add /r%d/,/r%d/,/r%d",
							address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,
							(opcode>>6)&7);
					}
				} else
					wsprintf(disasm,"%08X  /%04X      /asr /r%d/,/r%d/,/#%d",
					address,opcode&0xFFFF,opcode&7,(opcode>>3)&7,(opcode>>6)&31);

				break;

			case 2:
			case 3:
				wsprintf(disasm,"%08X  /%04X      /%s /r%d/,/#$%X",
					address,opcode&0xFFFF,tmbfmt3[(opcode>>11)&3],(opcode>>8)&7,opcode&255);
				break;

			case 4:
				if ((opcode&0xC00)==0)
				{
					wsprintf(disasm,"%08X  /%04X      /%s /r%d/,/r%d",
					address,opcode&0xFFFF,tmbalu[(opcode>>6)&15],opcode&7,(opcode>>3)&7);
				} else if ((opcode&0xC00)==0x800)
				{
					// PC-relative load
					physadr = (unsigned int*)&physadrs[(((opcode&0xFF)+1)<<1)-((address&2)>>1)];
					wsprintf(disasm,"%08X  /%04X      /ldr /r%d/,/[/r15/,/#$%X/]  /;($%08X)",
						address,opcode&0xFFFF,(opcode>>8)&7,(opcode&0xFF)<<2,
						physadr[0]);
				} else if ((opcode&0xC00)==0x400)
				{
					if ((opcode&0x300)==0x300)
					{
						wsprintf(disasm,"%08X  /%04X      /bx /r%d",
							address,opcode&0xFFFF,(opcode>>3)&15);
					} else
					{
						wsprintf(disasm,"%08X  /%04X      /%s /r%d/,/r%d",
							address,opcode&0xFFFF,tmbhiop[(opcode>>8)&3],
							(opcode&7)+((opcode>>4)&8),(opcode>>3)&15);
					}
				}
				break;

			case 5:
				break;
			case 6:
				wsprintf(disasm,"%08X  /%04X      /%s /r%d/,/[/r%d/,/#$%X/]",
					address,opcode&0xFFFF,ldrstr[(opcode>>11)&1],opcode&7,
					(opcode>>3)&7,(opcode>>6)&31);
				break;
			case 7:
				wsprintf(disasm,"%08X  /%04X      /%sb /r%d/,/[/r%d/,/#$%X/]",
					address,opcode&0xFFFF,ldrstr[(opcode>>11)&1],opcode&7,
					(opcode>>3)&7,(opcode>>6)&31);
				break;
			case 8:
				wsprintf(disasm,"%08X  /%04X      /%sh /r%d/,/[/r%d/,/#$%X/]",
					address,opcode&0xFFFF,ldrstr[(opcode>>11)&1],opcode&7,
					(opcode>>3)&7,(opcode>>5)&0x3E);
				break;
			case 9:
				break;
			case 10:
				break;

			// PUSH/POP  LDMIA/STMIA
			case 11:
			case 12:
				stemp[0] = '\0';
				j = -1;
				k = -1;
				l = -1;
				mask = 1;
				for (i=0; i<8; i++)
				{
					if ((opcode&mask))
					{
						if (j == -1) j = i;
					} else if (j != -1)
					{
						k = i-1;
						if (k>j)
						{
							if (l != -1) strcat(stemp,",");
							wsprintf(stemp2,"/r%d/-/r%d/",j,k);
							strcat(stemp,stemp2);
						} else
						{
							if (l != -1) strcat(stemp,",");
							wsprintf(stemp2,"/r%d/",j);
							strcat(stemp,stemp2);
						}
						l = 0;
						j = -1;
						k = -1;
					}
					mask += mask;
				}

				if (opcode&0x80)
				{
					k = 7;
					if (k>j)
					{
						if (l != -1) strcat(stemp,",");
						wsprintf(stemp2,"/r%d/-/r%d/",j,k);
						strcat(stemp,stemp2);
					} else if (j != -1)
					{
						if (l != -1) strcat(stemp,",");
						wsprintf(stemp2,"/r%d/",k);
						strcat(stemp,stemp2);
					}
					l = 0;
					j = -1;
					k = -1;
				}

				if (((opcode>>12)&0xF) == 11)
				{
					// Store lr/Load pc ?
					if (opcode&0x100)
					{
						if (l != -1) strcat(stemp,",");
						if (opcode&0x800)
							strcat(stemp,"/r15/");
						else
							strcat(stemp,"/r14/");
					}
					if (opcode&0x800)
						wsprintf(disasm,"%08X  /%04X      /pop /{/%s/}/",
						address,opcode&0xFFFF,stemp);
					else
						wsprintf(disasm,"%08X  /%04X      /push /{/%s/}/",
						address,opcode&0xFFFF,stemp);
				} else
				{
					if (opcode&0x800)
						wsprintf(disasm,"%08X  /%04X      /ldmia /r%d/!,/{/%s/}/",
						address,opcode&0xFFFF,(opcode>>8)&7,stemp);
					else
						wsprintf(disasm,"%08X  /%04X      /stmia /r%d/!,/{/%s/}/",
						address,opcode&0xFFFF,(opcode>>8)&7,stemp);
				}

				break;

			case 13:
				if ((opcode&0xF00)!=0xF00)
				{
					if ((opcode&0xF00)!=0xE00)
					{
						offset = (opcode&0xFF);
						if (offset&0x80) offset -= 0x100;
						offset = address+4+(offset<<1);
						wsprintf(disasm,"%08X  /%04X      /b%s /$%08X",
							address,opcode&0xFFFF,conditions[(opcode>>8)&15],offset);
					}
				} else
					wsprintf(disasm,"%08X  /%04X      /swi /$%02X",
					address,opcode&0xFFFF,opcode&0xFF);
				break;

			case 14:
				if ((opcode&0x800)==0x000)
				{
					offset = (opcode&0x7FF);
					if (offset&0x400) offset -= 0x800;
					offset = address+4+(offset<<1);
					wsprintf(disasm,"%08X  /%04X      /b /$%08X",
						address,opcode&0xFFFF,offset);
				}
				break;
			case 15:
				if ((opcode&0x800)==0)
				{
					offset = (opcode&0x7FF)<<12;
					offset += (opcode&0x7FF0000)>>15;
					if (offset&0x800000) offset -= 0x1000000;
					offset = address+4+offset;
					wsprintf(disasm,"%08X  /%08X  /bl /$%08X",
						address,opcode,offset);
					return 4;
				}
				break;
		}
	}

	return 2;
}
