#include "CEventQueue.h"


CEventQueue::CEventQueue(int items)
{
	e = new event[items];
	nItems = 0;
	nMax = items;
}


CEventQueue::~CEventQueue()
{
	delete [] e;
}


void CEventQueue::enqueue(event *pE)
{
	int i,j;

	if (nItems < nMax)
	{

		for (i=0; i<nItems; i++)
		{
			if (pE->timestamp == e[i].timestamp)
				if (pE->data == e[i].data)
					return;
			if (pE->timestamp < e[i].timestamp)
				break;
		}
		if (i<nItems)
		{
			j = nItems;
			while (j>i)
			{
				e[j] = e[j-1];
				j--;
			}
		}
		e[i] = *pE;
		nItems++;
	}
}


void CEventQueue::dequeue(event *pE)
{
	int i;

	if (nItems>0)
	{
		*pE = e[0];

		if (nItems>1)
			for (i=0; i<nItems-1; i++)
				e[i] = e[i+1];
		nItems--;
	}
}


void CEventQueue::flush()
{
	nItems = 0;
}
