#include "arm9_write.h"


void WRHDECL arm9_write_word_gen(unsigned int address,int word)
{
	unsigned int page = address>>24,pagen=address>>20,offset=address&0x0FFFFF;

	if (arm9_pageTable[pagen])
		if (arm9_pageLength[page]>offset)
			*(unsigned short int*)(arm9_pageTable[pagen] + offset) = (unsigned short int)word;
}


void WRHDECL arm9_write_word_dtcm(unsigned int address,int word)
{
	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		*(unsigned short int*)(DTCM + (address-dtcmBase)) = (unsigned short int)word;
	else if (arm9_pageTable[address>>20])
		*(unsigned short int*)(arm9_pageTable[address>>20] + (address&0xFFFFF)) = (unsigned short int)word;
}

void WRHDECL arm9_write_word_itcm(unsigned int address,int word)
{
	if ((address<0x8000))
		*(unsigned short int*)(ITCM + address) = (unsigned short int)word;
	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		*(unsigned short int*)(DTCM + (address-dtcmBase)) = (unsigned short int)word;
}


void WRHDECL arm9_write_word_ptok(unsigned int address,int word)
{
	*(unsigned short int*)(arm9_pageTable[address>>20] + (address&0xFFFFF)) = (unsigned short int)word;
}


void WRHDECL arm9_write_word_wram(unsigned int address,int word)
{
	*(unsigned short int*)(IWRAM + ((address)&0x7FFF)) = (unsigned short int)word;
}


void WRHDECL arm9_write_word_plt(unsigned int address,int word)
{
	*(unsigned short int*)(PLT_VRAM + (address&0xFFF)) = (unsigned short int)word;
}


void WRHDECL arm9_write_word_oam(unsigned int address,int word)
{
	*(unsigned short int*)(OAM + (address&0x7FF)) = (unsigned short int)word;
}


void WRHDECL arm9_write_word_io(unsigned int address,int word)
{
	unsigned int pagen=address>>20,offset=address&0x0FFFFF;

//	if (arm9_pageTable[pagen])
//		if (pageLength[4]>offset)
			*(unsigned short int*)(arm9_pageTable[pagen] + offset) = (unsigned short int)word;

		//wsprintf(buffer,"[%08X] = %08X, at %X\n",address,word,arm9_regs[15]);
		//WriteConsole(hout,buffer,lstrlen(buffer),(unsigned long*)&dummy,NULL);

	switch (offset)
	{
		case REG_DIVCNT:
			cp_div(word&3);
			break;

		case REG_SQRTCNT:
			cp_sqrt(word&3);
			break;
			
		case 0xC6:
			dma_setup(1,false);
			break;
		case 0xD2:
			dma_setup(2,false);
			break;
		case 0xDE:
			dma_setup(3,false);
			break;
		case IF_:
			irqFlags &= (word^0xFFFF);
			break;
		/*case TM0D:
			break;
		case TM1D:
			break;
		case TM2D:
			break;
		case TM3D:
			break;*/
		case TM0CNT:
			timer_setup(0);
			break;
		case TM1CNT:
			timer_setup(1);
			break;
		case TM2CNT:
			timer_setup(2);
			break;
		case TM3CNT:
			timer_setup(3);
			break;
	}
}


void WRHDECL arm9_write_word_na(unsigned int address,int word)
{
}


void WRHDECL arm9_write_word_vram(unsigned int address,int word)
{
	int chunk = (address>>14)&0x3FF;
	//dummy = address;

	//if (chunk==0x3)
	if ((address >= 0x600F800) && (address < 0x600FA00))
	{
		wsprintf(buffer,"[%08X] = %04X, chunk=%d, [chunk]=%X, %X\n",address,word&0xFFFF,
			chunk,vramChunk[chunk],vramChunk[chunk] + (address&0x3FFF));
		WriteConsole(hout,buffer,lstrlen(buffer),(unsigned long*)&dummy,NULL);
	}

	if (vramChunk[chunk])
	{
		/*if (((vramChunk[chunk]+(address&0x3FFF))>=VRAM_A+0x20000)&&
		    ((vramChunk[chunk]+(address&0x3FFF))<VRAM_A+0x20100))*/
		*(unsigned short int*)(vramChunk[chunk] + (address&0x3FFF)) = (unsigned short int)word;
	}
}

void WRHDECL arm9_write_word_lcdc(unsigned int address,int word)
{
	int chunk;
	address &= 0xFFFFF; if (address>0xA3FFF) address-=0xA3FFF; //if (address>0x9FFFF) address-=0x9FFFF;
	chunk = ((address>>14)|0x200)&0x3FF;
	if (vramChunk[chunk])
	{
		*(unsigned short int*)(vramChunk[chunk] + (address&0x3FFF)) = (unsigned short int)word;
	}
	//*(unsigned short int*)(LCDC_VRAM + address) = (unsigned short int)word;
}



/////////////////////////////////////////////////////////////////////////////////////////


void WRWDECL arm9_write_dword_gen(unsigned int address,int word)
{
	unsigned int page = address>>24,pagen=address>>20,offset=address&0x0FFFFC;
	dummy = address;

	/*if (address == 0x02199220) {
		wsprintf(buffer,"[%08X] = %08X\n",address,word);
		WriteConsole(hout,buffer,lstrlen(buffer),(unsigned long*)&dummy,NULL);
	}*/

	if (arm9_pageTable[pagen])
		if (arm9_pageLength[page]>offset)
			*(int*)(arm9_pageTable[pagen] + offset) = word;
}


void WRWDECL arm9_write_dword_dtcm(unsigned int address,int word)
{
	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		*(int*)(DTCM + (address-dtcmBase)) = word;
	else if (arm9_pageTable[address>>20])
		*(int*)(arm9_pageTable[address>>20] + (address&0xFFFFF)) = word;
}

void WRHDECL arm9_write_dword_itcm(unsigned int address,int word)
{
	if ((address<0x8000))
		*(int*)(ITCM + address) = word;
	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		*(int*)(DTCM + (address-dtcmBase)) = word;
}

void WRWDECL arm9_write_dword_ptok(unsigned int address,int word)
{
	*(int*)(arm9_pageTable[address>>20] + (address&0xFFFFC)) = word;
}


void WRWDECL arm9_write_dword_wram(unsigned int address,int word)
{
	//*(int*)(IWRAM + ((address-0x78000)&0x7FFC)) = word;
	*(int*)(IWRAM + ((address)&0x7FFC)) = word;
}


void WRWDECL arm9_write_dword_plt(unsigned int address,int word)
{
	*(int*)(PLT_VRAM + (address&0xFFC)) = word;
}


void WRWDECL arm9_write_dword_oam(unsigned int address,int word)
{
	*(int*)(OAM + (address&0x7FC)) = word;
}


void WRWDECL arm9_write_dword_io(unsigned int address,int word)
{
	unsigned int pagen=address>>20,offset=address&0x0FFFFC;

	*(int*)(arm9_pageTable[pagen] + offset) = word;

	if ((offset>=0x400)&&(offset<=0x600))
	{
		gpu_set(GPU_3D_COMMAND,offset,word);
		return;
	}

	//wsprintf(buffer,"[%08X] = %08X, at %X\n",address,word,arm9_regs[15]);
	//WriteConsole(hout,buffer,lstrlen(buffer),(unsigned long*)&dummy,NULL);

	switch (offset)
	{
		case REG_NUMER_L:
		case REG_DENOM_L:
			cp_div(-1);
			break;
		case REG_SQRTPARM:
			cp_sqrt(-1);
			break;

		case TM0D:
			timer_setup(0);
			break;
		case TM1D:
			timer_setup(1);
			break;
		case TM2D:
			timer_setup(2);
			break;
		case TM3D:
			timer_setup(3);
			break;

		case IF_:
			irqFlags &= (word^0xFFFF);
			break;

		case 0xC4:
			dma_setup(1,false);
			break;
		case 0xC6:
			dma_setup(1,false);
			break;
		case 0xD0:
			dma_setup(2,false);
			break;
		case 0xD2:
			dma_setup(2,false);
			break;
		case 0xDC:
			dma_setup(3,false);
			break;
		case 0xDE:
			dma_setup(3,false);
			break;
	}
}


void WRWDECL arm9_write_dword_na(unsigned int address,int word)
{
}


void WRWDECL arm9_write_dword_vram(unsigned int address,int word)
{
	int chunk = (address>>14)&0x3FF;

	/*if (chunk==0x225)		
	{
		wsprintf(buffer,"[%08X] = %08X, chunk=%d, [chunk]=%X, %X\n",address,word,
			chunk,vramChunk[chunk],vramChunk[chunk] + (address&0x3FFF));
		WriteConsole(hout,buffer,lstrlen(buffer),(unsigned long*)&dummy,NULL);
	}*/

	if (vramChunk[chunk])
	{
		*(int*)(vramChunk[chunk] + (address&0x3FFC)) = word;
	}
}

void WRWDECL arm9_write_dword_lcdc(unsigned int address,int word)
{
	int chunk;
	address &= 0xFFFFF; if (address>0xA3FFF) address-=0xA3FFF;
	chunk = ((address>>14)|0x200)&0x3FF;

	//wsprintf(buffer,"[%08X] = %08X\n",address,word);
	//WriteConsole(hout,buffer,lstrlen(buffer),(unsigned long*)&dummy,NULL);

	if (vramChunk[chunk])
	{
		*(int*)(vramChunk[chunk] + (address&0x3FFC)) = word;
	}
}


