#include "arm9_read.h"


// Generic read
//
unsigned short int RDHDECL arm9_read_word_gen(unsigned int address)
{

	if (arm9_pageTable[address>>20])
		return *(unsigned short int*)(arm9_pageTable[address>>20] + (address&0xFFFFF));

	return rand()&0xFFFF;
}


// DTCM read
//
unsigned short int RDHDECL arm9_read_word_dtcm(unsigned int address)
{
	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		return *(unsigned short int*)(DTCM + (address-dtcmBase));
	if (arm9_pageTable[address>>20])
		return *(unsigned short int*)(arm9_pageTable[address>>20] + (address&0xFFFFF));

	return rand()&0xFFFF;
}


// ITCM read
//
unsigned short int RDHDECL arm9_read_word_itcm(unsigned int address)
{
	if ((address<0x8000))
		return *(unsigned short int*)(ITCM + address);
	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		return *(unsigned short int*)(DTCM + (address-dtcmBase));
	return rand()&0xFFFF;
}


// I/O read
//
unsigned short int __fastcall arm9_read_word_io(unsigned int address)
{
	int	offset,page;
	unsigned int tlong;
	unsigned short int *pagew;

	switch (address&0xFFFFF)
	{
		case P1:
			return keys;

		case TM0D:
			if (timer[0].enabled)
			{
				tlong = *arm9_cycle;
				if (tlong < timer[0].tstart)
					tlong -= (timer[0].tstart-0x40000000);
				else
					tlong -= timer[0].tstart;
				timer[0].tcurr = tlong >> prescalar[IOREGS[TM0CNT]&3];
			}
			return timer[0].tcurr;

		case TM1D:
			if (timer[1].countup)
				return timer[1].te;
			if (timer[1].enabled)
			{
				tlong = *arm9_cycle;
				if (tlong < timer[1].tstart)
					tlong -= (timer[1].tstart-0x40000000);
				else
					tlong -= timer[1].tstart;
				timer[1].tcurr = tlong >> prescalar[IOREGS[TM1CNT]&3];
			}
			return timer[1].tcurr;

		case TM2D:
			if (timer[2].countup)
				return timer[2].te;
			if (timer[2].enabled)
			{
				tlong = *arm9_cycle;
				if (tlong < timer[2].tstart)
					tlong -= (timer[2].tstart-0x40000000);
				else
					tlong -= timer[2].tstart;
				timer[2].tcurr = tlong >> prescalar[IOREGS[TM2CNT]&3];
			}
			return timer[2].tcurr;

		case TM3D:
			if (timer[3].countup)
				return timer[3].te;
			if (timer[3].enabled)
			{
				tlong = *arm9_cycle;
				if (tlong < timer[3].tstart)
					tlong -= (timer[3].tstart-0x40000000);
				else
					tlong -= timer[3].tstart;
				timer[3].tcurr = tlong >> prescalar[IOREGS[TM3CNT]&3];
			}
			return timer[3].tcurr;

		case IF_:
			return irqFlags;

		case 0x600:
			gpu_get(GPU_3D_COMMAND);
			return *(unsigned short int*)(IOREGS + 0x600);

		case 0x10:
		case 0x12:
		case 0x14:
		case 0x16:
		case 0x18:
		case 0x1A:
		case 0x1C:
		case 0x1E:
			page = arm9_regs[15];
			pagew = (unsigned short int*)arm9_pageTable[page>>20];
			offset = (page&0x0FFFFF)>>1;
			return pagew[offset];

		default:
			return *(unsigned short int*)(arm9_pageTable[0x40] + (address&0xFFFFF));
	}
}


// ROM read
//
unsigned short int __fastcall arm9_read_word_rom(unsigned int address)
{
	int page,offset=address&0xFFFFF;
	unsigned short int *pagew;

	if (offset >= arm9_pageLength[0x8])
	{
		page = arm9_regs[15]-4;
		pagew = (unsigned short int*)arm9_pageTable[page>>20];
		offset = (page&0x0FFFFF)>>1;
		return pagew[offset];
	}
	
	if (arm9_pageTable[address>>20])
		return *(unsigned short int*)(arm9_pageTable[address>>20] + offset);

	return rand()&0xFFFF;

}


unsigned short int __fastcall arm9_read_word_ptok(unsigned int address)
{
	return *(unsigned short int*)(arm9_pageTable[address>>20] + (address&0xFFFFF));
}


// IWRAM read
//
unsigned short int __fastcall arm9_read_word_wram(unsigned int address)
{
	return *(unsigned short int*)(IWRAM + ((address)&0x7FFF));
}


// Palette read
unsigned short int __fastcall arm9_read_word_plt(unsigned int address)
{
	return *(unsigned short int*)(PLT_VRAM + (address&0xFFF));
}


// OAM read
unsigned short int __fastcall arm9_read_word_oam(unsigned int address)
{
	return *(unsigned short int*)(OAM + (address&0x7FF));
}


// LCDC read
unsigned short int __fastcall arm9_read_word_lcdc(unsigned int address)
{
	int chunk;
	address &= 0xFFFFF; if (address>0xA3FFF) address-=0xA3FFF;
	chunk = ((address>>14)|0x200)&0x3FF;
	if (vramChunk[chunk])
		return *(unsigned short int*)(vramChunk[chunk] + (address&0x3FFF));
}


// VRAM read
unsigned short int __fastcall arm9_read_word_vram(unsigned int address)
{
	int chunk = (address>>14)&0x3FF;
	if (vramChunk[chunk])
		return *(unsigned short int*)(vramChunk[chunk] + (address&0x3FFF));
	return 0;
}


unsigned short int __fastcall arm9_read_word_na(unsigned int address)
{
	return rand()&0xFFFF;
}


unsigned short int __fastcall arm9_read_word_zero(unsigned int address)
{
	return 0;
}




unsigned short int __fastcall arm9_read_word_ipc(unsigned int address)
{
	int offset = address&0xFFFFF;

	if (offset == ipc_x)
		return (touch->x*14);
	if (offset == ipc_y)
		return (touch->y*8917)>>9;

	if (offset == ipc_z)
		return ((touch->z&0x40)|(btnXY[0])|(btnXY[1]<<1))^0x37F;

	if (arm9_pageTable[ipc_page])
		return *(unsigned short int*)(arm9_pageTable[ipc_page] + offset);

	return rand()&0xFFFF;
}


unsigned short int __fastcall arm9_read_word_ipc_mirror(unsigned int address)
{
	int offset = address&0xFFFFF;

	if (offset == 0xFF004)
		return (touch->x*14);
	if (offset == 0xFF006)
		return (touch->y*8917)>>9;

	if (offset == 0xFF014)
		return ((touch->z&0x40)|(btnXY[0])|(btnXY[1]<<1))^0x37F;

	if (arm9_pageTable[address>>20])
		return *(unsigned short int*)(arm9_pageTable[address>>20] + offset);

	return rand()&0xFFFF;
}


unsigned short int __fastcall arm9_read_word_ipc_v2(unsigned int address)
{
	int offset = address&0xFFFFF;

	if (offset == ipc_x)
		return (touch->x*14);
	if (offset == ipc_y)
		return ((touch->y-16)*8917)>>9;

	if (offset == ipc_x+4)
		return (touch->x);
	if (offset == ipc_y+4)
		return (touch->y-16);
	
	if (offset == ipc_z + 4)
		return ((touch->z&0x40)|(btnXY[0])|(btnXY[1]<<1))^0x37F;

	if (arm9_pageTable[ipc_page])
		return *(unsigned short int*)(arm9_pageTable[ipc_page] + offset);

	return rand()&0xFFFF;
}


unsigned short int __fastcall arm9_read_word_ipc_mirror_v2(unsigned int address)
{
	int offset = address&0xFFFFF;

	if (offset == 0xFF004)
		return (touch->x*14);
	if (offset == 0xFF006)
		return ((touch->y-16)*8917)>>9;

	if (offset == 0xFF008)
		return (touch->x);
	if (offset == 0xFF00A)
		return (touch->y-16);

	if (offset == 0xFF014 + 4)
		return ((touch->z&0x40)|(btnXY[0])|(btnXY[1]<<1))^0x37F;

	if (arm9_pageTable[address>>20])
		return *(unsigned short int*)(arm9_pageTable[address>>20] + offset);

	return rand()&0xFFFF;
}

/////////////////////////////////////////////////////////////////////////////////////////

int __fastcall arm9_read_dword_gen(unsigned int address)
{
	int n;

	__asm
	{
		mov ebx,address
		mov edx,arm9_pageTableAddr
		mov edi,arm9_pageLengthAddr
		mov esi,ebx
		mov ecx,arm9_pageMaskAddr
		shr ebx,20			// page
		and esi,0x0FFFFF	// offset
		mov eax,ebx
		shr eax,4

		jmp __rd_normal

		// Unaligned read, rotate data
__rd_unaligned:
		mov ecx,esi
		and esi,0xFFFFFFFC		// Clear lower 2 bits of offset
		and ecx,3
		add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
		shl ecx,3
		mov eax,[esi]
		ror eax,cl				// Rotate value by (Offset & 3)*8
		jmp __rd_done

		// Return "random" data
__rd_random:
		mov ecx,ebp
		mov eax,address
		ror eax,cl
		jmp __rd_done

__rd_normal:
		test esi,3
		jnz __rd_unaligned
		and esi,[ecx+eax*4]		// AND with pageMask
		add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
		mov eax,[esi]

__rd_done:
		mov n,eax
	}

	return n;
}


int __fastcall arm9_read_dword_dtcm(unsigned int address)
{
	int n;

	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		__asm
		{
			mov ebx,address
			mov esi,DTCM
			test ebx,3
			jz __aligned
			sub ebx,dtcmBase
			mov ecx,ebx
			and ebx,0xFFFFFFFC
			and ecx,3
			mov eax,[esi + ebx]
			shl ecx,3
			ror eax,cl
			jmp __done
		__aligned:
			sub ebx,dtcmBase
			mov eax,[esi + ebx]
		__done:
			mov n,eax
		}
	else
		__asm
		{
			mov ebx,address
			mov edx,arm9_pageTableAddr
			mov edi,arm9_pageLengthAddr
			mov esi,ebx
			mov ecx,arm9_pageMaskAddr
			shr ebx,20			// page
			and esi,0x0FFFFF	// offset
			mov eax,ebx
			shr eax,4

			jmp __rd_normal

			// Unaligned read, rotate data
		__rd_unaligned:
			mov ecx,esi
			and esi,0xFFFFFFFC		// Clear lower 2 bits of offset
			and ecx,3
			add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
			shl ecx,3
			mov eax,[esi]
			ror eax,cl				// Rotate value by (Offset & 3)*8
			jmp __rd_done

			// Return "random" data
		__rd_random:
			mov ecx,ebp
			mov eax,address
			ror eax,cl
			jmp __rd_done

		__rd_normal:
			test esi,3
			jnz __rd_unaligned
			and esi,[ecx+eax*4]		// AND with pageMask
			add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
			mov eax,[esi]

		__rd_done:
			mov n,eax
		}

	return n;
}


int __fastcall arm9_read_dword_itcm(unsigned int address)
{
	int n;

	if (address<0x8000)
	{
		__asm
		{
			mov ebx,address
			mov esi,ITCM
			test ebx,3
			jz __i_aligned
			mov ecx,ebx
			and ebx,0xFFFFFFFC
			and ecx,3
			mov eax,[esi + ebx]
			shl ecx,3
			ror eax,cl
			jmp __i_done
		__i_aligned:
			mov eax,[esi + ebx]
		__i_done:
			mov n,eax
		}
		return n;
	}

	if ((address>=dtcmBase) && (address<dtcmBase+0x4000))
		__asm
		{
			mov ebx,address
			mov esi,DTCM
			test ebx,3
			jz __aligned
			sub ebx,dtcmBase
			mov ecx,ebx
			and ebx,0xFFFFFFFC
			and ecx,3
			mov eax,[esi + ebx]
			shl ecx,3
			ror eax,cl
			jmp __done
		__aligned:
			sub ebx,dtcmBase
			mov eax,[esi + ebx]
		__done:
			mov n,eax
		}
	else
		__asm
		{
			mov ebx,address
			mov edx,arm9_pageTableAddr
			mov edi,arm9_pageLengthAddr
			mov esi,ebx
			mov ecx,arm9_pageMaskAddr
			shr ebx,20			// page
			and esi,0x0FFFFF	// offset
			mov eax,ebx
			shr eax,4

			jmp __rd_normal

			// Unaligned read, rotate data
		__rd_unaligned:
			mov ecx,esi
			and esi,0xFFFFFFFC		// Clear lower 2 bits of offset
			and ecx,3
			add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
			shl ecx,3
			mov eax,[esi]
			ror eax,cl				// Rotate value by (Offset & 3)*8
			jmp __rd_done

			// Return "random" data
		__rd_random:
			mov ecx,ebp
			mov eax,address
			ror eax,cl
			jmp __rd_done

		__rd_normal:
			test esi,3
			jnz __rd_unaligned
			and esi,[ecx+eax*4]		// AND with pageMask
			add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
			mov eax,[esi]

		__rd_done:
			mov n,eax
		}

	return n;
}


int __fastcall arm9_read_dword_io(unsigned int address)
{
	int n;

	__asm
	{
		mov ebx,address
		mov edx,arm9_pageTableAddr
		mov edi,arm9_pageLengthAddr
		mov esi,ebx
		mov ecx,arm9_pageMaskAddr
		shr ebx,20			// page
		and esi,0x0FFFFF	// offset
		mov eax,ebx
		shr eax,4

		cmp esi,P1
		jne __rd_normal
		mov ebx,[IOREGS + P1CNT]
		movzx eax,keys
		shl ebx,16
		or eax,ebx
		jmp __rd_done

		// Unaligned read, rotate data
__rd_unaligned:
		mov ecx,esi
		and esi,0xFFFFFFFC		// Clear lower 2 bits of offset
		and ecx,3
		add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
		shl ecx,3
		mov eax,[esi]
		ror eax,cl				// Rotate value by (Offset & 3)*8
		jmp __rd_done

		// Return "random" data
__rd_random:
		mov ecx,ebp
		mov eax,address
		ror eax,cl
		jmp __rd_done

__rd_normal:
		test esi,3
		jnz __rd_unaligned
		and esi,[ecx+eax*4]		// AND with pageMask
		add esi,[edx+ebx*4]		// ADD arm9_pageTable[page]
		mov eax,[esi]

__rd_done:
		mov n,eax
	}

	return n;
}

int __fastcall arm9_read_dword_rom(unsigned int address)
{
	int page,offset;
	int *pagew;

	if ((address&0xFFFFF) >= arm9_pageLength[0x8])
	{
		page = arm9_regs[15]-4;
		pagew = (int*)arm9_pageTable[page>>20];
		offset = (page&0x0FFFFF)>>2;
		return pagew[offset];
	}
	
	if (arm9_pageTable[address>>20])
		return *(int*)(arm9_pageTable[address>>20] + (address&0xFFFFF));

	return rand()&0xFFFFFFFF;

}


int __fastcall arm9_read_dword_ptok(unsigned int address)
{
	return *(int*)(arm9_pageTable[address>>20] + (address&0xFFFFF));
}


int __fastcall arm9_read_dword_wram(unsigned int address)
{
	return *(int*)(IWRAM + ((address)&0x7FFF));
}


int __fastcall arm9_read_dword_plt(unsigned int address)
{
	return *(int*)(PLT_VRAM + (address&0xFFF));
}


int __fastcall arm9_read_dword_oam(unsigned int address)
{
	return *(int*)(OAM + (address&0x7FF));
}


int __fastcall arm9_read_dword_lcdc(unsigned int address)
{
	int n;

	__asm
	{
		mov ebx,address
		and ebx,0xFFFFF
		cmp ebx,0xA3FFF
		jbe __rd_address_ok
		sub ebx,0xA3FFF
__rd_address_ok:
		mov edx,ebx
		lea esi,vramChunk
		shr edx,14
		and ebx,0x3FFF
		or edx,0x200
		xor eax,eax
		and edx,0x3FF
		or eax,[esi + edx*4]
		jz __rd_random
		
		jmp __rd_normal

		// Unaligned read, rotate data
__rd_unaligned:
		mov ecx,ebx
		and ebx,0xFFFFFFFC		// Clear lower 2 bits of offset
		and ecx,3
		shl ecx,3
		mov esi,[eax+ebx]
		ror esi,cl				// Rotate value by (Offset & 3)*8
		jmp __rd_done

		// Return "random" data
__rd_random:
		mov ecx,ebp
		mov eax,address
		ror eax,cl
		jmp __rd_done

__rd_normal:
		test esi,3
		jnz __rd_unaligned
		mov esi,[eax+ebx]

__rd_done:
		mov n,esi
	}

	return n;
}


int __fastcall arm9_read_dword_vram(unsigned int address)
{
	int n;

	__asm
	{
		mov ebx,address
		mov edx,ebx
		lea esi,vramChunk
		shr edx,14
		and ebx,0x3FFF
		or edx,0x200
		xor eax,eax
		and edx,0x3FF
		or eax,[esi + edx*4]
		jz __rd_random
		
		jmp __rd_normal

		// Unaligned read, rotate data
__rd_unaligned:
		mov ecx,ebx
		and ebx,0xFFFFFFFC		// Clear lower 2 bits of offset
		and ecx,3
		shl ecx,3
		mov esi,[eax+ebx]
		ror esi,cl				// Rotate value by (Offset & 3)*8
		jmp __rd_done

		// Return "random" data
__rd_random:
		mov ecx,ebp
		mov eax,address
		ror eax,cl
		jmp __rd_done

__rd_normal:
		test esi,3
		jnz __rd_unaligned
		mov esi,[eax+ebx]

__rd_done:
		mov n,esi
	}

	return n;
}


int __fastcall arm9_read_dword_na(unsigned int address)
{
	return rand()&0xFFFFFFFF;
}


int __fastcall arm9_read_dword_zero(unsigned int address)
{
	return 0;
}


int __fastcall arm9_read_dword_ipc(unsigned int address)
{
	int offset = address&0xFFFFF;

	if (offset == ipc_x)
		return (touch->x*14);
	if (offset== ipc_y)
		return (touch->y*8917)>>9;
	if (offset == ipc_z)
		return (touch->z&0x40)^0x40;

	if (arm9_pageTable[ipc_page])
		return *(int*)(arm9_pageTable[ipc_page] + offset);

	return rand()&0xFFFFFFFF;
}