#ifndef __NDSFILE_H__
#define __NDSFILE_H__

typedef struct
{
	char szGameTitle[12];
	char szGameCode[4];
	short int sMakerCode;
	short int sUnknows0;
	unsigned int uCardSize;
	char cCardInfo[7];
	char cFlags;
	unsigned int uARM9Source;
	unsigned int uARM9ExecuteFrom;
	unsigned int uARM9CopyTo;
	unsigned int uARM9Size;
	unsigned int uARM7Source;
	unsigned int uARM7ExecuteFrom;
	unsigned int uARM7CopyTo;
	unsigned int uARM7Size;

Field		Start	End	   Size	Example(metroid)
Game title	0x000	0x00B	12	FIRST HUNT
Game code	0x00C	0x00F	4	AMFE
Maker code	0x010	0x011	2	01 (Nintendo)
Unknown0	0x012	0x013	2	0x0000
Card size	0x014	0x017	4	7 (2^(17+7) = 16 MB)
Card info	0x018	0x01E	7	0x00's
Flags	0x01F	0x01F	1	0x00
ARM9 source (ROM)	0x020	0x023	4	0x00004000 (must be 4 KB aligned)
ARM9 execute addr	0x024	0x027	4	0x02004800
ARM9 copy to addr	0x028	0x02B	4	0x02004000
ARM9 binary size	0x02C	0x02F	4	0x00081D58
ARM7 source (ROM)	0x030	0x033	4	0x000B3000
ARM7 execute addr	0x034	0x037	4	0x02380000
ARM7 copy to addr	0x038	0x03B	4	0x02380000
ARM7 binary size	0x03C	0x03F	4	0x00026494
Filename table offset (ROM)	0x040	0x043	4	0x000D9600
Filename table size	0x044	0x047	4	0x11B6
FAT offset (ROM)	0x048	0x04B	4	0x000DA800
FAT size	0x04C	0x04F	4	0x678
ARM9 overlay src (ROM)	0x050	0x053	4	0x00085E00
ARM9 overlay size	0x054	0x057	4	0x60
ARM7 overlay src (ROM)	0x058	0x05B	4	0
ARM7 overlay size	0x05C	0x05F	4	0
Unknown2a*	0x060	0x063	4	0x00586000
Unknown2b*	0x064	0x067	4	0x001808F8
Icon+titles (ROM)	0x068	0x06B	4	0x000DB000
Secure CRC16	0x06C	0x06D	2	0xC44D
ROM timeout	0x06E	0x06F	2	0x051E
ARM9 unk addr	0x070	0x073	4	0x020049EC
ARM7 unk addr	0x074	0x077	4	0x02380110
Unknown 3c	0x078	0x07F	8	0x00's
ROM size	0x080	0x083	4	0x00EE3E44
Header size	0x084	0x087	4	0x4000
Unknown 5	0x088	0x0BF	56	0x00's
GBA logo	0x0C0	0x15B	156	data
Logo CRC16	0x15C	0x15D	2	0xCF56
Header CRC16	0x15E	0x15F	2	0x00F8
Reserved	0x160	0x1FF	160	0x00's
} NDSFileHeader;


#endif
