#ifndef __CMatrixStack_h__
#define __CMatrixStack_h__

#include <string.h>

typedef float t_matrix_4x4[4][4];
static const float identity_4x4[4][4] = {
	{1,0,0,0},
	{0,1,0,0},
	{0,0,1,0},
	{0,0,0,1}
};

class CMatrixStack
{
public:
	CMatrixStack(int);
	~CMatrixStack();

	void load_3x3(int);
	void load_4x3(int);
	void load_4x4(int);
	void store(t_matrix_4x4*,int);
	void restore(t_matrix_4x4*,int);
	void flush();
	void push(t_matrix_4x4*);
	void pop(t_matrix_4x4*,int);

	t_matrix_4x4 *m;
	int pos,max,depth;
	bool overflow,underflow;
};

#endif
