#pragma once
#include <windows.h>

struct SMPCPluginInfos
{
	// pointers to functions enabling/disabling the slave SH2
	void   (__cdecl * pfSlaveSH2On)(void);
	void   (__cdecl * pfSlaveSH2Off)(void);
	// pointers to functions reseting the SH2s
	void   (__cdecl * pfMasterSH2Reset)(void);
	void   (__cdecl * pfSlaveSH2Reset)(void);
	// pointers to functions enabling/disabling the SCSP
	void   (__cdecl * pf68kOn)(void);
	void   (__cdecl * pf68kOff)(void);
	// pointers to functions enabling/disabling the CD
	void   (__cdecl * pfCDOn)(void);
	void   (__cdecl * pfCDOff)(void);
	// pointer to function requesting a SMPC interrupt (master SH2)
	void   (__cdecl * pfSMPCInterrupt)(void);
	// pointer to function resquesting a system reset
	void   (__cdecl * pfSystemReset)(void);
	// pointers to functions changing the system clock
	void   (__cdecl * pfClockChange352)(void);
	void   (__cdecl * pfClockChange320)(void);
	// pointer to function returning the area code for the current CD
	// returns 0xFF if no CD inserted
	unsigned char   (__cdecl * pfGetCurrentCDAreaCode)(void);
	// pointer to function returning the current cart ID
	unsigned char   (__cdecl * pfGetCurrentCartID)(void);
	// function to write text in the emu's client area
	// color:0x00RRGGBB
	// please do not use "/n" character, use instead multiple calls to function to write multiple lines
	void   (__cdecl * pfWriteText)(char *text,unsigned long color);
	// handle to the application's handle
	HINSTANCE hInstance;
	// pointer to the path of the plugin host executable
	char *hostPath;
	// Plugin version
	// you must return the plugin interface version you implement
	// format: 0xnm for version n.m
	unsigned char version;

	// DEBUG
	void	(__cdecl * pfMasterSH2NMI)(void);
};

#if defined(__cplusplus)
extern "C" {
#endif

///////////////////////////////////////
// SMPC plugin interface version 1.0 //
///////////////////////////////////////

// called to init the plugin, return true if success
__declspec(dllexport) bool _cdecl InitSMPCPlugin(SMPCPluginInfos * infos);
// called to deinit the plugin
__declspec(dllexport) void _cdecl DeInitPlugin(void);
// for the about dialog box of the plugin
__declspec(dllexport) void _cdecl DisplayPluginInfo(void);
// must display a dialog box to configure the plugin
__declspec(dllexport) void _cdecl SetupPlugin(void);

// reset
__declspec(dllexport) void _cdecl Reset(void);
// SMPC update
// function parameter is the number of cycles elapsed since last call
__declspec(dllexport) void _cdecl SMPCUpdate(int Count);
// write byte to SMPC registers
__declspec(dllexport) void _fastcall  WriteSMPCRegs(unsigned long address,unsigned char data);
// read byte from SMPC registers
__declspec(dllexport) unsigned char _fastcall  ReadSMPCRegs(unsigned long address);
// increment RTC by one second
__declspec(dllexport) void _cdecl RTCIncrement(void);
// called when the SH2 clock changes
// the parameter is the number of cycles taken by 1 micro second (10e-6s)
__declspec(dllexport) void _cdecl SMPCClockChange(int us);
// called when the emulator changes its mode
// mode can take two values: 0 for saturn and 1 for STV mode
__declspec(dllexport) void _cdecl SMPCSetMode(int mode);
// saturn pad states
// used by the host when running in ST-V mode to emulate the two ST-V joysticks
// format :
// state[0]: player one
// state[1]: player two
// 8 bits used for each player: rlud abcd
//								 |	   |
//						high nibble   low nibble
// button or direction on: set corresponding bit to 1 else set bit to 0
// r:right, l:left, u:up, d:down, a:button 1, b:button 2, c:button 3, d:button 4
__declspec(dllexport) void _cdecl GetSTVJoysticksState(unsigned char state[2]);

#if defined(__cplusplus)
}
#endif