#pragma once
#include <windows.h>

struct SCSPPluginInfos
{
	// pointer to function requesting a SCSP interrupt (master SH2)
	void   (__cdecl * pfSCSPInterrupt)(void);
	// color:0x00RRGGBB
	// please do not use "/n" character, use instead multiple calls to function to write multiple lines
	void   (__cdecl * pfWriteText)(char *text,unsigned long color);
	// handle to the application's handle
	HINSTANCE hInstance;
	// pointer to the path of the plugin host executable
	char *hostPath;
	// Plugin version
	// you must return the plugin interface version you implement
	// format: 0xnm for version n.m
	unsigned char version;
};

#if defined(__cplusplus)
extern "C" {
#endif

///////////////////////////////////////
// SCSP plugin interface version 1.0 //
///////////////////////////////////////

// called to init the plugin, return true if success
__declspec(dllexport) bool _cdecl InitSCSPPlugin(SCSPPluginInfos * infos);
// called to deinit the plugin
__declspec(dllexport) void _cdecl DeInitPlugin(void);
// for the about dialog box of the plugin
__declspec(dllexport) void _cdecl DisplayPluginInfo(void);
// must display a dialog box to configure the plugin
__declspec(dllexport) void _cdecl SetupPlugin(void);

// reset
__declspec(dllexport) void _cdecl Reset(void);
// write to SCSP registers
__declspec(dllexport) void _fastcall WriteByteSCSPRegs(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall WriteWordSCSPRegs(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongSCSPRegs(unsigned long address,unsigned long data);
// read from SCSP registers
__declspec(dllexport) unsigned char _fastcall ReadByteSCSPRegs(unsigned long address);
__declspec(dllexport) unsigned short _fastcall ReadWordSCSPRegs(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongSCSPRegs(unsigned long address);
// write to SCSP RAM
__declspec(dllexport) void _fastcall WriteByteSCSPRAM(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall WriteWordSCSPRAM(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongSCSPRAM(unsigned long address,unsigned long data);
// read from SCSP RAM
__declspec(dllexport) unsigned char _fastcall ReadByteSCSPRAM(unsigned long address);
__declspec(dllexport) unsigned short _fastcall ReadWordSCSPRAM(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongSCSPRAM(unsigned long address);

// function called to run the 68000
// number is the number of 6800 cycles to go though
__declspec(dllexport) void _cdecl SCSPRunCycles(int number);
// function called when the SMPC ask for sound on/off
// state=true : sound on
// state=false : sound off
__declspec(dllexport) void __cdecl SetSound(bool state);

// function called when one frame is elapsed
__declspec(dllexport) void __cdecl OneFrameElapsed();

// function called when saturn switch to 50 or 60 frame per second
__declspec(dllexport) void _cdecl FPSchange(int fps);

#if defined(__cplusplus)
}
#endif