#pragma once
#include <windows.h>

struct CDBlockPluginInfos
{
	// function to write text in the emu's client area
	// color:0x00RRGGBB
	// please do not use "/n" character, use instead multiple calls to function to write multiple lines
	void   (__cdecl * pfWriteText)(char *text,unsigned long color);
	// handle to the application's handle
	HINSTANCE hInstance;
	// pointer to the path of the plugin host executable
	char *hostPath;
	// you shall call this function when a CD or ISO is inserted in
	// order to notice the plugin host that a CD game has been inserted
	// you have to give a pointer to a buffer containing the 0x100 first bytes
	// of the first sector
	void (__cdecl * pfCDInserted)(char *gameHeader);
	// Plugin version
	// the host fills this byte with the oldest plugin interface version it supports
	// you must return the plugin interface version you implement
	// format: 0xnm for version n.m
	unsigned char version;
};

#if defined(__cplusplus)
extern "C" {
#endif

///////////////////////////////////////////
// CD block plugin interface version 1.0 //
///////////////////////////////////////////

// called to init the plugin, return true if success
__declspec(dllexport) bool _cdecl InitCDBlockPlugin(CDBlockPluginInfos * infos);
// called to deinit the plugin
__declspec(dllexport) void _cdecl DeInitPlugin(void);
// for the about dialog box of the plugin
__declspec(dllexport) void _cdecl DisplayPluginInfo(void);
// must display a dialog box to configure the plugin
__declspec(dllexport) void _cdecl SetupPlugin(void);

// reset
__declspec(dllexport) void _cdecl Reset(void);
// write to CD block
__declspec(dllexport) void _fastcall WriteByteCDBlock(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall WriteWordCDBlock(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongCDBlock(unsigned long address,unsigned long data);
// read from CD block
__declspec(dllexport) unsigned char _fastcall ReadByteCDBlock(unsigned long address);
__declspec(dllexport) unsigned short _fastcall ReadWordCDBlock(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongCDBlock(unsigned long address);

// function called to run the CD block
// the number of cycles to be processed is given in SH2 frequency
__declspec(dllexport) void _cdecl CDBlockRunCycles(int number);

// called when the host SH2 frequency is modified
// freq is the actual SH2 frequency in Hz
__declspec(dllexport) void _cdecl SH2FrequencyChange(int freq);

// obsolete functions
__declspec(dllexport) void _cdecl CDBlockPeriodicResponse(void);
__declspec(dllexport) unsigned char _cdecl GetCurrentCDAreaCode(void);

#if defined(__cplusplus)
}
#endif