#ifndef DATATYPE_DEFINED
#define DATATYPE_DEFINED

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define DATATYPE_TWO_BYTE_HIGHFIRST     0
#define DATATYPE_TWO_BYTE_LOWFIRST      1
#define DATATYPE_FOUR_BYTE_HIGHFIRST    0
#define DATATYPE_FOUR_BYTE_LOWFIRST     1
#define DATATYPE_REAL_IEEE      0
#define DATATYPE_REAL_VAX       1
#endif

/* Byte orders above were determined by storing the numbers
 * shown in a binary file and then reading the file back in to
 * a byte array of 8 bit numbers.
 *      Compiler/machine        0x0102          0x01020304
 *      Turbo C                 2, 1            4, 3, 2, 1
 *      MS Visual C++           2, 1            4, 3, 2, 1
 *      Gnu C on Intel          2, 1            4, 3, 2, 1
 *      VAX C                   2, 1            4, 3, 2, 1
 *      IBM RS/6000             1, 2            1, 2, 3, 4
 *      Sun Sparc               1, 2            1, 2, 3, 4
 *      SGI                     1, 2            1, 2, 3, 4
 *
 *      DATATYPE_TWO_BYTE_HIGHFIRST     1, 2
 *      DATATYPE_TWO_BYTE_LOWFIRST      2, 1
 *      DATATYPE_FOUR_BYTE_HIGHFIRST                    1, 2, 3, 4
 *      DATATYPE_FOUR_BYTE_LOWFIRST                     4, 3, 2, 1
 */

#if (defined(__GNUC__) && defined(__i386__) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned long int
#define INT32           long int
#define DATATYPE_TWO_BYTE_ORDER  DATATYPE_TWO_BYTE_LOWFIRST
#define DATATYPE_FOUR_BYTE_ORDER DATATYPE_FOUR_BYTE_LOWFIRST
#define DATATYPE_REAL_FORMAT     DATATYPE_REAL_IEEE
#endif

#if (defined(_MSC_VER) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned long int
#define INT32           long int
#define DATATYPE_TWO_BYTE_ORDER  DATATYPE_TWO_BYTE_LOWFIRST
#define DATATYPE_FOUR_BYTE_ORDER DATATYPE_FOUR_BYTE_LOWFIRST
#define DATATYPE_REAL_FORMAT     DATATYPE_REAL_IEEE
#endif

#if (defined(__BORLANDC__) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned long int
#define INT32           long int
#define DATATYPE_TWO_BYTE_ORDER  DATATYPE_TWO_BYTE_LOWFIRST
#define DATATYPE_FOUR_BYTE_ORDER DATATYPE_FOUR_BYTE_LOWFIRST
#define DATATYPE_REAL_FORMAT     DATATYPE_REAL_IEEE
#endif

#if (defined(VAXC) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned long int
#define INT32           long int
#define DATATYPE_TWO_BYTE_ORDER  DATATYPE_TWO_BYTE_LOWFIRST
#define DATATYPE_FOUR_BYTE_ORDER DATATYPE_FOUR_BYTE_LOWFIRST
#define DATATYPE_REAL_FORMAT     DATATYPE_REAL_VAX
#define RET_AFTER_GETS
#endif

#if (defined(_IBMR2) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned long int
#define INT32           long int
#define DATATYPE_TWO_BYTE_ORDER  DATATYPE_TWO_BYTE_HIGHFIRST
#define DATATYPE_FOUR_BYTE_ORDER DATATYPE_FOUR_BYTE_HIGHFIRST
#define DATATYPE_REAL_FORMAT     DATATYPE_REAL_IEEE
#endif

#if (defined(sparc) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned int
#define INT32           int
#define DATATYPE_TWO_BYTE_ORDER  DATATYPE_TWO_BYTE_HIGHFIRST
#define DATATYPE_FOUR_BYTE_ORDER DATATYPE_FOUR_BYTE_HIGHFIRST
#define DATATYPE_REAL_FORMAT     DATATYPE_REAL_IEEE
#endif

#if (defined(__mips) && !defined(UINT8))
#define UINT8           unsigned char
#define INT8            char
#define UINT16          unsigned short int
#define INT16           short int
#define UINT32          unsigned int
#define INT32           int
#define DATATYPE_TWO_BYTE_ORDER   DATATYPE_TWO_BYTE_HIGHFIRST
#define DATATYPE_FOUR_BYTE_ORDER  DATATYPE_FOUR_BYTE_HIGHFIRST
#define DATATYPE_REAL_FORMAT      DATATYPE_REAL_IEEE

#endif //DATATYPE_DEFINED
