/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Stringconv.h"

int n_strncmpA( register const char *string1, register const char *string2, register size_t count )
{
	if( string1 == string2 )
		return NULL;
	while( --count > 0 && *string1 == *string2 && *string2 != '\0' )
	{
		++string1;
		++string2;
	}
	return *string1 - *string2;
}

int n_strncmpW( register const wchar_t *string1, register const wchar_t *string2, register size_t count )
{
	if( string1 == string2 )
		return NULL;
	while( --count > 0 && *string1 == *string2 && *string2 != (wchar_t)'\0' )
	{
		string1 += 2;
		string2 += 2;
	}
	return *string1 - *string2;
}


char* n_strchrA( register const char* s, register int c )
{
	do
	{
		if( *s == c )
			return (char*)s;
	}
	while( *s++ != '\0' );
	return (char*)NULL;
}

wchar_t* n_strchrW( register const wchar_t* s, register int c )
{
	do
	{
		if( *s == c )
			return (wchar_t*)s;
	}
	while( *s++ != (wchar_t)'\0' );
	return (wchar_t*)NULL;
}

char* n_strrchrA( register const char* s, register int c )
{
	char *lastInst = NULL;
	do
	{
		lastInst = (*s == c) ? (char*)s : lastInst;
	}
	while( *s++ != '\0' );
	
	return (char*)lastInst;
}

wchar_t* n_strrchrW( register const wchar_t* s, register int c )
{
	wchar_t *lastInst = NULL;
	do
	{
		lastInst = ( *s == c ) ? (wchar_t*)s : lastInst;
	}
	while( *s++ != (wchar_t)'\0' );
	
	return (wchar_t*)lastInst;
}

