/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _PAKIO_H_
#define _PAKIO_H_

BYTE InitControllerPak( int iControl );
void SaveControllerPak( int iControl );
BYTE ReadControllerPak( int iControl, BYTE * Command );
BYTE WriteControllerPak( int iControl, BYTE * Command );
void CloseControllerPak( int iControl );
WORD ShowMemPakContent( BYTE *bMemPakBinary, HWND hListWindow );
TCHAR TranslateNotes( BYTE *bNote, TCHAR *Text );
void FormatMemPak( BYTE *aMemPak );
bool SaveNoteFileA( LPBYTE aMemPak, int iNote, LPTSTR pszFileName );
bool InsertNoteFile( BYTE *aMemPak, TCHAR *pszFileName );
bool RemoveNote( BYTE *aMemPak, int iNote );

void TexttoHexA( LPSTR szText, LPBYTE Data, CONST int nBytes );
void HextoTextA( LPBYTE Data, LPSTR szText, CONST int nBytes );



//************Raw Data***********//
   //byte 1 = number of bytes to send
   //byte 2 = number of bytes to recieve
   //byte 3 = Command Type

#define RD_GETSTATUS		0x00 // get status
#define RD_READKEYS			0x01 // read button values
#define RD_READPAK			0x02 // read from controllerpack
#define RD_WRITEPAK			0x03 // write to controllerpack
#define RD_RESETCONTROLLER	0xff // reset controller
#define RD_READEEPROM		0x04 // read eeprom
#define RD_WRITEEPROM		0x05 // write eeprom

	// Codes for retrieving status
    // 0x010300 - A1B2C3FF

	//A1
#define RD_ABSOLUTE			0x01 // Default GamePad
#define RD_RELATIVE			0x02
#define RD_GAMEPAD			0x04 // Default GamePad

	//B2
#define RD_EEPROM			0x80 
#define RD_NOEEPROM			0x00

	//C3
#define RD_NOPLUGIN			0x00 // No Plugin in Controller
#define RD_PLUGIN			0x01 // Plugin in Controller (Mempack, RumblePack etc)
#define RD_NOTINITIALIZED	0x02 // Pak interface was uninitialized before the call
#define RD_ADDRCRCERR		0x04 // Address of last Pak I/O was invalid
#define RD_EEPROMBUSY		0x80 // eeprom busy

// The Error values are as follows:
// 0x01ER00 - ........

	//ER
#define RD_OK				0x00 // no error, operation successful.
#define RD_ERROR			0x80 // error, device not present for specified command.
#define RD_WRONGSIZE		0x40 // error, unable to send/recieve the number bytes for command type.

#define PAK_IO_RUMBLE		0xC000		// the address where rumble-commands are sent to

// Pak Specific Data //
// First BYTE always determines current Paktype
// this can be different to the paktype in the Controller-structure.
// that makes sure to corectly handle/close the pak.

//PAK_NONE
//pPakData = NULL;

//PAK_MEM
typedef struct _MEMPAK
{
	BYTE bPakType;
	HANDLE hMemPakFile;
	bool fDexSave;
	bool fReadonly;
	BYTE aMemPakData[32*1024+0x100];
} MEMPAK, *LPMEMPAK;

//PAK_RUMBLE
typedef struct _RUMBLEPAK
{
	BYTE bPakType;
	BYTE bRumbleTyp;
	BYTE bRumbleStrength;
	bool fVisualRumble;
} RUMBLEPAK, *LPRUMBLEPAK;

//PAK_TRANSFER
/**typedef struct _TRANSFERPAK
{
	BYTE bPakType;
	HANDLE hRomFile;
	HANDLE hSaveFile;

} TRANSFERPAK, *LPTRANSFERPAK;**/

#include "GBCart.h"
//PAK_TRANSFER
typedef struct _TRANSFERPAK
{
	BYTE bPakType;
	int iCurrentBankNo;
	int iCurrentAccessMode;
	int iAccessModeChanged;
	bool iEnableState;
	bool bPakInserted;
	GBCART gbCart;
} TRANSFERPAK, *LPTRANSFERPAK;

//PAK_VOICE
typedef struct _VOICEPAK //not supported
{
	BYTE bPakType;
} VOICEPAK, *LPVOICEPAK;
 
//PAK_ADAPTOID
typedef struct _ADAPTOIDPAK
{
	BYTE bPakType;
	BYTE bIdentifier;
	bool fRumblePak;
} ADAPTOIDPAK, *LPADAPTOIDPAK;

#endif // #ifndef _PAKIO_H_