/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <windows.h>
#include <Commctrl.h>
#include "commonIncludes.h"
#include "NRage PluginV2.h"
#include "DirectInput.h"
#include "Interface.h"
#include "DataBufferClass.h"
#include "FileAcces.h"
#include "PakIO.h"
#include "GBCart.h"

// ProtoTypes
void FormatMemPak( BYTE *aMemPak );
void SaveControllerPak( int iControl );
void CloseControllerPak( int iControl );
BYTE AddressCRC( LPBYTE Address );
BYTE DataCRC( LPBYTE Data, CONST int iLenght );

BYTE InitControllerPak( int iControl )
// Prepares the Pak
{
	if( !g_pcControllers[iControl].fPlugged )
		return FALSE;
	BYTE bReturn = FALSE;
	if( g_pcControllers[iControl].pPakData )
	{
		SaveControllerPak( iControl );
		CloseControllerPak( iControl );
	}

	switch( g_pcControllers[iControl].PakType )
	{
	case PAK_MEM:
		{
			g_pcControllers[iControl].pPakData = P_malloc( sizeof(MEMPAK));
			MEMPAK *mPak = (MEMPAK*)g_pcControllers[iControl].pPakData;
			mPak->bPakType = PAK_MEM;
			mPak->fReadonly = false;
			mPak->fDexSave = false;
			mPak->hMemPakFile = INVALID_HANDLE_VALUE;

			TCHAR szBuffer[MAX_PATH+1],
				  szFullPath[MAX_PATH+1],
				  *pcFile,
				  *pcSlash;
			GetAbsoluteFileName( szBuffer, g_pcControllers[iControl].szMempakFile, DIRECTORY_MEMPAK );
			GetFullPathName( szBuffer, sizeof(szFullPath) / sizeof(TCHAR), szFullPath, &pcFile );

			if( pcFile == NULL )
			{ // no Filename specified
				if( MessageBox( g_strEmuInfo.hMainWindow, "No Mempak specified, please configure Plugin", PLUGINWARNING, MB_OKCANCEL | MB_ICONWARNING ) == IDCANCEL )
					g_pcControllers[iControl].PakType = PAK_NONE;
				break;

			}

			pcSlash = n_strrchr( szFullPath, '\\' );
			if( pcSlash )
			{
				*pcSlash = '\0';
				
				if( !CheckFileExists( szFullPath ))
				{
					wsprintf( szBuffer, "Error creating Mempak!\nThe MemPak Directory doesn`t exist!\n\nCreate Directory \"%s\" now?", szFullPath );
					if( MessageBox( g_strEmuInfo.hMainWindow, szBuffer, PLUGINWARNING, MB_OKCANCEL | MB_ICONQUESTION ) == IDOK )
						CreateMultipleDirs( szFullPath );
				}
				*pcSlash = '\\';
			}


			mPak->hMemPakFile = CreateFile( szFullPath, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS, 0, NULL );
			if( mPak->hMemPakFile == INVALID_HANDLE_VALUE )
			{// test if Read-only access is possible
				mPak->hMemPakFile = CreateFile( szFullPath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_ALWAYS, 0, NULL );
				if( mPak->hMemPakFile != INVALID_HANDLE_VALUE )
				{
					mPak->fReadonly = true;
					wsprintf( szBuffer, "Mempak \"%s\" opened with Read-only access.\nAfter exiting the Game the Mempak will not be saved", pcFile );
					//MessageBox( g_strEmuInfo.hMainWindow, szBuffer, PLUGINWARNING, MB_OK | MB_ICONWARNING );
				}
			}
			if( mPak->hMemPakFile != INVALID_HANDLE_VALUE )
			{
				DWORD dwBytesRead = 0;
				DWORD dwFilesize = 32*1024;
				TCHAR *pcPoint = n_strrchr( pcFile, '.' );

				if( !lstrcmpi( pcPoint, ".n64" ) )
				{
					mPak->fDexSave = true;
					SetFilePointer( mPak->hMemPakFile, 0x1040, NULL, FILE_BEGIN );
					dwFilesize += 0x1040;
				} else
				{
					mPak->fDexSave = false;
					SetFilePointer( mPak->hMemPakFile, 0L, NULL, FILE_BEGIN );
				}

				dwFilesize = min( dwFilesize, GetFileSize( mPak->hMemPakFile, NULL ));
				if( dwFilesize > 0 )
				{
					if( ReadFile( mPak->hMemPakFile, mPak->aMemPakData, dwFilesize, &dwBytesRead, NULL ))
					{
						dwBytesRead = 32*1024 - dwFilesize;
						if( dwBytesRead > 0 )
							FillMemory( &mPak->aMemPakData[dwFilesize], dwBytesRead, 0xFF );

						bReturn = TRUE;
					}
				}
				else
				{
					FormatMemPak( mPak->aMemPakData );
					bReturn = TRUE;
				}
			}
			else
			{
				wsprintf( szBuffer, "Error creating Mempak!\nCouldnt create/open MemPakfile \"%s\"", szFullPath );
				if( !ErrorMessage( szBuffer, GetLastError(), true ))
					g_pcControllers[iControl].PakType = PAK_NONE;
			}
		}
		break;

	case PAK_RUMBLE:
		{
			g_pcControllers[iControl].pPakData = P_malloc( sizeof(RUMBLEPAK));
			RUMBLEPAK *rPak = (RUMBLEPAK*)g_pcControllers[iControl].pPakData;
			rPak->bPakType = PAK_RUMBLE;

			rPak->bRumbleTyp = g_pcControllers[iControl].bRumbleTyp;
			rPak->bRumbleStrength = g_pcControllers[iControl].bRumbleStrength;
			rPak->fVisualRumble = g_pcControllers[iControl].fVisualRumble;
			
			CreateEffectHandle( iControl, rPak->bRumbleTyp, rPak->bRumbleStrength );
			bReturn = TRUE;
		}
		break;
	case PAK_TRANSFER:
		{
			g_pcControllers[iControl].pPakData = P_malloc( sizeof(TRANSFERPAK));
			LPTRANSFERPAK tPak = (LPTRANSFERPAK)g_pcControllers[iControl].pPakData;
			tPak->bPakType = PAK_TRANSFER;

			/*
			 * Once the Interface is implemented g_pcControllers[iControl].szTransferRom will hold filename of the GB-Rom
			 * and g_pcControllers[iControl].szTransferSave holds Filename of the SRAM Save
			 * 
			 * Here, both files should be opened and the handles stored in tPak ( modify the struct for Your own purposes, only bPakType must stay at first )
			 */


			//CreateFile( g_pcControllers[iControl].szTransferSave, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_ALWAYS, 0, NULL );
			//MessageBox( g_strEmuInfo.hMainWindow, "*** Transfer Pak Init ***", PLUGINWARNING, MB_OKCANCEL | MB_ICONWARNING );
			tPak->iCurrentAccessMode = 0;
			tPak->iCurrentBankNo = 0;
			tPak->iEnableState = false;
			tPak->iAccessModeChanged = 0x44;

			if (LoadCart( &tPak->gbCart, g_pcControllers[iControl].szTransferRom, g_pcControllers[iControl].szTransferSave, "") == true) {
				bReturn = TRUE;
				DebugWrite( "*** Init Transfer Pak - Success***\n" );
				tPak->bPakInserted = true;
			} else {
				bReturn = FALSE;
				DebugWrite( "*** Init Transfer Pak - FAILURE***\n" );
				tPak->bPakInserted = false;
			}
		}
		break;

	/*case PAK_VOICE:
		{
			g_pcControllers[iControl].pPakData = P_malloc( sizeof(VOICEPAK));
			VOICEPAK *vPak = (VOICEPAK*)g_pcControllers[iControl].pPakData;
			vPak->bPakType = PAK_VOICE;

			bReturn = TRUE;
		}
		break;*/
	
	case PAK_ADAPTOID:
		if( !g_pcControllers[iControl].fIsAdaptoid )
			g_pcControllers[iControl].PakType = PAK_NONE;
		else
		{
			g_pcControllers[iControl].pPakData = P_malloc( sizeof(ADAPTOIDPAK));
			ADAPTOIDPAK *aPak = (ADAPTOIDPAK*)g_pcControllers[iControl].pPakData;
			aPak->bPakType = PAK_ADAPTOID;

			aPak->bIdentifier = 0x80;
#ifdef ADAPTOIDPAK_RUMBLEFIX
			aPak->fRumblePak = true;
#pragma message( "Driver-fix for Rumble with Adaptoid enabled" )
#else
			aPak->fRumblePak = false;
#endif
			bReturn = TRUE;
		}
		break;

	
	/*case PAK_NONE:
		break;*/
	}

	if( !bReturn && g_pcControllers[iControl].pPakData )
		CloseControllerPak( iControl );

	return bReturn;
}


BYTE ReadControllerPak( int iControl, BYTE *Command )
{
	BYTE bReturn = RD_ERROR;
	BYTE *Data = &Command[2];

#ifdef MAKEADRESSCRCCHECK
#pragma message( "Addresscheck for Pak-Reads active" )
	if( AddressCRC( Command ) != (Command[1] & 0x1F) )
	{
		g_pcControllers[iControl].fPakCRCError = true;
		if( MessageBox( g_strEmuInfo.hMainWindow, "bad AdressCRC detected!!\n Bad ROM??\n\nIgnore it and continue?", PLUGINWARNING, MB_OKCANCEL | MB_ICONQUESTION ) == IDCANCEL )
			return RD_ERROR;
	}
#endif

	if( !g_pcControllers[iControl].pPakData )
		return RD_ERROR;

	DWORD dwAddress = (Command[0] << 8) + (Command[1] & 0xE0);

	switch( *(BYTE*)g_pcControllers[iControl].pPakData )
	{
	case PAK_MEM:
		{
			MEMPAK *mPak = (MEMPAK*)g_pcControllers[iControl].pPakData;
			
			if( dwAddress < 0x8000 )
				CopyMemory( Data, &mPak->aMemPakData[dwAddress], 32 );
			else
				CopyMemory( Data, &mPak->aMemPakData[0x8000+(dwAddress%0x100)], 32 );
			Data[32] = DataCRC( Data, 32 );
			bReturn = RD_OK;
		}
		break;
	case PAK_RUMBLE:
		if(( dwAddress >= 0x8000 ) && ( dwAddress < 0x9000 ) )
			FillMemory( Data, 32, 0x80 );
		else
			FillMemory( Data, 32, 0x00 );

		Data[32] = DataCRC( Data, 32 );
		bReturn = RD_OK;
		break;

	case PAK_TRANSFER:
		{
			LPTRANSFERPAK tPak = (LPTRANSFERPAK)g_pcControllers[iControl].pPakData;
			// set bReturn = RD_OK when implementing Transferpak
			bReturn = RD_OK;
			DebugWrite( "TPak Read:\n" );
			DebugWrite( "  Address: %04X\n", dwAddress );

			int i;

			if ((dwAddress >= 0x8000) && (dwAddress <= 0x8FFF)) {
				DebugWrite( "Query Enable State: %u\n", tPak->iEnableState );

				if (tPak->iEnableState == false) for (i=0; i<32; i++) Data[i] = 0;
				if (tPak->iEnableState == true) for (i=0; i<32; i++) Data[i] = 0x84;
			}

			if (tPak->iEnableState == true) {
				if ((dwAddress >= 0xB000) && (dwAddress <= 0xBFFF)) {
					DebugWrite( "Query Cart. State:" );
					if (tPak->bPakInserted) {
						if (tPak->iCurrentAccessMode == 1) {
							for (i=0; i<32; i++) Data[i] = 0x89;
							DebugWrite( " Inserted, Access Mode 1\n" );
						} else {
							for (i=0; i<32; i++) Data[i] = 0x80;
							DebugWrite( " Inserted, Access Mode 0\n" );
						}
						Data[0] = Data[0] | tPak->iAccessModeChanged;
					} else {
						for (i=0; i<32; i++) Data[i] = 0x40; // Cart not inserted.
						DebugWrite( " Not Inserted\n" );
					}
					tPak->iAccessModeChanged = 0;
				}
				if ((dwAddress >= 0xC000) && (dwAddress <= 0xFFFF)) {
					DebugWrite( "Cart Read: Bank:%i\n", tPak->iCurrentBankNo );
					DebugWrite( "    Address:%04X\n", ((dwAddress & 0xFFE0) - 0xC000) + ((tPak->iCurrentBankNo & 3) * 0x4000) );

					ReadCart(&tPak->gbCart, ((dwAddress & 0xFFE0) - 0xC000) + ((tPak->iCurrentBankNo & 3) * 0x4000), Data);
				}
			}

			
			if (((dwAddress >= 0x0000) && (dwAddress <= 0x7FFF)) || 
				((dwAddress >= 0x9000) && (dwAddress <= 0xAFFF))) {
				DebugWrite("WARNING: Unusual Pak Read\n");
				DebugWrite("  Address: ");
				DebugWriteWord(dwAddress);
				DebugWrite("\n");
			}

#ifdef ENABLE_TPAK_READS_WRITES_DEBUG
			DebugWrite( "TPak Data: " );

			for (i = 0; i < 32; i ++) {
				if ((i < 31) && ((i & 7) == 0)) DebugWrite( "\n  " );
				DebugWriteByte(Data[i]);
				if (i < 31) {
					DebugWrite( ", ");
				}
			}
			DebugWrite( "\n" );
#endif
			DebugWrite( "\n" );

			Data[32] = DataCRC( Data, 32 );

			bReturn = RD_OK;
		}
		break;

	/*case PAK_VOICE:
		break;*/
	
	case PAK_ADAPTOID:
		if( ReadAdaptoidPak( iControl, dwAddress, Data ) == DI_OK )
		{
			Data[32] = DataCRC( Data, 32 );
			bReturn = RD_OK;
			
			if( ((ADAPTOIDPAK*)g_pcControllers[iControl].pPakData)->fRumblePak )
			{
				BYTE bId = ((ADAPTOIDPAK*)g_pcControllers[iControl].pPakData)->bIdentifier;
				if(	(( dwAddress == 0x8000 ) && ( bId == 0x80 ) && ( Data[0] != 0x80 ))
					|| (( dwAddress == 0x8000 ) && ( bId != 0x80 ) && ( Data[0] != 0x00 ))
					|| (( dwAddress < 0x8000 ) && ( Data[0] != 0x00 )))
				{
					((ADAPTOIDPAK*)g_pcControllers[iControl].pPakData)->fRumblePak = false;
					DebugWriteA( "\nAssuming the inserted Pak AINT a RumblePak\nDisabling Rumblefix\n" );
				}	
			}
		}
		break;
	
	/*case PAK_NONE:
		break;*/
	}

	return bReturn;
}

BYTE WriteControllerPak( int iControl, BYTE *Command )
{
	BYTE bReturn = RD_ERROR;
	BYTE *Data = &Command[2];

#ifdef MAKEADRESSCRCCHECK
#pragma message( "Addresscheck for Pak-Writes active" )
	if( AddressCRC( Command ) != (Command[1] & 0x1F) )
	{
		g_pcControllers[iControl].fPakCRCError = true;
		if( MessageBox( g_strEmuInfo.hMainWindow, "bad AdressCRC detected!!\n Bad ROM??\n\nIgnore it and continue?", PLUGINWARNING, MB_OKCANCEL | MB_ICONQUESTION ) == IDCANCEL )
			return RD_ERROR;
	}
#endif

	if( !g_pcControllers[iControl].pPakData )
		return RD_ERROR;

	DWORD dwAddress = (Command[0] << 8) + (Command[1] & 0xE0);

	switch( *(BYTE*)g_pcControllers[iControl].pPakData )
	{
	case PAK_MEM:
		{
			MEMPAK *mPak = (MEMPAK*)g_pcControllers[iControl].pPakData;
			
			if( dwAddress < 0x8000 )
				CopyMemory( &mPak->aMemPakData[dwAddress], Data, 32 );
			else
				CopyMemory( &mPak->aMemPakData[0x8000+(dwAddress%0x100)], Data, 32 );
			Data[32] = DataCRC( Data, 32 );
			bReturn = RD_OK;
		}
		break;
	case PAK_RUMBLE:
		if( dwAddress == PAK_IO_RUMBLE )
		{
			RUMBLEPAK *rPak = (RUMBLEPAK*)g_pcControllers[iControl].pPakData;
			if( rPak->fVisualRumble )
				FlashWindow( g_strEmuInfo.hMainWindow, ( *Data != 0 ) ? TRUE : FALSE );
			if( rPak->bRumbleTyp == RUMBLE_DIRECT )
			{  // Adaptoid Direct Rumble
				if( g_pcControllers[iControl].fIsAdaptoid )
					DirectRumbleCommand( iControl, *Data );
			}
			else
			{  // FF-FeedBack Rumble
				if( g_apdiEffect[iControl] )
				{
					if( *Data )
					{
						HRESULT hr;
						hr = g_apdiEffect[iControl]->Start( 1, DIES_NODOWNLOAD );
						if( hr != DI_OK )// just download if needed( seems to work smoother)
							g_apdiEffect[iControl]->Start( 1, 0);
					}
					else
					{
						if( g_apdiEffect[iControl] )
							g_apdiEffect[iControl]->Stop();
					}
				}
			}
		}

		Data[32] = DataCRC( Data, 32 );
		bReturn = RD_OK;
		break;

	case PAK_TRANSFER:
		{
			LPTRANSFERPAK tPak = (LPTRANSFERPAK)g_pcControllers[iControl].pPakData;
			// set bReturn = RD_OK when implementing Transferpak
			DebugWrite( "TPak Write:\n" );
			DebugWrite( "  Address: %04X\n", dwAddress );

#ifdef ENABLE_TPAK_READS_WRITES_DEBUG
			DebugWrite( "  Data: ");

			int i;

			for (i = 0; i < 32; i++) {
				if ((i < 31) && ((i & 7) == 0)) DebugWrite( "\n    " );
				DebugWriteByte( Data[i]);
				if (i < 31) {
					DebugWrite( ", ");
				}
			}

			DebugWrite( "\n" );
#endif

			if ((dwAddress >= 0xC000) && (dwAddress <= 0xFFFF)) {
				WriteCart(&tPak->gbCart, ((dwAddress & 0xFFE0) - 0xC000) + ((tPak->iCurrentBankNo & 3) * 0x4000), Data);
			}

			if ((dwAddress >= 0x8000) && (dwAddress <= 0x8FFF)) {
				if (Data[0] == 0xFE) {
					DebugWrite("Cart Disable\n");
					tPak->iEnableState = false;
				}
				if (Data[0] == 0x84) {
					DebugWrite("Cart Enable\n");
					tPak->iEnableState = true;
				}
				if ((Data[0] != 0xFE) && (Data[0] != 0x84)) {
					DebugWrite("WARNING: Unusual Cart Enable/Disable\n");
					DebugWrite("  Address: ");
					DebugWriteWord(dwAddress);
					DebugWrite("\n");
					DebugWrite("  Data: ");
					DebugWriteByte(Data[0]);
					DebugWrite("\n");
				}
			}

			if (tPak->iEnableState == true) {
				if ((dwAddress >= 0xA000) && (dwAddress <= 0xAFFF)) {
					tPak->iCurrentBankNo = Data[0];
					DebugWrite("Set TPak Bank No:%02X\n", Data[0] );
				}
				if ((dwAddress >= 0xB000) && (dwAddress <= 0xBFFF)) {
					tPak->iCurrentAccessMode = Data[0] & 1;
					tPak->iAccessModeChanged = 4;
					DebugWrite("Set TPak Access Mode: %04X\n", tPak->iCurrentAccessMode);
					if ((Data[0] != 1) && (Data[0] != 0)) {
						DebugWrite("WARNING: Unusual Access Mode Change\n");
						DebugWrite("  Address: ");
						DebugWriteWord(dwAddress);
						DebugWrite("\n");
						DebugWrite("  Data: ");
						DebugWriteByte(Data[0]);
						DebugWrite("\n");
					}
				}
			}

			if (((dwAddress >= 0x0000) && (dwAddress <= 0x7FFF)) || 
				((dwAddress >= 0x9000) && (dwAddress <= 0x9FFF))) {
				DebugWrite("WARNING: Unusual Pak Write\n");
				DebugWrite("  Address: ");
				DebugWriteWord(dwAddress);
				DebugWrite("\n");
			}



			DebugWrite( "\n" );

			Data[32] = DataCRC( Data, 32 );
			bReturn = RD_OK; 
		}
		break;

	/*case PAK_VOICE:
		break;*/
	
	case PAK_ADAPTOID:
		if(( dwAddress == PAK_IO_RUMBLE ) && ((ADAPTOIDPAK*)g_pcControllers[iControl].pPakData)->fRumblePak )
		{
			if( DirectRumbleCommand( iControl, *Data ) == DI_OK )
			{
				Data[32] = DataCRC( Data, 32 );
				bReturn = RD_OK;
			}
		}
		else
		{
			if( WriteAdaptoidPak( iControl, dwAddress, Data ) == DI_OK )
			{
				Data[32] = DataCRC( Data, 32 );
				if( dwAddress == 0x8000 )
					((ADAPTOIDPAK*)g_pcControllers[iControl].pPakData)->bIdentifier = Data[0];

				bReturn = RD_OK;
			}
		}
		break;

	/*case PAK_NONE:
		break;*/
	}

	return bReturn;
}

void SaveControllerPak( int iControl )
{
	if( !g_pcControllers[iControl].pPakData )
		return;

	switch( *(BYTE*)g_pcControllers[iControl].pPakData )
	{
	case PAK_MEM:
		{
			MEMPAK *mPak = (MEMPAK*)g_pcControllers[iControl].pPakData;
			DWORD dwBytesWritten = 0;

			if( mPak->fReadonly )
				break;

			do
			{
				if( mPak->fDexSave )
				{
					if( GetFileSize( mPak->hMemPakFile, NULL ) <= 0 )
					{// write Header if new File
						SetFilePointer( mPak->hMemPakFile, 0x0, NULL, FILE_BEGIN );
						char szHeader[] = "123-456-STD";
						WriteFile( mPak->hMemPakFile, szHeader, sizeof(szHeader), &dwBytesWritten, NULL );
					}
					SetFilePointer( mPak->hMemPakFile, 0x1040, NULL, FILE_BEGIN );
				}
				else
					SetFilePointer( mPak->hMemPakFile, 0L, NULL, FILE_BEGIN );

				if( WriteFile( mPak->hMemPakFile, mPak->aMemPakData, 32*1024, &dwBytesWritten, NULL ))
					SetEndOfFile( mPak->hMemPakFile );
			}
			while(	(dwBytesWritten != 32*1024 )
					&& ErrorMessage( "Failed to save MemPak Contents", GetLastError(), true ));
		}
		break;
	case PAK_RUMBLE:
		break;
	case PAK_TRANSFER:
		{
			LPTRANSFERPAK tPak = (LPTRANSFERPAK)g_pcControllers[iControl].pPakData;
			// here the changes( if any ) in the SRAM should be saved
			SaveCart(&tPak->gbCart, g_pcControllers[iControl].szTransferSave, "");
			DebugWrite( "*** Save Transfer Pak ***\n" );
		}
		break;
	case PAK_VOICE:
		break;
	case PAK_ADAPTOID:
		break;

	/*case PAK_NONE:
		break;*/
	}
}

void CloseControllerPak( int iControl )
{
	if( !g_pcControllers[iControl].pPakData )
		return;

	g_pcControllers[iControl].fPakInitialized = false;

	switch( *(BYTE*)g_pcControllers[iControl].pPakData )
	{
	case PAK_MEM:
		{
			MEMPAK *mPak = (MEMPAK*)g_pcControllers[iControl].pPakData;
			if( mPak->hMemPakFile != INVALID_HANDLE_VALUE )
				CloseHandle( mPak->hMemPakFile );
		}
		break;
	case PAK_RUMBLE:
		ReleaseEffect( iControl );
		break;
	case PAK_TRANSFER:
		{
			LPTRANSFERPAK tPak = (LPTRANSFERPAK)g_pcControllers[iControl].pPakData;
//			UnloadCart(tPak->Cartrige);
			UnloadCart(&tPak->gbCart);
			DebugWrite( "*** Close Transfer Pak ***\n" );
			// close files and free any additionally ressources
			//MessageBox( g_strEmuInfo.hMainWindow, "*** Transfer Pak Close ***", PLUGINWARNING, MB_OKCANCEL | MB_ICONWARNING );
		}
		break;
	case PAK_VOICE:
		break;
	
	case PAK_ADAPTOID:
		break;

	/*case PAK_NONE:
		break;*/
	}

	P_free( g_pcControllers[iControl].pPakData );
	g_pcControllers[iControl].pPakData = NULL;
	return;
}

inline WORD CountBlocks( BYTE *bMemPakBinary, BYTE *aNoteSizes )
{
	WORD wRemainingBlocks = 123;
	BYTE bNextIndex;
	int i = 0;
	while( i < 16 && wRemainingBlocks <= 123 )
	{
		aNoteSizes[i] = 0;
		bNextIndex = bMemPakBinary[0x307 + (i*0x20)];
		while(( bNextIndex >= 5 ) && ( aNoteSizes[i] < wRemainingBlocks))
		{
			aNoteSizes[i]++;
			bNextIndex = bMemPakBinary[0x101 + (bNextIndex*2)];
		}

		if( aNoteSizes[i] > wRemainingBlocks )
			wRemainingBlocks = 0xFF;
		else
			wRemainingBlocks -= aNoteSizes[i];
	
		i++;
	}
	return wRemainingBlocks;
}



void FormatMemPak( BYTE *aMemPak )
{
	FillMemory( aMemPak, 0x100, 0xFF );
	
	aMemPak[0] = 0x81;

	// generate a valid code( i hope i can calculate it one day)
	BYTE aValidCodes[] = {	0x12, 0xC5, 0x8F, 0x6F, 0xA4, 0x28, 0x5B, 0xCA };
	BYTE aCode[8];

	int iRand = (( (ULONG)aMemPak / 4 + (ULONG)g_strEmuInfo.hMainWindow / 4 ) % (sizeof(aValidCodes)/8) );
	for( int n = 0; n <8; n++ )
		aCode[n] = aValidCodes[n+iRand];

	//----------

	aMemPak[0x20+0] = aMemPak[0x60+0] = aMemPak[0x80+0] = aMemPak[0xC0+0] = 0xFF;
	aMemPak[0x20+1] = aMemPak[0x60+1] = aMemPak[0x80+1] = aMemPak[0xC0+1] = 0xFF;
	aMemPak[0x20+2] = aMemPak[0x60+2] = aMemPak[0x80+2] = aMemPak[0xC0+2] = 0xFF;
	aMemPak[0x20+3] = aMemPak[0x60+3] = aMemPak[0x80+3] = aMemPak[0xC0+3] = 0xFF;

	aMemPak[0x20+4] = aMemPak[0x60+4] = aMemPak[0x80+4] = aMemPak[0xC0+4] = aCode[0];
	aMemPak[0x20+5] = aMemPak[0x60+5] = aMemPak[0x80+5] = aMemPak[0xC0+5] = aCode[1];
	aMemPak[0x20+6] = aMemPak[0x60+6] = aMemPak[0x80+6] = aMemPak[0xC0+6] = aCode[2];
	aMemPak[0x20+7] = aMemPak[0x60+7] = aMemPak[0x80+7] = aMemPak[0xC0+7] = aCode[3];

	//aMemPak[0x30+9] = aMemPak[0x70+9] = aMemPak[0x90+9] = aMemPak[0xD0+9] = 0x01; // not sure
	aMemPak[0x30+10] = aMemPak[0x70+10] = aMemPak[0x90+10] = aMemPak[0xD0+10] = 0x01;

	aMemPak[0x30+12] = aMemPak[0x70+12] = aMemPak[0x90+12] = aMemPak[0xD0+12] = aCode[4];
	aMemPak[0x30+13] = aMemPak[0x70+13] = aMemPak[0x90+13] = aMemPak[0xD0+13] = aCode[5];
	aMemPak[0x30+14] = aMemPak[0x70+14] = aMemPak[0x90+14] = aMemPak[0xD0+14] = aCode[6];
	aMemPak[0x30+15] = aMemPak[0x70+15] = aMemPak[0x90+15] = aMemPak[0xD0+15] = aCode[7];



	// Index
	ZeroMemory( &aMemPak[0x100], 0x400 );

	aMemPak[0x100+1] = aMemPak[0x200+1] = 0x71;
	for( int i = 0x00b; i < 0x100; i += 2 )
		aMemPak[0x100+i] = aMemPak[0x200+i] = 03;

	
	FillMemory( &aMemPak[0x500], 0x7B00, 0xFF );

}

CHAR TranslateNotes( LPBYTE bNote, LPSTR Text )
{
#pragma warning( disable : 4305 4309 )
	CHAR cReturn = 0x00;
	CONST CHAR aSpecial[] =	{ 0x21, 0x22, 0x23, 0x60, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x3A, 0x3D, 0x3F, 0x40, 0x74, 0xA9, 0xAE };
						//	{ '!' , '\"', '#' , '`' , '*' , '+' , ',' , '-' , '.' , '/' , ':' , '=' , '?' , '>' , 'tm', '(r)','(c)' };
#pragma warning( default : 4305 4309 )
	int i = 16;
	do
	{
		BYTE b = bNote[i];
		if(( b > 0 ) && i < 32 )
		{
			if( b <= 0x0F ) // translate Icons as Spaces
				*Text = 0x20;
			else if( b <= 0x19 ) // Numbers
				*Text = 0x20 + b;
			else if( b <= 0x33 ) // Characters
				*Text = 0x47 + b;
			else if( b <= 0x44 ) // special Symbols
				*Text = aSpecial[b - 0x34];
			else if( b <= 0x94 ) // Japan
				*Text = 0xC0 + ( b % 40 );
			else // unknown
				*Text = (CHAR)0xA4;
			++i;
			++Text;
		}
		else
		{
			*Text = '\0';
			if( b )
			{
				i = 12;
				Text = &cReturn;
			}
			else
				i = 13;
		}
		
	}
	while( i != 13 );

	return cReturn;
}

int ReverseNotes( LPSTR Text, LPBYTE Note )
{
#pragma warning( disable : 4305 4309 )
	CONST CHAR aSpecial[] =	{ 0x21, 0x22, 0x23, 0x60, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x3A, 0x3D, 0x3F, 0x40, 0x74, 0xA9, 0xAE };
						//	{ '!' , '\"', '#' , '`' , '*' , '+' , ',' , '-' , '.' , '/' , ':' , '=' , '?' , '>' , 'tm', '(r)','(c)' };
#pragma warning( default : 4305 4309 )

	LPSTR TextPos = Text;
	while( *TextPos != '\0' )
	{
		CHAR c = *TextPos;
		*Note = 0x0F;

		if( c >= '0' && c <= '9' )
			*Note = c - '0' + 0x10;
		else if( c >= 'A' && c <= 'Z' )
			*Note = c - 'A' + 0x1A;
		else if( c >= 'a' && c <= 'z' )
			*Note = c - 'a' + 0x1A;

		else
		{
			for( int i = 0; i < ARRAYSIZE(aSpecial); ++i )
			{
				if( c == aSpecial[i] )
				{
					*Note = i + 0x34;
					break;
				}
			}
		}
		++TextPos;
		++Note;
	}
	return TextPos - Text;
}

WORD ShowMemPakContent( BYTE *bMemPakBinary, HWND hListWindow )
{
	BYTE bMemPakValid = MPAK_OK;
	TCHAR szBuffer[40],
		  cAppendix;
	BYTE aNoteSizes[16];
	bool bFirstChar;


	LVITEM lvItem;
	lvItem.mask = LVIF_TEXT | LVIF_PARAM;
	lvItem.iItem = 0;
	lvItem.iSubItem = 0;
	lvItem.pszText = szBuffer;

	int i = 0,
		nNotes = 0,
		iSum = 0,
		iRemainingBlocks;

	for( i = 0x10A; i < 0x200; i++ )
		iSum += bMemPakBinary[i];


	if((( iSum % 256 ) == bMemPakBinary[0x101] ))
	{
		iRemainingBlocks = CountBlocks( bMemPakBinary, aNoteSizes );

		if( iRemainingBlocks <= 123 )
		{
			for( lvItem.lParam = 0; lvItem.lParam < 16; lvItem.lParam++ )
			{
				
				if( bMemPakBinary[0x300 + (lvItem.lParam*32)] ||
					bMemPakBinary[0x301 + (lvItem.lParam*32)] ||
					bMemPakBinary[0x302 + (lvItem.lParam*32)] )
				{
					cAppendix = TranslateNotes( &bMemPakBinary[0x300 + (lvItem.lParam*32)], szBuffer );

					if( cAppendix != '\0' )
						wsprintf( szBuffer, "%s. %c", szBuffer, cAppendix );

					bFirstChar = true;
					for( i = 0; i < (int)lstrlen(szBuffer); i++ )
					{
						if( szBuffer[i] == ' ' )
							bFirstChar = true;
						else
						{
							if( bFirstChar && ( szBuffer[i] >= 'a') && ( szBuffer[i] <= 'z'))
							{
								bFirstChar = false;
								szBuffer[i] -= 0x20;
							}
						}

					}
	
					i = ListView_InsertItem( hListWindow, &lvItem );

					switch( bMemPakBinary[0x303 + (lvItem.lParam*32)] )
					{
					case 0x00:
						lstrcpy( szBuffer, "None" );
						break;
					case 0x37:
						lstrcpy( szBuffer, "Beta" );
						break;
					case 0x41:
						lstrcpy( szBuffer, "NTSC" );
						break;
					case 0x44:
						lstrcpy( szBuffer, "Germany" );
						break;
					case 0x45:
						lstrcpy( szBuffer, "USA" );
						break;
					case 0x46:
						lstrcpy( szBuffer, "France" );
						break;
					case 0x49:
						lstrcpy( szBuffer, "Italy" );
						break;
					case 0x4A:
						lstrcpy( szBuffer, "Japan" );
						break;
					case 0x50:
						lstrcpy( szBuffer, "Europe" );
						break;
					case 0x53:
						lstrcpy( szBuffer, "Spain" );
						break;
					case 0x55:
						lstrcpy( szBuffer, "Australia" );
						break;
					case 0x58:
					case 0x59:
						lstrcpy( szBuffer, "PAL" );
						break;
					default:
						wsprintf( szBuffer, "Unknown(%02X)", bMemPakBinary[0x303 + (lvItem.lParam*32)] );
					}

					ListView_SetItemText( hListWindow, i, 1, szBuffer );

					wsprintf( szBuffer, "%i", aNoteSizes[lvItem.lParam] );
					ListView_SetItemText( hListWindow, i, 2, szBuffer );
					nNotes++;
				}
			}
			
		}
		else
			bMemPakValid = MPAK_DAMAGED;

	}
	else
		bMemPakValid = MPAK_DAMAGED;

	return MAKEWORD( (BYTE)iRemainingBlocks, bMemPakValid );
}

void HextoTextA( LPBYTE Data, LPSTR szText, CONST int nBytes )
{
	CONST CHAR acValues[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
							  'A', 'B', 'C', 'D', 'E', 'F' };

	for( int i = 0; i < nBytes; i++ )
	{
		BYTE byte = *Data;
		szText[0] = acValues[(byte>>4) & 0x0F];
		szText[1] = acValues[byte & 0x0F];

		++Data;
		szText+=2;
	}
	*szText = '\0';
}

void TexttoHexA( LPSTR szText, LPBYTE Data, CONST int nBytes )
{
	bool fLowByte = false;
	CONST LPSTR endText = szText + nBytes * 2;

	for( ; szText < endText; ++szText )
	{
		BYTE bByte = 0;

		if(( '0' <= *szText ) && ( *szText <= '9' ))
			bByte = *szText - '0';
		else
		{
			if(( 'A' <= *szText ) && ( *szText <= 'F' ))
				bByte = szText[0] - 'A' + 10;
			else if(( 'a' <= *szText ) && ( *szText <= 'f' ))
				bByte = szText[0] - 'a' + 10;
		}

		if( !fLowByte )
			*Data = bByte << 4;
		else
		{
			*Data |= bByte;
			++Data;
		}

		fLowByte = !fLowByte;
	}
}

bool SaveNoteFileA( LPBYTE aMemPak, int iNote, LPTSTR pszFileName )
{
	BYTE aNoteSizes[16];
	LPBYTE aNote;
	bool bReturn = false;
	if( CountBlocks( aMemPak, aNoteSizes ) > 123 )
		return false;

	aNote = (LPBYTE)P_malloc( aNoteSizes[iNote] * 0x100 + 32 );
	if( !aNote )
		return false;

	CopyMemory( aNote, &aMemPak[0x300 + iNote * 32], 32 );
	BYTE bNextIndex = aNote[0x7];
	int iBlock = 0;
	while( iBlock < aNoteSizes[iNote] )
	{
		CopyMemory( &aNote[32 + iBlock * 0x100], &aMemPak[bNextIndex * 0x100], 0x100);
		bNextIndex = aMemPak[0x101 + (bNextIndex*2)];
		
		iBlock++;
	}

	HANDLE hFile = CreateFile( pszFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL);
	if ( hFile != INVALID_HANDLE_VALUE )
	{	
		SetFilePointer( hFile, 0L, NULL, FILE_BEGIN );
		CHAR szLine[70];
		
		
		DWORD dwBytesWritten = 0;
		lstrcpyA( szLine, "a64-notes\r\ndescription of game save goes here...\r\na64-data\r\n" );
		WriteFile( hFile, szLine, lstrlenA(szLine), &dwBytesWritten, NULL );

		CopyMemory( szLine, aNote, 4 );
		szLine[4] = ' ';
		szLine[5] = aNote[4];
		szLine[6] = aNote[5];
		szLine[7] = ' ';
		HextoTextA( &aNote[8], &szLine[8], 2 );

		int pos = 12;
		szLine[pos++] = ' ';
		szLine[pos++] = aNote[10] + '0';
		szLine[pos++] = ' ';
		szLine[pos++] = '{';
		
		if( aNote[12] )
		{
			szLine[pos] = TranslateNotes( aNote, &szLine[pos+4] );
			pos++;
		}
		else
			TranslateNotes( aNote, &szLine[pos+3] );

		szLine[pos++] = '}';
		szLine[pos++] = ' ';
		szLine[pos++] = '{';

		lstrcatA( szLine, "}\r\n" );
		WriteFile( hFile, szLine, lstrlenA(szLine), &dwBytesWritten, NULL );

		for( int i = 32; i < aNoteSizes[iNote] * 0x100 + 32; i += 32 )
		{
			HextoTextA( &aNote[i], szLine, 32 );
			WriteFile( hFile, szLine, lstrlenA(szLine), &dwBytesWritten, NULL );
			WriteFile( hFile, "\r\n", 2, &dwBytesWritten, NULL );
		}
		WriteFile( hFile, "a64-crc\r\n", 9, &dwBytesWritten, NULL );

		// insert crc here
		lstrcpy( szLine, "00000000\r\n" );
		WriteFile( hFile, szLine, lstrlenA(szLine), &dwBytesWritten, NULL );
		//
		WriteFile( hFile, "a64-end\r\n", 9, &dwBytesWritten, NULL );

		SetEndOfFile( hFile );
		bReturn = true;
		CloseHandle( hFile );
	}
	else
		ErrorMessage( TEXT( "Couldnt write NoteFile" ), GetLastError(), false );

	P_free( aNote );
	return bReturn;
}

bool InsertNoteFile( BYTE *aMemPak, TCHAR *pszFileName )
{
	bool bReturn = false;


	DataBuffer NoteFile;

	if( NoteFile.SetFile( pszFileName, false, true ) == DBC_OK )
	{
		DWORD dwOffSet = 0;
		TCHAR szLine[128];
		DWORD dwDataStart = 0;

		while( !dwDataStart && ( NoteFile.ReadLine( dwOffSet, szLine, 128 ) == DBC_OK ))
		{
			dwOffSet += lstrlen(szLine) + 2;
			if( !n_strncmp( "a64-data", szLine, 8 ))
				dwDataStart = dwOffSet;
		}

		NoteFile.ReadLine( dwOffSet, szLine, 128  );
		dwOffSet += lstrlen(szLine) + 2;

		DWORD dwNoteSize = 0;
		while( ( NoteFile.ReadLine( dwOffSet, szLine, 128  ) == DBC_OK ) && n_strncmp( "a64-crc", szLine, 7 ))
		{
			dwNoteSize++;
			dwOffSet += lstrlen(szLine) + 2;
		}
		dwNoteSize /= 8;

		BYTE aNoteSizes[16];
		WORD wRemainingBlocks;
		int i,
			ifreeNote = -1;

		wRemainingBlocks = CountBlocks( aMemPak, aNoteSizes );

		if( dwNoteSize <= 0 )
			ErrorMessage( "Couldnt read NoteFile", 0, false );
		else
		{
			if( wRemainingBlocks < dwNoteSize )
				ErrorMessage( "Not enough Space on MemPak", 0, false );
			else
			{
				i = 0;
				while(( i < 16 ) && ( ifreeNote == -1 ))
				{
					if( aNoteSizes[i] == 0 )
						ifreeNote = i;
					i++;
				}
				if( ifreeNote == -1 )
					ErrorMessage( "No free Note on MemPak", 0, false );
				else
					bReturn = true;
			}
		}

		if( bReturn )
		{
			BYTE *pBlock;
			dwOffSet = dwDataStart;
			NoteFile.ReadLine( dwOffSet, szLine, 128  );
			dwOffSet += lstrlen(szLine) + 2;

			pBlock = &aMemPak[0x300 + ifreeNote*32];
			CopyMemory( pBlock, szLine, 4 );
			pBlock[4] = szLine[5];
			pBlock[5] = szLine[6];
			TexttoHexA( &szLine[8], &pBlock[8], 2 );
			pBlock[10] = szLine[13] - '0';

			int len = lstrlen( szLine );

			i = 16;
			while(( szLine[i] != '}' ) && (i < len))
				i++;

			szLine[i] = '\0';
			i += ReverseNotes( &szLine[16], &pBlock[12] );

			while(( szLine[i] != '{' ) && (i < len))
				i++;

			if(i < len)
			{
				int start = i+1;
				while(( szLine[i] != '}' ) && (i < len))
					i++;
				if(i < len)
				{
					szLine[i] = '\0';
					ReverseNotes( &szLine[start], &pBlock[16] );
				}
			}

			while(( szLine[i] != '}' ) && (i < len))
				i++;
			szLine[i] = '\0';

			

			BYTE bDataBlock = 5;
			pBlock = &pBlock[7];
			BYTE *pDataBlock;

			while( dwNoteSize > 0 )
			{
				while( aMemPak[0x101 + bDataBlock*2] != 0x03 )
					bDataBlock++;
				*pBlock = bDataBlock;
				pBlock = &aMemPak[0x101 + bDataBlock*2];
				pDataBlock = &aMemPak[bDataBlock * 0x100];
				for( i = 0; i < 0x100; i+=32 )
				{
					NoteFile.ReadLine( dwOffSet, szLine, 128  );
					dwOffSet += lstrlen(szLine) + 2;
					TexttoHexA( szLine, &pDataBlock[i], 32 );
				}
				bDataBlock++;
				dwNoteSize--;
			}
			*pBlock = 0x01;

			int iSum = 0;

			for( i = 0x10A; i < 0x200; i++ )
				iSum += aMemPak[i];

			aMemPak[0x101] = iSum % 256;

			CopyMemory( &aMemPak[0x200], &aMemPak[0x100], 0x100 );
		}

		NoteFile.CloseFile();
	}
	else
		ErrorMessage( "Couldnt read NoteFile", GetLastError(), false );
	return bReturn;
}

bool RemoveNote( BYTE *aMemPak, int iNote )
{
	BYTE bBlock = aMemPak[0x307 + iNote*32];
	int iPos;

	while( bBlock >= 0x05 )
	{
		iPos = 0x101 + bBlock*2;
		bBlock = aMemPak[iPos];
		aMemPak[iPos] = 0x03;
	}
	int i = 0, iSum = 0;
	for( i = 0x10A; i < 0x200; i++ )
		iSum += aMemPak[i];

	aMemPak[0x101] = iSum % 256;

	CopyMemory( &aMemPak[0x200], &aMemPak[0x100], 0x100 );

	ZeroMemory( &aMemPak[0x300 + iNote*32], 32 );

	return true;
}



BYTE AddressCRC( LPBYTE Address )
{
	bool HighBit;
	WORD Data = MAKEWORD( Address[1], Address[0] );
	register BYTE Remainder = ( Data >> 11 ) & 0x1F;

	BYTE bBit = 5;

	while( bBit < 16 )
	{
		HighBit = (Remainder & 0x10) != 0;
		Remainder = (Remainder << 1) & 0x1E;

		Remainder += ( bBit < 11 && Data & (0x8000 >> bBit )) ? 1 : 0;

		Remainder ^= (HighBit) ? 0x15 : 0;
		
		bBit++;
	}

	return Remainder;
}

BYTE DataCRC( LPBYTE Data, CONST int iLenght )
{
	register BYTE Remainder = Data[0];

	int iByte = 1;
	BYTE bBit = 0;

	while( iByte <= iLenght )
	{
		bool HighBit = ((Remainder & 0x80) != 0);
		Remainder = Remainder << 1;

		Remainder += ( iByte < iLenght && Data[iByte] & (0x80 >> bBit )) ? 1 : 0;

		Remainder ^= (HighBit) ? 0x85 : 0;
		
		bBit++;
		iByte += bBit/8;
		bBit %= 8;
	}

	return Remainder;
}
