/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <windows.h>
#include <Commctrl.h>
#include "commonIncludes.h"
#include "NRage PluginV2.h"
#include "DirectInput.h"
#include "FileAcces.h"
#include "PakIO.h"
#include "Interface.h"


// Prototypes //
BOOL CALLBACK ControllerTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ControlsTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK DevicesTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ModifierTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ControllerPakTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK PakProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK MemPakProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK TransferPakProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ShorcutsTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK FoldersDialogProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );

BOOL CALLBACK EnumGetKeyDesc( LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef );
bool GetButtonID( LPDWORD ButtonID, CONST BYTE bIndex, CONST BYTE bButtonSet );
bool GetButtonText( CONST BUTTON btnButton, LPTSTR Buffer, CONST LPTSTR KeyDescription );
DWORD ScanDevices( LPDIRECTINPUTDEVICE8 *apDirectInputDevices, LPDWORD Value, LPBUTTON pButton );

void DeleteControllerSettings( int indexController );
void GetCurrentConfiguration();
void UpdateControllerStructures();

// global Variables //
INTERFACEVALUES *g_ivConfig = NULL;	// this structure hold all GUI-Data
LPTSTR g_KeyDescription = NULL;		// here the names of the keys are stored
LPDIRECTINPUTDEVICE8 g_apConfigDevice[3] = { NULL, NULL, NULL }; // 3 device handles
LPDIRECTINPUTEFFECT  g_pConfigEffect = NULL; // FF-effect handle
HWND g_hMainDialog = NULL; // handle of base-dialog

BOOL CALLBACK MainDlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static HWND hTabControl;
	HWND hDlgItem;
	LONG i,j;

	switch(uMsg)
	{
	case WM_INITDIALOG:
	{
		g_ivConfig = (INTERFACEVALUES*)P_malloc( sizeof(INTERFACEVALUES) );
		ZeroMemory( g_ivConfig, sizeof(INTERFACEVALUES) );
		CopyMemory( &g_ivConfig->ShortCuts, &g_scShortcuts ,sizeof(SHORTCUTS) );
		for( i = 0; i < 4; ++i )
			DeleteControllerSettings( i );

		if( g_bRunning )
			GetCurrentConfiguration();
		else
		{
			LoadConfigStructFromReg();
		}


		EnterCriticalSection( &g_resController );
		g_KeyDescription =(TCHAR*)P_malloc( sizeof(TCHAR) * 256 * 5 );

		ZeroMemory( g_KeyDescription, sizeof(TCHAR) * 256 * 5 );
		g_hMainDialog = hDlg;

		GetInputDevice( g_hMainDialog, g_apConfigDevice[DID_KEYBOARD], GUID_SysKeyboard, DI8DEVTYPE_KEYBOARD, DIB_CONFIG );
		GetInputDevice( g_hMainDialog, g_apConfigDevice[DID_MOUSE], GUID_SysMouse, DI8DEVTYPE_MOUSE, DIB_CONFIG );

		// Get Key-Descriptions //
		LPTSTR lpKeys = g_KeyDescription;
		g_apConfigDevice[DID_KEYBOARD]->EnumObjects( EnumGetKeyDesc, (LPVOID)&lpKeys, DIDFT_BUTTON );
		

		// Display Version
		SetDlgItemText( hDlg, IDC_VERSIONSTRING, "Version " VERSIONNUMBER );


		// Tab - Control //
		hTabControl = NULL;
		hDlgItem = GetDlgItem( hDlg, IDC_UPPERTAB );

		TCITEM tcItem;
		tcItem.mask = TCIF_TEXT;
		
		tcItem.pszText = TEXT( "Controller 1" );
		TabCtrl_InsertItem( hDlgItem, TAB_CONTROLLER1, &tcItem );
		tcItem.pszText = TEXT( "Controller 2" );
		TabCtrl_InsertItem( hDlgItem, TAB_CONTROLLER2, &tcItem );
		tcItem.pszText = TEXT( "Controller 3" );
		TabCtrl_InsertItem( hDlgItem, TAB_CONTROLLER3, &tcItem );
		tcItem.pszText = TEXT( "Controller 4" );
		TabCtrl_InsertItem( hDlgItem, TAB_CONTROLLER4, &tcItem );
		tcItem.pszText = TEXT( "Short Cuts" );
		TabCtrl_InsertItem( hDlgItem, TAB_SHORTCUTS, &tcItem );
		// Tab - Control  End //

		TabCtrl_SetCurSel( GetDlgItem( hDlg, IDC_UPPERTAB), g_ivConfig->ChoosenTab );
		NMHDR nmInit;
		nmInit.hwndFrom = hDlgItem;
		nmInit.idFrom = IDC_UPPERTAB;
		nmInit.code = TCN_SELCHANGE;
		MainDlgProc( hDlg, WM_NOTIFY, IDC_UPPERTAB, (LPARAM)&nmInit );

		if( !g_bRunning )
			EnableWindow( GetDlgItem( hDlg, IDUSE ), FALSE );

		g_ivConfig->ChoosenTab = TAB_CONTROLLER1;
		LeaveCriticalSection( &g_resController );
	}

		// call routine to show content( recursive call )
		MainDlgProc( hDlg, WM_USER_UPDATE, 0, 0 );
		return TRUE; // the system sets focus to one control element

	case WM_NOTIFY:
		hDlgItem = ((LPNMHDR)lParam)->hwndFrom;
		i = ((LPNMHDR)lParam)->code;
		j = ((LPNMHDR)lParam)->idFrom;

		switch( j )
		{
		case IDC_UPPERTAB:
			if( i == TCN_SELCHANGE )
			{
				i = g_ivConfig->ChoosenTab;
				g_ivConfig->ChoosenTab = TabCtrl_GetCurSel( hDlgItem );

				if( hTabControl )
				{
					if(	(( i == TAB_CONTROLLER1 ) || ( i == TAB_CONTROLLER2 ) || ( i == TAB_CONTROLLER3 ) || ( i == TAB_CONTROLLER4 )) &&
						(( g_ivConfig->ChoosenTab == TAB_CONTROLLER1 ) || ( g_ivConfig->ChoosenTab == TAB_CONTROLLER2 ) || ( g_ivConfig->ChoosenTab == TAB_CONTROLLER3 ) || ( g_ivConfig->ChoosenTab == TAB_CONTROLLER4 )))
					{
						MainDlgProc( hDlg, WM_USER_UPDATE, 0, 0 );
						return TRUE;
					}
					else
						DestroyWindow( hTabControl );
				}

				switch( g_ivConfig->ChoosenTab )
				{
				case TAB_CONTROLLER1:
				case TAB_CONTROLLER2:
				case TAB_CONTROLLER3:
				case TAB_CONTROLLER4:
					hTabControl = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_CONTROLLER ), hDlgItem, ControllerTabProc );
					break;
				case TAB_SHORTCUTS:
					hTabControl = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_SHORTCUT ), hDlgItem, ShorcutsTabProc );
					break;
				default:
					hTabControl = NULL;
					return TRUE;
				}
				
				RECT rectWindow;

				GetClientRect( hDlgItem, &rectWindow );
				TabCtrl_AdjustRect( hDlgItem, FALSE, &rectWindow );
				
				MoveWindow( hTabControl, rectWindow.left, rectWindow.top, rectWindow.right - rectWindow.left, rectWindow.bottom - rectWindow.top, FALSE );
				ShowWindow( hTabControl, SW_SHOW );
			}
			break;
		}

		break;


	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );

		switch( LOWORD(wParam) )
		{
		case IDC_AUTOCONFIG:
			g_ivConfig->bAutoConfig = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;
		case IDC_STOREINDB:
		case IDC_UPDATEDB:
		case IDC_ERASEFROMDB:
		case IDC_SAVEPROFILE:
		case IDC_LOADPROFILE:
			break;

		
		case IDSAVE:
			if( hTabControl )
			{
				DestroyWindow( hTabControl );
				hTabControl = NULL;
			}
			StoreConfigStructIntoRegistry();
		case IDUSE:
			if( hTabControl )
			{
				DestroyWindow( hTabControl );
				hTabControl = NULL;
			}
			CopyMemory( &g_scShortcuts ,&g_ivConfig->ShortCuts, sizeof(SHORTCUTS) );
			if( g_bRunning )
				UpdateControllerStructures();

			EndDialog( hDlg, 10 );
			break;
		case IDCANCEL:
			if( hTabControl )
			{
				DestroyWindow( hTabControl );
				hTabControl = NULL;
			}
			EndDialog( hDlg, FALSE );
			break;

		default:
			return FALSE;
		}
		break;

	case WM_CLOSE:
		if( hTabControl )
		{
			DestroyWindow( hTabControl );
			hTabControl = NULL;
		}
		EndDialog( hDlg, FALSE );
		break;

	case WM_DESTROY:
		if( hTabControl )
		{
			DestroyWindow( hTabControl );
			hTabControl = NULL;
		}

		ReleaseEffect( g_pConfigEffect );
		ReleaseDevice( g_apConfigDevice[DID_GAMEPAD] );
		ReleaseDevice( g_apConfigDevice[DID_MOUSE] );
		ReleaseDevice( g_apConfigDevice[DID_KEYBOARD] );

		for( i = 0; i < 4; ++i )
			freeControllerStruct( &g_ivConfig->Controllers[i] );
		P_free( g_ivConfig );
		g_ivConfig = NULL;
		P_free( g_KeyDescription );
		g_KeyDescription = NULL;
		break;

	case WM_USER_UPDATE:
		// for main dialog
		CheckDlgButton( hDlg, IDC_AUTOCONFIG, g_ivConfig->bAutoConfig ? BST_CHECKED : BST_UNCHECKED );
		

		// call child-dialog(s) to update their content as well
		if( hTabControl )
			SendMessage( hTabControl, WM_USER_UPDATE, 0, 0 );
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK ControllerTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static HWND hTabControl;

	CONTROLLER *pcController = &g_ivConfig->Controllers[g_ivConfig->ChoosenTab];;
	HWND hDlgItem;
	LONG i,j;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		hTabControl = NULL;

		// Tab - Control //
		hDlgItem = GetDlgItem( hDlg, IDC_CONTROLLERTAB );

		TCITEM tcItem;
		tcItem.mask = TCIF_TEXT;
		
		tcItem.pszText = TEXT( "Controls" );
		TabCtrl_InsertItem( hDlgItem, TAB_CONTROLS, &tcItem );
		tcItem.pszText = TEXT( "Devices" );
		TabCtrl_InsertItem( hDlgItem, TAB_DEVICES, &tcItem );
		tcItem.pszText = TEXT( "Modifiers" );
		TabCtrl_InsertItem( hDlgItem, TAB_MODIFIERS, &tcItem );
		tcItem.pszText = TEXT( "Controller Pak" );
		TabCtrl_InsertItem( hDlgItem, TAB_PAK, &tcItem );

		NMHDR nmInit;
		nmInit.hwndFrom = hDlgItem;
		nmInit.idFrom = IDC_CONTROLLERTAB;
		nmInit.code = TCN_SELCHANGE;

		// initiate Tab-Display
		ControllerTabProc( hDlg, WM_NOTIFY, IDC_CONTROLLERTAB, (LPARAM)&nmInit );
		// Tab - Control End //

		// call routine to show content( recursive call )
		ControllerTabProc( hDlg, WM_USER_UPDATE, 0, 0 );


		return FALSE; // dont give it focus

	case WM_NOTIFY:
		hDlgItem = ((LPNMHDR)lParam)->hwndFrom;
		i = ((LPNMHDR)lParam)->code;
		j = ((LPNMHDR)lParam)->idFrom;
		
		switch( j )
		{
		case IDC_CONTROLLERTAB:
			if( i == TCN_SELCHANGE )
			{
				if( hTabControl )
					DestroyWindow( hTabControl );

				i = TabCtrl_GetCurSel( hDlgItem );
				
				switch( i )
				{
				case TAB_CONTROLS:
					hTabControl = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_CONTROLS ), hDlgItem, ControlsTabProc );
					break;
				case TAB_DEVICES:
					hTabControl = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_DEVICES ), hDlgItem, DevicesTabProc );
					break;
				case TAB_MODIFIERS:
					hTabControl = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_MODIFIER ), hDlgItem, ModifierTabProc );
					break;
				case TAB_PAK:
					hTabControl = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_CONTROLLERPAK ), hDlgItem, ControllerPakTabProc );
					break;
				default:
					hTabControl = NULL;
					return TRUE;
				}
				hDlgItem = GetDlgItem( hDlg, IDC_CONTROLLERTAB );
				
				RECT rectWindow;

				GetClientRect( hDlgItem, &rectWindow );
				TabCtrl_AdjustRect( hDlgItem, FALSE, &rectWindow );
				
				MoveWindow( hTabControl, rectWindow.left, rectWindow.top, rectWindow.right - rectWindow.left, rectWindow.bottom - rectWindow.top, FALSE );
				ShowWindow( hTabControl, SW_SHOW );
			}
			break;
		}

		break;


	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );

		switch( LOWORD(wParam) )
		{
		case IDC_PLUGGED:
			pcController->fPlugged = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;
		case IDC_CLEARCONTROLLER:
			if( MessageBox( hDlg, TEXT( "The Controller configuration will be discarded\nAre u sure?" ), TEXT( "Clear Controller" ), MB_OKCANCEL | MB_ICONWARNING ) == IDOK )
			{
				DeleteControllerSettings( g_ivConfig->ChoosenTab );
				ControllerTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
			break;
		case IDC_SETDEFAULT:
			if( MessageBox( hDlg, TEXT( "The Controller configuration will be restored\nAre u sure?" ), TEXT( "Restore Default" ), MB_OKCANCEL | MB_ICONWARNING ) == IDOK )
			{
				DeleteControllerSettings( g_ivConfig->ChoosenTab );
				LoadProfileFromResource( g_ivConfig->ChoosenTab, pcController, g_ivConfig->Devices[g_ivConfig->ChoosenTab].szProductName, &g_ivConfig->Devices[g_ivConfig->ChoosenTab].bProductCounter );
				ControllerTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
			break;

		case IDC_SAVEPROFILE:
			{
			TCHAR szFilename[MAX_PATH+1] = TEXT( "" );
			if( BrowseFile( hDlg, szFilename, MAKELONG( BF_PROFILE, BF_SAVE )))
			{
				TCHAR szTextBlock[8*1024] = TEXT( "@" ) TEXT( STRING_PROFILEVERSION ) TEXT( "\r\n\r\n" );
				DWORD dwBytestoWrite = FormatProfileBlock( szTextBlock, g_ivConfig->ChoosenTab );

				HANDLE hFile = CreateFile( szFilename, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, 0, NULL);
				if ( hFile != INVALID_HANDLE_VALUE )
				{
					SetFilePointer( hFile, 0, NULL, FILE_BEGIN );
					DWORD dwBytesWritten = 0;
					WriteFile( hFile, szTextBlock, dwBytestoWrite, &dwBytesWritten, NULL );
					SetEndOfFile( hFile );
					
					CloseHandle( hFile );
				}
				else
					MessageBox( hDlg, TEXT( "Couldnt write Profile" ), TEXT( PLUGINWARNING ), MB_OK );
			}
			}
			break;

		case IDC_LOADPROFILE:
			{
			TCHAR szFilename[MAX_PATH+1] = TEXT( "" );
			if( BrowseFile( hDlg, szFilename, MAKELONG( BF_PROFILE, BF_LOAD )))
			{
				if( LoadProfile( szFilename, NULL, &g_ivConfig->Controllers[g_ivConfig->ChoosenTab], g_ivConfig->Devices[g_ivConfig->ChoosenTab].szProductName, &g_ivConfig->Devices[g_ivConfig->ChoosenTab].bProductCounter ))
					ControllerTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
				else
					MessageBox( hDlg, TEXT( "Couldnt read Profile" ), TEXT( PLUGINWARNING ), MB_OK );

			}
			}
			break;

		default:
			return FALSE;
		}
		break;

	case WM_USER_UPDATE:
		// for this dialog
		CheckDlgButton( hDlg, IDC_PLUGGED, pcController->fPlugged ? BST_CHECKED : BST_UNCHECKED );
		
		// call child-dialog(s) to update their content as well
		if( hTabControl )
			SendMessage( hTabControl, WM_USER_UPDATE, 0, 0 );
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK ControlsTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static LPBUTTON aButtons = NULL;
	static DWORD dwButtonID[3];
	static DWORD dwCounter;
	static bool bScanRunning;
	static HWND hFocus;

	TCHAR szBuffer[40];
	HWND hDlgItem;
	LONG i,j;

	switch(uMsg)
	{
	case WM_INITDIALOG:

		// SetTicks on TrackBar
		hDlgItem = GetDlgItem( hDlg, IDC_CTRRANGE );
		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 100 ));  
		SendMessage( hDlgItem, TBM_SETTICFREQ, (WPARAM) 10, 0 );
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );

		// SetTicks on RapidFire Bar
		hDlgItem = GetDlgItem( hDlg, IDC_RAPIDFIRERATE );
		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 32 ));  
		SendMessage( hDlgItem, TBM_SETTICFREQ, (WPARAM) 1, 0 );
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );

		// call routine to show content( recursive call )
		ControlsTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
		return FALSE; // dont give it focus

	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );

		switch( LOWORD(wParam) )
		{
		case IDC_N64RANGE:
			g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRealN64Range = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;

		case IDC_RAPIDFIREENABLE:
			g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bRapidFireEnabled = (IsDlgButtonChecked( hDlg, LOWORD(wParam)) == BST_CHECKED);
			break;

		case IDC_CONFIG1:
		case IDC_CONFIG2:
		case IDC_CONFIG3:
			if( HIWORD(wParam) == BN_CLICKED )
			{
				if( LOWORD(wParam) == IDC_CONFIG1 )
					g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet = 0;
				else if( LOWORD(wParam) == IDC_CONFIG2 )
					g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet = 1;
				else if( LOWORD(wParam) == IDC_CONFIG3 )
					g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet = 2;

				ControlsTabProc( hDlg, WM_USER_UPDATE, 1, 0 );
			}
			break;

		case IDC_LEFTTRIGGER:
		case IDC_RIGHTTRIGGER:
		case IDC_ZTRIGGER:
		case IDC_DUP:
		case IDC_DLEFT:
		case IDC_DRIGHT:
		case IDC_DDOWN:
		case IDC_AUP:
		case IDC_ALEFT:
		case IDC_ARIGHT:
		case IDC_ADOWN:
		case IDC_CUP:
		case IDC_CLEFT:
		case IDC_CRIGHT:
		case IDC_CDOWN:
		case IDC_ABUTTON:
		case IDC_BBUTTON:
		case IDC_SBUTTON:
			if( bScanRunning )
			{
				bScanRunning = false;
				KillTimer( hDlg, TIMER_BUTTON );
				GetButtonText( aButtons[dwButtonID[2]], szBuffer, g_KeyDescription );
				SendMessage( GetDlgItem( hDlg, dwButtonID[1] ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			}
			if( HIWORD(wParam) == BN_CLICKED )
			{
				dwButtonID[0] = LOWORD(wParam);
				dwCounter = 0;
				GetButtonID( dwButtonID, 0, BSET_CONTROLS );
				if( dwButtonID[2] >= PF_APADR )
					dwButtonID[2] += g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet * 4;
				hFocus = SetFocus( NULL );
				SetTimer( hDlg, TIMER_BUTTON, 20, NULL );
				bScanRunning = true;
			}
			break;

		default:
			return FALSE;
		}
		break;

	case WM_TIMER:
		if( wParam == TIMER_BUTTON && bScanRunning )
		{
			BUTTON newButton;

			i = ScanDevices( g_apConfigDevice, &dwCounter, &newButton);
			if( i || dwCounter > 500 )
			{
				bScanRunning = false;
				KillTimer( hDlg, TIMER_BUTTON );
				
				if( i == SC_SCANESCAPE ) // Scan aborted
					aButtons[dwButtonID[2]].dwButton = 0;
				else if( i == SC_SCANSUCCEED  ) // Succesfull
					aButtons[dwButtonID[2]] = newButton;

				GetButtonText( aButtons[dwButtonID[2]], szBuffer, g_KeyDescription );
				SendMessage( GetDlgItem( hDlg, dwButtonID[1] ), WM_SETTEXT , 0, (LPARAM)szBuffer );
				if( hFocus != NULL )
					SetFocus( hFocus );
			}
			else
			{
				if(( dwCounter % 50 ) == 0 )
				{
					wsprintf( szBuffer, TEXT( "...Awaiting Input %i..." ), 10 - dwCounter / 50 );
					SendMessage( GetDlgItem( hDlg, dwButtonID[1] ), WM_SETTEXT , 0, (LPARAM)szBuffer );
				}
				++dwCounter;
			}
		}
		break;

	case WM_HSCROLL: // TrackBars
	case WM_VSCROLL:
		if( GetWindowLong( (HWND)lParam, GWL_ID ) == IDC_CTRRANGE )
		{
			g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bStickRange = (BYTE)SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
			wsprintf( szBuffer, TEXT( "Range: %i%%" ), g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bStickRange );
			SendMessage( GetDlgItem( hDlg, IDT_RANGE ), WM_SETTEXT , 0, (LPARAM)szBuffer );
		}
		if( GetWindowLong( (HWND)lParam, GWL_ID ) == IDC_RAPIDFIRERATE )
		{
			g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bRapidFireRate = 33 - (BYTE)SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
		}
		break;

	case WM_USER_UPDATE:
		bScanRunning = false;
		KillTimer( hDlg, TIMER_BUTTON );
		aButtons = g_ivConfig->Controllers[g_ivConfig->ChoosenTab].aButton;

		if( wParam == 0 )
		{
			CheckDlgButton( hDlg, IDC_N64RANGE, g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRealN64Range ? BST_CHECKED : BST_UNCHECKED );
			CheckDlgButton( hDlg, IDC_RAPIDFIREENABLE, g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bRapidFireEnabled ? BST_CHECKED : BST_UNCHECKED );
			CheckDlgButton( hDlg, IDC_CONFIG1, ( g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet == 0 ) ? BST_CHECKED : BST_UNCHECKED );
			CheckDlgButton( hDlg, IDC_CONFIG2, ( g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet == 1 ) ? BST_CHECKED : BST_UNCHECKED );
			CheckDlgButton( hDlg, IDC_CONFIG3, ( g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet == 2 ) ? BST_CHECKED : BST_UNCHECKED );


			SendMessage( GetDlgItem( hDlg, IDC_CTRRANGE ), TBM_SETPOS, TRUE, g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bStickRange );
			wsprintf( szBuffer, "Range: %i%%", g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bStickRange );
			SendMessage( GetDlgItem( hDlg, IDT_RANGE ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			SendMessage( GetDlgItem( hDlg, IDC_RAPIDFIRERATE ), TBM_SETPOS, TRUE, 33 - g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bRapidFireRate );

			// aquires Device, incase it got changed
			j = FindDeviceinList( g_ivConfig->Devices[g_ivConfig->ChoosenTab].szProductName, g_ivConfig->Devices[g_ivConfig->ChoosenTab].bProductCounter, false );
		
			hDlgItem = GetDlgItem( hDlg, IDC_CTRDEVICE );
			ReleaseEffect( g_pConfigEffect );
			if( j == -1 )
				ReleaseDevice( g_apConfigDevice[DID_GAMEPAD] );
			else
				GetInputDevice( g_hMainDialog, g_apConfigDevice[DID_GAMEPAD], g_devList[j].guidInstance, g_devList[j].dwDevType, DIB_CONFIG );
			i = 0;
		}
		else
			i = PF_APADR;

		for( ;i < 18; ++i )
		{
			DWORD dwIDs[3];
			dwIDs[2] = i;
			if( !GetButtonID( dwIDs, 2, BSET_CONTROLS ))
				continue;

			if( dwIDs[2] >= PF_APADR )
				dwIDs[2] += g_ivConfig->Controllers[g_ivConfig->ChoosenTab].bAxisSet * 4;

			GetButtonText( aButtons[dwIDs[2]], szBuffer, g_KeyDescription );
			SendMessage( GetDlgItem( hDlg, dwIDs[1] ), WM_SETTEXT , 0, (LPARAM)szBuffer );
		}
		break;


	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK DevicesTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static BOOL bNewRumbleTyp;

	IFDEVICE *pifDevice = &g_ivConfig->Devices[g_ivConfig->ChoosenTab];
	CONTROLLER *pcController = &g_ivConfig->Controllers[g_ivConfig->ChoosenTab];
	TCHAR szBuffer[MAX_PATH+3];
	HWND hDlgItem;
	LONG i,j;

	switch(uMsg)
	{
	case WM_INITDIALOG:

		// TrackBars
		hDlgItem = GetDlgItem( hDlg, IDC_DEADZONE );

		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 100 ));  
		SendMessage( hDlgItem, TBM_SETTICFREQ, (WPARAM) 10, 0 );
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );

		hDlgItem = GetDlgItem( hDlg, IDC_RUMBLESTRENGTH );

		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 100 ));  
		SendMessage( hDlgItem, TBM_SETTICFREQ, (WPARAM) 10, 0 );
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );

		hDlgItem = GetDlgItem( hDlg, IDC_MSSENSITIVITY );

		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 1000 ));  
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );
		{
			short sTics[] = { 25, 50, 75, 100, 125, 150, 200, 250, 300, 400, 500, 600, 700, 800, 900 };
			for( i = 0; i < (sizeof(sTics) / sizeof(short)); ++i )
				SendMessage( hDlgItem, TBM_SETTIC, 0, sTics[i] );
		}
		// TrackBars End

		// filling DropDownlist with devices
		i = 0;
		hDlgItem = GetDlgItem( hDlg, IDC_CTRDEVICE );
		j = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"None" );
		SendMessage( hDlgItem, CB_SETITEMDATA, j, -1 );
		while( g_devList[i].dwDevType != 0 && i < ARRAYSIZE(g_devList) )
		{
			if( g_devList[i].bProductCounter == 0 )
				lstrcpy( szBuffer, g_devList[i].szProductName );
			else
				wsprintf( szBuffer, "%s %i", g_devList[i].szProductName, g_devList[i].bProductCounter );

			j = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)szBuffer );
			SendMessage( hDlgItem, CB_SETITEMDATA, j, i );
			++i;
		}
		// DropDownlist End
		

		DevicesTabProc( hDlg, WM_USER_UPDATE, 0, 0 ); // setting values

		return FALSE; // dont give it focus

	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );

		switch( LOWORD(wParam) )
		{
		case IDC_CTRDEVICE:
			if( HIWORD(wParam) == CBN_SELCHANGE )
			{
				i = SendMessage( hDlgItem, CB_GETCURSEL, 0, 0 );
				j = SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
			
				if( j == -1 )
				{
					pifDevice->bProductCounter = -1;
					pifDevice->szProductName[0] = '\0';
				}
				else
				{
					pifDevice->bProductCounter = g_devList[j].bProductCounter;
					lstrcpy( pifDevice->szProductName, g_devList[j].szProductName );
				}
				DevicesTabProc( hDlg, WM_USER_UPDATE, 0, 0 ); // en/disabling RumbleOptions
			}
			break;

		case IDC_ABSOLUTEMX:
			pcController->fAbsoluteMouseX = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;
		case IDC_ABSOLUTEMY:
			pcController->fAbsoluteMouseY = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;

		case IDC_ACCELERATEX:
			pcController->fKeyAbsoluteX = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;
		case IDC_ACCELERATEY:
			pcController->fKeyAbsoluteY = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;
		
		case IDC_RUMBLE1:
			if( LOWORD(wParam) == IDC_RUMBLE1 )
				i = RUMBLE_EFF1;
		case IDC_RUMBLE2:
			if( LOWORD(wParam) == IDC_RUMBLE2 )
				i = RUMBLE_EFF2;
		case IDC_RUMBLE3:
			if( LOWORD(wParam) == IDC_RUMBLE3 )
				i = RUMBLE_EFF3;
			if(( HIWORD(wParam) == BN_CLICKED ) &&
				( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED ))
			{
				pcController->bRumbleTyp = i;
				bNewRumbleTyp = true;
			}
			break;

		case IDC_VISUALRUMBLE:
			pcController->fVisualRumble = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			break;

		default:
			return FALSE;
		}
		break;

	case WM_HSCROLL: // TrackBars
	case WM_VSCROLL:
		i = GetWindowLong( (HWND)lParam, GWL_ID );
		switch( i )
		{
		case IDC_MSSENSITIVITY:
			pcController->wMouseSensitivity = (WORD)SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
			wsprintf( szBuffer, "MouseSensitivity: %i%%", pcController->wMouseSensitivity );
			SendMessage( GetDlgItem( hDlg, IDT_MSSENSITIVITY ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			break;

		case IDC_DEADZONE:
			pcController->bPadDeadZone = (BYTE)SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
			wsprintf( szBuffer, "DeadZone: %i%%", pcController->bPadDeadZone );
			SendMessage( GetDlgItem( hDlg, IDT_DEADZONE ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			break;

		case IDC_RUMBLESTRENGTH:
			pcController->bRumbleStrength = (BYTE)SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
			wsprintf( szBuffer, "Rumblestrength: %i%%", pcController->bRumbleStrength );
			SendMessage( GetDlgItem( hDlg, IDT_RUMBLESTRENGTH ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			bNewRumbleTyp = true;
			break;
		}
		break;

	case WM_TIMER:
		if( wParam == TIMER_RUMBLETEST && g_apConfigDevice[DID_GAMEPAD] )
		{
			DIJOYSTATE djState;
			g_apConfigDevice[DID_GAMEPAD]->Poll();
			HRESULT hr = g_apConfigDevice[DID_GAMEPAD]->GetDeviceState( sizeof(DIJOYSTATE), &djState );
			if ( FAILED(hr) )
				g_apConfigDevice[DID_GAMEPAD]->Acquire();
			else
			{
				i = 0;
				while ( i < 32 )
				{
					if( djState.rgbButtons[i] & 0x80 )
					{
						if( bNewRumbleTyp )
						{
							CreateEffectHandle( g_hMainDialog, g_apConfigDevice[DID_GAMEPAD], g_pConfigEffect, pcController->bRumbleTyp, pcController->bRumbleStrength );
							bNewRumbleTyp = false;
						}
						if( g_pConfigEffect )
							g_pConfigEffect->Start( 1, 0 );
						i = 32;
					}
					++i;
				}
			}
		}
		
		break;

	case WM_USER_UPDATE:
		KillTimer( hDlg, TIMER_RUMBLETEST );

		j = FindDeviceinList( pifDevice->szProductName, pifDevice->bProductCounter, false );
		
		hDlgItem = GetDlgItem( hDlg, IDC_CTRDEVICE );
		ReleaseEffect( g_pConfigEffect );
		if( j == -1 )
		{
			ReleaseDevice( g_apConfigDevice[DID_GAMEPAD] );
			SendMessage( hDlgItem, CB_SETCURSEL, 0, 0 ); // set "None"
			EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE1 ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE2 ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE3 ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_RUMBLESTRENGTH ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDT_RUMBLESTRENGTH ), FALSE );
		}
		else
		{
			GetInputDevice( g_hMainDialog, g_apConfigDevice[DID_GAMEPAD], g_devList[j].guidInstance, g_devList[j].dwDevType, DIB_GAMEPAD );
			// DropDownList
			if( g_devList[j].bProductCounter == 0 )
				i = SendMessage( hDlgItem, CB_FINDSTRINGEXACT, -1, (LPARAM)g_devList[j].szProductName );
			else
			{
				wsprintf( szBuffer, "%s %i", g_devList[j].szProductName, g_devList[j].bProductCounter );
				i = SendMessage( hDlgItem, CB_FINDSTRINGEXACT, -1, (LPARAM)szBuffer ); // search index of Device-String
			}

			SendMessage( hDlgItem, CB_SETCURSEL, i, 0 ); // select the right string

			if( g_devList[j].bEffType & RUMBLE_EFF1 )
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE1 ), TRUE );
			else
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE1 ), FALSE );
			if( g_devList[j].bEffType & RUMBLE_EFF2 )
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE2 ), TRUE );
			else
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE2 ), FALSE );
			if( g_devList[j].bEffType & RUMBLE_EFF3 )
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE3 ), TRUE );
			else
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLE3 ), FALSE );

			if(	( g_devList[j].bEffType & RUMBLE_EFF1 ) ||
				( g_devList[j].bEffType & RUMBLE_EFF2 ))
			{
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLESTRENGTH ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDT_RUMBLESTRENGTH ), TRUE );
			}
			else
			{
				EnableWindow( GetDlgItem( hDlg, IDC_RUMBLESTRENGTH ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDT_RUMBLESTRENGTH ), FALSE );
			}

			if( g_devList[j].bEffType != RUMBLE_NONE )
			{
				bNewRumbleTyp = true;
				SetTimer( hDlg, TIMER_RUMBLETEST, INTERVALL_RUMBLETEST, NULL );
			}
		}

		if( pcController->bRumbleTyp == RUMBLE_EFF1 )
			CheckDlgButton( hDlg, IDC_RUMBLE1, BST_CHECKED );
		else
			CheckDlgButton( hDlg, IDC_RUMBLE1, BST_UNCHECKED );
		if( pcController->bRumbleTyp == RUMBLE_EFF2 )
			CheckDlgButton( hDlg, IDC_RUMBLE2, BST_CHECKED );
		else
			CheckDlgButton( hDlg, IDC_RUMBLE2, BST_UNCHECKED );
		if( pcController->bRumbleTyp == RUMBLE_EFF3 )
			CheckDlgButton( hDlg, IDC_RUMBLE3, BST_CHECKED );
		else
			CheckDlgButton( hDlg, IDC_RUMBLE3, BST_UNCHECKED );

		CheckDlgButton( hDlg, IDC_ABSOLUTEMX, pcController->fAbsoluteMouseX ? BST_CHECKED : BST_UNCHECKED );
		CheckDlgButton( hDlg, IDC_ABSOLUTEMY, pcController->fAbsoluteMouseY ? BST_CHECKED : BST_UNCHECKED );
		CheckDlgButton( hDlg, IDC_ACCELERATEX, pcController->fKeyAbsoluteX ? BST_CHECKED : BST_UNCHECKED );
		CheckDlgButton( hDlg, IDC_ACCELERATEY, pcController->fKeyAbsoluteY ? BST_CHECKED : BST_UNCHECKED );
		CheckDlgButton( hDlg, IDC_VISUALRUMBLE, pcController->fVisualRumble ? BST_CHECKED : BST_UNCHECKED );

		// TrackBars
		SendMessage( GetDlgItem( hDlg, IDC_DEADZONE ), TBM_SETPOS, TRUE, pcController->bPadDeadZone );
		wsprintf( szBuffer, "DeadZone: %i%%", pcController->bPadDeadZone );
		SendMessage( GetDlgItem( hDlg, IDT_DEADZONE ), WM_SETTEXT , 0, (LPARAM)szBuffer );

		SendMessage( GetDlgItem( hDlg, IDC_RUMBLESTRENGTH ), TBM_SETPOS, TRUE, pcController->bRumbleStrength );
		wsprintf( szBuffer, "Rumblestrength: %i%%", pcController->bRumbleStrength );
		SendMessage( GetDlgItem( hDlg, IDT_RUMBLESTRENGTH ), WM_SETTEXT , 0, (LPARAM)szBuffer );

		SendMessage( GetDlgItem( hDlg, IDC_MSSENSITIVITY ), TBM_SETPOS, TRUE, pcController->wMouseSensitivity );
		wsprintf( szBuffer, "MouseSensitivity: %i%%", pcController->wMouseSensitivity );
		SendMessage( GetDlgItem( hDlg, IDT_MSSENSITIVITY ), WM_SETTEXT , 0, (LPARAM)szBuffer );
		// TrackBars End
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK MoveModifierDialog( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{

	HWND hDlgItem;
	LONG i,j;
	DWORD dwValue;
	TCHAR szBuffer[80];

	switch(uMsg)
	{
	case WM_INITDIALOG:
		// TrackBars
		hDlgItem = GetDlgItem( hDlg, IDC_XMODIFIER );

		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 500 ));  
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );
		{
			short sTics[] = { 25, 50, 75, 100, 125, 150, 200, 250, 300, 400, 500 };
			for( i = 0; i < (sizeof(sTics) / sizeof(short)); ++i )
				SendMessage( hDlgItem, TBM_SETTIC, 0, sTics[i] );
		}

		hDlgItem = GetDlgItem( hDlg, IDC_YMODIFIER );

		SendMessage( hDlgItem, TBM_SETRANGE, (WPARAM) TRUE, (LPARAM) MAKELONG( 0, 500 ));  
		SendMessage( hDlgItem, TBM_SETPAGESIZE, (WPARAM) 0, 1 );
		{
			short sTics[] = { 25, 50, 75, 100, 125, 150, 200, 250, 300, 400, 500 };
			for( i = 0; i < (sizeof(sTics) / sizeof(short)); ++i )
				SendMessage( hDlgItem, TBM_SETTIC, 0, sTics[i] );
		}
		return FALSE; // dont give it focus

	case WM_HSCROLL: // TrackBars
	case WM_VSCROLL:
		if( GetWindowLong( (HWND)lParam, GWL_ID ) == IDC_XMODIFIER )
		{
			i = SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
			wsprintf( szBuffer, "Movement Value: %i%%", i );
			SendMessage( GetDlgItem( hDlg, IDT_XMODIFIER ), WM_SETTEXT , 0, (LPARAM)szBuffer );
		}
		if( GetWindowLong( (HWND)lParam, GWL_ID ) == IDC_YMODIFIER )
		{
			i = SendMessage( (HWND)lParam, TBM_GETPOS, 0, 0 );
			wsprintf( szBuffer, "Movement Value: %i%%", i );
			SendMessage( GetDlgItem( hDlg, IDT_YMODIFIER ), WM_SETTEXT , 0, (LPARAM)szBuffer );
		}
		break;

	case WM_USER_UPDATE:
		if( wParam == MDT_MOVE )
			dwValue = (DWORD)lParam;
		else
			dwValue = MAKELONG( 100, 100 );
	
		i = (short)(dwValue & 0x0000FFFF);

		if( i < 0 )
		{
			i = -i;
			CheckDlgButton( hDlg, IDC_XNEGATE, BST_CHECKED );
		}
		else
			CheckDlgButton( hDlg, IDC_XNEGATE, BST_UNCHECKED );
		SendMessage( GetDlgItem( hDlg, IDC_XMODIFIER ), TBM_SETPOS, TRUE, i );
		wsprintf( szBuffer, "Movement Value: %i%%", i );
		SendMessage( GetDlgItem( hDlg, IDT_XMODIFIER ), WM_SETTEXT , 0, (LPARAM)szBuffer );

		i = (short)((dwValue >> 16) & 0x0000FFFF);

		if( i < 0 )
		{
			i = -i;
			CheckDlgButton( hDlg, IDC_YNEGATE, BST_CHECKED );
		}
		else
			CheckDlgButton( hDlg, IDC_YNEGATE, BST_UNCHECKED );
		SendMessage( GetDlgItem( hDlg, IDC_YMODIFIER ), TBM_SETPOS, TRUE, i );
		wsprintf( szBuffer, "Movement Value: %i%%", i );
		SendMessage( GetDlgItem( hDlg, IDT_YMODIFIER ), WM_SETTEXT , 0, (LPARAM)szBuffer );
		break;

	case WM_USER_READVALUES:
		i = SendMessage( GetDlgItem( hDlg, IDC_XMODIFIER ), TBM_GETPOS, 0, 0 );
		if( IsDlgButtonChecked( hDlg, IDC_XNEGATE ) == BST_CHECKED )
			i = -i;

		j = SendMessage( GetDlgItem( hDlg, IDC_YMODIFIER ), TBM_GETPOS, 0, 0 );
		if( IsDlgButtonChecked( hDlg, IDC_YNEGATE ) == BST_CHECKED )
			j = -j;

		*(DWORD*)wParam = MAKELONG( (short)i, (short)j );
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK MacroModifierDialog( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	LONG i;
	DWORD dwValue;

	DWORD aButtons[] ={	IDC_DRIGHT	, IDC_DLEFT	, IDC_DDOWN		, IDC_DUP, 
						IDC_SBUTTON	, IDC_ZTRIG	, IDC_BBUTTON	, IDC_ABUTTON,
						IDC_CRIGHT	, IDC_CLEFT	, IDC_CDOWN		, IDC_CUP,
						IDC_RTRIG	, IDC_LTRIG	, 0				, 0,
						IDC_ARIGHT	, IDC_ALEFT	, IDC_ADOWN		, IDC_AUP,
						IDC_RAPIDFIREMODE		, IDC_RAPIDFIREMODERATE };

	switch(uMsg)
	{
	case WM_INITDIALOG:
		return FALSE; // dont give it focus

	case WM_USER_UPDATE:
		if( wParam == MDT_MACRO )
			dwValue = (DWORD)lParam;
		else
			dwValue = 0;

		i = sizeof(aButtons) / sizeof(aButtons[0]) - 1;

		while( i >= 0 )
		{
			if( aButtons[i] )
			{
				if( dwValue & ( 1 << i ) )
					CheckDlgButton( hDlg, aButtons[i], BST_CHECKED );
				else
					CheckDlgButton( hDlg, aButtons[i], BST_UNCHECKED );
			}

			i--;
		}
		break;

	case WM_USER_READVALUES:
		dwValue = 0;

		i = sizeof(aButtons) / sizeof(aButtons[0]) - 1;
		while( i >= 0 )
		{
			if( aButtons[i] && ( IsDlgButtonChecked( hDlg, aButtons[i] ) == BST_CHECKED ))
				dwValue = dwValue | ( 1 << i );

			i--;
		}

		*(DWORD*)wParam = dwValue;
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK ConfigModifierDialog( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	DWORD dwValue;

	DWORD aButtons[] ={	IDC_CONFIG1		, 0x000001,
						IDC_CONFIG2		, 0x000003,
						IDC_CONFIG3		, 0x000005,
						IDC_CONFIGCYCLE	, 0x0000FF,
						IDC_MOUSEX		, 0x000100,
						IDC_MOUSEY		, 0x000200,
						IDC_KEYX		, 0x010000,
						IDC_KEYY		, 0x020000 };

	int i;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		return FALSE; // dont give it focus

	case WM_COMMAND:
		switch( LOWORD(wParam) )
		{
		case IDC_CONFIG1:
		case IDC_CONFIG2:
		case IDC_CONFIG3:
		case IDC_CONFIGCYCLE:
			if(( HIWORD(wParam) == BN_CLICKED ) || ( HIWORD(wParam) == BN_DBLCLK ))
			{
				bool bCheck = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED ) ? false : true;
				CheckDlgButton( hDlg, IDC_CONFIG1, BST_UNCHECKED );
				CheckDlgButton( hDlg, IDC_CONFIG2, BST_UNCHECKED );
				CheckDlgButton( hDlg, IDC_CONFIG3, BST_UNCHECKED );
				CheckDlgButton( hDlg, IDC_CONFIGCYCLE, BST_UNCHECKED );
				if( bCheck )
					CheckDlgButton( hDlg, LOWORD(wParam), BST_CHECKED );
			}
			break;
		default:
			return FALSE;
		}
		break;

	case WM_USER_UPDATE:
		if( wParam == MDT_CONFIG )
			dwValue = (DWORD)lParam;
		else
			dwValue = 0;
		if( dwValue & 0x01 )
		{
			BYTE bConfig = (BYTE)((dwValue >> 1) & 0x7F);
			if( bConfig >= PF_AXESETS )
			{
				CheckDlgButton( hDlg, IDC_CONFIG1, BST_UNCHECKED );
				CheckDlgButton( hDlg, IDC_CONFIG2, BST_UNCHECKED );
				CheckDlgButton( hDlg, IDC_CONFIG3, BST_UNCHECKED );
				CheckDlgButton( hDlg, IDC_CONFIGCYCLE, BST_CHECKED );
			}
			else
			{
				i = PF_AXESETS - 1;
				while( i >= 0 )
				{
					if( bConfig == i )
						CheckDlgButton( hDlg, aButtons[i*2], BST_CHECKED );
					else
						CheckDlgButton( hDlg, aButtons[i*2], BST_UNCHECKED );

					i--;
				}
			}
		}

		i = sizeof(aButtons) / sizeof(aButtons[0]) - 2;
		while( i >= 8 )
		{
			if(( dwValue & aButtons[i+1] ) == aButtons[i+1] )
				CheckDlgButton( hDlg, aButtons[i], BST_CHECKED );
			else
				CheckDlgButton( hDlg, aButtons[i], BST_UNCHECKED );

			i -= 2;
		}
		break;

	case WM_USER_READVALUES:
		dwValue = 0;

		i = sizeof(aButtons) / sizeof(aButtons[0]) - 2;
		while( i >= 0 )
		{
			if( IsDlgButtonChecked( hDlg, aButtons[i] ) == BST_CHECKED )
				dwValue |= aButtons[i+1];
			i -= 2;
		}

		*(DWORD*)wParam = dwValue;
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

void ModDescription( HWND hListView, int iEntry, LPMODIFIER pModifier )
{
	TCHAR szBuffer[100];
	LPTSTR pszModTypes[] = {	TEXT( "None" ),
								TEXT( "Move" ),
								TEXT( "Macro" ),
								TEXT( "Config" ) };

	GetButtonText( pModifier->btnButton, szBuffer, g_KeyDescription );

	ListView_SetItemText( hListView, iEntry, 0,szBuffer );

	switch( pModifier->bTyp )
	{
	case MDT_MOVE:
		ListView_SetItemText( hListView, iEntry, 1, pszModTypes[1] );
		wsprintf( szBuffer, "X:%i%% / Y:%i%%", (short)(pModifier->dwSpecific & 0x0000FFFF), (short)((pModifier->dwSpecific >> 16) & 0x0000FFFF));
		break;
	case MDT_MACRO:
		ListView_SetItemText( hListView, iEntry, 1, pszModTypes[2] );
		szBuffer[0] = '\0';
		{
			bool bGotKey = false;
			DWORD dwValue = pModifier->dwSpecific;
			TCHAR *apszButtons[] ={	"Dp->", "Dp<-", "Dp\\/", "Dp/\\", "St", "Z", "B", "A",
									"Cb->", "Cb<-", "Cb\\/", "Cb/\\", "R", "L", NULL, NULL,
									"As->", "As<-", "As\\/", "As/\\", "(<Rf>)" };

			int i = sizeof(apszButtons) / sizeof(apszButtons[0]) - 1;

			while( i >= 0 )
			{
				if( apszButtons[i] && ( dwValue & ( 1 << i ) ))
				{
					if( bGotKey )
						lstrcat( szBuffer, " " );
					else
						bGotKey = true;

					lstrcat( szBuffer, apszButtons[i] );
				}

				i--;
			}
		}
		break;
	case MDT_CONFIG:
		ListView_SetItemText( hListView, iEntry, 1, pszModTypes[3] );
		szBuffer[0] = '\0';
		{
			DWORD dwValue = pModifier->dwSpecific;
			bool bGotKey = false;

			if( dwValue & 0x1 )
			{
				lstrcat( szBuffer, "C-" );
				if((( dwValue >> 1 ) & 0x7F ) < PF_AXESETS )
					wsprintf( &szBuffer[lstrlen(szBuffer)], "%i", (( dwValue >> 1 ) & 0x7F ));
				else
					lstrcat( szBuffer, "Sw" );
				bGotKey = true;
			}

			if( dwValue & 0x300 )
			{
				if( bGotKey )
					lstrcat( szBuffer, " " );
				else
					bGotKey = true;

				lstrcat( szBuffer, "Ms-" );
				if( dwValue & 0x100 )
					lstrcat( szBuffer, "X" );
				if( dwValue & 0x200 )
					lstrcat( szBuffer, "Y" );
			}

			if( dwValue & 0x30000 )
			{
				if( bGotKey )
					lstrcat( szBuffer, " " );
				else
					bGotKey = true;

				lstrcat( szBuffer, "Kb-" );
				if( dwValue & 0x10000 )
					lstrcat( szBuffer, "X" );
				if( dwValue & 0x20000 )
					lstrcat( szBuffer, "Y" );
			}
		}
		break;

	case MDT_NONE:
	default:
		ListView_SetItemText( hListView, iEntry, 1, pszModTypes[0] );
		szBuffer[0] = '\0'; 
	}
	ListView_SetItemText( hListView, iEntry, 2, szBuffer );

}

BOOL CALLBACK ModifierTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static bool bScanRunning;
	static DWORD dwCounter;
	static HWND hFocus;
	static int iSelectedMod;
	static BYTE bDisplayedProbs;
	static HWND hModProperties;
	static CONTROLLER *pcController;

	TCHAR *pszModTypes[] = { "None", "Movement", "Macro", "Configuration" };
	TCHAR szBuffer[40];
	HWND hDlgItem;
	LONG i,j;
	BYTE bByte;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		bScanRunning = false;
		hModProperties = NULL;
		bDisplayedProbs = MDT_NONE;
		// List View
		hDlgItem = GetDlgItem( hDlg, IDC_MODIFIERLIST );

		LVCOLUMN lvColumn;

		lvColumn.mask = LVCFMT_CENTER | LVCF_WIDTH | LVCF_TEXT;
		lvColumn.fmt = LVCFMT_LEFT;
		lvColumn.cx = 100;	
		lvColumn.pszText = "Assigned to";
		ListView_InsertColumn( hDlgItem, 0, &lvColumn );

		lvColumn.fmt = LVCFMT_CENTER | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		lvColumn.cx = 43;	
		lvColumn.iSubItem = 1;
		lvColumn.pszText = "Typ";
		ListView_InsertColumn( hDlgItem, 1, &lvColumn );

		lvColumn.cx = 128;	
		lvColumn.iSubItem = 2;
		lvColumn.pszText = "Parameter";
		ListView_InsertColumn( hDlgItem, 2, &lvColumn );

		ListView_SetExtendedListViewStyle( hDlgItem, LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP );
		// ListView End

		// DropDown
		hDlgItem = GetDlgItem( hDlg, IDC_MODTYP );

		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)pszModTypes[0] );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, MDT_NONE );

		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)pszModTypes[1] );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, MDT_MOVE );

		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)pszModTypes[2] );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, MDT_MACRO );

		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)pszModTypes[3] );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, MDT_CONFIG );
		// DropDown End

		ModifierTabProc( hDlg, WM_USER_UPDATE, 0, 0 ); // setting values

		return FALSE; // dont give it focus

	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );
		switch( LOWORD(wParam) )
		{
		case IDC_NEWMODIFIER:
			if( pcController->nModifiers < 255 )
			{
				++pcController->nModifiers;
				pcController->pModifiers = (MODIFIER*)P_realloc( pcController->pModifiers, sizeof(MODIFIER) * pcController->nModifiers );

				ZeroMemory( &pcController->pModifiers[pcController->nModifiers - 1], sizeof(MODIFIER) );
				iSelectedMod = pcController->nModifiers - 1;
				ModifierTabProc( hDlg, WM_USER_UPDATE, 0, 1 );
			}
			break;

		case IDC_KILLMODIFIER:
			hDlgItem = GetDlgItem( hDlg, IDC_MODIFIERLIST );

			if( ListView_GetSelectedCount( hDlgItem ) > 0 )
			{
				for( i = ListView_GetItemCount( hDlgItem ) - 1; i >= 0; i-- )
				{
					if( ListView_GetItemState( hDlgItem, i, LVIS_SELECTED ))
					{
						MoveMemory( &pcController->pModifiers[i], &pcController->pModifiers[i+1], sizeof(MODIFIER) * ( pcController->nModifiers - 1 - i ));
						pcController->nModifiers--;
					}
				}
				pcController->pModifiers = (MODIFIER*)P_realloc( pcController->pModifiers, sizeof(MODIFIER) * pcController->nModifiers );
				ModifierTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
			break;

		case IDC_ASSIGNMOD:
			if( bScanRunning )
			{
				bScanRunning = false;
				KillTimer( hDlg, TIMER_BUTTON );
				BUTTON btnButton;
				btnButton.dwButton = GetWindowLong( hDlgItem, GWL_USERDATA );
				GetButtonText( btnButton, szBuffer, g_KeyDescription );
				SendMessage( GetDlgItem( hDlg, IDT_ASSIGNMOD ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			}
			hDlgItem = GetDlgItem( hDlg, IDC_MODIFIERLIST );
			if( HIWORD(wParam) == BN_CLICKED && ListView_GetItemCount( hDlgItem ))
			{
				dwCounter = 0;
				hFocus = SetFocus( NULL );
				SetTimer( hDlg, TIMER_BUTTON, INTERVALL_BUTTON, NULL );
				bScanRunning = true;
			}
			break;

		case IDC_MODTYP:
			if( HIWORD (wParam) == CBN_SELCHANGE )
			{
				ModifierTabProc( hDlg, WM_USER_UPDATE, 1, 1 );
			}
			break;

		case IDC_APPCHANGES:
			// ModType
			hDlgItem = GetDlgItem( hDlg, IDC_MODTYP );
			i = SendMessage( hDlgItem, CB_GETCURSEL, 0, 0 );
			pcController->pModifiers[iSelectedMod].bTyp = (BYTE)SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
			switch( pcController->pModifiers[iSelectedMod].bTyp )
			{
			case MDT_CONFIG:
				pcController->pModifiers[iSelectedMod].fSHandling = true;
				break;
			case MDT_NONE:
			case MDT_MOVE:
			case MDT_MACRO:
			default:
				pcController->pModifiers[iSelectedMod].fSHandling = false;
			}

			// Toggle
			pcController->pModifiers[iSelectedMod].fToggle = ( IsDlgButtonChecked( hDlg, IDC_TOGGLE ) == BST_CHECKED );
			// Status
			pcController->pModifiers[iSelectedMod].fStatus = ( IsDlgButtonChecked( hDlg, IDC_STATE ) == BST_CHECKED );

			// Specific Data
			if( hModProperties )
				SendMessage( hModProperties, WM_USER_READVALUES, (WPARAM)&pcController->pModifiers[iSelectedMod].dwSpecific, 0 );
			else
				pcController->pModifiers[iSelectedMod].dwSpecific = 0;

			// ModButton
			pcController->pModifiers[iSelectedMod].btnButton.dwButton = GetWindowLong( GetDlgItem( hDlg, IDC_ASSIGNMOD ), GWL_USERDATA );

			ModDescription( GetDlgItem( hDlg, IDC_MODIFIERLIST ), iSelectedMod, &pcController->pModifiers[iSelectedMod] );

			break;
		case IDC_RESET:
			ModifierTabProc( hDlg, WM_USER_UPDATE, 1, 0 );
			break;

		case IDC_TOGGLE:
			EnableWindow( GetDlgItem( hDlg, IDC_STATE ), ( IsDlgButtonChecked( hDlg, IDC_TOGGLE ) == BST_CHECKED ) ? TRUE : FALSE );
			break;
		case IDC_STATE:
			break;
			
		default:
			return FALSE;
		}
		break;

	case WM_TIMER:
		if( wParam == TIMER_BUTTON && bScanRunning )
		{
			BUTTON newButton;
			i = ScanDevices( g_apConfigDevice, &dwCounter, &newButton );
			if( i || dwCounter > 500 )
			{
				bScanRunning = false;
				KillTimer( hDlg, TIMER_BUTTON );
				
				hDlgItem = GetDlgItem( hDlg, IDC_ASSIGNMOD );

				if( i == SC_SCANESCAPE )
					SetWindowLong( hDlgItem, GWL_USERDATA, 0 );
				else if( i == SC_SCANSUCCEED  ) // Succesfull
					SetWindowLong( hDlgItem, GWL_USERDATA, newButton.dwButton );

				newButton.dwButton = GetWindowLong( hDlgItem, GWL_USERDATA );

				GetButtonText( newButton, szBuffer, g_KeyDescription );
				SendMessage( GetDlgItem( hDlg, IDT_ASSIGNMOD ), WM_SETTEXT , 0, (LPARAM)szBuffer );
				if( hFocus != NULL )
					SetFocus( hFocus );
			}
			else
			{
				++dwCounter;
				if(( dwCounter % 50 ) == 0 )
				{
					wsprintf( szBuffer, "...Awaiting Input %i...", 10 - dwCounter / 50 );
					SendMessage( GetDlgItem( hDlg, IDT_ASSIGNMOD ), WM_SETTEXT , 0, (LPARAM)szBuffer );
				}
			}
		}
		return TRUE;

	case WM_NOTIFY:
		switch( ((LPNMHDR)lParam)->idFrom )
		{
		case IDC_MODIFIERLIST:
			switch( ((LPNMHDR)lParam)->code )
			{
			case LVN_ITEMCHANGED:
				ModifierTabProc( hDlg, WM_USER_UPDATE, 1, 0 );
				break;
			}
		}
		break;


	case WM_USER_UPDATE:
		pcController = &g_ivConfig->Controllers[g_ivConfig->ChoosenTab];
		hDlgItem = GetDlgItem( hDlg, IDC_MODIFIERLIST );

		if( wParam == 0 )
		{
			// Update Modifier List
			ListView_DeleteAllItems( hDlgItem );
			if( lParam == 0 )
				iSelectedMod = -1;
	
			LVITEM lvItem;
			lvItem.mask = LVIF_TEXT | LVIF_PARAM;
			lvItem.iItem = 0;
			lvItem.iSubItem = 0;
			lvItem.pszText = "";

			ListView_SetItemCount( hDlgItem, pcController->nModifiers );
			for( lvItem.lParam = 0; lvItem.lParam < pcController->nModifiers; ++lvItem.lParam )
			{
				lvItem.iItem = lvItem.lParam;
				i = ListView_InsertItem( hDlgItem, &lvItem );

				ModDescription( hDlgItem, i, &pcController->pModifiers[lvItem.lParam] );
			}
			if( iSelectedMod >= 0 && iSelectedMod < ListView_GetItemCount( hDlgItem ))

				ListView_SetItemState( hDlgItem, iSelectedMod, LVIS_SELECTED, LVIS_SELECTED )
			else
				iSelectedMod = -1;
		

			j = FindDeviceinList( g_ivConfig->Devices[g_ivConfig->ChoosenTab].szProductName, g_ivConfig->Devices[g_ivConfig->ChoosenTab].bProductCounter, false );
		
			ReleaseEffect( g_pConfigEffect );
			if( j == -1 )
				ReleaseDevice( g_apConfigDevice[DID_GAMEPAD] );
			else
				GetInputDevice( g_hMainDialog, g_apConfigDevice[DID_GAMEPAD], g_devList[j].guidInstance, g_devList[j].dwDevType, DIB_CONFIG );
		}
		else
		{
			// Get selected Modifier
			iSelectedMod = -1;
			if( ListView_GetSelectedCount( hDlgItem ) > 0 )
			{
				for( i = ListView_GetItemCount( hDlgItem ) - 1; i >= 0; i-- )
				{
					if( ListView_GetItemState( hDlgItem, i, LVIS_SELECTED ))
					{
						iSelectedMod = i;
						i = -1;
					}
				}
			}
		}

		hDlgItem = GetDlgItem( hDlg, IDC_MODTYP );

		if( lParam == 0 )
		{
			if( iSelectedMod >= 0 )
			{	// a mod is selected
				EnableWindow( GetDlgItem( hDlg, IDC_ASSIGNMOD ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDT_ASSIGNMOD ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_TOGGLE ), TRUE );
				EnableWindow( hDlgItem, TRUE );
				EnableWindow( GetDlgItem( hDlg, IDT_MODTYP ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_APPCHANGES ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_RESET ), TRUE );

				for( i = SendMessage( hDlgItem, CB_GETCOUNT, 0, 0 )-1; i >= 0; i-- )
				{ // looking which Mod-Typ
					bByte = (BYTE)SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
					if( pcController->pModifiers[iSelectedMod].bTyp == bByte )
					{
						SendMessage( hDlgItem, CB_SETCURSEL, i, 0 );
						i = -10;
					}
				}
				if( i > -5 )
					SendMessage( hDlgItem, CB_SETCURSEL, 0, 0 );

				CheckDlgButton( hDlg, IDC_TOGGLE, pcController->pModifiers[iSelectedMod].fToggle ? BST_CHECKED : BST_UNCHECKED );
				EnableWindow( GetDlgItem( hDlg, IDC_STATE ), pcController->pModifiers[iSelectedMod].fToggle ? TRUE : FALSE );
				CheckDlgButton( hDlg, IDC_STATE, pcController->pModifiers[iSelectedMod].fStatus ? BST_CHECKED : BST_UNCHECKED );


				SetWindowLong( GetDlgItem( hDlg, IDC_ASSIGNMOD ), GWL_USERDATA, pcController->pModifiers[iSelectedMod].btnButton.dwButton );
				GetButtonText( pcController->pModifiers[iSelectedMod].btnButton, szBuffer, g_KeyDescription );
				SendMessage( GetDlgItem( hDlg, IDT_ASSIGNMOD ), WM_SETTEXT , 0, (LPARAM)szBuffer );
			}
			else
			{
				EnableWindow( GetDlgItem( hDlg, IDC_ASSIGNMOD ), FALSE );
				SetWindowLong( GetDlgItem( hDlg, IDC_ASSIGNMOD ), GWL_USERDATA, 0 );
				SendMessage( GetDlgItem( hDlg, IDT_ASSIGNMOD ), WM_SETTEXT , 0, (LPARAM)"" );
				EnableWindow( GetDlgItem( hDlg, IDT_ASSIGNMOD ), FALSE );

				SendMessage( hDlgItem, CB_SETCURSEL, 0, 0 );
				EnableWindow( hDlgItem, FALSE );
				EnableWindow( GetDlgItem( hDlg, IDT_MODTYP ), FALSE );

				EnableWindow( GetDlgItem( hDlg, IDC_TOGGLE ), FALSE );
				CheckDlgButton( hDlg, IDC_TOGGLE , BST_UNCHECKED );
				EnableWindow( GetDlgItem( hDlg, IDC_STATE ), FALSE );
				CheckDlgButton( hDlg, IDC_STATE , BST_UNCHECKED );
				EnableWindow( GetDlgItem( hDlg, IDC_APPCHANGES ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDC_RESET ), FALSE );
			}
		}

		i = SendMessage( hDlgItem, CB_GETCURSEL, 0, 0 );
		bByte = (BYTE)SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
		

		if(( bByte == bDisplayedProbs ) && hModProperties )
			SendMessage( hModProperties, WM_USER_UPDATE, pcController->pModifiers[iSelectedMod].bTyp, pcController->pModifiers[iSelectedMod].dwSpecific );
		else
		{
			if( hModProperties )
				DestroyWindow( hModProperties );

			hDlgItem = GetDlgItem( hDlg, IDC_PROPWINDOW );
				
			switch( bByte )
			{
			case MDT_MOVE:
				hModProperties = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_MOD_MOVE ), hDlgItem, MoveModifierDialog );
				break;
			case MDT_MACRO:
				hModProperties = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_MOD_MACRO ), hDlgItem, MacroModifierDialog );
				break;
			case MDT_CONFIG:
				hModProperties = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_MOD_CONFIG ), hDlgItem, ConfigModifierDialog );
				break;
			case MDT_NONE:
			default:
				hModProperties = NULL;
			}

			if( hModProperties )
			{
				SendMessage( hModProperties, WM_USER_UPDATE, pcController->pModifiers[iSelectedMod].bTyp, pcController->pModifiers[iSelectedMod].dwSpecific );
				ShowWindow( hModProperties, SW_SHOW );				
			}
			bDisplayedProbs = bByte;
		}
		break;


		
	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK ControllerPakTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static HWND hPakWindow;
	static bool bAdaptoidInList;
	static BYTE bCurrentPak;
	HWND hDlgItem;
	LONG i,j;
	BYTE bByte;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		hPakWindow = NULL;
		bAdaptoidInList = false;
		bCurrentPak = -1;

		// DropDown-List;
		hDlgItem = GetDlgItem( hDlg, IDC_MEMPAKTYP );
		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"None" );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, PAK_NONE );

		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"Mem Pak" );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, PAK_MEM );

		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"Rumble Pak" );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, PAK_RUMBLE );

#ifdef V_TRANSFERPAK
		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"Transfer Pak" );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, PAK_TRANSFER );
#pragma message( "Transferpak enabled in Interface" )
#endif
#ifdef V_VOICEPAK
		i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"Voice Pak" );
		SendMessage( hDlgItem, CB_SETITEMDATA, i, PAK_VOICE );
#pragma message( "Voicepak enabled in Interface" )
#endif

		ControllerPakTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
		return FALSE; // dont give it focus

	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );

		switch( LOWORD(wParam) )
		{
		case IDC_MEMPAKTYP:
			if( HIWORD (wParam) == CBN_SELCHANGE )
			{
				i = SendMessage( hDlgItem, CB_GETCURSEL, 0, 0 );
				g_ivConfig->Controllers[g_ivConfig->ChoosenTab].PakType = SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
				ControllerPakTabProc( hDlg, WM_USER_UPDATE, 0, 0 );		
			}
			break;
		case IDC_RAWMODE:
			g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRawData = ( IsDlgButtonChecked( hDlg, LOWORD(wParam) ) == BST_CHECKED );
			ControllerPakTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
			break;

		default:
			return FALSE;
		}
		break;

	case WM_USER_UPDATE:

		CheckDlgButton( hDlg, IDC_RAWMODE, g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRawData ? BST_CHECKED : BST_UNCHECKED );
		//Set Dropdownlist
		hDlgItem = GetDlgItem( hDlg, IDC_MEMPAKTYP );

		if(	g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRawData &&
			!lstrcmp( g_ivConfig->Devices[g_ivConfig->ChoosenTab].szProductName, STRING_ADAPTOID ) &&
			!bAdaptoidInList )
		{
			// add Adaptoid Pak to list
			i = SendMessage( hDlgItem, CB_ADDSTRING, 0, (LPARAM)"Adaptoid Pak" );
			SendMessage( hDlgItem, CB_SETITEMDATA, i, PAK_ADAPTOID );
			bAdaptoidInList = true;
		}

		if(	bAdaptoidInList &&
			( lstrcmp( g_ivConfig->Devices[g_ivConfig->ChoosenTab].szProductName, STRING_ADAPTOID ) ||
			  !g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRawData ))
		{
			// remove Adaptoid Pak from list
			i = SendMessage( hDlgItem, CB_GETCOUNT, 0, 0 ) - 1;
			while(( i >= 0 ))
			{
				j = SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
				if( j == PAK_ADAPTOID )
				{
					SendMessage( hDlgItem, CB_DELETESTRING, i, 0 );
					i = -1;
				}
				i--;
			}
			bAdaptoidInList = false;
		}
		

		i = SendMessage( hDlgItem, CB_GETCOUNT, 0, 0 ) - 1;
		
		while(( i >= 0 ))
		{
			bByte = (BYTE)SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
			if( g_ivConfig->Controllers[g_ivConfig->ChoosenTab].PakType == bByte )
			{
				SendMessage( hDlgItem, CB_SETCURSEL, i, 0 );
				i = -10;
			}
			else
				i--;
		}
		if( i != -10 )
			SendMessage( hDlgItem, CB_SETCURSEL, 0, 0 );
		
		// Update Pak-Display
		if( g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRawData )
		{
			i = SendMessage( GetDlgItem( hDlg, IDC_MEMPAKTYP ), CB_GETCURSEL, 0, 0 );
			bByte = (BYTE)SendMessage( hDlgItem, CB_GETITEMDATA, i, 0 );
		}
		else
			bByte = PAK_NONRAW;
		

		if( bByte == bCurrentPak && hPakWindow )
			SendMessage( hPakWindow, WM_USER_UPDATE, 0, 0 );
		else
		{
			if( hPakWindow )
				DestroyWindow( hPakWindow );

			hDlgItem = GetDlgItem( hDlg, IDC_PAKAREA );
				
			switch( bByte )
			{
			case PAK_MEM:
				hPakWindow = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_PAK_MEMPAK ), hDlgItem, MemPakProc );
				break;
			case PAK_RUMBLE:
				hPakWindow = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_PAK_TEXT ), hDlgItem, PakProc );
				break;
			case PAK_TRANSFER:
				hPakWindow = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_PAK_TRANSFER ), hDlgItem, TransferPakProc );
				break;
			case PAK_ADAPTOID:
				hPakWindow = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_PAK_ADAPTOID ), hDlgItem, PakProc );
				break;

			case PAK_VOICE:
			case PAK_NONRAW:
			case PAK_NONE:
			default:
				hPakWindow = CreateDialog( g_hinstDll, MAKEINTRESOURCE( IDD_PAK_TEXT ), hDlgItem, PakProc );

			}
			if( hPakWindow )
				ShowWindow( hPakWindow, SW_SHOW );
			bCurrentPak = bByte;
		}

		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK PakProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	TCHAR *pszDescription[2] = { "", "" };
	bool bRAW;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		PakProc( hDlg, WM_USER_UPDATE, 0, 0 );
		return FALSE; // dont give it focus

	case WM_USER_UPDATE:
		bRAW = g_ivConfig->Controllers[g_ivConfig->ChoosenTab].fRawData ? 1 : 0;

		switch( g_ivConfig->Controllers[g_ivConfig->ChoosenTab].PakType )
		{	
		case PAK_MEM:
			pszDescription[0] = "The MemPak is handled by the Emulator.";
			break;
		case PAK_RUMBLE:
			pszDescription[0] =	"The RumblePak is handled by the Emulator.\n\nYou wont get ForceFeedBack,\n"
								" the Emulator may use other ways( Visual ) or wont do anything at all";
			pszDescription[1] = "You can choose different Rumble-Types\n and adjust Rumble-Strength in the DevicesTab"; 
			break;
		case PAK_TRANSFER:
			pszDescription[0] = "The TransferPak is handled by the Emulator.\n\nWill very likely doing nothing( no Emu can handle this ATM )";
			break;
		case PAK_VOICE:
			pszDescription[0] = 
			pszDescription[1] = "Isnt emulated by this Plugin or Emulator\n and likely wont ever be";
			break;
		case PAK_ADAPTOID:
			pszDescription[0] = "The AdaptoidPak needs RAWMode to be activated";
			break;
		case PAK_NONE:
		default:
			pszDescription[0] =
			pszDescription[1] = "No Pak inserted";
		}
		SendMessage( GetDlgItem( hDlg, IDT_PAKDESC ), WM_SETTEXT, 0, (LPARAM)pszDescription[bRAW] );
		
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK MemPakProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static TCHAR *pszMemPakFile;
	static WORD wMemPakState;
	static int iSelectedNote;
	TCHAR szBuffer[MAX_PATH+1];

	HWND hDlgItem;
	LONG i,j;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		if( g_bRunning )
		{
			EnableWindow( GetDlgItem( hDlg, IDC_CHGDIR ), FALSE );
			SendMessage( GetDlgItem( hDlg, IDC_CHGDIR ), WM_SETTEXT, 0, (LPARAM)"Cant change whilst running" );
		}
		iSelectedNote = -1;
		// Browser
		hDlgItem = GetDlgItem( hDlg, IDC_MEMPAKBROWSER );

		LVCOLUMN lvColumn;

		lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT;
		lvColumn.fmt = LVCFMT_LEFT;
		lvColumn.cx = 147;	
		lvColumn.pszText = "Name";
		ListView_InsertColumn( hDlgItem, 0, &lvColumn );

		lvColumn.fmt = LVCFMT_CENTER | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;

		lvColumn.cx = 70;	
		lvColumn.iSubItem = 1;
		lvColumn.pszText = "Country";
		ListView_InsertColumn( hDlgItem, 1, &lvColumn );

		lvColumn.cx = 50;	
		lvColumn.iSubItem = 2;
		lvColumn.pszText = "Blocks";
		ListView_InsertColumn( hDlgItem, 2, &lvColumn );

		ListView_SetExtendedListViewStyle( hDlgItem, LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP );


		MemPakProc( hDlg, WM_USER_UPDATE, 0, 0 ); // setting values
		return FALSE; // dont give it focus

	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );
		switch( LOWORD(wParam) )
		{
		case IDC_MEMPAKLIST:
			if( HIWORD(wParam) == LBN_SELCHANGE )
			{
				i = SendMessage( hDlgItem, LB_GETCURSEL, 0, 0 );
				SendMessage( hDlgItem, LB_GETTEXT, i, (LPARAM)pszMemPakFile );
				MemPakProc( hDlg, WM_USER_UPDATE, 1, 0 );
			}
			break;
		case IDC_BROWSE:
			lstrcpy( szBuffer, pszMemPakFile );
			if( BrowseFile( hDlg, szBuffer, MAKELONG( BF_MEMPAK, BF_LOAD )))
			{
				if( !CheckFileExists( szBuffer ) )
				{
					BYTE aMemPak[32*1024];

					FormatMemPak( aMemPak );
					WriteMemPakFile( szBuffer, aMemPak, true );
				}
				if( CheckFileExists( szBuffer ) )
				{
					lstrcpy( pszMemPakFile, szBuffer );
					MemPakProc( hDlg, WM_USER_UPDATE, 0, 0 );
				}
			}
			break;
		case IDC_CHGDIR:
			if( DialogBox( g_hinstDll, MAKEINTRESOURCE( IDD_FOLDERS ), hDlg, FoldersDialogProc ) == TRUE )
				MemPakProc( hDlg, WM_USER_UPDATE, 0, 0 );
			break;

		case IDC_DELMEMPAK:
			if( MessageBox( hDlg, "Do you really want to delete that MemPak ?", PLUGINMESSAGE, MB_OKCANCEL | MB_ICONQUESTION ) == IDOK )
			{
				GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );
				DeleteFile( szBuffer );
				pszMemPakFile[0] = '\0';
				MemPakProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
			break;

		case IDC_FORMATMEMPAK:
			if( MessageBox( hDlg, "Do you really want to format the MemPak ?", PLUGINMESSAGE, MB_OKCANCEL | MB_ICONQUESTION ) == IDOK )
			{
				GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );
				BYTE aMemPak[32*1024];

				FormatMemPak( aMemPak );
				WriteMemPakFile( szBuffer, aMemPak, false );
				MemPakProc( hDlg, WM_USER_UPDATE, 1, 0 );
			}
			break;
		case IDC_SAVENOTE:
			{
			BYTE aMemPak[32*1024];
			if( g_bRunning && ( HIWORD(wMemPakState) == MPAK_INUSE ) 
				&& g_pcControllers[g_ivConfig->ChoosenTab].pPakData
				&& ( *(BYTE*)g_pcControllers[g_ivConfig->ChoosenTab].pPakData == PAK_MEM ))
			{
				EnterCriticalSection( &g_resController );
				CopyMemory( aMemPak, ((MEMPAK*)g_pcControllers[g_ivConfig->ChoosenTab].pPakData)->aMemPakData, 32*1024 );
				LeaveCriticalSection( &g_resController );
			}
			else
			{
				GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );
				ReadMemPakFile( szBuffer, aMemPak, false );
			}

			TCHAR cAppendix;

			cAppendix = TranslateNotes( &aMemPak[0x300 + iSelectedNote * 32], szBuffer );
			if( cAppendix != '\0' )
				wsprintf( szBuffer, "%s_(%c)", szBuffer, cAppendix );

			if( BrowseFile( hDlg, szBuffer, MAKELONG( BF_NOTE, BF_SAVE )))
			{
				TCHAR szAbsoluteMemPak[MAX_PATH+1];
				GetAbsoluteFileName( szAbsoluteMemPak, pszMemPakFile, DIRECTORY_MEMPAK );

				SaveNoteFileA( aMemPak, iSelectedNote, szBuffer );
			}
			}
			break;
		case IDC_INSERTNOTE:
			{
			GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );
			BYTE aMemPak[32*1024];
			ReadMemPakFile( szBuffer, aMemPak, false );
			szBuffer[0] = '\0';

			if( BrowseFile( hDlg, szBuffer, MAKELONG( BF_NOTE, BF_LOAD )))
			{
				if( InsertNoteFile( aMemPak, szBuffer ) )
				{
					GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );
					WriteMemPakFile( szBuffer, aMemPak, false );
					MemPakProc( hDlg, WM_USER_UPDATE, 1, 0 );
				}
			}
			}
			break;
		case IDC_DELETENOTE:
			if( MessageBox( hDlg, "Do you really want to delete this Note ?", PLUGINMESSAGE, MB_OKCANCEL | MB_ICONQUESTION ) == IDOK )
			{
				GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );
				BYTE aMemPak[32*1024];
				ReadMemPakFile( szBuffer, aMemPak, false );
				if( RemoveNote( aMemPak, iSelectedNote ) )
				{
					WriteMemPakFile( szBuffer, aMemPak, false );
					MemPakProc( hDlg, WM_USER_UPDATE, 1, 0 );
				}
			}
			break;

		default:
			return FALSE;
		}
		break;

	case WM_NOTIFY:
		switch( ((LPNMHDR)lParam)->idFrom )
		{
		case IDC_MEMPAKBROWSER:
			switch( ((LPNMHDR)lParam)->code )
			{
			case LVN_ITEMCHANGED:
				if( ((LPNMLISTVIEW)lParam)->uNewState & LVIS_SELECTED )
				{
					iSelectedNote = ((LPNMLISTVIEW)lParam)->lParam;
					if( HIBYTE(wMemPakState) & MPAK_READABLE )
						EnableWindow( GetDlgItem( hDlg, IDC_SAVENOTE ), TRUE );
					if( HIBYTE(wMemPakState) & MPAK_WRITEABLE )
						EnableWindow( GetDlgItem( hDlg, IDC_DELETENOTE ), TRUE );
				}
				else
				{
					iSelectedNote = -1;
					EnableWindow( GetDlgItem( hDlg, IDC_SAVENOTE ), FALSE );
					EnableWindow( GetDlgItem( hDlg, IDC_DELETENOTE ), FALSE );
				}

				break;
			}
		}
		break;

	case WM_USER_UPDATE:
		pszMemPakFile = g_ivConfig->Controllers[g_ivConfig->ChoosenTab].szMempakFile;
		iSelectedNote = -1;

		// Mempak List Window
		if( wParam == 0 && lParam == 0 )
		{
			hDlgItem = GetDlgItem( hDlg, IDC_MEMPAKLIST );
			SendMessage( hDlgItem, LB_RESETCONTENT, 0, 0 );
			SendFilestoList( hDlgItem, FILIST_MEM );

			if( pszMemPakFile[1] == ':' || ( pszMemPakFile[1] == '\\' && pszMemPakFile[0] == '\\' ))
			{
				GetDirectory( szBuffer, DIRECTORY_MEMPAK );
				i = lstrlen( szBuffer );
				if( !n_strncmp( szBuffer, pszMemPakFile, i ))
				{
					lstrcpy( szBuffer, &pszMemPakFile[i] );
					lstrcpy( pszMemPakFile, szBuffer );
				}

			}

			j = -1;
			if( !( pszMemPakFile[1] == ':' || ( pszMemPakFile[1] == '\\' && pszMemPakFile[0] == '\\' )) )
			{
				i = SendMessage( hDlgItem, LB_FINDSTRINGEXACT, -1, (LPARAM)pszMemPakFile );
				if( i != LB_ERR )
					j = i;
			}
			SendMessage( hDlgItem, LB_SETCURSEL, j, 0 );
		}
		// Mempak List Window End

		// MamPak Full Path+Name
		GetAbsoluteFileName( szBuffer, pszMemPakFile, DIRECTORY_MEMPAK );

		// MemPak Browser
		ListView_DeleteAllItems( GetDlgItem( hDlg, IDC_MEMPAKBROWSER ));
		if(	(!lstrcmpi( &szBuffer[lstrlen(szBuffer)-4], ".mpk" ))
			|| (!lstrcmpi( &szBuffer[lstrlen(szBuffer)-4], ".n64" )))
		{
			BYTE aMemPakHeader[0x500];

			HANDLE hFile;
			hFile = CreateFile( szBuffer, GENERIC_READ, FILE_SHARE_READ,
			                           NULL, OPEN_EXISTING, 0, NULL );
			if ( hFile == INVALID_HANDLE_VALUE )
			{
				DWORD dwError = GetLastError();
				bool fMemPakUsed = false;

				if( dwError == ERROR_SHARING_VIOLATION && g_bRunning )
				{
					TCHAR szMemPakFile[MAX_PATH+1];
					for( i = 0; i < 4; ++i )
					{
						if( g_pcControllers[i].pPakData && ( *(BYTE*)g_pcControllers[i].pPakData == PAK_MEM ))
						{
							GetAbsoluteFileName( szMemPakFile, g_pcControllers[i].szMempakFile, DIRECTORY_MEMPAK );
							if( !lstrcmp( szMemPakFile, szBuffer ))
							{
								EnterCriticalSection( &g_resController );			
								wMemPakState = ShowMemPakContent( ((MEMPAK*)g_pcControllers[i].pPakData)->aMemPakData, GetDlgItem( hDlg, IDC_MEMPAKBROWSER ));
								LeaveCriticalSection( &g_resController );
								fMemPakUsed = true;
							}
						}
					}
				}

				if( fMemPakUsed )
					wMemPakState = MAKEWORD( LOWORD(wMemPakState), MPAK_INUSE );
				else
				{
					DWORD dwLength = wsprintf( szBuffer, "ErrorCode %lu: ", dwError );			
					FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError , 0, &szBuffer[dwLength], sizeof(szBuffer) - dwLength - 1, NULL );
					wMemPakState = MAKEWORD( 0, MPAK_ERROR );
				}
			}
			else
			{
				DWORD dwFileSize = GetFileSize( hFile, NULL );
				DWORD dwCorrectFileSize = 0x8000;

				TCHAR *pcPoint = n_strrchr( szBuffer, '.' );
				if( !lstrcmpi( pcPoint, ".n64" ) )
				{
					SetFilePointer( hFile, 0x1040, NULL, FILE_BEGIN );
					dwCorrectFileSize += 0x1040;
				}
				else
					SetFilePointer( hFile, 0L, NULL, FILE_BEGIN );
					
				if( dwFileSize > ( dwCorrectFileSize - 0x7500 ))
				{
					DWORD dwBytesRead;

					ReadFile( hFile, aMemPakHeader, 0x500, &dwBytesRead, NULL);
					ListView_DeleteAllItems( GetDlgItem( hDlg, IDC_MEMPAKBROWSER ));
					wMemPakState = ShowMemPakContent( aMemPakHeader, GetDlgItem( hDlg, IDC_MEMPAKBROWSER ));
				}
				else
					wMemPakState = MAKEWORD( 0, MPAK_DAMAGED );

				if( HIBYTE( wMemPakState ) == MPAK_OK &&
					dwFileSize != dwCorrectFileSize )
					wMemPakState = MAKEWORD( LOBYTE( wMemPakState ), MPAK_WRONGSIZE );

				CloseHandle( hFile );
			}
		}
		else
			wMemPakState = MAKEWORD( 0, MPAK_NOSELECTION );

		if( HIBYTE(wMemPakState) & MPAK_FORMATABLE )
		{
			EnableWindow( GetDlgItem( hDlg, IDC_FORMATMEMPAK ), TRUE );
			EnableWindow( GetDlgItem( hDlg, IDC_DELMEMPAK ), TRUE );
		}
		else
		{
			EnableWindow( GetDlgItem( hDlg, IDC_FORMATMEMPAK ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_DELMEMPAK ), FALSE );
		}

		if( HIBYTE(wMemPakState) & MPAK_WRITEABLE )
			EnableWindow( GetDlgItem( hDlg, IDC_INSERTNOTE ), TRUE );
		else
			EnableWindow( GetDlgItem( hDlg, IDC_INSERTNOTE ), FALSE );
			
		EnableWindow( GetDlgItem( hDlg, IDC_SAVENOTE ), FALSE );
		EnableWindow( GetDlgItem( hDlg, IDC_DELETENOTE ), FALSE );


		switch( HIBYTE(wMemPakState) )
		{
		case MPAK_OK:
			wsprintf( szBuffer, "%i Blocks free", LOBYTE(wMemPakState) );
			break;
		case MPAK_INUSE:
			wsprintf( szBuffer, "%i Blocks free\nMemPak is currently used by the Emulator", LOBYTE(wMemPakState) );
			break;
		case MPAK_WRONGSIZE:
			wsprintf( szBuffer, "%i Blocks free\nMemPak has wrong FileSize and may be damaged", LOBYTE(wMemPakState) );
			break;
		case MPAK_NOSELECTION:
			lstrcpy( szBuffer, "No MemPak selected" );
			break;
		case MPAK_DAMAGED:
			lstrcpy( szBuffer, "MemPak is damaged\nFormat is neccesary" );
			break;

		case MPAK_ERROR:
		default:
			break;
		}
		SendMessage( GetDlgItem( hDlg, IDT_MEMPAKSTATE ), WM_SETTEXT, 0, (LPARAM)szBuffer );

		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK TransferPakProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static LPTSTR pszGBRomFile = NULL;
	static LPTSTR pszGBSaveFile = NULL;
	switch(uMsg)
	{
	case WM_INITDIALOG:
		if( g_bRunning )
		{
			EnableWindow( GetDlgItem( hDlg, IDC_CHGDIR ), FALSE );
			SendMessage( GetDlgItem( hDlg, IDC_CHGDIR ), WM_SETTEXT, 0, (LPARAM)"Cant change whilst running" );
		}
		
		TransferPakProc( hDlg, WM_USER_UPDATE, 0, 0 ); // setting values
		return FALSE; // dont give it focus

	case WM_COMMAND:
		switch( LOWORD(wParam) )
		{
		case IDC_GBROM_EDIT:
			if( HIWORD(wParam) == EN_CHANGE )
				GetDlgItemText( hDlg, IDC_GBROM_EDIT, pszGBRomFile, ARRAYSIZE(g_ivConfig->Controllers->szTransferRom) );
			break;
		case IDC_GBSAVE_EDIT:
			if( HIWORD(wParam) == EN_CHANGE )
				GetDlgItemText( hDlg, IDC_GBSAVE_EDIT, pszGBSaveFile, ARRAYSIZE(g_ivConfig->Controllers->szTransferSave) );
			break;
		case IDC_GBROM_BROWSE:
		{
			TCHAR szBuffer[MAX_PATH+1];
			GetAbsoluteFileName( szBuffer, pszGBRomFile, DIRECTORY_GBROMS );
			if( BrowseFile( hDlg, szBuffer, MAKELONG( BF_GBROM, BF_LOAD )))
			{
				lstrcpyn( pszGBRomFile, szBuffer, ARRAYSIZE(g_ivConfig->Controllers->szTransferRom) );
				TransferPakProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
		}
			break;
		case IDC_GBSAVE_BROWSE:
		{
			TCHAR szBuffer[MAX_PATH+1];
			GetAbsoluteFileName( szBuffer, pszGBSaveFile, DIRECTORY_GBSAVES );
			if( BrowseFile( hDlg, szBuffer, MAKELONG( BF_GBSAVE, BF_LOAD )))
			{
				lstrcpyn( pszGBSaveFile, szBuffer, ARRAYSIZE(g_ivConfig->Controllers->szTransferSave) );
				TransferPakProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
		}
			break;
		
		case IDC_CHGDIR:
			if( DialogBox( g_hinstDll, MAKEINTRESOURCE( IDD_FOLDERS ), hDlg, FoldersDialogProc ) == TRUE )
				TransferPakProc( hDlg, WM_USER_UPDATE, 0, 0 );
			break;

		default:
			return FALSE;
		}
		break;

	case WM_USER_UPDATE:
		pszGBRomFile = g_ivConfig->Controllers[g_ivConfig->ChoosenTab].szTransferRom;
		pszGBSaveFile = g_ivConfig->Controllers[g_ivConfig->ChoosenTab].szTransferSave;

		SetDlgItemText( hDlg, IDC_GBROM_EDIT, pszGBRomFile );
		SetDlgItemText( hDlg, IDC_GBSAVE_EDIT, pszGBSaveFile );
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK ShorcutsTabProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static bool bScanRunning;
	static DWORD dwButtonID[3];
	static DWORD dwCounter;
	static HWND hFocus;

	TCHAR szKeyname[30];
	long i;


	switch(uMsg)
	{
	case WM_INITDIALOG:

#ifndef RAWPROFILEWRITE
		DestroyWindow( GetDlgItem( hDlg, IDC_SAVEBINARY ));
#pragma message( "Save Binary Button hidden from Shortcutstab" )
#endif // #ifndef RAWPROFILEWRITE

		bScanRunning = false;

		ShorcutsTabProc( hDlg, WM_USER_UPDATE, 0, 0 ); // setting values
		return FALSE; // dont give it focus
		break;

	case WM_COMMAND:
		switch( LOWORD(wParam) )
		{
		case IDC_LOCKMOUSE:

		case IDC_SETNOPAK_P1:
		case IDC_SETMEMPAK_P1:
		case IDC_SETRUMBLEPAK_P1:
		case IDC_SETTRANSFERPAK_P1:
		case IDC_SETADAPTOIDPAK_P1:
		case IDC_SWMEMRUMBLE_P1:
		case IDC_SWMEMADAPTOID_P1:

		case IDC_SETNOPAK_P2:
		case IDC_SETMEMPAK_P2:
		case IDC_SETRUMBLEPAK_P2:
		case IDC_SETTRANSFERPAK_P2:
		case IDC_SETADAPTOIDPAK_P2:
		case IDC_SWMEMRUMBLE_P2:
		case IDC_SWMEMADAPTOID_P2:

		case IDC_SETNOPAK_P3:
		case IDC_SETMEMPAK_P3:
		case IDC_SETRUMBLEPAK_P3:
		case IDC_SETTRANSFERPAK_P3:
		case IDC_SETADAPTOIDPAK_P3:
		case IDC_SWMEMRUMBLE_P3:
		case IDC_SWMEMADAPTOID_P3:

		case IDC_SETNOPAK_P4:
		case IDC_SETMEMPAK_P4:
		case IDC_SETRUMBLEPAK_P4:
		case IDC_SETTRANSFERPAK_P4:
		case IDC_SETADAPTOIDPAK_P4:
		case IDC_SWMEMRUMBLE_P4:
		case IDC_SWMEMADAPTOID_P4:
		
			if( bScanRunning )
			{
				bScanRunning = false;
				KillTimer( hDlg, TIMER_BUTTON );
				if( ((LPBYTE)&g_ivConfig->ShortCuts)[dwButtonID[2]] == VK_ESCAPE )
					lstrcpy( szKeyname, "Unassigned" );
				else
					GetKeyNameText(( MapVirtualKey( ((LPBYTE)&g_ivConfig->ShortCuts)[dwButtonID[2]], 0 ) << 16 ), szKeyname, sizeof(szKeyname) );

				SendMessage( GetDlgItem( hDlg, dwButtonID[1] ), WM_SETTEXT, 0, (LPARAM)szKeyname );
			}
			if( HIWORD(wParam) == BN_CLICKED )
			{
				bScanRunning = true;
				dwButtonID[0] = LOWORD(wParam);
				GetButtonID( dwButtonID, 0, BSET_SHORTCUTS );
				dwCounter = 0;
				hFocus = SetFocus( NULL );
				
				SendMessage( GetDlgItem( hDlg, dwButtonID[1] ), WM_SETTEXT , 0, (LPARAM)"Press Key" );
				SetTimer( hDlg, TIMER_BUTTON, INTERVALL_BUTTON, NULL );
			}
			break;

		case IDC_SETDEFAULTSC:
			if( MessageBox( hDlg, "The Shortcut configuration will be restored\nAre u sure?", "Restore Default", MB_OKCANCEL | MB_ICONWARNING ) == IDOK )
			{
				LoadShortCutsfromRessource( &g_ivConfig->ShortCuts );
				ShorcutsTabProc( hDlg, WM_USER_UPDATE, 0, 0 );
			}
			break;

		case IDC_SAVEBINARY:
			{
			TCHAR szFilename[MAX_PATH+1] = "";
			if( BrowseFile( hDlg, szFilename, MAKELONG( BF_BINARY, BF_SAVE )))
			{
				HANDLE hFile = CreateFile( szFilename, GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS, 0, NULL);
				if( hFile != INVALID_HANDLE_VALUE )
				{
					DWORD dwBytesWritten = 0;
					WriteFile( hFile, (const void*)&g_ivConfig->ShortCuts, sizeof(SHORTCUTS), &dwBytesWritten, NULL );
					CloseHandle( hFile );
				}
			}
			}
			break;

		default:
			return FALSE;
		}
		break;

	case WM_TIMER:
		if( wParam == TIMER_BUTTON && bScanRunning )
		{
			++dwCounter;
			bool fGotKey = false;

			BYTE bKey = 0;
			BYTE aKeyboardState[256];
			GetKeyboardState( aKeyboardState );

			for( i = 0; i < ARRAYSIZE(aKeyboardState); ++i )
			{
				if(	( aKeyboardState[i] & 0x80 )
					&& ( i != VK_SHIFT )
					&& ( i != VK_CONTROL )
					&& ( i != VK_MENU ))
				{
					fGotKey = true;
					break;
				}
			}

			if(( dwCounter > 500 ) || fGotKey )
			{
				bScanRunning = false;
				KillTimer( hDlg, TIMER_BUTTON );

				if( fGotKey )
					((LPBYTE)&g_ivConfig->ShortCuts)[dwButtonID[2]] = (BYTE)i;
				
				i = ((LPBYTE)&g_ivConfig->ShortCuts)[dwButtonID[2]];

				if( i == VK_ESCAPE )
					lstrcpy( szKeyname, "Unassigned" );
				else
					GetKeyNameText(( MapVirtualKey( i, 0 ) << 16 ), szKeyname, sizeof(szKeyname) );

				SendMessage( GetDlgItem( hDlg, dwButtonID[1] ), WM_SETTEXT, 0, (LPARAM)szKeyname );

				if( hFocus )
					SetFocus( hFocus );
			}
		}
		return TRUE;
		break;

	case WM_USER_UPDATE:
		bScanRunning = false;
		KillTimer( hDlg, TIMER_BUTTON );
		//wsprintf( szKeyname, "%i", sizeof(g_ivConfig->ShortCuts) );
		//MessageBox( hDlg, szKeyname, "", MB_OK);
		for( i = 0; i < sizeof(g_ivConfig->ShortCuts); ++i )
		{
			DWORD aIDs[3];
			aIDs[2] = i;
			if( !GetButtonID( aIDs, 2, BSET_SHORTCUTS ))
				continue; // for not implemented Buttons, otherwise the behaviour is unsafe

			if( ((LPBYTE)&g_ivConfig->ShortCuts)[aIDs[2]] == VK_ESCAPE )
				lstrcpy( szKeyname, "Unassigned" );
			else
				GetKeyNameText(( MapVirtualKey( ((LPBYTE)&g_ivConfig->ShortCuts)[aIDs[2]], 0 ) << 16 ), szKeyname, sizeof(szKeyname) );

			SendMessage( GetDlgItem( hDlg, aIDs[1] ), WM_SETTEXT, 0, (LPARAM)szKeyname );
		}
		break;
		

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}

BOOL CALLBACK FoldersDialogProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	HWND hDlgItem;
	LONG i,j;
	TCHAR szBuffer[MAX_PATH+1];
	TCHAR szApplication[MAX_PATH+1],
		  *pcSlash;
	DWORD dwSize;

	switch(uMsg)
	{
	case WM_INITDIALOG:

#if defined(HIDEUNIMPLEMENTED) && !defined(V_TRANSFERPAK)
		{
			RECT rRect, rGBSave;
			GetWindowRect( GetDlgItem( hDlg, IDC_GBSAVEPANEL ), &rGBSave );
			GetWindowRect( GetDlgItem( hDlg, IDC_MEMPAKPANEL ), &rRect );
			int iShift = rRect.bottom - rGBSave.bottom;

			WINDOWPLACEMENT pos;
			pos.length = sizeof(WINDOWPLACEMENT);

			GetWindowPlacement( GetDlgItem( hDlg, IDOK ), &pos );
			pos.rcNormalPosition.top += iShift;
			pos.rcNormalPosition.bottom += iShift;
			SetWindowPlacement( GetDlgItem( hDlg, IDOK ), &pos );

			GetWindowPlacement( GetDlgItem( hDlg, IDCANCEL ), &pos );
			pos.rcNormalPosition.top += iShift;
			pos.rcNormalPosition.bottom += iShift;
			SetWindowPlacement( GetDlgItem( hDlg, IDCANCEL ), &pos );

			GetWindowRect( hDlg, &rRect );
			rRect.bottom += iShift;

			SetWindowPos( hDlg, NULL, rRect.left, rRect.top, rRect.right-rRect.left, rRect.bottom-rRect.top, SWP_NOMOVE | SWP_NOZORDER );

			int aChilds[] = {	IDC_GBROMPANEL, IDC_GBROM_REL, IDC_GBROM_REL_EDIT, IDC_GBROM_BROWSE_REL, IDC_GBROM_ABS, 
								IDC_GBROM_ABS_EDIT, IDC_GBROM_BROWSE_ABS, IDC_GBSAVEPANEL, IDC_GBSAVE_SAME, IDC_GBSAVE_REL, 
								IDC_GBSAVE_REL_EDIT, IDC_GBSAVE_BROWSE_REL, IDC_GBSAVE_ABS, IDC_GBSAVE_ABS_EDIT, IDC_GBSAVE_BROWSE_ABS };

			for( int i = 0; i < sizeof(aChilds)/sizeof(int); ++i )
				DestroyWindow( GetDlgItem( hDlg, aChilds[i] ));
		}
#pragma message( "unimplemented Features from the Folderdialog will be removed" )
#endif // #ifdef HIDEUNIMPLEMENTED

		GetDirectory( szApplication, DIRECTORY_GBROMS );
		GetDirectory( szBuffer, DIRECTORY_GBSAVES );
		j = lstrcmp( szApplication, szBuffer );
		
		GetDirectory( szApplication, DIRECTORY_APPLICATION );
		i = lstrlen( szApplication );

		// MemPak Directory
		dwSize = sizeof(szBuffer);
		LoadRegValue( STRING_REG_FOLDERS, 0, STRING_REG_MEMPAKDIR, szBuffer, &dwSize );
		
		if( dwSize > 0 && ( szBuffer[1] == ':' || ( szBuffer[1] == '\\' &&  szBuffer[0] == '\\' )))
		{

			CheckDlgButton( hDlg, IDC_MEMPAK_ABS, BST_CHECKED );

			GetDirectory( szBuffer, DIRECTORY_MEMPAK );
			if( !n_strncmp( szBuffer, szApplication, i ))
			{
				TCHAR *pcSub = &szBuffer[i];
				pcSlash = n_strrchr( pcSub, '\\' );
				if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)pcSub );
			}
			else
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)STRING_DEF_MEMPAKFILE );
		}
		else
		{
			CheckDlgButton( hDlg, IDC_MEMPAK_REL, BST_CHECKED );

			if( dwSize > 0 )
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			else
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)STRING_DEF_MEMPAKFILE );
		}


		GetDirectory( szBuffer, DIRECTORY_MEMPAK );
		pcSlash = n_strrchr( szBuffer, '\\' );
		if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';
		SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_ABS_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );

		// GBRom Directory
		dwSize = sizeof(szBuffer);
		LoadRegValue( STRING_REG_FOLDERS, 0, STRING_REG_GBROMDIR, szBuffer, &dwSize );

		if( dwSize > 0 && ( szBuffer[1] == ':' || ( szBuffer[1] == '\\' &&  szBuffer[0] == '\\' )))
		{
			CheckDlgButton( hDlg, IDC_GBROM_ABS, BST_CHECKED );

			GetDirectory( szBuffer, DIRECTORY_GBROMS );
			if( !n_strncmp( szBuffer, szApplication, i ))
			{
				TCHAR *pcSub = &szBuffer[i];
				pcSlash = n_strrchr( pcSub, '\\' );
				if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			}
			else
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)STRING_DEF_GBROMFILE );
		}
		else
		{
			CheckDlgButton( hDlg, IDC_GBROM_REL, BST_CHECKED );

			if( dwSize > 0 )
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			else
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)STRING_DEF_GBROMFILE );
		}

		GetDirectory( szBuffer, DIRECTORY_GBROMS );
		pcSlash = n_strrchr( szBuffer, '\\' );
		if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';
		SendMessage( GetDlgItem( hDlg, IDC_GBROM_ABS_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );


		// GBSave Directory
		dwSize = sizeof(szBuffer);
		LoadRegValue( STRING_REG_FOLDERS, 0, STRING_REG_GBROMSDIR, szBuffer, &dwSize );

		if( !j )
		{
			CheckDlgButton( hDlg, IDC_GBSAVE_SAME, BST_CHECKED );
			FoldersDialogProc( hDlg, WM_COMMAND, (WPARAM)MAKELONG( IDC_GBSAVE_SAME, BN_CLICKED ), (LPARAM)GetDlgItem( hDlg, IDC_GBSAVE_SAME ));
			SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_GETTEXT, sizeof(szBuffer), (LPARAM)szBuffer );
			SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
		}
		else
		{
			if( dwSize > 0 && ( szBuffer[1] == ':' || ( szBuffer[1] == '\\' &&  szBuffer[0] == '\\' )))
			{
				CheckDlgButton( hDlg, IDC_GBSAVE_ABS, BST_CHECKED );

				GetDirectory( szBuffer, DIRECTORY_GBSAVES );
				if( !n_strncmp( szBuffer, szApplication, i ))
				{
					TCHAR *pcSub = &szBuffer[i];
					pcSlash = n_strrchr( pcSub, '\\' );
					if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';
					SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
				}
				else
					SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)STRING_DEF_GBROMSAVE );
			}
			else
			{
				CheckDlgButton( hDlg, IDC_GBSAVE_REL, BST_CHECKED );

				if( dwSize > 0 )
					SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
				else
					SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)STRING_DEF_GBROMSAVE );
			}
		}


		GetDirectory( szBuffer, DIRECTORY_GBSAVES );
		pcSlash = n_strrchr( szBuffer, '\\' );
		if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';
		SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_ABS_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );


		return FALSE; // dont give it focus

	case WM_COMMAND:
		hDlgItem = GetDlgItem( hDlg, LOWORD(wParam) );

		switch( LOWORD(wParam) )
		{
		case IDC_GBSAVE_ABS:
		case IDC_GBSAVE_REL:
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), TRUE );
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_ABS_EDIT ), TRUE );
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_BROWSE_REL ), TRUE );
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_BROWSE_ABS ), TRUE );
			break;
		
		case IDC_GBSAVE_SAME:
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_ABS_EDIT ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_BROWSE_REL ), FALSE );
			EnableWindow( GetDlgItem( hDlg, IDC_GBSAVE_BROWSE_ABS ), FALSE );
			break;

		case IDC_MEMPAK_BROWSE_ABS:
			szBuffer[0] = '\0';
			if( BrowseFolders( hDlg, NULL, szBuffer ))
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_ABS_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			break;
		case IDC_GBROM_BROWSE_ABS:
			szBuffer[0] = '\0';
			if( BrowseFolders( hDlg, NULL, szBuffer ))
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_ABS_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			break;
		case IDC_GBSAVE_BROWSE_ABS:
			szBuffer[0] = '\0';
			if( BrowseFolders( hDlg, NULL, szBuffer ))
				SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_ABS_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			break;
		case IDC_MEMPAK_BROWSE_REL:
			GetDirectory( szApplication, DIRECTORY_APPLICATION );
			lstrcpy( szBuffer, szApplication );
			if( BrowseFolders( hDlg, NULL, szBuffer ))
			{
				i = lstrlen( szApplication );
				lstrcpy( szBuffer, &szBuffer[i] );
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			}
			break;
		case IDC_GBROM_BROWSE_REL:
			GetDirectory( szApplication, DIRECTORY_APPLICATION );
			lstrcpy( szBuffer, szApplication );
			if( BrowseFolders( hDlg, NULL, szBuffer ))
			{
				i = lstrlen( szApplication );
				lstrcpy( szBuffer, &szBuffer[i] );
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			}
			break;
		case IDC_GBSAVE_BROWSE_REL:
			GetDirectory( szApplication, DIRECTORY_APPLICATION );
			lstrcpy( szBuffer, szApplication );
			if( BrowseFolders( hDlg, NULL, szBuffer ))
			{
				i = lstrlen( szApplication );
				lstrcpy( szBuffer, &szBuffer[i] );
				SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_SETTEXT, 0, (LPARAM)szBuffer );
			}
			break;
		
		case IDOK:
			dwSize = sizeof(szBuffer);
			if( IsDlgButtonChecked( hDlg, IDC_MEMPAK_ABS ) == BST_CHECKED )
			{
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_ABS_EDIT ), WM_GETTEXT, sizeof(szApplication), (LPARAM)szApplication );
				GetFullPathName( szApplication, sizeof(szBuffer), szBuffer, &pcSlash );
			}
			else
				SendMessage( GetDlgItem( hDlg, IDC_MEMPAK_REL_EDIT ), WM_GETTEXT, dwSize, (LPARAM)szBuffer );
			pcSlash = n_strrchr( szBuffer, '\\' );
			if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';

			if( !lstrcmp( szBuffer, STRING_DEF_MEMPAKFILE ))
				SaveRegString( STRING_REG_FOLDERS, 0, STRING_REG_MEMPAKDIR, NULL );
			else
				SaveRegString( STRING_REG_FOLDERS, 0, STRING_REG_MEMPAKDIR, szBuffer );

			dwSize = sizeof(szBuffer);
			if( IsDlgButtonChecked( hDlg, IDC_GBROM_ABS ) == BST_CHECKED )
			{
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_ABS_EDIT ), WM_GETTEXT, sizeof(szApplication), (LPARAM)szApplication );
				GetFullPathName( szApplication, sizeof(szBuffer), szBuffer, &pcSlash );
			}
			else
				SendMessage( GetDlgItem( hDlg, IDC_GBROM_REL_EDIT ), WM_GETTEXT, dwSize, (LPARAM)szBuffer );
			pcSlash = n_strrchr( szBuffer, '\\' );
			if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';

			if( !lstrcmp( szBuffer, STRING_DEF_GBROMFILE ))
				SaveRegString( STRING_REG_FOLDERS, 0, STRING_REG_GBROMDIR, NULL );
			else
				SaveRegString( STRING_REG_FOLDERS, 0, STRING_REG_GBROMDIR, szBuffer );

			if( !IsDlgButtonChecked( hDlg, IDC_GBSAVE_SAME ) == BST_CHECKED )
			{
				dwSize = sizeof(szBuffer);
				if( IsDlgButtonChecked( hDlg, IDC_GBSAVE_ABS ) == BST_CHECKED )
				{
					SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_ABS_EDIT ), WM_GETTEXT, sizeof(szApplication), (LPARAM)szApplication );
					GetFullPathName( szApplication, sizeof(szBuffer), szBuffer, &pcSlash );
				}
				else
					SendMessage( GetDlgItem( hDlg, IDC_GBSAVE_REL_EDIT ), WM_GETTEXT, dwSize, (LPARAM)szBuffer );
			}

			pcSlash = n_strrchr( szBuffer, '\\' );
			if( pcSlash && ( pcSlash[1] == '\0' )) *pcSlash = '\0';

			if( !lstrcmp( szBuffer, STRING_DEF_GBROMSAVE ))
				SaveRegString( STRING_REG_FOLDERS, 0, STRING_REG_GBROMSDIR, NULL );
			else
				SaveRegString( STRING_REG_FOLDERS, 0, STRING_REG_GBROMSDIR, szBuffer );

			EndDialog( hDlg, TRUE );
			break;
		case IDCANCEL:
			EndDialog( hDlg, FALSE );
			break;
		default:
			return FALSE;
		}
		break;

	default:
		return FALSE; //false means the msg dint got processed
	}
	return TRUE; //msg got processed	
}



///////////////////////////////////////////////////////////////////////////////


BOOL CALLBACK EnumGetKeyDesc( LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef )
{
	LPTSTR curPos = *(LPTSTR*)pvRef;
	LONG emptySpots = lpddoi->dwOfs - *(LPLONG)curPos;
	if( emptySpots > 0 )
	{
		ZeroMemory( curPos, emptySpots * sizeof(TCHAR));
		curPos += emptySpots;
	}
	lstrcpy( curPos, lpddoi->tszName );
	curPos += lstrlen( curPos ) + 1;
	*(LPLONG)curPos = lpddoi->dwOfs + 1;
	*(LPTSTR*)pvRef = curPos;
	return DIENUM_CONTINUE;
}

bool GetButtonID( LPDWORD ButtonID, CONST BYTE bIndex, CONST BYTE bButtonSet )
{
	LPDWORD ButtonTable = NULL;
	int nEntries = 0;

							//	ID of PushButton  ID of TextWindow	  place in Button-structure
	DWORD Controls[][3] = {	{ IDC_DRIGHT		, IDT_DRIGHT		, PF_DPADR },		// Controls
							{ IDC_DLEFT			, IDT_DLEFT			, PF_DPADL },
							{ IDC_DDOWN			, IDT_DDOWN			, PF_DPADD },
							{ IDC_DUP			, IDT_DUP			, PF_DPADU },
							{ IDC_SBUTTON		, IDT_SBUTTON		, PF_START },
							{ IDC_ZTRIGGER		, IDT_ZTRIGGER		, PF_TRIGGERZ },
							{ IDC_BBUTTON		, IDT_BBUTTON		, PF_BBUTTON },
							{ IDC_ABUTTON		, IDT_ABUTTON		, PF_ABUTTON },
							{ IDC_CRIGHT		, IDT_CRIGHT		, PF_CBUTTONR },
							{ IDC_CLEFT			, IDT_CLEFT			, PF_CBUTTONL },
							{ IDC_CDOWN			, IDT_CDOWN			, PF_CBUTTOND },
							{ IDC_CUP			, IDT_CUP			, PF_CBUTTONU },
							{ IDC_RIGHTTRIGGER	, IDT_RIGHTTRIGGER	, PF_TRIGGERR },
							{ IDC_LEFTTRIGGER	, IDT_LEFTTRIGGER	, PF_TRIGGERL },
							{ IDC_ARIGHT		, IDT_ARIGHT		, PF_APADR },
							{ IDC_ALEFT			, IDT_ALEFT			, PF_APADL },
							{ IDC_ADOWN			, IDT_ADOWN			, PF_APADD },
							{ IDC_AUP			, IDT_AUP			, PF_APADU }	};

	DWORD ShortCuts[][3]= {	{ IDC_LOCKMOUSE			, IDT_LOCKMOUSE			, FIELD_OFFSET( SHORTCUTS, bMouseLock ) },

							{ IDC_SETNOPAK_P1		, IDT_SETNOPAK_P1		, FIELD_OFFSET( SHORTCUTS, Player[0].bNoPak ) },
							{ IDC_SETMEMPAK_P1		, IDT_SETMEMPAK_P1		, FIELD_OFFSET( SHORTCUTS, Player[0].bMemPak ) },
							{ IDC_SETRUMBLEPAK_P1	, IDT_SETRUMBLEPAK_P1	, FIELD_OFFSET( SHORTCUTS, Player[0].bRumblePak ) },
							{ IDC_SETTRANSFERPAK_P1	, IDT_SETTRANSFERPAK_P1	, FIELD_OFFSET( SHORTCUTS, Player[0].bTransferPak ) },
							{ IDC_SETADAPTOIDPAK_P1	, IDT_SETADAPTOIDPAK_P1	, FIELD_OFFSET( SHORTCUTS, Player[0].bAdaptoidPak ) },
							{ IDC_SWMEMRUMBLE_P1	, IDT_SWMEMRUMBLE_P1	, FIELD_OFFSET( SHORTCUTS, Player[0].bSwMemRumble ) },
							{ IDC_SWMEMADAPTOID_P1	, IDT_SWMEMADAPTOID_P1	, FIELD_OFFSET( SHORTCUTS, Player[0].bSwMemAdaptoid ) },

							{ IDC_SETNOPAK_P2		, IDT_SETNOPAK_P2		, FIELD_OFFSET( SHORTCUTS, Player[1].bNoPak ) },
							{ IDC_SETMEMPAK_P2		, IDT_SETMEMPAK_P2		, FIELD_OFFSET( SHORTCUTS, Player[1].bMemPak ) },
							{ IDC_SETRUMBLEPAK_P2	, IDT_SETRUMBLEPAK_P2	, FIELD_OFFSET( SHORTCUTS, Player[1].bRumblePak ) },
							{ IDC_SETTRANSFERPAK_P2	, IDT_SETTRANSFERPAK_P2	, FIELD_OFFSET( SHORTCUTS, Player[1].bTransferPak ) },
							{ IDC_SETADAPTOIDPAK_P2	, IDT_SETADAPTOIDPAK_P2	, FIELD_OFFSET( SHORTCUTS, Player[1].bAdaptoidPak ) },
							{ IDC_SWMEMRUMBLE_P2	, IDT_SWMEMRUMBLE_P2	, FIELD_OFFSET( SHORTCUTS, Player[1].bSwMemRumble ) },
							{ IDC_SWMEMADAPTOID_P2	, IDT_SWMEMADAPTOID_P2	, FIELD_OFFSET( SHORTCUTS, Player[1].bSwMemAdaptoid ) },

							{ IDC_SETNOPAK_P3		, IDT_SETNOPAK_P3		, FIELD_OFFSET( SHORTCUTS, Player[2].bNoPak ) },
							{ IDC_SETMEMPAK_P3		, IDT_SETMEMPAK_P3		, FIELD_OFFSET( SHORTCUTS, Player[2].bMemPak ) },
							{ IDC_SETRUMBLEPAK_P3	, IDT_SETRUMBLEPAK_P3	, FIELD_OFFSET( SHORTCUTS, Player[2].bRumblePak ) },
							{ IDC_SETTRANSFERPAK_P3	, IDT_SETTRANSFERPAK_P3	, FIELD_OFFSET( SHORTCUTS, Player[2].bTransferPak ) },
							{ IDC_SETADAPTOIDPAK_P3	, IDT_SETADAPTOIDPAK_P3	, FIELD_OFFSET( SHORTCUTS, Player[2].bAdaptoidPak ) },
							{ IDC_SWMEMRUMBLE_P3	, IDT_SWMEMRUMBLE_P3	, FIELD_OFFSET( SHORTCUTS, Player[2].bSwMemRumble ) },
							{ IDC_SWMEMADAPTOID_P3	, IDT_SWMEMADAPTOID_P3	, FIELD_OFFSET( SHORTCUTS, Player[2].bSwMemAdaptoid ) },

							{ IDC_SETNOPAK_P4		, IDT_SETNOPAK_P4		, FIELD_OFFSET( SHORTCUTS, Player[3].bNoPak ) },
							{ IDC_SETMEMPAK_P4		, IDT_SETMEMPAK_P4		, FIELD_OFFSET( SHORTCUTS, Player[3].bMemPak ) },
							{ IDC_SETRUMBLEPAK_P4	, IDT_SETRUMBLEPAK_P4	, FIELD_OFFSET( SHORTCUTS, Player[3].bRumblePak ) },
							{ IDC_SETTRANSFERPAK_P4	, IDT_SETTRANSFERPAK_P4	, FIELD_OFFSET( SHORTCUTS, Player[3].bTransferPak ) },
							{ IDC_SETADAPTOIDPAK_P4	, IDT_SETADAPTOIDPAK_P4	, FIELD_OFFSET( SHORTCUTS, Player[3].bAdaptoidPak ) },
							{ IDC_SWMEMRUMBLE_P4	, IDT_SWMEMRUMBLE_P4	, FIELD_OFFSET( SHORTCUTS, Player[3].bSwMemRumble ) },
							{ IDC_SWMEMADAPTOID_P4	, IDT_SWMEMADAPTOID_P4	, FIELD_OFFSET( SHORTCUTS, Player[3].bSwMemAdaptoid ) }	};


	if( bButtonSet == BSET_CONTROLS )
	{
		ButtonTable = (LPDWORD)Controls;
		nEntries = ARRAYSIZE( Controls );
	}

	if( bButtonSet == BSET_SHORTCUTS )
	{
		ButtonTable = (LPDWORD)ShortCuts;
		nEntries = ARRAYSIZE( ShortCuts );
	}

	bool bReturn = false;

	if( ButtonTable != NULL )
	{
		nEntries *= 3;
		for( int i = 0; i < nEntries; i+=3 )
		{
			if( ButtonTable[i+bIndex] == ButtonID[bIndex] )
			{
				ButtonID[0] = ButtonTable[i+0];
				ButtonID[1] = ButtonTable[i+1];
				ButtonID[2] = ButtonTable[i+2];

				bReturn = true;
				break;
			}
		}
	}

	return bReturn;
}

bool GetButtonText( CONST BUTTON btnButton, LPTSTR Buffer, CONST LPTSTR KeyDescription )
{
	LPTSTR Device[] ={	TEXT( "Unassigned" ),
						TEXT( "GamePad: " ),
						TEXT( "Keyboard: " ), 
						TEXT( "Mouse: " ) };
	LPTSTR Gamepad[] ={ TEXT( "X-Axis" ),
						TEXT( "Y-Axis" ),
						TEXT( "Z-Axis" ),
						TEXT( "X-Rotation" ),
						TEXT( "Y-Rotation" ),
						TEXT( "Z-Rotation" ),
						TEXT( "Slider 1" ),
						TEXT( "Slider 2" ),
						TEXT( "PoV 1" ),
						TEXT( "PoV 2" ),
						TEXT( "PoV 3" ),
						TEXT( "PoV 4" ),
						TEXT( "Button " ) };
	LPTSTR Mouse[] = {	TEXT( "X-Axis" ),
						TEXT( "Y-Axis" ),
						TEXT( "Wheel" ),
						TEXT( "Button " ) };
	LPTSTR AxeID[] = {	TEXT( " +" ),
						TEXT( " -" ),
						TEXT( " /\\" ),
						TEXT( " >" ),
						TEXT( " \\/" ),
						TEXT( " <" ) };
	LPTSTR Text[3];
	TCHAR Btn[6];
	int i;
	

	switch ( btnButton.bType )
	{	
	case DT_JOYBUTTON:
		Text[0] = Device[1];
		Text[1] = Gamepad[12];
		Text[2] = Btn;
		wsprintf( Btn, TEXT( "%02u" ), btnButton.bOffset );
		break;
	case DT_JOYAXE:
	case DT_JOYSLIDER:
		Text[0] = Device[1];
		Text[1] = Gamepad[btnButton.bOffset];
		Text[2] = AxeID[btnButton.bAxisID];
		break;
	case DT_JOYPOV:
		Text[0] = Device[1];
		Text[1] = Gamepad[btnButton.bOffset];
		Text[2] = AxeID[2 + btnButton.bAxisID];
		break;

	case DT_KEYBUTTON:
		Text[0] = Device[2];	
		Text[1] = KeyDescription;
		for( i = 0 ; i < btnButton.bOffset; ++i )
		{
			Text[1] += lstrlen( Text[1] ) + 1;
		}
		Text[2] = TEXT( "" );
		break;

	case DT_MOUSEBUTTON:
		Text[0] = Device[3];
		Text[1] = Mouse[3];
		Text[2] = Btn;
		wsprintf( Btn, TEXT( "%02u" ), btnButton.bOffset );
		break;

	case DT_MOUSEAXE:
		Text[0] = Device[3];
		Text[1] = Mouse[btnButton.bOffset];
		Text[2] = AxeID[btnButton.bAxisID];
		break;

	case DT_UNASSIGNED:
	default:
		Text[0] = Device[0];
		Text[1] = Text[2] = TEXT( "" );
	}

	wsprintf( Buffer, TEXT( "%s%s%s" ), Text[0], Text[1], Text[2] );
	return ( Text[0] != Device[0] );
}


DWORD ScanKeyBoard( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPDWORD Value, LPBUTTON pButton )
{
	HRESULT hr;
	BYTE cKeys[256];

	hr = lpDirectInputDevice->GetDeviceState( sizeof( cKeys ), (LPVOID)&cKeys );
	if ( FAILED(hr) )
	{
			lpDirectInputDevice->Acquire();
			return FALSE;
	}

	INT iGotKey = FALSE;
	int i = 0;

	for( i = 0; i < ARRAYSIZE( cKeys ); ++i )
	{
		if (( cKeys[i] & 0x80 ) )
		{
			if( i == DIK_ESCAPE )
				iGotKey = SC_SCANESCAPE;
			else
			{
				iGotKey = SC_SCANSUCCEED;
				pButton->bType = (BYTE)DT_KEYBUTTON;
				pButton->bAxisID = (BYTE)0;
				pButton->bOffset = (BYTE)i;
				pButton->bFlags = (BYTE)0;
			}
		}
	}
	return iGotKey;
}

DWORD ScanMouse( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPDWORD Value, LPBUTTON pButton )
{
	static BYTE rgbInitButtons[8];
	static bool bFirstScan = true;
	DIMOUSESTATE2 dm_Current;
	HRESULT hr;

	if ( *Value == 0 )
		bFirstScan = true;

	hr = lpDirectInputDevice->GetDeviceState( sizeof(DIMOUSESTATE2), &dm_Current );
	if ( FAILED(hr) )
	{
		lpDirectInputDevice->Acquire();
		return FALSE;
	}

	
	if ( bFirstScan )
	{
		CopyMemory( rgbInitButtons, dm_Current.rgbButtons, sizeof(rgbInitButtons));
		bFirstScan = false;
		lpDirectInputDevice->GetDeviceState( sizeof(DIMOUSESTATE2), &dm_Current );
	}

	INT iGotKey = FALSE;
	int i = 0;
	BYTE bAxeDirection = 0;
	LONG Mouse[] ={		FIELD_OFFSET( DIMOUSESTATE2, lX ) / sizeof(LONG),
						FIELD_OFFSET( DIMOUSESTATE2, lY ) / sizeof(LONG),
						FIELD_OFFSET( DIMOUSESTATE2, lZ ) / sizeof(LONG) };
	
	LONG lValue;

	for( i = 0; i < ARRAYSIZE(Mouse); ++i )
	{
		lValue =  ((LONG*)&dm_Current)[Mouse[i]];
		
		if( lValue > 30 )
		{
			iGotKey = SC_SCANSUCCEED;
			bAxeDirection = AI_AXE_P;
		}
		if( lValue < -30 )
		{
			iGotKey = SC_SCANSUCCEED;
			bAxeDirection = AI_AXE_N;
		}
		if( iGotKey ) 
			break;
	}

	if( iGotKey == SC_SCANSUCCEED )
	{
		pButton->bType = (BYTE)DT_MOUSEAXE;
		pButton->bAxisID = (BYTE)bAxeDirection;
		pButton->bOffset = (BYTE)Mouse[i];
		pButton->bFlags = (BYTE)0;
	}
	else
	{
		for( i = 0; i < ARRAYSIZE( dm_Current.rgbButtons ); ++i )
		{
			if(( dm_Current.rgbButtons[i] != rgbInitButtons[i] ) && ( dm_Current.rgbButtons[i] & 0x80 ))
			{
				iGotKey = SC_SCANSUCCEED;
				pButton->bType = (BYTE)DT_MOUSEBUTTON;
				pButton->bAxisID = (BYTE)0;
				pButton->bOffset = (BYTE)i;
				pButton->bFlags = (BYTE)0;
				break;
			}
		}
	}
	CopyMemory( rgbInitButtons, dm_Current.rgbButtons, sizeof(rgbInitButtons));

	return iGotKey;
}

DWORD ScanGamePad ( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPDWORD Value, LPBUTTON pButton )
{
	static DIJOYSTATE dj_Initial;
	static bool bFirstScan = true;
	DIJOYSTATE dj_Current;
	HRESULT hr;

	if ( *Value == 0 )
		bFirstScan = true;

	hr = lpDirectInputDevice->GetDeviceState( sizeof(DIJOYSTATE), &dj_Current );
	if ( FAILED(hr) )
	{
			lpDirectInputDevice->Acquire();
			return FALSE;
	}

	if ( bFirstScan )
	{
		dj_Initial = dj_Current;
		bFirstScan = false;
		lpDirectInputDevice->GetDeviceState( sizeof(DIJOYSTATE), &dj_Current );
	}

	LONG lAxePos = ZEROVALUE + ( RANGERELATIVE * CONFIGTHRESHOLD / 100 );
	LONG lAxeNeg = ZEROVALUE - ( RANGERELATIVE * CONFIGTHRESHOLD / 100 );
	LONG lValue;

	INT iGotKey = FALSE;
	BYTE bAxeDirection = 0;

	int JoyPad[][2] ={	{ FIELD_OFFSET( DIJOYSTATE, lX ) / sizeof(LONG)	, DT_JOYAXE },
						{ FIELD_OFFSET( DIJOYSTATE, lY ) / sizeof(LONG)	, DT_JOYAXE },
						{ FIELD_OFFSET( DIJOYSTATE, lZ ) / sizeof(LONG)	, DT_JOYAXE },
						{ FIELD_OFFSET( DIJOYSTATE, lRx ) / sizeof(LONG)	, DT_JOYAXE },
						{ FIELD_OFFSET( DIJOYSTATE, lRy ) / sizeof(LONG)	, DT_JOYAXE },
						{ FIELD_OFFSET( DIJOYSTATE, lRz ) / sizeof(LONG)	, DT_JOYAXE },
						{ FIELD_OFFSET( DIJOYSTATE, rglSlider[0] ) / sizeof(LONG)	, DT_JOYSLIDER },
						{ FIELD_OFFSET( DIJOYSTATE, rglSlider[1] ) / sizeof(LONG)	, DT_JOYSLIDER },
						{ FIELD_OFFSET( DIJOYSTATE, rgdwPOV[0] ) / sizeof(LONG)	, DT_JOYPOV },
						{ FIELD_OFFSET( DIJOYSTATE, rgdwPOV[1] ) / sizeof(LONG)	, DT_JOYPOV },
						{ FIELD_OFFSET( DIJOYSTATE, rgdwPOV[2] ) / sizeof(LONG)	, DT_JOYPOV },
						{ FIELD_OFFSET( DIJOYSTATE, rgdwPOV[3] ) / sizeof(LONG)	, DT_JOYPOV }	};
	
	for( int i = 0; i < ARRAYSIZE( JoyPad ); ++i )
	{
		lValue =  ((LONG*)&dj_Current)[JoyPad[i][0]];
		if( lValue != ((LONG*)&dj_Initial)[JoyPad[i][0]] )
		{
			if(( JoyPad[i][1] == DT_JOYAXE ) || ( JoyPad[i][1] == DT_JOYSLIDER ))
			{
				if( lValue > lAxePos )
				{
					iGotKey = SC_SCANSUCCEED;
					bAxeDirection = AI_AXE_P;
					break;
				}
				if( lValue < lAxeNeg )
				{
					iGotKey = SC_SCANSUCCEED;
					bAxeDirection = AI_AXE_N;
					break;
				}
			}
			if( JoyPad[i][1] == DT_JOYPOV && LOWORD( lValue ) != 0xFFFF )
			{
				iGotKey = SC_SCANSUCCEED;
				if (( lValue > 31500 ) || ( lValue < 4500 ))
					bAxeDirection = AI_POV_UP;
				if (( lValue > 4500 ) && ( lValue < 13500 ))
					bAxeDirection = AI_POV_RIGHT;
				if (( lValue > 13500 ) && ( lValue < 22500 ))
					bAxeDirection = AI_POV_DOWN;
				if (( lValue > 22500 ) && ( lValue < 31500 ))
					bAxeDirection = AI_POV_LEFT;
				break;
			}
		}
	}

	if( iGotKey == SC_SCANSUCCEED )
	{
		pButton->bType = (BYTE)JoyPad[i][1];
		pButton->bAxisID = (BYTE)bAxeDirection;
		pButton->bOffset = (BYTE)JoyPad[i][0];
		pButton->bFlags = (BYTE)0;
	}
	else
	{
		for( i = 0; i < ARRAYSIZE( dj_Current.rgbButtons ); ++i )
		{
			if (( dj_Current.rgbButtons[i] & 0x80 ) && ( dj_Current.rgbButtons[i] != dj_Initial.rgbButtons[i] ))
			{
				iGotKey = SC_SCANSUCCEED;
				pButton->bType = (BYTE)DT_JOYBUTTON;
				pButton->bAxisID = (BYTE)0;
				pButton->bOffset = (BYTE)i;
				pButton->bFlags = (BYTE)0;
				break;
			}
		}
	}
	dj_Initial = dj_Current;

	return iGotKey;
}

DWORD ScanDevices( LPDIRECTINPUTDEVICE8 *apDirectInputDevices, LPDWORD Value, LPBUTTON pButton )
{
	int i;
	for( i = 0; i <= 2; i++)
	{
		if( apDirectInputDevices[i] )
		{
			if( FAILED(apDirectInputDevices[i]->Poll()))
				apDirectInputDevices[i]->Acquire();
		}
	}

	if( *Value == 0 )
	{
		for(i = 0; i <= 2; i++)		
		{
			if( apDirectInputDevices[i] )
				apDirectInputDevices[i]->Poll();
		}
	}

	DWORD dwReturn = FALSE;
	
	if( !dwReturn && apDirectInputDevices[DID_KEYBOARD] )
		dwReturn = ScanKeyBoard( apDirectInputDevices[DID_KEYBOARD], Value, pButton );

	if( !dwReturn && apDirectInputDevices[DID_MOUSE] )
		dwReturn = ScanMouse( apDirectInputDevices[DID_MOUSE], Value, pButton );
	
	if( !dwReturn && apDirectInputDevices[DID_GAMEPAD] )
		dwReturn = ScanGamePad( apDirectInputDevices[DID_GAMEPAD], Value, pButton );
	
	return dwReturn;
}

void SetControllerDefaults( LPCONTROLLER pcController )
{
	freeControllerStruct( pcController );
	ZeroMemory( pcController, sizeof(CONTROLLER) );

	pcController->fRawData =			true;
	pcController->fRealN64Range =		true;
	pcController->bRapidFireEnabled =	false;
	pcController->bRapidFireRate =		3; // Set default rapid fire rate here
	pcController->bStickRange =			DEFAULT_STICKRANGE;
	pcController->bPadDeadZone =		DEFAULT_DEADZONE;
	pcController->bRumbleTyp =			DEFAULT_RUMBLETYP;
	pcController->bRumbleStrength =		DEFAULT_RUMBLESTRENGTH;
	pcController->wMouseSensitivity =	DEFAULT_MOUSESENSIVITY;
	pcController->PakType =				DEFAULT_PAKTYPE;
}

void DeleteControllerSettings( int indexController )
{
	if( !g_ivConfig )
		return;

	SetControllerDefaults( &g_ivConfig->Controllers[indexController] );
	g_ivConfig->Devices[indexController].bProductCounter =		-1;
	g_ivConfig->Devices[indexController].szProductName[0] =		'\0';
	
	if( indexController == 0 )
		g_ivConfig->Controllers[indexController].fPlugged = true;
	return;
}

void SetModifier( LPCONTROLLER pcController )
{
	for( int i = 0; i < pcController->nModifiers; i++ )
	{
		if( pcController->pModifiers[i].fSHandling && pcController->pModifiers[i].fStatus )
		{
			switch( pcController->pModifiers[i].bTyp )
			{
			/*case MDT_MOVE:
				break;
			case MDT_MACRO:
				break;*/
			case MDT_CONFIG:
			{
				MODSPEC_CONFIG args;
				args.dwValue = pcController->pModifiers[i].dwSpecific;
				if( args.fChangeAnalogConfig )
				{
					BYTE bConfig = (BYTE)args.fAnalogStickMode;
					if( bConfig < PF_AXESETS )
						pcController->bAxisSet = bConfig;
					else
					{
						if( pcController->bAxisSet == PF_AXESETS-1 )
							pcController->bAxisSet = 0;
						else
							++pcController->bAxisSet;
					}
				}
				if( args.fChangeMouseXAxis )
					pcController->fAbsoluteMouseX = !pcController->fAbsoluteMouseX;
				if( args.fChangeMouseYAxis )
					pcController->fAbsoluteMouseY = !pcController->fAbsoluteMouseY;

				if( args.fChangeKeyBoardXAxis )
					pcController->fKeyAbsoluteX = !pcController->fKeyAbsoluteX;
				if( args.fChangeKeyBoardYAxis )
					pcController->fKeyAbsoluteY = !pcController->fKeyAbsoluteY;
			}
				break;

			/*case MDT_NONE:
				break;*/
			}
		}
	}
}

void GetCurrentConfiguration()
{
	g_ivConfig->bAutoConfig = bDebug;
	EnterCriticalSection( &g_resController );

	LPCONTROLLER pcController;
	for( int i = 0; i < 4; i++ )
	{
		pcController = &g_ivConfig->Controllers[i];
		CopyMemory( pcController, &g_pcControllers[i], sizeof(CONTROLLER));

		if( pcController->nModifiers > 0 )
		{
			pcController->pModifiers = (LPMODIFIER)P_malloc( sizeof(MODIFIER) * pcController->nModifiers );
			CopyMemory( pcController->pModifiers, g_pcControllers[i].pModifiers, sizeof(MODIFIER) * pcController->nModifiers );
			SetModifier( pcController );
		}
		else
			pcController->pModifiers = NULL;
			
		pcController->pPakData = NULL;

		for( int iDevice = 0; iDevice < ARRAYSIZE(g_devList) && g_devList[iDevice].dwDevType; ++iDevice )
		{
			if(	( g_devList[iDevice].guidInstance == pcController->guidPadDevice ) &&
				( g_devList[iDevice].dwDevType == pcController->dwDevType ))
			{
				g_ivConfig->Devices[i].bProductCounter = g_devList[iDevice].bProductCounter;
				lstrcpy( g_ivConfig->Devices[i].szProductName, g_devList[iDevice].szProductName );
				break;
			}
		}
	}

	LeaveCriticalSection( &g_resController );
	return;
}

void UpdateControllerStructures()
{
	bDebug = g_ivConfig->bAutoConfig;
	EnterCriticalSection( &g_resController );

	LPCONTROLLER pcController;
	for( int i = 0; i < 4; i++ )
	{
		pcController = &g_ivConfig->Controllers[i];

		if( pcController->fPlugged )
		{
			SaveControllerPak( i );
			CloseControllerPak( i );
			freeControllerStruct( &g_pcControllers[i] );
			
			CopyMemory( &g_pcControllers[i], pcController, sizeof(CONTROLLER));
			g_pcControllers[i].pPakData = NULL;
			g_pcControllers[i].pModifiers = NULL;

			if( g_pcControllers[i].nModifiers > 0 )
			{
				g_pcControllers[i].pModifiers = (LPMODIFIER)P_malloc( sizeof(MODIFIER) * g_pcControllers[i].nModifiers );
				CopyMemory( g_pcControllers[i].pModifiers, pcController->pModifiers, sizeof(MODIFIER) * g_pcControllers[i].nModifiers );
				SetModifier( &g_pcControllers[i] );
			}
			

			int iDevice = FindDeviceinList( g_ivConfig->Devices[i].szProductName, g_ivConfig->Devices[i].bProductCounter, true );
			if( iDevice != -1 )
			{
				g_pcControllers[i].guidPadDevice = g_devList[iDevice].guidInstance;
				g_pcControllers[i].dwDevType = g_devList[iDevice].dwDevType;
			}
			else
			{
				ZeroMemory( &g_pcControllers[i].guidPadDevice, sizeof(GUID));
				g_pcControllers[i].dwDevType = 0;
			}


			g_pcControllers[i].fPakCRCError = false;
			g_pcControllers[i].fPakInitialized = false;
		}
		else
		{
			SaveControllerPak( i );
			CloseControllerPak( i );
			freeControllerStruct( &g_pcControllers[i] );
			ZeroMemory( &g_pcControllers[i], sizeof(CONTROLLER) );	
		}
	}
	LeaveCriticalSection( &g_resController );
	return;
}