#ifndef _GBCART_H_
#define _GBCART_H_

#include <windows.h>
#include <time.h>

typedef struct _gbCartRTC {
  int mapperSeconds;
  int mapperMinutes;
  int mapperHours;
  int mapperDays;
  int mapperControl;
  int mapperLSeconds;
  int mapperLMinutes;
  int mapperLHours;
  int mapperLDays;
  int mapperLControl;
  time_t mapperLastTime;
} gbCartRTC, *lpgbCartRTC;

typedef struct _GBCART
{
	int iCurrentRomBankNo;
	int iCurrentRamBankNo;
	int iCartType;
	bool bHasRam;
	bool bHasBattery;
	bool bHasTimer;
	bool bHasRumble;
	bool bRamEnableState;
	int iNumRomBanks;
	int iNumRamBanks;
	char TimerData[5];
	char LatchedTimerData[5];
	time_t timerLastUpdate;
	bool TimerDataLatched;
	char RamData[0x10 * 0x2000];
	char RamDataSafetyPadding[64];
	char RomData[0x200 * 0x4000];
	char RomDataSafetyPadding[64];
} GBCART, *LPGBCART;

bool LoadCart(LPGBCART Cart, LPCTSTR RomFile, LPCTSTR RamFile, LPCTSTR TdfFile);
bool ReadCart(LPGBCART Cart, DWORD dwAddress, BYTE *Data);
bool WriteCart(LPGBCART Cart, DWORD dwAddress, BYTE *Data);
bool SaveCart(LPGBCART Cart, LPTSTR SaveFile, LPTSTR TimeFile);
bool UnloadCart(LPGBCART Cart);

#endif // #ifndef _GBCART_H_
/*
iCartType values:
0 = no MBC
1 = MBC1
2 = MBC2
3 = MMMO1
4 = MBC3
5 = MBC5
6 = Pocket Camera
7 = TAMA 5
8 = HuC 3
9 = HuC 1
Note, that 6 and up are not implemented yet.
*/