/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <windows.h>
#include <dinput.h>
#include <shlobj.h>
#include "commonIncludes.h"
#include "NRage PluginV2.h"
#include "DataBufferClass.h"
#include "PakIO.h"
#include "Interface.h"
#include "FileAcces.h"

#ifndef IDR_PROFILE_DEFAULT1
#define IDR_PROFILE_DEFAULT1 -1
#endif
#ifndef IDR_PROFILE_DEFAULT2
#define IDR_PROFILE_DEFAULT2 -1
#endif
#ifndef IDR_PROFILE_DEFAULT3
#define IDR_PROFILE_DEFAULT3 -1
#endif
#ifndef IDR_PROFILE_DEFAULT4
#define IDR_PROFILE_DEFAULT4 -1
#endif

bool CheckFileExists( CONST LPTSTR FileName )
{
	WIN32_FIND_DATA FindFile;
	bool Succed = false;

	HANDLE hFindFile = FindFirstFile( FileName, &FindFile );
	if( hFindFile != INVALID_HANDLE_VALUE )
	{
		FindClose( hFindFile );
		Succed = true;
	}
	return Succed;
}

bool CreateMultipleDirs( CONST LPTSTR pszDirName )
{
	TCHAR szDirectory[MAX_PATH+1];
	LPTSTR pcSlash;
	lstrcpy( szDirectory, pszDirName );
	pcSlash = n_strrchr( szDirectory, '\\' );
	if( pcSlash )
	{
		*pcSlash = '\0';

		if( !CheckFileExists( szDirectory ))
			CreateMultipleDirs( szDirectory );

		*pcSlash = '\\';

		if( !CheckFileExists( szDirectory ))
		{
			if(	CreateDirectory( szDirectory , NULL ))
				return true;
		}
	}
	else
	{
		if(	CreateDirectory( szDirectory , NULL ))
			return true;
	}
	return false;
}

LONG OpenRegistryKey( CONST LPTSTR pszSubKey, CONST int nSubNumber, PHKEY phKey, CONST bool fCreate )
{
	TCHAR szRegSubKey[MAX_PATH+1] = TEXT( STRING_REG_BASEKEY );
	LPTSTR pszEnd = &szRegSubKey[lstrlen(szRegSubKey)];

	if( pszSubKey )
	{
		if( nSubNumber > 0 )
			wsprintf( pszEnd, TEXT( "\\%s %i" ), pszSubKey, nSubNumber );
		else
			wsprintf( pszEnd, TEXT( "\\%s" ), pszSubKey );
	}

	if( fCreate )
	{
		DWORD dwDisposition;
		return RegCreateKeyEx(	HKEY_CURRENT_USER, szRegSubKey, 0, NULL, REG_OPTION_NON_VOLATILE,
								KEY_WRITE, NULL, phKey, &dwDisposition );
	}
	else
		return RegOpenKeyEx ( HKEY_CURRENT_USER, szRegSubKey, 0, KEY_QUERY_VALUE, phKey );
}

bool LoadRegValue( CONST LPTSTR pszSubKey, CONST int nSubNumber, CONST LPTSTR pszKey, LPVOID pData, LPDWORD pdwDataSize )
{
	HKEY hKey;
	bool Succed = false;

	if( OpenRegistryKey( pszSubKey, nSubNumber, &hKey, false ) == ERROR_SUCCESS )
	{
		Succed = ( RegQueryValueEx( hKey, pszKey, NULL, NULL, (UCHAR*)pData, pdwDataSize )== ERROR_SUCCESS );
		
		RegCloseKey( hKey );
	}
		
	if( !Succed )
		*pdwDataSize = 0; //tells that no Byte got read

	return Succed;
}

bool SaveRegString( CONST LPTSTR szSubKey, CONST int nSubNumber, CONST LPTSTR pszStringName, CONST LPTSTR pszString )
{
	HKEY hKey;
	bool Succed = false;
	
	if( OpenRegistryKey( szSubKey, nSubNumber, &hKey, true ) == ERROR_SUCCESS )
	{
		if( pszString )
			Succed = ( RegSetValueEx( hKey, pszStringName, 0, REG_SZ, (CONST BYTE*)pszString, (lstrlen(pszString) + 1) * sizeof(TCHAR) ) == ERROR_SUCCESS );
		else
			Succed = ( RegDeleteValue( hKey, pszStringName ) == ERROR_SUCCESS );
		RegCloseKey ( hKey );
	}

	return Succed;
}

DWORD ParseLine( LPSTR pszLine )
{
	DWORD dwReturn = PL_NOHIT;
	DWORD dwChar = 0;
	DWORD dwValue = 0;

	if( pszLine[0] == '[' )
	{
		while( pszLine[dwChar] != ']' && pszLine[dwChar] != '\0' )
			++dwChar;
		if( pszLine[dwChar] == ']' )
		{
			MoveMemory( pszLine, pszLine+1, (dwChar-1) * sizeof(pszLine[0]) );
			pszLine[dwChar] = '\0';
			return PL_KEYNAME;
		}
		else
			return PL_NOHIT;
	}

	while( pszLine[dwChar] != '=' && pszLine[dwChar] != '\0' )
	{
		++dwChar;
		dwValue += pszLine[dwChar] * dwChar;
	}
	if( pszLine[dwChar] != '=' ) // no = sign
	{
		switch( dwValue )
		{
		case CHK_PROFILEVERSION20:
			if( !lstrcmpA( pszLine, "@" STRING_PROFILEVERSION ))
			{
				lstrcpyA( pszLine, "2.0" );
				dwReturn = PL_VERSIONSTRING;
			}
			break;
		}
	}
	else
	{
		pszLine[dwChar] = '\0';

		switch( dwValue )
		{
		case CHK_CONTROLS:
			if( !lstrcmpA( pszLine, STRING_REG_CONTROLS ))
				dwReturn = PL_CONTROLS;
			break;

		case CHK_SETTINGS:
			if( !lstrcmpA( pszLine, STRING_REG_SETTINGS ))
				dwReturn = PL_SETTINGS;
			break;

		case CHK_DEVICE:
			if( !lstrcmpA( pszLine, STRING_REG_DEVICE ))
				dwReturn = PL_DEVICE;
			break;

		case CHK_RUMBLE:
			if( !lstrcmpA( pszLine, STRING_REG_RUMBLE ))
				dwReturn = PL_RUMBLE;
			break;

		case CHK_MODIFIERS:
			if( !lstrcmpA( pszLine, STRING_REG_MODIFIERS ))
				dwReturn = PL_MODIFIERS;
			break;

		case CHK_GAMEDEVICE:
			if( !lstrcmpA( pszLine, STRING_REG_GAMEDEVICE ))
				dwReturn = PL_GAMEDEVICE;
			break;

		case CHK_GAMEDEVICENR:
			if( !lstrcmpA( pszLine, STRING_REG_GAMEDEVICENR ))
				dwReturn = PL_GAMEDEVICENR;
			break;

		case CHK_MEMPAKFILE:
			if( !lstrcmpA( pszLine, STRING_REG_MEMPAKFILE ))
				dwReturn = PL_MEMPAKFILE;
			break;

		case CHK_GBROMFILE:
			if( !lstrcmpA( pszLine, STRING_REG_GBROMFILE ))
				dwReturn = PL_GBROMFILE;
			break;

		case CHK_GBROMSAVE:
			if( !lstrcmpA( pszLine, STRING_REG_GBROMSAVE ))
				dwReturn = PL_GBROMSAVE;
			break;
/*
		default:
			{
				TCHAR szText[200];
				wsprintf( szText, "%s  = %i", pszLine, dwValue );
				MessageBox( NULL, szText, "", MB_OK);
			}
*/

		}
		if( dwReturn == PL_NOHIT )
			pszLine[dwChar] = '=';
		else
			MoveMemory( pszLine, pszLine+dwChar+1, (lstrlenA( pszLine+dwChar+1 ) + 1) * sizeof(pszLine[0]) );
	}

	return dwReturn;
}

bool ProcessKey( DWORD dwKey, LPSTR pszLine, LPCONTROLLER pController = NULL, LPSTR pszGameDevice = NULL, LPBYTE bGameDeviceNr = NULL )
{
	bool bReturn = false;
	int iLength = lstrlenA( pszLine ) / 2;

	DWORD dwValue = 0;
	BYTEFLAGS bfFlags;
	bfFlags.bValue = 0;

	switch( dwKey )
	{
	case PL_CONTROLS:
		if( pController && ( iLength >= sizeof(pController->aButton) ))
		{
			TexttoHexA( pszLine, (BYTE*)pController->aButton, sizeof(pController->aButton) );
			bReturn = true;
		}
		break;

	case PL_SETTINGS:
		if( pController && ( iLength >= sizeof(DWORD) ))
		{
			TexttoHexA( pszLine, (LPBYTE)&dwValue, sizeof(DWORD) );

			bfFlags.bValue = LOBYTE( LOWORD( dwValue ));
			pController->bRapidFireRate = (int) HIBYTE(LOWORD(dwValue));
			//HIBYTE( LOWORD( dwValue ));
			pController->PakType = LOBYTE( HIWORD( dwValue ));
			pController->bStickRange = HIBYTE( HIWORD( dwValue ));
					
			pController->fPlugged = bfFlags.fFlag0;
			pController->fRawData = bfFlags.fFlag1;
			pController->fRealN64Range = bfFlags.fFlag2;
			if (bfFlags.fFlag3) {
				pController->bRapidFireEnabled = true;
			} else {
				pController->bRapidFireEnabled = false;
			}
			bReturn = true;
		}
		break;

	case PL_DEVICE:
		if( pController && ( iLength >= sizeof(DWORD) ))
		{
			TexttoHexA( pszLine, (LPBYTE)&dwValue, sizeof(DWORD) );

			bfFlags.bValue = LOBYTE( LOWORD( dwValue ));
			pController->bPadDeadZone = HIBYTE( LOWORD( dwValue ));
			pController->wMouseSensitivity = HIWORD( dwValue );

			pController->fAbsoluteMouseX = bfFlags.fFlag0;
			pController->fAbsoluteMouseY = bfFlags.fFlag1;

			pController->bAxisSet = ( bfFlags.fFlag2 << 1 ) | bfFlags.fFlag3;

			pController->fKeyAbsoluteX = bfFlags.fFlag4;
			pController->fKeyAbsoluteY = bfFlags.fFlag5;
			bReturn = true;
		}
		break;

	case PL_RUMBLE:
		if( pController && ( iLength >= sizeof(DWORD) ))
		{
			TexttoHexA( pszLine, (LPBYTE)&dwValue, sizeof(DWORD) );

			pController->bRumbleTyp = LOBYTE( LOWORD( dwValue ));
			pController->bRumbleStrength = HIBYTE( LOWORD( dwValue ));
			pController->fVisualRumble = (LOBYTE( HIWORD( dwValue )) != 0);
			//HIBYTE( HIWORD( dwValue ));

			bReturn = true;
		}
		break;

	case PL_MODIFIERS:
		if( pController )
		{
			BYTE nModifiers = (BYTE)( iLength / sizeof( MODIFIER ));

			if( nModifiers > 0 )
			{
				MODIFIER *pNewModifier = (MODIFIER*)P_realloc( pController->pModifiers, sizeof( MODIFIER ) * nModifiers );
				if( pNewModifier )
				{
					pController->pModifiers = pNewModifier;
					TexttoHexA( pszLine, (LPBYTE)pController->pModifiers, sizeof( MODIFIER ) * nModifiers );
					pController->nModifiers = nModifiers;
					bReturn = true;
				}
			}
			else
			{
				P_free( pController->pModifiers );
				pController->nModifiers = 0;
				bReturn = true;
			}
		}
		break;

	case PL_GAMEDEVICE:
		if( pszGameDevice )
		{
			lstrcpy( pszGameDevice, pszLine );
			bReturn = true;
		}
		break;

	case PL_GAMEDEVICENR:
		if( bGameDeviceNr && ( iLength >= sizeof(BYTE) ))
		{
			TexttoHexA( pszLine, bGameDeviceNr, sizeof(BYTE) );
			bReturn = true;
		}
		break;

	case PL_MEMPAKFILE:
		if( pController )
		{
			lstrcpy( pController->szMempakFile, pszLine );
			bReturn = true;
		}
		break;

	case PL_GBROMFILE:
		if( pController )
		{
			lstrcpy( pController->szTransferRom, pszLine );
			bReturn = true;
		}

	case PL_GBROMSAVE:
		if( pController )
		{
			lstrcpy( pController->szTransferSave, pszLine );
			bReturn = true;
		}
/*
	default:
		{
			TCHAR szText[200];
			wsprintf( szText, "ID:%i- \"%s\"", dwKey, pszLine );
			MessageBox( NULL, szText, "", MB_OK);
		}
*/
	}

	return bReturn;
}

bool LoadProfileFromResource( char* pszRessource, CONTROLLER *pController, TCHAR *pszGameDevice, BYTE *bGameDeviceNr )
{
	if( pController == NULL && pszGameDevice == NULL && bGameDeviceNr == NULL )
		return false;
	HRSRC res = FindResource( g_hinstDll, pszRessource, "PROFILE");
	if( res == NULL )
		return false;
	char *profile = (char*)LockResource( LoadResource( g_hinstDll, res ));
	char *profileend = profile + SizeofResource( g_hinstDll, res );
	

	DWORD dwCommand = PL_NOHIT;
	char szLine[4096];
	while( profile < profileend )
	{
		while( profile < profileend && (CHECK_WHITESPACES( *profile ) || *profile == ' ' ))
			++profile;
		int i = 0;
		while( profile < profileend && i < sizeof(szLine)-1 && !(CHECK_WHITESPACES( *profile )) )
			szLine[i++] = *profile++;

		szLine[i] = '\0';
		dwCommand = ParseLine( szLine );
		ProcessKey( dwCommand, szLine, pController, pszGameDevice, bGameDeviceNr );
	}
	return true;
}

bool LoadProfileFromResource( int indexController, CONTROLLER *pController, TCHAR *pszGameDevice, BYTE *bGameDeviceNr )
{
	int resIds[] = { IDR_PROFILE_DEFAULT1, IDR_PROFILE_DEFAULT2, IDR_PROFILE_DEFAULT3, IDR_PROFILE_DEFAULT4 };

	char szId[20];
	wsprintf( szId, "#%i", resIds[indexController] );
	return LoadProfileFromResource( szId, pController, pszGameDevice, bGameDeviceNr );
}

bool LoadProfile( TCHAR *pszFileName, TCHAR *pszConfigname, CONTROLLER *pController, TCHAR *pszGameDevice, BYTE *bGameDeviceNr )
{
	DataBuffer dbFile( pszFileName, 2048, false, true );
	TCHAR szLine[4096];
	DWORD dwOffset = 0;
	int iVersion = 0;
	bool bReturn = false;
	

	// Test if right Version
	while(( dbFile.ReadLine( dwOffset, szLine, sizeof(szLine) ) == DBC_OK ) && !iVersion )
	{
		dwOffset += lstrlen( szLine ) + 2;
		if( ParseLine( szLine ) == PL_VERSIONSTRING )
			iVersion = (int)(atof( szLine ) * 100);
	}
	if( iVersion != 200 )
		return false;

	dwOffset -= lstrlen( szLine ) + 2;

	SetControllerDefaults( pController );
	pszGameDevice[0] = pszGameDevice[1] = '\0';
	*bGameDeviceNr = -1;

	DWORD dwCommand = PL_NOHIT;
	while(( dwCommand != PL_KEYNAME ) && ( dbFile.ReadLine( dwOffset, szLine, sizeof(szLine) ) == DBC_OK ))
	{
		dwOffset += lstrlen( szLine ) + 2;
		dwCommand = ParseLine( szLine );
		char szt[800];
		wsprintf( szt, "%i - %s\n", dwCommand, szLine );
		ProcessKey( dwCommand, szLine, pController, pszGameDevice, bGameDeviceNr );
	}

	return true;
}

int FormatProfileBlock( TCHAR *szTextBlock, int iController )
{
	TCHAR *pszProfile = &szTextBlock[lstrlen(szTextBlock)];

	CONTROLLER *pController = &g_ivConfig->Controllers[iController];
	BYTEFLAGS bfFlags;
	DWORD dwValue;

	lstrcat( pszProfile, STRING_REG_CONTROLS "=" );
	pszProfile += lstrlen(pszProfile);
	HextoTextA( (BYTE*)pController->aButton, pszProfile, sizeof(pController->aButton) );

	lstrcat( pszProfile, "\r\n" STRING_REG_SETTINGS "=" );
	pszProfile += lstrlen(pszProfile);
	bfFlags.bValue = 0;
	bfFlags.fFlag0 = pController->fPlugged;
	bfFlags.fFlag1 = pController->fRawData;
	bfFlags.fFlag2 = pController->fRealN64Range;
	if (pController->bRapidFireEnabled) {
		bfFlags.fFlag3 = 1;
	} else {
		bfFlags.fFlag3 = 0;
	}

	dwValue = MAKELONG(	MAKEWORD( bfFlags.bValue, pController->bRapidFireRate ),
						MAKEWORD( pController->PakType, pController->bStickRange ));
	HextoTextA( (LPBYTE)&dwValue, pszProfile, 4 );

	lstrcat( pszProfile, "\r\n" STRING_REG_DEVICE "=" );
	pszProfile += lstrlen(pszProfile);
	bfFlags.bValue = 0;
	bfFlags.fFlag0 = pController->fAbsoluteMouseX;
	bfFlags.fFlag1 = pController->fAbsoluteMouseY;
	bfFlags.fFlag2 = ( pController->bAxisSet & 0x02 ) ? 1 : 0;
	bfFlags.fFlag3 = ( pController->bAxisSet & 0x01 ) ? 1 : 0;
	bfFlags.fFlag4 = pController->fKeyAbsoluteX;
	bfFlags.fFlag5 = pController->fKeyAbsoluteY;
	dwValue = MAKELONG( MAKEWORD( bfFlags.bValue, (BYTE)pController->bPadDeadZone ),
						pController->wMouseSensitivity );
	HextoTextA( (LPBYTE)&dwValue, pszProfile, 4 );

	lstrcat( pszProfile, "\r\n" STRING_REG_RUMBLE "=" );
	pszProfile += lstrlen(pszProfile);
	dwValue = MAKELONG(	MAKEWORD( pController->bRumbleTyp, pController->bRumbleStrength ),
						MAKEWORD( pController->fVisualRumble, 0 ));
	HextoTextA( (LPBYTE)&dwValue, pszProfile, 4 );

	if( pController->nModifiers > 0 && pController->pModifiers )
	{
		lstrcat( pszProfile, "\r\n" STRING_REG_MODIFIERS "=" );
		pszProfile += lstrlen(pszProfile);
		HextoTextA( (LPBYTE)pController->pModifiers, pszProfile, sizeof(MODIFIER) * pController->nModifiers );
	}
	
	if( g_ivConfig->Devices[iController].bProductCounter != BYTE(-1) )
	{
		lstrcat( pszProfile, "\r\n" STRING_REG_GAMEDEVICE "=" );
		pszProfile += lstrlen(pszProfile);
		lstrcpy( pszProfile, g_ivConfig->Devices[iController].szProductName );

		lstrcat( pszProfile, "\r\n" STRING_REG_GAMEDEVICENR "=" );
		pszProfile += lstrlen(pszProfile);
		HextoTextA( &g_ivConfig->Devices[iController].bProductCounter, pszProfile, 1 );
	}

	lstrcat( pszProfile, "\r\n" STRING_REG_MEMPAKFILE "=" );
	pszProfile += lstrlen(pszProfile);
	lstrcpy( pszProfile, pController->szMempakFile );

	lstrcat( pszProfile, "\r\n" STRING_REG_GBROMFILE "=" );
	pszProfile += lstrlen(pszProfile);
	lstrcpy( pszProfile, pController->szTransferRom );

	lstrcat( pszProfile, "\r\n" STRING_REG_GBROMSAVE "=" );
	pszProfile += lstrlen(pszProfile);
	lstrcpy( pszProfile, pController->szTransferSave );

	lstrcat( pszProfile, "\r\n" );
	pszProfile += lstrlen(pszProfile);

	return pszProfile - szTextBlock;
}

BOOL StoreConfigStructIntoRegistry()
{
	if(	!g_ivConfig )
		return FALSE;

	HKEY hKey;
	BOOL Succed = FALSE;
	int i;

	DWORD dwValue;
	BYTEFLAGS bfFlags;
	
	if( OpenRegistryKey( NULL, 0, &hKey, true ) == ERROR_SUCCESS )
	{
		RegSetValueEx( hKey, NULL, 0, REG_SZ, (CONST UCHAR*)VERSIONINFO, sizeof(VERSIONINFO) );

		dwValue = g_ivConfig->bAutoConfig;
		RegSetValueEx( hKey, STRING_REG_AUTOCONFIG, 0, REG_DWORD, (CONST UCHAR*)&dwValue, sizeof(DWORD) );

		RegSetValueEx( hKey, STRING_REG_SHORTCUTS, 0, REG_BINARY, (CONST UCHAR*)&g_ivConfig->ShortCuts, sizeof(SHORTCUTS) );

		RegCloseKey( hKey );
	}

	CONTROLLER *pController;
	for( i = 0; i < 4; ++i )
	{
		if( OpenRegistryKey( STRING_REG_CONTROLLER, i+1, &hKey, true ) == ERROR_SUCCESS )
		{
			pController = &g_ivConfig->Controllers[i];
			RegSetValueEx( hKey, STRING_REG_CONTROLS, 0, REG_BINARY, (CONST UCHAR*)pController->aButton, sizeof(pController->aButton) );

			bfFlags.bValue = 0;
			bfFlags.fFlag0 = pController->fPlugged;
			bfFlags.fFlag1 = pController->fRawData;
			bfFlags.fFlag2 = pController->fRealN64Range;
			if (pController->bRapidFireEnabled) {
				bfFlags.fFlag3 = 1;
			} else {
				bfFlags.fFlag3 = 0;
			}

			dwValue = MAKELONG(	MAKEWORD( bfFlags.bValue, pController->bRapidFireRate ),
								MAKEWORD( pController->PakType, pController->bStickRange ));
			RegSetValueEx( hKey, STRING_REG_SETTINGS, 0, REG_DWORD, (CONST UCHAR*)&dwValue, sizeof(DWORD) );

			bfFlags.bValue = 0;
			bfFlags.fFlag0 = pController->fAbsoluteMouseX;
			bfFlags.fFlag1 = pController->fAbsoluteMouseY;
			bfFlags.fFlag2 = ( pController->bAxisSet & 0x02 ) ? 1 : 0;
			bfFlags.fFlag3 = ( pController->bAxisSet & 0x01 ) ? 1 : 0;
			bfFlags.fFlag4 = pController->fKeyAbsoluteX;
			bfFlags.fFlag5 = pController->fKeyAbsoluteY;

			dwValue = MAKELONG( MAKEWORD( bfFlags.bValue, (BYTE)pController->bPadDeadZone ),
							pController->wMouseSensitivity );
			RegSetValueEx( hKey, STRING_REG_DEVICE, 0, REG_DWORD, (CONST UCHAR*)&dwValue, sizeof(DWORD) );

			dwValue = MAKELONG(	MAKEWORD( pController->bRumbleTyp, pController->bRumbleStrength ),
							MAKEWORD( pController->fVisualRumble, 0 ));
			RegSetValueEx( hKey, STRING_REG_RUMBLE, 0, REG_DWORD, (CONST UCHAR*)&dwValue, sizeof(DWORD) );

			if( pController->nModifiers > 0 && pController->pModifiers )
				RegSetValueEx( hKey, STRING_REG_MODIFIERS, 0, REG_BINARY, (CONST UCHAR*)pController->pModifiers, sizeof(MODIFIER) * pController->nModifiers );
			else
				RegDeleteValue( hKey, STRING_REG_MODIFIERS );

			if( g_ivConfig->Devices[i].bProductCounter == BYTE(-1) )
			{
				RegDeleteValue( hKey, STRING_REG_GAMEDEVICE );
				RegDeleteValue( hKey, STRING_REG_GAMEDEVICENR );
			}
			else
			{
				RegSetValueEx( hKey, STRING_REG_GAMEDEVICE, 0, REG_SZ, (CONST UCHAR*)g_ivConfig->Devices[i].szProductName, lstrlen(g_ivConfig->Devices[i].szProductName) + 1 );
				dwValue = g_ivConfig->Devices[i].bProductCounter;
				RegSetValueEx( hKey, STRING_REG_GAMEDEVICENR, 0, REG_DWORD, (CONST UCHAR*)&dwValue, sizeof(DWORD) );
			}

			if( pController->szMempakFile[0] == '\0' )
				RegDeleteValue( hKey, STRING_REG_MEMPAKFILE );
			else
				RegSetValueEx( hKey, STRING_REG_MEMPAKFILE, 0, REG_SZ, (CONST UCHAR*)pController->szMempakFile, lstrlen(pController->szMempakFile) + 1 );

			if( pController->szTransferRom[0] == '\0' )
				RegDeleteValue( hKey, STRING_REG_GBROMFILE );
			else
				RegSetValueEx( hKey, STRING_REG_GBROMFILE, 0, REG_SZ, (CONST UCHAR*)pController->szTransferRom, lstrlen(pController->szTransferRom) + 1 );

			if( pController->szTransferSave[0] == '\0' )
				RegDeleteValue( hKey, STRING_REG_GBROMSAVE );
			else
				RegSetValueEx( hKey, STRING_REG_GBROMSAVE, 0, REG_SZ, (CONST UCHAR*)pController->szTransferSave, lstrlen(pController->szTransferSave) + 1 );

			RegCloseKey( hKey );
		}
	}
	
	return Succed;
}

bool LoadDeviceDescfromReg( TCHAR *pszProductName, BYTE *bProductCounter, int indexController )
{
	HKEY hKey;
	bool bSucced = false;
	LONG Error;

	if( OpenRegistryKey( STRING_REG_CONTROLLER, indexController+1, &hKey, false ) == ERROR_SUCCESS )
	{
		DWORD dwBuffer,
				dwSize;
		dwSize = MAX_PATH + 1;
		RegQueryValueEx( hKey, STRING_REG_GAMEDEVICE, NULL, NULL, (UCHAR*)pszProductName, &dwSize );

		dwSize = sizeof(DWORD);
		Error = RegQueryValueEx( hKey, STRING_REG_GAMEDEVICENR, NULL, NULL, (LPBYTE)&dwBuffer, &dwSize );
		if ( Error == ERROR_SUCCESS )
			*bProductCounter = (BYTE)dwBuffer;

		bSucced = true;
		RegCloseKey( hKey );
	}
	return bSucced;
}

bool LoadDeviceDesc( TCHAR *pszProductName, BYTE *bProductCounter, int indexController )
{
	return LoadDeviceDescfromReg( pszProductName, bProductCounter, indexController )
		|| LoadProfileFromResource( indexController, NULL, pszProductName, bProductCounter );
}

BYTE LoadModifiersfromReg( MODIFIER **ppMods, int indexController )
{
	HKEY hKey;
	DWORD dwSize = 0;
	LONG Error;

	if( OpenRegistryKey( STRING_REG_CONTROLLER, indexController+1, &hKey, false ) == ERROR_SUCCESS )
	{
		Error = RegQueryValueEx( hKey, STRING_REG_MODIFIERS, NULL, NULL, NULL, &dwSize );
		if(( Error == ERROR_SUCCESS ) & ( dwSize >= sizeof(MODIFIER)))
		{
			*ppMods = (MODIFIER*)P_realloc( *ppMods, dwSize );
			RegQueryValueEx( hKey, STRING_REG_MODIFIERS, NULL, NULL, (LPBYTE)*ppMods, &dwSize );
		}
		else
			dwSize = 0; 

		RegCloseKey( hKey );
	}
	if( dwSize <= 0 )
	{
		P_free( *ppMods );
		*ppMods = NULL;
	}

	return (BYTE)dwSize / sizeof(MODIFIER);
}

bool LoadShortCutsfromReg( SHORTCUTS *pShortCuts )
{
	HKEY hKey;
	DWORD dwSize = 0;
	LONG Error;
	bool fReturn = false;

	if( OpenRegistryKey( NULL, 0, &hKey, false ) == ERROR_SUCCESS )
	{
		dwSize = sizeof(SHORTCUTS);
		Error =	RegQueryValueEx( hKey, STRING_REG_SHORTCUTS, NULL, NULL, (UCHAR*)pShortCuts, &dwSize );
		if( Error == ERROR_SUCCESS )
			fReturn = true;

		RegCloseKey( hKey );
	}

	return fReturn;
}

void LoadShortCutsfromRessource( SHORTCUTS *pShortCuts )
{
	FillMemory( pShortCuts, sizeof(SHORTCUTS), VK_ESCAPE );
	char szId[20];
	wsprintf( szId, "#%i", IDR_SHORTCUTS_DEFAULT );
	HRSRC res = FindResource( g_hinstDll, szId, "SHORTCUT");
	if( res != NULL )
		CopyMemory( pShortCuts, LockResource( LoadResource( g_hinstDll, res )), sizeof(SHORTCUTS));
}

void LoadShortCuts( SHORTCUTS *pShortCuts )
{
	FillMemory( pShortCuts, sizeof(SHORTCUTS), VK_ESCAPE );
	if( !LoadShortCutsfromReg( pShortCuts ))
	{
		LoadShortCutsfromRessource( pShortCuts );
	}
}

bool LoadControllerStructFromReg( CONTROLLER *pController, int indexController )
{
	if(	!pController )
		return false;
		

	HKEY hKey;
	LONG Error;
	bool bSucced = false;

	if( OpenRegistryKey( STRING_REG_CONTROLLER, indexController+1, &hKey, false ) == ERROR_SUCCESS )
	{
		bSucced = true;
		DWORD dwBuffer,
				dwSize;

		BYTEFLAGS bfFlags;

		dwSize = sizeof(pController->aButton);
		RegQueryValueEx( hKey, STRING_REG_CONTROLS, NULL, NULL, (UCHAR*)pController->aButton, &dwSize );

		dwSize = sizeof(DWORD);
		Error = RegQueryValueEx( hKey, STRING_REG_SETTINGS, NULL, NULL, (UCHAR*)&dwBuffer, &dwSize );
		if ( Error == ERROR_SUCCESS )
		{
			bfFlags.bValue = LOBYTE( LOWORD( dwBuffer ));
			pController->bRapidFireRate = HIBYTE(LOWORD(dwBuffer));
			pController->PakType = LOBYTE( HIWORD( dwBuffer ));
			pController->bStickRange = HIBYTE( HIWORD( dwBuffer ));

			pController->fPlugged = bfFlags.fFlag0;
			pController->fRawData = bfFlags.fFlag1;
			pController->fRealN64Range = bfFlags.fFlag2;
			if (bfFlags.fFlag3) {
				pController->bRapidFireEnabled = true;
			} else {
				pController->bRapidFireEnabled = false;
			}
		}

		dwSize = sizeof(DWORD);
		Error = RegQueryValueEx( hKey, STRING_REG_DEVICE, NULL, NULL, (UCHAR*)&dwBuffer, &dwSize );
		if ( Error == ERROR_SUCCESS )
		{
			bfFlags.bValue = LOBYTE( LOWORD( dwBuffer ));
			pController->bPadDeadZone = HIBYTE( LOWORD( dwBuffer ));
			pController->wMouseSensitivity = HIWORD( dwBuffer );

			pController->fAbsoluteMouseX = bfFlags.fFlag0;
			pController->fAbsoluteMouseY = bfFlags.fFlag1;

			pController->bAxisSet = ( bfFlags.fFlag2 << 1 ) | bfFlags.fFlag3;

			pController->fKeyAbsoluteX = bfFlags.fFlag4;
			pController->fKeyAbsoluteY = bfFlags.fFlag5;
		}

		dwSize = sizeof(DWORD);
		Error = RegQueryValueEx( hKey, STRING_REG_RUMBLE, NULL, NULL, (UCHAR*)&dwBuffer, &dwSize );
		if ( Error == ERROR_SUCCESS )
		{
			pController->bRumbleTyp = LOBYTE( LOWORD( dwBuffer ));
			pController->bRumbleStrength = HIBYTE( LOWORD( dwBuffer ));
			pController->fVisualRumble = (LOBYTE( HIWORD( dwBuffer )) != 0);
			//HIBYTE( HIWORD( dwBuffer ));
		}

		dwSize = sizeof( pController->szMempakFile );
		RegQueryValueEx( hKey, STRING_REG_MEMPAKFILE, NULL, NULL, (UCHAR*)pController->szMempakFile, &dwSize );

		dwSize = sizeof( pController->szTransferRom );
		RegQueryValueEx( hKey, STRING_REG_GBROMFILE, NULL, NULL, (UCHAR*)pController->szTransferRom, &dwSize );

		dwSize = sizeof( pController->szTransferSave );
		RegQueryValueEx( hKey, STRING_REG_GBROMSAVE, NULL, NULL, (UCHAR*)pController->szTransferSave, &dwSize );

		RegCloseKey ( hKey );

		pController->nModifiers = LoadModifiersfromReg( &pController->pModifiers, indexController );
	}

	return bSucced;
}

bool LoadControllerStruct( CONTROLLER *pController, int indexController )
{
	SetControllerDefaults( pController );
	return LoadControllerStructFromReg( pController, indexController )
		|| LoadProfileFromResource( indexController, pController, NULL, NULL );
}

BOOL LoadConfigStructFromReg()
{
	if(	!g_ivConfig )
		return FALSE;

	HKEY hKey;
	LONG Error;
	DWORD dwBuffer,
			dwSize;
	BOOL bSucced = FALSE;

	//Base Entries
	if ( OpenRegistryKey( NULL, 0, &hKey, false ) == ERROR_SUCCESS )
	{
		dwSize = sizeof(DWORD);
		Error = RegQueryValueEx( hKey, STRING_REG_AUTOCONFIG, NULL, NULL, (UCHAR*)&dwBuffer, &dwSize );
		if ( Error == ERROR_SUCCESS )
			g_ivConfig->bAutoConfig = (dwBuffer & 0x1) ? 1 : 0;

		RegCloseKey ( hKey );
	}
	
	// Controllers

	for( int i = 0; i < 4; ++i )
	{
		LoadControllerStruct( &g_ivConfig->Controllers[i], i );
		LoadDeviceDesc( g_ivConfig->Devices[i].szProductName, &g_ivConfig->Devices[i].bProductCounter, i );
	}
	return bSucced;
}


BOOL GetDirectory( LPTSTR pszDirectory, WORD wDirID )
{
	BOOL bReturn = TRUE;
	TCHAR szBuffer[MAX_PATH + 1];
	DWORD dwSize = sizeof(szBuffer);

	switch( wDirID )
	{
	case DIRECTORY_OWNFILES:
	case DIRECTORY_APPLICATION:
		pszDirectory[0] = pszDirectory[1] = '\0';
		break;

	case DIRECTORY_MEMPAK:
		if( !LoadRegValue( STRING_REG_FOLDERS, 0, STRING_REG_MEMPAKDIR, pszDirectory, &dwSize ))
			lstrcpy( pszDirectory, STRING_DEF_MEMPAKFILE );
		break;

	case DIRECTORY_GBROMS:
		if( !LoadRegValue( STRING_REG_FOLDERS, 0, STRING_REG_GBROMDIR, pszDirectory, &dwSize ))
			lstrcpy( pszDirectory, STRING_DEF_GBROMFILE );
		break;

	case DIRECTORY_GBSAVES:
		if( !LoadRegValue( STRING_REG_FOLDERS, 0, STRING_REG_GBROMSDIR, pszDirectory, &dwSize ))
			lstrcpy( pszDirectory, STRING_DEF_GBROMSAVE );
		break;

	default:
		pszDirectory[0] = pszDirectory[1] = '\0';
		bReturn = FALSE;
	}

	TCHAR *pSlash;
	if( pszDirectory[1] == ':' || ( pszDirectory[1] == '\\' && pszDirectory[0] == '\\' )) // Absolute Path( x: or \\ )
		lstrcpy( szBuffer, pszDirectory );
	else
	{
		GetModuleFileName( NULL, szBuffer, MAX_PATH );
		pSlash = n_strrchr( szBuffer, '\\' );
		++pSlash;
		lstrcpy( pSlash, pszDirectory );
	}

	GetFullPathName( szBuffer, MAX_PATH, pszDirectory, &pSlash );

	pSlash = &pszDirectory[lstrlen( pszDirectory ) - 1];
	if( *pSlash != '\\' )
	{
		pSlash[1] = '\\';
		pSlash[2] = '\0';
	}

	return bReturn;
}

void GetAbsoluteFileName( TCHAR *szAbsolute, CONST TCHAR *szFileName, CONST WORD wDirID )
{
	if( szFileName[1] == ':' || (szFileName[1] == '\\' && szFileName[0] == '\\'))
		lstrcpy( szAbsolute, szFileName );
	else
	{
		GetDirectory( szAbsolute, wDirID );
		lstrcat( szAbsolute, szFileName );
	}
}

BOOL SendFilestoList( HWND hDlgItem, WORD wType )
{
	HANDLE hFindFile;

	WIN32_FIND_DATA FindFile;
	TCHAR szPattern[MAX_PATH + 10];
	TCHAR *pszExtensions;
	BOOL Succed;

	switch( wType )
	{
	case FILIST_MEM:
		GetDirectory( szPattern, DIRECTORY_MEMPAK );
		lstrcat( szPattern, "*.*" );
		pszExtensions = ".mpk\0.n64\0";
		break;
	case FILIST_TRANSFER:
		GetDirectory( szPattern, DIRECTORY_GBROMS );
		lstrcat( szPattern, "*.gb?" );
		pszExtensions = ".gb\0.gbc\0";
		break;
	default:
		return FALSE;
	}

	TCHAR *pcPoint;
	TCHAR *pszExt;
	bool bValidFile;

	hFindFile = FindFirstFile( szPattern, &FindFile );
	if( hFindFile != INVALID_HANDLE_VALUE )
	{
		do
		{
			pszExt = pszExtensions;
			pcPoint = n_strrchr( FindFile.cFileName, '.' );
			bValidFile = false;
			do
			{
				if( !lstrcmpi( pcPoint, pszExt ))
					bValidFile = true;
				pszExt += lstrlen( pszExt ) + 1;	
			}
			while( *pszExt && !bValidFile );

			if( bValidFile )
				SendMessage( hDlgItem, LB_ADDSTRING, 0, (LPARAM)FindFile.cFileName );
		}
		while( FindNextFile( hFindFile, &FindFile ));
		FindClose( hFindFile );
		Succed = TRUE;
	}
	else
		Succed = FALSE;

	return Succed;
}

bool BrowseFolders( HWND hwndParent, TCHAR *pszHeader, TCHAR *pszDirectory )
{
	ITEMIDLIST *piStart = NULL;

	if( pszDirectory[0] != '\0')
	{
		IShellFolder* pDesktopFolder;
		if( SUCCEEDED( SHGetDesktopFolder( &pDesktopFolder )))
		{
			OLECHAR olePath[MAX_PATH];
			ULONG chEaten;

			MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, pszDirectory, -1, olePath, sizeof( olePath ) );

			pDesktopFolder->ParseDisplayName( NULL, NULL, olePath, &chEaten, &piStart, NULL );

			pDesktopFolder->Release();
		}
	}

	BROWSEINFO brInfo;
	brInfo.hwndOwner = hwndParent;
	brInfo.pidlRoot = piStart;
	brInfo.pszDisplayName = pszDirectory;
	brInfo.lpszTitle  = pszHeader;
	brInfo.ulFlags = BIF_RETURNONLYFSDIRS;
	brInfo.lpfn = NULL;

	ITEMIDLIST *piList;

	piList = SHBrowseForFolder( &brInfo );
	if( piList )
	{
		SHGetPathFromIDList( (const LPITEMIDLIST)piList, pszDirectory );
		LPMALLOC pMal;
		if( SUCCEEDED( SHGetMalloc( &pMal )))
		{
			pMal->Free( piList );
			pMal->Release();
		}
		return true;
	}

	return false;
}

BOOL GetInitialBrowseDir( TCHAR *pszFileName, DWORD dwType )
{
	DWORD dwSize = MAX_PATH+1;
	BOOL bReturn = TRUE;
	switch( dwType )
	{
	case BF_PROFILE:
		bReturn = LoadRegValue( STRING_REG_BROWSER, 0, STRING_REG_BRPROFILE, pszFileName, &dwSize );
		break;
	case BF_MEMPAK:
		bReturn = LoadRegValue( STRING_REG_BROWSER, 0, STRING_REG_BRMEMPAK, pszFileName, &dwSize )
			|| GetDirectory( pszFileName, DIRECTORY_MEMPAK );
		break;
	case BF_NOTE:
		bReturn = LoadRegValue( STRING_REG_BROWSER, 0, STRING_REG_BRNOTE, pszFileName, &dwSize );
		break;
	case BF_GBROM:
		bReturn = LoadRegValue( STRING_REG_BROWSER, 0, STRING_REG_BRGBROM, pszFileName, &dwSize )
			|| GetDirectory( pszFileName, DIRECTORY_GBROMS );
		break;
	case BF_GBSAVE:
		bReturn = LoadRegValue( STRING_REG_BROWSER, 0, STRING_REG_BRGBSAVE, pszFileName, &dwSize )
			|| GetDirectory( pszFileName, DIRECTORY_GBSAVES );
		break;
	default:
		GetDirectory( pszFileName, DIRECTORY_APPLICATION );
		return FALSE;
	}
	return bReturn;
}

BOOL SaveLastBrowseDir( TCHAR *pszFileName, DWORD dwType )
{
	BOOL bReturn = TRUE;
	TCHAR *cSlash = n_strrchr( pszFileName, '\\' );
	if( cSlash )
	{
		TCHAR *subKey = NULL;

		switch( dwType )
		{
		case BF_PROFILE:
			subKey = STRING_REG_BRPROFILE;
			break;
		case BF_MEMPAK:
			subKey = STRING_REG_BRMEMPAK;
			break;
		case BF_NOTE:
			subKey = STRING_REG_BRNOTE;
			break;
		case BF_GBROM:
			subKey = STRING_REG_BRGBROM;
			break;
		case BF_GBSAVE:
			subKey = STRING_REG_BRGBSAVE;
			break;
		default:
			return FALSE;
		}
		*cSlash = '\0';
		bReturn = SaveRegString( STRING_REG_BROWSER, 0, subKey, pszFileName );
		*cSlash = '\\';
	}
	return bReturn;
}



bool BrowseFile( HWND hDlg, TCHAR *pszFileName, DWORD dwType )
{
	bool fSave = (HIWORD(dwType) == BF_SAVE);
	TCHAR *pszFilter = NULL;
	TCHAR *pszTitle = NULL;
	DWORD dwFlags = /*OFN_DONTADDTORECENT |*/ OFN_NOCHANGEDIR;
	dwFlags |= (fSave)	? OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT
						: OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
	TCHAR *pszExt = NULL;

	switch( LOWORD(dwType) )
	{
	case BF_PROFILE:
		pszFilter = "Controller-Profile (*.cpf)\0*.cpf\0";
		pszExt = "cpf";
		break;
	case BF_MEMPAK:
		pszFilter = "MemPak (*.mpk)\0*.mpk\0" \
					"Dexdrive Save (*.n64)\0*.n64\0";
		if( !fSave )
		{
			pszTitle = "Choose a MemPak or type a new Name to create one";
			dwFlags = OFN_HIDEREADONLY;
		}
		pszExt = "mpk";
		break;
	case BF_NOTE:
		pszFilter = "MemPak Note (*.a64)\0*.a64\0";
		pszExt = "a64";
		break;
	case BF_GBROM:
		pszFilter = "GameBoy ROM (*.gb;*.gbc)\0*.gb;*.gbc\0";
		pszExt = "gb";
		break;
	case BF_GBSAVE:
		pszFilter = "GameBoy Save (*.sv;*.sav)\0*.sv;*.sav\0";
		pszExt = "sv";
		break;
	case BF_BINARY:
		pszFilter = "Binary Data (*.bin)\0*.bin\0";
		pszExt = "bin";
		break;
	default:
		return false;
	}
	dwFlags |= OFN_NOCHANGEDIR;

	TCHAR szFileName[MAX_PATH+1] = "",
		  szInitialDir[MAX_PATH+1] = "",
		  *pcSlash;


	if( pszFileName[1] == ':' || ( pszFileName[1] == '\\' && pszFileName[0] == '\\' ))
	{
		lstrcpy( szInitialDir, pszFileName );
		pcSlash = n_strrchr( szInitialDir, '\\' );
		if( pcSlash )
		{
			*pcSlash = '\0';
			lstrcpy( szFileName, &pcSlash[1] );
		}
	}
	else
	{
		if( !GetInitialBrowseDir( szInitialDir, LOWORD(dwType) ))
			GetDirectory( szInitialDir, DIRECTORY_APPLICATION );
		lstrcpy( szFileName, pszFileName );
	}


	OPENFILENAME oFile;

	oFile.lStructSize		= sizeof (OPENFILENAME);
	oFile.hwndOwner			= hDlg;
	oFile.hInstance			= NULL;
	oFile.lpstrFilter		= pszFilter;
	oFile.lpstrCustomFilter	= NULL;
	oFile.nMaxCustFilter	= 0;
	oFile.nFilterIndex		= 0;
	oFile.lpstrFile			= szFileName;
	oFile.nMaxFile			= MAX_PATH;
	oFile.lpstrFileTitle	= NULL;
	oFile.nMaxFileTitle		= MAX_PATH; // ignored
	oFile.lpstrInitialDir	= szInitialDir;
	oFile.lpstrTitle		= pszTitle;
	oFile.Flags				= dwFlags;
	oFile.nFileOffset		= 0;
	oFile.nFileExtension	= 0;
	oFile.lpstrDefExt		= pszExt;
	oFile.lCustData			= 0L;
	oFile.lpfnHook			= NULL;
	oFile.lpTemplateName	= NULL;

	if( fSave )
	{
		if( !GetSaveFileName( &oFile ))
			return false;
	}
	else
	{
		if( !GetOpenFileName( &oFile ))
			return false;
	}

	lstrcpy( pszFileName, szFileName );
	SaveLastBrowseDir( szFileName, LOWORD(dwType) );
	return true;
}

bool ReadMemPakFile( TCHAR *pszMemPakFile, BYTE *aMemPak, bool fCreate )
{
	DWORD dwCreationDisposition = fCreate ? OPEN_ALWAYS : OPEN_EXISTING;

	HANDLE hFile = CreateFile( pszMemPakFile, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, dwCreationDisposition, 0, NULL);
	if ( hFile != INVALID_HANDLE_VALUE )
	{
		ZeroMemory( aMemPak, 32*1024 );
		TCHAR *pcPoint = n_strrchr( pszMemPakFile, '.' );
		if( !lstrcmpi( pcPoint, ".n64" ) )
			SetFilePointer( hFile, 0x1040, NULL, FILE_BEGIN );
		else
			SetFilePointer( hFile, 0L, NULL, FILE_BEGIN );
		
		DWORD dwBytesRead;
		bool Succed = ( ReadFile( hFile, aMemPak, min( 32*1024, GetFileSize( hFile, NULL )), &dwBytesRead, NULL) != 0 );

		CloseHandle( hFile );
		return Succed;
	}
	else
		ErrorMessage( "Couldnt read MemPak", GetLastError(), false );
	return false;
}

bool WriteMemPakFile( TCHAR *pszMemPakFile, BYTE *aMemPak, bool fCreate )
{
	DWORD dwCreationDisposition = fCreate ? OPEN_ALWAYS : OPEN_EXISTING;

	HANDLE hFile = CreateFile( pszMemPakFile, GENERIC_WRITE, FILE_SHARE_READ, NULL, dwCreationDisposition, 0, NULL);
	if ( hFile != INVALID_HANDLE_VALUE )
	{
		DWORD dwBytesWritten = 0;
		TCHAR *pcPoint = n_strrchr( pszMemPakFile, '.' );
		if( !lstrcmpi( pcPoint, ".n64" ) )
		{
			if( fCreate && !GetFileSize( hFile, NULL ))
			{
				char szHeader[] = "123-456-STD";
				SetFilePointer( hFile, 0L, NULL, FILE_BEGIN );
				WriteFile( hFile, szHeader, sizeof(szHeader), &dwBytesWritten, NULL );
			}
			SetFilePointer( hFile, 0x1040, NULL, FILE_BEGIN );
		}
		else
			SetFilePointer( hFile, 0L, NULL, FILE_BEGIN );
		
		bool Succed = ( WriteFile( hFile, aMemPak, 32*1024, &dwBytesWritten, NULL ) != 0 );
		if( Succed )
			SetEndOfFile( hFile );
		
		CloseHandle( hFile );
		return Succed;
	}
	else
		ErrorMessage( "Couldnt write MemPak", GetLastError(), false );

	return false;
}
