/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _DIRECTINPUT_H_
#define _DIRECTINPUT_H_

#include <dinput.h>

extern LPDIRECTINPUTEFFECT g_apdiEffect[4];
extern LPDIRECTINPUT8 g_pDIHandle;
extern LPDIRECTINPUTDEVICE8 g_apInputDevice[6];


bool InitDirectInput( HWND hWnd );
void FreeDirectInput ();
bool PrepareInputDevices();
void GetDeviceDatas();
bool GetNControllerInput ( int indexController, DWORD *pdwData );

BOOL CALLBACK EnumMakeDeviceList( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef );

bool GetInputDevice( HWND hWnd, LPDIRECTINPUTDEVICE8 &lpDirectInputDevice, GUID gGuid, DWORD dwDevType, DWORD dwCooperativeLevel );
void ReleaseDevice( LPDIRECTINPUTDEVICE8 &lpDirectInputDevice );
bool CreateEffectHandle( HWND hWnd, LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPDIRECTINPUTEFFECT &pDIEffect, BYTE bRumbleTyp, LONG lStrength );
void ReleaseEffect( LPDIRECTINPUTEFFECT &lpDirectEffect );
void ReleaseEffect( INT iEffect );


BYTE GetAdaptoidStatus( LPDIRECTINPUTDEVICE8 lpDirectInputDevice );
bool IsAdaptoidCommandSupported( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD cmd );
HRESULT DirectRumbleCommand( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD cmd );
HRESULT InitializeAdaptoid( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPBYTE status );
HRESULT ReadAdaptoidPak( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD addr, LPBYTE data );
HRESULT WriteAdaptoidPak( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD addr, LPBYTE data );


#define MINAXISVALUE	-32767
#define MAXAXISVALUE	32767
#define ZEROVALUE		0
#define THRESHOLD		40
#define RANGERELATIVE	(MAXAXISVALUE - ZEROVALUE + 1)
#define ABSTHRESHOLD	(RANGERELATIVE * THRESHOLD / 100)

#define MOUSEMOVE		5
#define MOUSESCALEVALUE	1 // ~= 100% Movement

#define N64DIVIDER		258


#define DID_KEYBOARD	0
#define DID_MOUSE		1
#define DID_GAMEPAD		2

#define DIB_KEYBOARD	DISCL_NONEXCLUSIVE | DISCL_FOREGROUND
#define DIB_MOUSE		DISCL_EXCLUSIVE | DISCL_FOREGROUND
#define DIB_GAMEPAD		DISCL_EXCLUSIVE | DISCL_BACKGROUND

#define DIB_CONFIG	DISCL_NONEXCLUSIVE | DISCL_BACKGROUND

#define RUMBLE_NONE			0x00
#define RUMBLE_CONSTANT		0x01
#define RUMBLE_RAMP			0x02
#define RUMBLE_CONDITION	0x04
#define RUMBLE_PERIODIC		0x08
#define RUMBLE_CUSTOM		0x10

#define RUMBLE_DIRECT		0x80

#define RUMBLE_EFF1			RUMBLE_CONSTANT
#define RUMBLE_EFF2			RUMBLE_RAMP
#define RUMBLE_EFF3			RUMBLE_DIRECT

#define STRING_ADAPTOID			"Adaptoid"		// Reported Name of the Adaptoid


#define ADAPT_TEST			0x7834BB00	// Query API - pass in command #, returns 0xB0CAB0CA if supported
#define ADAPT_RUMBLE		0x7834BB08	// Send command to rumble pack (DWORD 0=stop, 1=go)
#define ADAPT_INIT			0x7834BB0C	// Initialize pak (returns pak status bit flags)
#define ADAPT_READPAK		0x7834BB0D	// Read from pak  (reads 32 bytes of data)
#define ADAPT_WRITEPAK		0x7834BB0E	// Write to pak   (writes 32 bytes of data)
#define ADAPT_DIRECTCOMMAND	0x7834BB28	// Send command directly to controller - synchronous


inline bool GetInputDeviceNr( int iNumber, GUID gGuid, DWORD dwDevType, DWORD dwCooperativeLevel )
{
	return GetInputDevice( g_strEmuInfo.hMainWindow, g_apInputDevice[iNumber], gGuid, dwDevType, dwCooperativeLevel );
}
inline bool CreateEffectHandle( int iDevice, BYTE bRumbleTyp, LONG lStrength )
{
	return CreateEffectHandle( g_strEmuInfo.hMainWindow, g_apInputDevice[DID_GAMEPAD + iDevice], g_apdiEffect[iDevice], bRumbleTyp, lStrength );
}
inline void ReleaseEffect( int iEffect )
{
	ReleaseEffect( g_apdiEffect[iEffect] );
}

inline BYTE GetAdaptoidStatus( int iDevice )
{
	return GetAdaptoidStatus( g_apInputDevice[DID_GAMEPAD + iDevice] );
}
inline HRESULT WriteAdaptoidPak( int iDevice, DWORD addr, LPBYTE data )
{
	return WriteAdaptoidPak( g_apInputDevice[DID_GAMEPAD + iDevice], addr, data );
}
inline HRESULT ReadAdaptoidPak( int iDevice, DWORD addr, LPBYTE data )
{
	return ReadAdaptoidPak( g_apInputDevice[DID_GAMEPAD + iDevice], addr, data );
}
inline HRESULT InitializeAdaptoid( int iDevice, LPBYTE status )
{
	return InitializeAdaptoid( g_apInputDevice[DID_GAMEPAD + iDevice], status );
}
inline HRESULT DirectRumbleCommand( int iDevice, DWORD cmd )
{
	return DirectRumbleCommand( g_apInputDevice[DID_GAMEPAD + iDevice], cmd );
}
inline bool IsAdaptoidCommandSupported( int iDevice, DWORD cmd )
{
	return IsAdaptoidCommandSupported( g_apInputDevice[DID_GAMEPAD + iDevice], cmd );
}


#endif // #ifndef _DIRECTINPUT_H_