/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <dinput.h>

#include "commonIncludes.h"
#include "NRage PluginV2.h"
#include "PakIO.h"
#include "DirectInput.h"

// ProtoTypes //
HRESULT AcquireDevice( LPDIRECTINPUTDEVICE8 lpDirectInputDevice );

// global Variables //
LPDIRECTINPUT8  g_pDIHandle = NULL; // Base DirectInput8-Handle
LPDIRECTINPUTDEVICE8 g_apInputDevice[6] = { NULL, NULL, NULL, NULL, NULL, NULL }; // array of Handles for devices
LPDIRECTINPUTEFFECT  g_apdiEffect[4] = { NULL, NULL, NULL, NULL }; // array of handles for FF-Effects

CHAR g_acKeystate[256];
DIMOUSESTATE2 g_msMouseState = { 0, 0, 0 };

void GetDeviceDatas()
{
	HRESULT hr;

	if( g_apInputDevice[DID_KEYBOARD] )
	{
		hr = g_apInputDevice[DID_KEYBOARD]->Poll();
		if( FAILED( hr ))
			AcquireDevice( g_apInputDevice[DID_KEYBOARD] );

		hr = g_apInputDevice[DID_KEYBOARD]->GetDeviceState( sizeof(g_acKeystate), &g_acKeystate );

		if( FAILED( hr ))
			ZeroMemory( g_acKeystate, sizeof(g_acKeystate) );
	}

	if( g_apInputDevice[DID_MOUSE] )
	{
		hr = g_apInputDevice[DID_MOUSE]->Poll();

		if( FAILED( hr ))
			AcquireDevice( g_apInputDevice[DID_MOUSE] );

		hr = g_apInputDevice[DID_MOUSE]->GetDeviceState( sizeof(DIMOUSESTATE2), &g_msMouseState );
		if( FAILED( hr ))
			ZeroMemory( &g_msMouseState, sizeof(DIMOUSESTATE2) );
	}

	for( int i = 0; i < 4; ++i )
	{
		if( g_pcControllers[i].fGamePad )
		{
			if( g_apInputDevice[DID_GAMEPAD + i] )
			{
				if( FAILED( g_apInputDevice[DID_GAMEPAD + i]->Poll() ))
					AcquireDevice( g_apInputDevice[DID_GAMEPAD + i] );
			
				hr = g_apInputDevice[DID_GAMEPAD + i]->GetDeviceState( sizeof(DIJOYSTATE), &g_pcControllers[i].jsPadData );
			}
			else
				hr = DIERR_NOTACQUIRED;

			if( FAILED( hr ))
			{
				ZeroMemory( &g_pcControllers[i].jsPadData, sizeof(DIJOYSTATE));
				FillMemory( g_pcControllers[i].jsPadData.rgdwPOV, sizeof(g_pcControllers[i].jsPadData.rgdwPOV), 0xFF );
			}
		}
	}
}

inline bool GetJoyPadPOV( PULONG dwDegree, BYTE AxeId )
// TRUE if specified Direction is Pressed
{
	if( LOWORD( *dwDegree ) == 0xFFFF )
		return false;

	bool bPressed;

	switch( AxeId )
	{
	case AI_POV_DOWN:
		bPressed = (( *dwDegree >= 18000 - 5675 ) && (*dwDegree <= 18000 + 5675 ));
		break;
	case AI_POV_LEFT:
		bPressed = (( *dwDegree >= 27000 - 5675 ) && (*dwDegree <= 27000 + 5675 ));
		break;
	case AI_POV_RIGHT:
		bPressed = (( *dwDegree >= 9000 - 5675 ) && (*dwDegree <= 9000 + 5675 ));
		break;
	case AI_POV_UP:
		bPressed = (( *dwDegree >= 36000 - 5675 ) || ( *dwDegree <= 0 + 5675 ));
		break;
	default:
		bPressed = false;
	}
	
	return bPressed;
}

bool GetNControllerInput ( int indexController, LPDWORD pdwData )
{
	*pdwData = 0;
	WORD w_Buttons = 0;
	WORD w_Axes = 0;

	LPCONTROLLER pcController = &g_pcControllers[indexController];
	LPLONG plPadAxes = (LPLONG)&pcController->jsPadData;

	if( pcController->fMouse )
	{
		pcController->lMouseAxes[0] += g_msMouseState.lX * pcController->wMouseSensitivity * 3;
		pcController->lMouseAxes[1] += g_msMouseState.lY * pcController->wMouseSensitivity * 3;
		pcController->lMouseAxes[2] += g_msMouseState.lZ * pcController->wMouseSensitivity * 3;
	}

	BUTTON btnButton;
	bool b_Value;
	LONG l_Value;

	LONG lAxisValueX = ZEROVALUE;
	LONG lAxisValueY = ZEROVALUE;

	float d_ModifierX = (float)pcController->bStickRange / 100.0f;
	float d_ModifierY = (float)pcController->bStickRange / 100.0f;

	bool fModifier = ( pcController->nModifiers > 0 );
	int i = ( fModifier ) ? pcController->nModifiers-1 : 14-1;

	for( ; i >= 0; --i ) //Get N64-Buttons for
	{
		btnButton = ( fModifier)	? pcController->pModifiers[i].btnButton
									: pcController->aButton[i];
		
		switch ( btnButton.bType )
		{
		case DT_JOYBUTTON:
			b_Value = ( pcController->jsPadData.rgbButtons[btnButton.bOffset] & 0x80 ) != 0;
			break;

		case DT_JOYSLIDER:
		case DT_JOYAXE:
			l_Value = plPadAxes[btnButton.bOffset] - ZEROVALUE;

			if ( btnButton.bAxisID )
			{
				b_Value = ( l_Value <= -ABSTHRESHOLD );
			}
			else
			{
				b_Value = ( l_Value >= ABSTHRESHOLD );
			}		
			break;

		case DT_JOYPOV:
			b_Value = GetJoyPadPOV( (PULONG)&plPadAxes[btnButton.bOffset], btnButton.bAxisID );
			break;

		case DT_KEYBUTTON:
			b_Value = ( g_acKeystate[btnButton.bOffset] & 0x80 ) != 0;
			break;

		case DT_MOUSEBUTTON:
			b_Value = ( g_msMouseState.rgbButtons[btnButton.bOffset] & 0x80 ) != 0;
			break;

		case DT_MOUSEAXE:
			l_Value = MOUSEMOVE * pcController->wMouseSensitivity;

			if( btnButton.bAxisID )
			{
				b_Value = ( pcController->lMouseAxes[btnButton.bOffset] < -l_Value );
			}
			else
			{
				b_Value = ( pcController->lMouseAxes[btnButton.bOffset] > l_Value );
			}
			break;

		case DT_UNASSIGNED:
		default:
			b_Value = false;
		}

		if( fModifier )
		{
			bool fChangeMod = false;

			if( pcController->pModifiers[i].fSHandling )
			{ // Config-Type
				if( pcController->pModifiers[i].fToggle )
				{
					if( b_Value && !btnButton.fPrevPressed)
					{
						pcController->pModifiers[i].fStatus = !pcController->pModifiers[i].fStatus;
						fChangeMod = true;
					}
				}
				else
				{
					if(	b_Value != ( btnButton.fPrevPressed != 0 ))
						fChangeMod = true;
				}
			}
			else
			{ // Move / Macro Type
				if( pcController->pModifiers[i].fToggle )
				{
					if( b_Value && !btnButton.fPrevPressed )
						pcController->pModifiers[i].fStatus = !pcController->pModifiers[i].fStatus;
					fChangeMod = ( pcController->pModifiers[i].fStatus != 0 );
				}
				else
				{
					fChangeMod = b_Value;
				}
			}

			if( fChangeMod )
			{
				switch( pcController->pModifiers[i].bTyp )
				{
				case MDT_MOVE:
				{
					LPMODSPEC_MOVE args = (LPMODSPEC_MOVE)&pcController->pModifiers[i].dwSpecific;
					d_ModifierX *= args->XModification / 100.0f;
					d_ModifierY *= args->YModification / 100.0f;	
				}
					break;
				case MDT_MACRO:
				{
					LPMODSPEC_MACRO args = (LPMODSPEC_MACRO)&pcController->pModifiers[i].dwSpecific;

					if (args->fRapidFire) // w00t! Rapid Fire here
					{
						if ((unsigned) b_Value != btnButton.fPrevPressed) // New macro pressed
						{
							args->fPrevFireState = 0;
							args->fPrevFireState2 = 0;
						}
						if(!args->fPrevFireState) // This round, a firing is needed
						{
							w_Buttons |= args->aButtons;
							if( args->fAnalogRight )
								lAxisValueX += MAXAXISVALUE;
							else if( args->fAnalogLeft )
								lAxisValueX -= MAXAXISVALUE;

							if( args->fAnalogDown )
								lAxisValueY -= MAXAXISVALUE;
							else if( args->fAnalogUp ) // up
									lAxisValueY += MAXAXISVALUE;
						}

						// Ok, update the firing counters here
						if (args->fRapidFireRate) // Do the rapid fire slowly
						{ // Note that this updates State2 before State... Makes a nice slower square-wave type pulse for the update
							args->fPrevFireState2 = (args->fPrevFireState2 + 1) & 1;
							if (!args->fPrevFireState2)
							{
								args->fPrevFireState = (args->fPrevFireState + 1) & 1;
								DebugWrite("Slow Rapid Fire - Mark 2\n");
							}
						}
						else // Do a fast rapid fire
						{
							args->fPrevFireState = (args->fPrevFireState + 1) & 1;
							DebugWrite("Fast Rapid Fire\n");
						}
					}
					else
					{
						w_Buttons |= args->aButtons; // Note this: It lets you push buttons as well as the macro buttons
						if( args->fAnalogRight )
							lAxisValueX += MAXAXISVALUE;
						else if( args->fAnalogLeft )
							lAxisValueX -= MAXAXISVALUE;

						if( args->fAnalogDown )
							lAxisValueY -= MAXAXISVALUE;
						else if( args->fAnalogUp ) // up
							lAxisValueY += MAXAXISVALUE;

						args->fPrevFireState = 0;
					}
				}
					break;
				case MDT_CONFIG:
				{
					LPMODSPEC_CONFIG args = (LPMODSPEC_CONFIG)&pcController->pModifiers[i].dwSpecific;

					if( args->fChangeAnalogConfig )
					{
						BYTE bConfig = (BYTE)args->fAnalogStickMode;
						if( bConfig < PF_AXESETS )
							pcController->bAxisSet = bConfig;
						else
						{
							if( pcController->bAxisSet == PF_AXESETS-1 )
								pcController->bAxisSet = 0;
							else
								++pcController->bAxisSet;
						}

					}
					if( args->fChangeMouseXAxis )
						pcController->fAbsoluteMouseX = !pcController->fAbsoluteMouseX;
					if( args->fChangeMouseYAxis )
						pcController->fAbsoluteMouseY = !pcController->fAbsoluteMouseY;

					if( args->fChangeKeyBoardXAxis )
						pcController->fKeyAbsoluteX = !pcController->fKeyAbsoluteX;
					if( args->fChangeKeyBoardYAxis )
						pcController->fKeyAbsoluteY = !pcController->fKeyAbsoluteY;
				}
					break;
				}
			}

			btnButton.fPrevPressed = b_Value;
			pcController->pModifiers[i].btnButton = btnButton;

			if( i <= 0 )
			{
				fModifier = false;
				i = PF_APADR -1+1;
			}
		}
		else
			w_Buttons |= (((WORD)b_Value) << i);
	}

	LONG lDeadZoneValue = pcController->bPadDeadZone * RANGERELATIVE / 100;
	float fDeadZoneRelation	= (float)RANGERELATIVE  / (float)( RANGERELATIVE - lDeadZoneValue );

	bool fNegInput; // Input has to be negated

	for ( i = 0; i < 4; ++i )
	{
		//	0 : right
		//	1 : left
		//	2 : down
		//	3 : up

		fNegInput = (( i == 1 ) || ( i == 2 ));

		btnButton = pcController->aButton[PF_APADR + pcController->bAxisSet*sizeof(pcController->aButton[0]) + i];
		
		switch( btnButton.bType )
		{
		case DT_JOYBUTTON:
			l_Value = MAXAXISVALUE;
			b_Value = ( pcController->jsPadData.rgbButtons[btnButton.bOffset] & 0x80 ) != 0;
			break;

		case DT_JOYSLIDER:
		case DT_JOYAXE:
			l_Value = plPadAxes[btnButton.bOffset] - ZEROVALUE;

			if( btnButton.bAxisID ) // negative Range
			{
				fNegInput = !fNegInput;

				b_Value = ( l_Value <= -lDeadZoneValue );
				if( b_Value )
					l_Value = (LONG) ((float)(l_Value + lDeadZoneValue ) * fDeadZoneRelation );
			}
			else
			{
				b_Value = ( l_Value >= lDeadZoneValue );
				if( b_Value )
					l_Value = (LONG) ((float)(l_Value - lDeadZoneValue ) * fDeadZoneRelation );
			}	
			break;

		case DT_JOYPOV:
			l_Value = MAXAXISVALUE;
			b_Value = GetJoyPadPOV( (DWORD*)&plPadAxes[btnButton.bOffset], btnButton.bAxisID );
			break;

		case DT_KEYBUTTON:
			if( g_acKeystate[btnButton.bOffset] & 0x80 )
			{
				b_Value = true;

				if(( pcController->fKeyAbsoluteX && i < 2 )
					|| ( pcController->fKeyAbsoluteY &&  i > 1 ))
				{
					if( pcController->wAxeBuffer[i] < MAXAXISVALUE )
					{
						l_Value = pcController->wAxeBuffer[i] = min(( pcController->wAxeBuffer[i] + N64DIVIDER*3), MAXAXISVALUE );
					}
					else
						l_Value = MAXAXISVALUE;
				}
				else
				{
					if( pcController->wAxeBuffer[i] < MAXAXISVALUE )
					{
						l_Value = pcController->wAxeBuffer[i] = min(( pcController->wAxeBuffer[i] * 2 + N64DIVIDER*5 ), MAXAXISVALUE );
					}
					else
						l_Value = MAXAXISVALUE;
				}
			}
			else
			{
				if(( pcController->fKeyAbsoluteX && i < 2 )
					|| ( pcController->fKeyAbsoluteY && i > 1 ))
				{
					l_Value = pcController->wAxeBuffer[i];
					b_Value = true;
				}
				else
				{
					if( pcController->wAxeBuffer[i] > N64DIVIDER )
					{
						b_Value = true;
						l_Value = pcController->wAxeBuffer[i] = pcController->wAxeBuffer[i] / 2 ;
					}
					else
						b_Value = false;
				}
			}
			break;

		case DT_MOUSEBUTTON:
			l_Value = MAXAXISVALUE;
			b_Value = ( g_msMouseState.rgbButtons[btnButton.bOffset] & 0x80 ) != 0;
			break;

		case DT_MOUSEAXE:
			l_Value = pcController->lMouseAxes[btnButton.bOffset];

			if( btnButton.bAxisID )
			{
				fNegInput = !fNegInput;

				b_Value = ( l_Value < ZEROVALUE );
			}
			else
			{
				b_Value = ( l_Value > ZEROVALUE );
			}
			break;
		
		case DT_UNASSIGNED:
		default:
			b_Value = false;
		}

		if ( b_Value )
		{
			if ( fNegInput )
				l_Value = -l_Value;
			
			if( i < 2 )
				lAxisValueX += l_Value;
			else
				lAxisValueY += l_Value;
		}
	}

	if( pcController->fMouse )
	{
		if( pcController->fAbsoluteMouseX )
			pcController->lMouseAxes[0] = min( max( MINAXISVALUE, pcController->lMouseAxes[0]) , MAXAXISVALUE);
		else
			pcController->lMouseAxes[0] = pcController->lMouseAxes[0] * 80 / 100;

		if( pcController->fAbsoluteMouseY )
			pcController->lMouseAxes[1] = min( max( MINAXISVALUE, pcController->lMouseAxes[1]) , MAXAXISVALUE);
		else
			pcController->lMouseAxes[1] = pcController->lMouseAxes[1] * 80 / 100;
		pcController->lMouseAxes[2] = 0;
	}

	if( pcController->fKeyboard )
	{
		if( pcController->fKeyAbsoluteX )
		{
			if( pcController->wAxeBuffer[0] > pcController->wAxeBuffer[1] )
			{
				pcController->wAxeBuffer[0] -= pcController->wAxeBuffer[1];
				pcController->wAxeBuffer[1] = 0;
			}
			else
			{
				pcController->wAxeBuffer[1] -= pcController->wAxeBuffer[0];
				pcController->wAxeBuffer[0] = 0;
			}
		}
		if( pcController->fKeyAbsoluteY )
		{
			if( pcController->wAxeBuffer[2] > pcController->wAxeBuffer[3] )
			{
				pcController->wAxeBuffer[2] -= pcController->wAxeBuffer[3];
				pcController->wAxeBuffer[3] = 0;
			}
			else
			{
				pcController->wAxeBuffer[3] -= pcController->wAxeBuffer[2];
				pcController->wAxeBuffer[2] = 0;
			}
		}
	}


	if (pcController->bRapidFireEnabled) {
		if (pcController->bRapidFireCounter >= pcController->bRapidFireRate || pcController->bRapidFireCounter < 0) {
			w_Buttons = (w_Buttons & 0xFF1F);
			pcController->bRapidFireCounter = 0;
		} else{
			pcController->bRapidFireCounter = pcController->bRapidFireCounter + 1;
		}
	}

	if( pcController->fRealN64Range && ( lAxisValueX || lAxisValueY ))
	{
		LONG lAbsoluteX = ( lAxisValueX > 0 ) ? lAxisValueX : -lAxisValueX;
		LONG lAbsoluteY = ( lAxisValueY > 0 ) ? lAxisValueY : -lAxisValueY;

		LONG lRangeX;
		LONG lRangeY;

		if(	lAbsoluteX > lAbsoluteY )
		{
			lRangeX = MAXAXISVALUE;
			lRangeY = lRangeX * lAbsoluteY / lAbsoluteX;
		}
		else
		{
			lRangeY = MAXAXISVALUE;
			lRangeX = lRangeY * lAbsoluteX / lAbsoluteY;
		}

		float fRangeDiagonal = (float)lRangeX * (float)lRangeX + (float)lRangeY * (float)lRangeY;
		__asm{
			fld fRangeDiagonal
			fsqrt
			fstp fRangeDiagonal
			fwait
		}
		float fRel = (float)MAXAXISVALUE / (float)fRangeDiagonal;

		*pdwData = MAKELONG(w_Buttons,
							MAKEWORD(	(BYTE)(min( max( MINAXISVALUE, (LONG)(lAxisValueX * d_ModifierX * fRel )), MAXAXISVALUE) / N64DIVIDER ),
										(BYTE)(min( max( MINAXISVALUE, (LONG)(lAxisValueY * d_ModifierY * fRel )), MAXAXISVALUE) / N64DIVIDER )));
	}
	else
	{
		*pdwData = MAKELONG(w_Buttons,
							MAKEWORD(	(BYTE)(min( max( MINAXISVALUE, (LONG)(lAxisValueX * d_ModifierX )), MAXAXISVALUE) / N64DIVIDER ),
										(BYTE)(min( max( MINAXISVALUE, (LONG)(lAxisValueY * d_ModifierY )), MAXAXISVALUE) / N64DIVIDER )));
	}
	

	return true;
}

bool InitDirectInput( HWND hWnd )
{
	if( g_hDirectInputDLL == NULL )
		g_hDirectInputDLL = LoadLibrary( TEXT( "dinput8.dll" ));
	if( g_hDirectInputDLL == NULL )
		MessageBox( hWnd, TEXT("dinput8.dll not found\nFix the DirectX Installation"), PLUGINERROR, MB_ICONSTOP | MB_OK );

	if( !g_pDIHandle && g_hDirectInputDLL ) // zeigt auf NULL falls nicht initialisiert
	{
		HRESULT (WINAPI *lpGetDIHandle)( HINSTANCE, DWORD, REFIID, LPVOID*, LPUNKNOWN ) = NULL;
		lpGetDIHandle = (HRESULT (WINAPI *)( HINSTANCE, DWORD, REFIID, LPVOID*, LPUNKNOWN ))GetProcAddress( g_hDirectInputDLL, TEXT("DirectInput8Create") );

		if( lpGetDIHandle != NULL )
		{
			HRESULT hr;
			hr = lpGetDIHandle( g_hinstDll, DIRECTINPUT_VERSION, 
								IID_IDirectInput8, (LPVOID*)&g_pDIHandle, NULL );
			if( FAILED( hr ))
			{
				MessageBox( hWnd, TEXT("Could not create DirectInput Object for wathever reason."), PLUGINERROR, MB_ICONSTOP | MB_OK );
				g_pDIHandle = NULL;
				FreeLibrary( g_hDirectInputDLL );
				g_hDirectInputDLL = NULL;
			}
		}
	}

	return (g_pDIHandle != NULL);
}

void ReleaseDevice( LPDIRECTINPUTDEVICE8 &lpDirectInputDevice )
{
	if( lpDirectInputDevice != NULL )
	{
		lpDirectInputDevice->Unacquire();
		lpDirectInputDevice->Release();
		lpDirectInputDevice = NULL;
	}
	return;
}

void ReleaseEffect( LPDIRECTINPUTEFFECT &lpDirectEffect )
{
	if( lpDirectEffect != NULL )
	{
		lpDirectEffect->Release();
		lpDirectEffect = NULL;
	}
	return;
}

void FreeDirectInput ()
{
	for( int i = 0; i < ARRAYSIZE( g_apdiEffect ); ++i )
		ReleaseEffect( g_apdiEffect[i] );
	for( i = 0; i << ARRAYSIZE(g_apInputDevice); ++i )
		ReleaseDevice( g_apInputDevice[i] );
    

    // Release any DirectInput objects.
	if( g_pDIHandle != NULL )
	{
		g_pDIHandle->Release();
		g_pDIHandle = NULL;
	}
	if( g_hDirectInputDLL != NULL )
	{
		FreeLibrary( g_hDirectInputDLL );
		g_hDirectInputDLL = NULL;
	}
	return;
}

inline HRESULT AcquireDevice( LPDIRECTINPUTDEVICE8 lpDirectInputDevice )
{
	HRESULT hResult;
	hResult = lpDirectInputDevice->Acquire();
	while( hResult == DIERR_INPUTLOST )
		hResult = lpDirectInputDevice->Acquire();
	if( SUCCEEDED( hResult ))
		lpDirectInputDevice->Poll();
	return hResult;
}

BOOL CALLBACK EnumGetEffectTypes( LPCDIEFFECTINFO pdei, LPVOID pvRef )
{
	BYTE bFFType = *(LPBYTE)pvRef;
	bFFType |= ( pdei->dwEffType & DIEFT_CONSTANTFORCE )	? RUMBLE_CONSTANT : 0;
	bFFType |= ( pdei->dwEffType & DIEFT_RAMPFORCE )		? RUMBLE_RAMP : 0;
	bFFType |= ( pdei->dwEffType & DIEFT_CONDITION )		? RUMBLE_CONDITION : 0;
	bFFType |= ( pdei->dwEffType & DIEFT_PERIODIC )			? RUMBLE_PERIODIC : 0;
	bFFType |= ( pdei->dwEffType & DIEFT_CUSTOMFORCE )		? RUMBLE_CUSTOM : 0;
	*(WORD*)pvRef = bFFType;
	return DIENUM_CONTINUE;
}

BOOL CALLBACK EnumMakeDeviceList( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef )
{
	int nDevice = *((int*)((LPVOID*)pvRef)[0]);
	LPDEVICE devsDeviceList = (LPDEVICE)((LPVOID*)pvRef)[1];

	if(	( LOBYTE(lpddi->dwDevType) == DI8DEVTYPE_GAMEPAD )	||
		( LOBYTE(lpddi->dwDevType) == DI8DEVTYPE_JOYSTICK )	||
		( LOBYTE(lpddi->dwDevType) == DI8DEVTYPE_DRIVING )	||
		( LOBYTE(lpddi->dwDevType) == DI8DEVTYPE_1STPERSON ) )
	{
		lstrcpy( devsDeviceList[nDevice].szProductName, lpddi->tszProductName );
		devsDeviceList[nDevice].dwDevType = lpddi->dwDevType;
		devsDeviceList[nDevice].guidInstance = lpddi->guidInstance;

		devsDeviceList[nDevice].bProductCounter = 0; // counting similar devices
		for( int i = 0; i < nDevice; ++i )
		{
			if( !lstrcmp( lpddi->tszProductName, devsDeviceList[i].szProductName ))
			{
				if( devsDeviceList[nDevice].bProductCounter == 0 )
				{
					devsDeviceList[nDevice].bProductCounter = 2;
					if( devsDeviceList[i].bProductCounter == 0 )
						devsDeviceList[i].bProductCounter = 1;
				}
				else
					++devsDeviceList[nDevice].bProductCounter; // give em instance numbers
			}
		}
		if( !lstrcmp( lpddi->tszProductName, TEXT( STRING_ADAPTOID )))
			devsDeviceList[nDevice].bEffType = RUMBLE_DIRECT;
		else
			devsDeviceList[nDevice].bEffType = RUMBLE_NONE;

		LPDIRECTINPUTDEVICE8 lpDirectInputDevice;

		g_pDIHandle->CreateDevice( lpddi->guidInstance, &lpDirectInputDevice, NULL);
		lpDirectInputDevice->EnumEffects( EnumGetEffectTypes, &devsDeviceList[nDevice].bEffType, DIEFT_ALL );
		lpDirectInputDevice->Release();

		*((int*)((LPVOID*)pvRef)[0]) = ++nDevice;
	}

	return ( nDevice < ARRAYSIZE(g_devList) ) ? DIENUM_CONTINUE : DIENUM_STOP;
}

BOOL CALLBACK EnumIsDeviceAvailable( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef )
{
	if( lpddi->guidInstance == *(GUID*)((LPVOID*)pvRef)[0] )
	{
		*(bool*)((LPVOID*)pvRef)[1] = true;
		return DIENUM_STOP;
	}

	return DIENUM_CONTINUE;
}

BOOL CALLBACK EnumSetObjectsAxis( LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef)
{
	LPDIRECTINPUTDEVICE8 lpDirectInputDevice = (LPDIRECTINPUTDEVICE8)pvRef;
	DIPROPRANGE diprg; 

	diprg.diph.dwSize       = sizeof(DIPROPRANGE);
	diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diprg.diph.dwHow        = DIPH_BYID;
	diprg.diph.dwObj        = lpddoi->dwType;
	diprg.lMin              = MINAXISVALUE;
	diprg.lMax              = MAXAXISVALUE;
	
	lpDirectInputDevice->SetProperty(DIPROP_RANGE, &diprg.diph);

	return DIENUM_CONTINUE;
}

bool GetInputDevice( HWND hWnd, LPDIRECTINPUTDEVICE8 &lpDirectInputDevice, GUID gGuid, DWORD dwDevType, DWORD dwCooperativeLevel )
{
	if( lpDirectInputDevice )
	{
		DIDEVICEINSTANCE didDev;
		didDev.dwSize = sizeof(DIDEVICEINSTANCE);
		lpDirectInputDevice->GetDeviceInfo( &didDev );

		if( didDev.guidInstance == gGuid )
		{
			lpDirectInputDevice->Unacquire();
			lpDirectInputDevice->SetCooperativeLevel( hWnd, dwCooperativeLevel );
			return true;
		}
		else
			ReleaseDevice( lpDirectInputDevice );
	}

	HRESULT hResult;
	
	LPCDIDATAFORMAT ppDiDataFormat = NULL;
	bool Succed = false;
	bool GamePad = false;

	switch( LOBYTE(dwDevType) )
	{
	case DI8DEVTYPE_GAMEPAD:
	case DI8DEVTYPE_JOYSTICK:
	case DI8DEVTYPE_DRIVING:
	case DI8DEVTYPE_1STPERSON:
		ppDiDataFormat = &c_dfDIJoystick;
		break;
		
	case DI8DEVTYPE_KEYBOARD:
		ppDiDataFormat = &c_dfDIKeyboard;
		break;

	case DI8DEVTYPE_MOUSE:
		ppDiDataFormat = &c_dfDIMouse2;
		break;

	default:
		return false;
	}

	bool bDeviceAvailable = false;
		
	VOID* aRef[2] = { &gGuid, &bDeviceAvailable };
		
	g_pDIHandle->EnumDevices( LOBYTE(dwDevType), EnumIsDeviceAvailable, (LPVOID)aRef, DIEDFL_ATTACHEDONLY );
		
	if( !bDeviceAvailable )
		return false;
		
	hResult = g_pDIHandle->CreateDevice( gGuid, &lpDirectInputDevice, NULL );
	
	if( SUCCEEDED( hResult ))
	{
		lpDirectInputDevice->SetDataFormat( ppDiDataFormat );
		hResult = lpDirectInputDevice->SetCooperativeLevel( hWnd, dwCooperativeLevel );
		
		Succed = SUCCEEDED( hResult );
	}

	if( Succed && ( ppDiDataFormat == &c_dfDIJoystick ))
		lpDirectInputDevice->EnumObjects( EnumSetObjectsAxis, lpDirectInputDevice, DIDFT_AXIS );

	return Succed;
}

BOOL CALLBACK EnumCountFFAxes( LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pnAxes )
{
	*(DWORD*)pnAxes += 1;
	return DIENUM_CONTINUE;
}

bool CreateEffectHandle( HWND hWnd, LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPDIRECTINPUTEFFECT &pDIEffect, BYTE bRumbleTyp, LONG lStrength )
{
	if( pDIEffect )
		ReleaseEffect( pDIEffect );

	if( !lpDirectInputDevice || bRumbleTyp == RUMBLE_DIRECT )
		return false;	

	DWORD nAxes = 0;
	DWORD rgdwAxes[] = { DIJOFS_X, DIJOFS_Y };

	HRESULT hResult;

	// count the FF - axes of the joystick
	lpDirectInputDevice->EnumObjects( EnumCountFFAxes, &nAxes, DIDFT_FFACTUATOR | DIDFT_AXIS );

	if( nAxes == 0 )
		return false;
	nAxes = min( nAxes, 2 );


	// Must be unaquired for setting stuff like Co-op Level
	lpDirectInputDevice->Unacquire();
	//FF Requires EXCLUSIVE LEVEL, took me hours to find the reason why it wasnt working
	lpDirectInputDevice->SetCooperativeLevel( hWnd, DISCL_EXCLUSIVE | DISCL_BACKGROUND );
    // Since we will be playing force feedback effects, we should disable the
    // auto-centering spring.
	DIPROPDWORD dipdw;
    dipdw.diph.dwSize       = sizeof(DIPROPDWORD);
    dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
    dipdw.diph.dwObj        = 0;
    dipdw.diph.dwHow        = DIPH_DEVICE;
    dipdw.dwData            = FALSE;
	
	hResult = lpDirectInputDevice->SetProperty( DIPROP_AUTOCENTER, &dipdw.diph );

	LONG rglDirection[] = { 1, 1 };
	LPGUID EffectGuid;
    DIEFFECT eff;
    ZeroMemory( &eff, sizeof(eff) );

	eff.dwSize                  = sizeof(DIEFFECT);
	eff.dwFlags                 = DIEFF_CARTESIAN | DIEFF_OBJECTOFFSETS;
	eff.dwGain                  = lStrength * 100;
    eff.dwTriggerButton         = DIEB_NOTRIGGER;
    eff.dwTriggerRepeatInterval = 0;
    eff.cAxes                   = nAxes; //Number of Axes
    eff.rgdwAxes                = rgdwAxes;
    eff.rglDirection            = rglDirection;
    eff.lpEnvelope              = NULL;
	eff.dwStartDelay            = 0;

	DICONSTANTFORCE cf;
	DIRAMPFORCE rf;
	DIPERIODIC pf;

	switch( bRumbleTyp )
	{
	case RUMBLE_CONSTANT:
		EffectGuid = (GUID*)&GUID_ConstantForce;

		eff.dwDuration              = 150000; // miliseconds
		eff.dwSamplePeriod          = 0;
		eff.cbTypeSpecificParams    = sizeof(DICONSTANTFORCE);
		eff.lpvTypeSpecificParams   = &cf;

		cf.lMagnitude = 10000;
		break;
	case RUMBLE_RAMP:
		EffectGuid = (GUID*)&GUID_RampForce;
		
		eff.dwDuration              = 300000; // miliseconds
		eff.dwSamplePeriod          = 0;
		eff.cbTypeSpecificParams    = sizeof(DIRAMPFORCE);
		eff.lpvTypeSpecificParams   = &rf;

		rf.lStart = 10000;
		rf.lEnd = 2000;
		break;
	
	case RUMBLE_CONDITION:
	case RUMBLE_PERIODIC:
		EffectGuid = (GUID*)&GUID_Sine;

		eff.dwDuration              = 150000; // miliseconds
		eff.dwSamplePeriod          = 0;
		eff.cbTypeSpecificParams    = sizeof(DIPERIODIC);
		eff.lpvTypeSpecificParams   = &pf;

		pf.dwMagnitude = 10000;
		pf.lOffset = 0;
		pf.dwPhase = 0;
		pf.dwPeriod = 2000;
		break;

	case RUMBLE_NONE:
	case RUMBLE_CUSTOM:
	default:
		return false;
	}

	hResult = lpDirectInputDevice->CreateEffect( *EffectGuid, &eff, &pDIEffect, NULL );
	
	return SUCCEEDED( hResult );
}

DWORD CountControllerStructDevs( CONTROLLER *pController )
{
	BYTE bMouse = 0, bKeyBoard = 0, bGamePad = 0;
	BYTE bDType;

	bool fModifier = ( pController->pModifiers != NULL );
	int i = ( fModifier ) ? pController->nModifiers : ARRAYSIZE( pController->aButton );
	i--;

	for( ; i >= 0 || fModifier; --i )
	{
		if( i < 0 )
		{
			i = ARRAYSIZE( pController->aButton ) - 1;
			fModifier = false;
		}

		bDType = ( fModifier )	? pController->pModifiers[i].btnButton.bType
								: pController->aButton[i].bType;

		switch( bDType )
		{
		case DT_JOYBUTTON:
		case DT_JOYAXE:
		case DT_JOYSLIDER:
		case DT_JOYPOV:
			++bGamePad;
			break;

		case DT_KEYBUTTON:
			++bKeyBoard;
			break;

		case DT_MOUSEBUTTON:
		case DT_MOUSEAXE:
			++bMouse;
			break;
		}
	}

	pController->fGamePad	= bGamePad != 0;
	pController->fKeyboard	= bKeyBoard != 0;
	pController->fMouse		= bMouse != 0;

	return MAKELONG( MAKEWORD( bGamePad, bMouse ), MAKEWORD( bKeyBoard, ( bMouse + bKeyBoard + bGamePad )));
}

bool PrepareInputDevices()
{
	bool fKeyBoard = false;
	bool fMouse = false;
	bool fGamePad = false;

	for( int i = 0; i < ARRAYSIZE( g_pcControllers ); ++i )
	{
		fGamePad = false;
		if( g_pcControllers[i].fPlugged )
		{
			CountControllerStructDevs( &g_pcControllers[i] );

			fKeyBoard = g_pcControllers[i].fKeyboard != 0;
			fMouse = g_pcControllers[i].fMouse != 0;
			fGamePad = ( g_pcControllers[i].fGamePad && g_pcControllers[i].dwDevType );
		}

		if( fGamePad )
		{
			ReleaseEffect( g_apdiEffect[i] );
			if( GetInputDeviceNr( DID_GAMEPAD + i, g_pcControllers[i].guidPadDevice, g_pcControllers[i].dwDevType, DIB_GAMEPAD ))
			{
				DIDEVICEINSTANCE diDev;
				diDev.dwSize = sizeof( DIDEVICEINSTANCE );

				g_apInputDevice[DID_GAMEPAD + i]->GetDeviceInfo( &diDev );

				if( !lstrcmp( diDev.tszProductName, TEXT( STRING_ADAPTOID )))
					g_pcControllers[i].fIsAdaptoid = true;
				else
					g_pcControllers[i].fIsAdaptoid = false;

				AcquireDevice( g_apInputDevice[DID_GAMEPAD + i] );
			}
		}
		else
		{
			ReleaseEffect( g_apdiEffect[i] );
			ReleaseDevice( g_apInputDevice[DID_GAMEPAD + i] );
		}
	}

	if( fKeyBoard )
	{
		if( !g_apInputDevice[DID_KEYBOARD] )
		{
			if( GetInputDeviceNr( DID_KEYBOARD, GUID_SysKeyboard, DI8DEVTYPE_KEYBOARD, DIB_KEYBOARD ))
				AcquireDevice( g_apInputDevice[DID_KEYBOARD] );
		}
	}
	else
		ReleaseDevice( g_apInputDevice[DID_KEYBOARD] );

	if( fMouse )
	{
		if( !g_apInputDevice[DID_MOUSE] )
		{
			if( GetInputDeviceNr( DID_MOUSE, GUID_SysMouse, DI8DEVTYPE_MOUSE , DIB_MOUSE ))
			{
				AcquireDevice( g_apInputDevice[DID_MOUSE] );
				g_bExclusiveMouse = true;
			}
		}
	}
	else
	{
		ReleaseDevice( g_apInputDevice[DID_MOUSE] );
		g_bExclusiveMouse = false;
	}

	return true;
}

bool IsAdaptoidCommandSupported( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD cmd )
{
    DIEFFESCAPE esc;
    DWORD inbuf, outbuf;
    HRESULT hr;

	esc.dwSize = sizeof(esc);
	esc.dwCommand = ADAPT_TEST;   // command to determine if a command is supported
	esc.lpvInBuffer = &inbuf;
	esc.cbInBuffer = 4;
	esc.lpvOutBuffer = &outbuf;   
	esc.cbOutBuffer = 4;
	inbuf = cmd;                  // command that we are asking is supported
	outbuf = 0;                   

	hr = lpDirectInputDevice->Escape(&esc);

    return( SUCCEEDED(hr) && esc.cbOutBuffer == 4 && outbuf == 0xB0CAB0CA );
}


void _debugAd( LPSTR szMessage, HRESULT res )
{
	LPSTR suc = (SUCCEEDED(res)) ? "OK" : "FAILED";

	DebugWriteA( "%s: %s (RC:%08X)\n", szMessage, suc, res );
}

HRESULT DirectRumbleCommand( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD cmd )
{
    DIEFFESCAPE esc;

    esc.dwSize = sizeof(esc);
    esc.dwCommand = ADAPT_RUMBLE;   // send rumble command
    esc.lpvInBuffer = &cmd;  // 1=go, 0=stop
    esc.cbInBuffer = 4;
    esc.lpvOutBuffer = NULL;   
    esc.cbOutBuffer = 0;

	HRESULT hr = lpDirectInputDevice->Escape(&esc);

#ifdef _DEBUG
	_debugAd( "Direct Adaptoid RumbleCommand", hr );
#endif // #ifdef _DEBUG

    return hr;
}

HRESULT InitializeAdaptoid( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, LPBYTE status )
{
    DIEFFESCAPE esc;

    esc.dwSize = sizeof(esc);
    esc.dwCommand = ADAPT_INIT;   // Initialize Pak
    esc.lpvInBuffer = NULL;
    esc.cbInBuffer = 0;
    esc.lpvOutBuffer = status;   
    esc.cbOutBuffer = 1;

	HRESULT hr = lpDirectInputDevice->Escape(&esc);

#ifdef _DEBUG
	_debugAd( "Direct Adaptoid InitPak", hr );
#endif // #ifdef _DEBUG

    return hr;
}

HRESULT ReadAdaptoidPak( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD addr, LPBYTE data )
{
    DIEFFESCAPE esc;

    esc.dwSize = sizeof(esc);
    esc.dwCommand = ADAPT_READPAK;   // Read 32 bytes from pak
    esc.lpvInBuffer = &addr;
    esc.cbInBuffer = 4;
    esc.lpvOutBuffer = data;   
    esc.cbOutBuffer = 32;

	HRESULT hr = lpDirectInputDevice->Escape(&esc);

#ifdef _DEBUG
	LPSTR suc = (SUCCEEDED(hr)) ? "OK" : "FAILED";

	DebugWriteA( "Direct Adaptoid ReadPak(Addr:%04X): %s (RC:%08X)\n", addr, suc, hr );
#endif // #ifdef _DEBUG

    return hr;
}

HRESULT WriteAdaptoidPak( LPDIRECTINPUTDEVICE8 lpDirectInputDevice, DWORD addr, LPBYTE data )
{
    DIEFFESCAPE esc;
    struct
    {
        DWORD addr;
        BYTE data[32];
    } buf;

    buf.addr = addr;
    CopyMemory( buf.data, data, 32 );

    esc.dwSize = sizeof(esc);
    esc.dwCommand = ADAPT_WRITEPAK;   // Write 32 bytes to pak
    esc.lpvInBuffer = &buf;
    esc.cbInBuffer = 36;
    esc.lpvOutBuffer = NULL;   
    esc.cbOutBuffer = 0;
	
	HRESULT hr = lpDirectInputDevice->Escape(&esc);

#ifdef _DEBUG
	LPSTR suc = (SUCCEEDED(hr)) ? "OK" : "FAILED";

	DebugWriteA( "Direct Adaptoid WritePak(Addr:%04X): %s (RC:%08X)\n", addr, suc, hr );
#endif // #ifdef _DEBUG

    return hr;
}

BYTE GetAdaptoidStatus( LPDIRECTINPUTDEVICE8 lpDirectInputDevice )
{
	HRESULT hr;
	BYTE bStatus = 0;
	hr = InitializeAdaptoid( lpDirectInputDevice, &bStatus );

	int iRetrys = 10;
	while( FAILED( hr ) && iRetrys > 0 )
	{
		Sleep( 5 );
		hr = AcquireDevice( lpDirectInputDevice );
		hr = InitializeAdaptoid( lpDirectInputDevice, &bStatus );
		iRetrys--;
	}

	return (SUCCEEDED(hr)) ? bStatus : RD_NOPLUGIN | RD_NOTINITIALIZED;
}