/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <windows.h>
#include "commonIncludes.h"
#include "Fileacces.h"

bool bDebug = true;


HANDLE hDebug = INVALID_HANDLE_VALUE;


void _DebugAnsiFileWrite( CONST LPSTR szRemark )
{
	if( !bDebug )
		return;
	int i = 0;
	for( i = 0; hDebug == INVALID_HANDLE_VALUE && i < 10; ++i )
	{
		TCHAR szFile[100];
		TCHAR szBuffer[MAX_PATH+1];
		wsprintf( szFile, TEXT( "NRage-Debug%i.txt" ), i );
		GetAbsoluteFileName( szBuffer, szFile, DIRECTORY_APPLICATION );
		hDebug = CreateFile( szBuffer, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	}

	if( hDebug != INVALID_HANDLE_VALUE )
	{
		DWORD dwWritten;
		LPSTR szText = (LPSTR)szRemark;
		if( szText == NULL )
			szText = "\r\n";

		LPSTR szCurrPos = szText;

		while( ( szCurrPos = n_strchrA( szCurrPos, '\n' )) != NULL )
		{
			DWORD lenght = szCurrPos - szText;
			if( lenght > 0 && szCurrPos[-1] == '\r' )
				--lenght;

			if( lenght > 0 )
				WriteFile( hDebug, (LPCVOID)szText, lenght, &dwWritten, NULL );
			WriteFile( hDebug, "\r\n", 2, &dwWritten, NULL );

			szText = ++szCurrPos;
		}

		DWORD lenght = lstrlenA( szText );

		if( lenght > 0 )
            WriteFile( hDebug, (LPCVOID)szText, lenght, &dwWritten, NULL );
	}
	return;
}

void _cdecl _DebugWriteA( CONST LPSTR szFormat, ... )
{
	if( szFormat != NULL )
	{
		CHAR szBuffer[4096];

		va_list val;

		va_start( val,szFormat );
		wvsprintfA( szBuffer, szFormat, val );
		va_end( val );
		szBuffer[sizeof(szBuffer)-1] = '\0';

		_DebugAnsiFileWrite( szBuffer );
	}
	else
        _DebugAnsiFileWrite( NULL );
}

void _cdecl _DebugWriteW( CONST LPWSTR szFormat, ... )
{
	if( szFormat != NULL )
	{
		WCHAR szBuffer[4096];
		va_list val;

		va_start( val,szFormat );
		wvsprintfW( szBuffer, szFormat, val );
		va_end( val );
		szBuffer[sizeof(szBuffer)-1] = '\0';

		CHAR szAnsi[sizeof(szBuffer)];
		WideCharToMultiByte( CP_ACP, 0, szBuffer, -1, szAnsi, sizeof(szAnsi), NULL, NULL );
		_DebugAnsiFileWrite( szAnsi );
	}
	else
		_DebugAnsiFileWrite( NULL );
}

void _WriteDatasA( LPSTR Header, LPBYTE Data, HRESULT hr )
{
	if( !bDebug )
		return;

	_DebugAnsiFileWrite( Header );
	_DebugAnsiFileWrite( NULL );
	
	if( hr )
	{
		_DebugWriteA( "Failed! ErrorCode: %08X\n", hr );
	}


	int iEnd = Data[0] + Data[1] + 2;

	for( int i = -1; i < iEnd; i += 8 )
	{
		_DebugWriteA( "%02X%02X%02X%02X %02X%02X%02X%02X\n", Data[i+0], Data[i+1], Data[i+2], Data[i+3], Data[i+4], Data[i+5], Data[i+6], Data[i+7] );
	}

	return;
}

void _CloseDebugFile()
{
	if( hDebug != INVALID_HANDLE_VALUE )
		CloseHandle( hDebug );
}