/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _DATABUFFERCLASS_
#define _DATABUFFERCLASS_

//needs <wtypes.h>, <winbase.h>... they should be included in .cpp before this header is included
//DefaultBuffersize = 64KBytes
#define DBC_DEFAULTBUFFERSIZE	65536 // 64KByte


// ErrorCodes
#define DBC_OK				0x0000L
#define DBC_FILEERROR		0x0100L
#define DBC_FILEOPENFAILED	0x0101L
#define DBC_WRITEFAILED		0x0102L
#define DBC_READFAILED		0x0103L
#define DBC_ENDOFFILE		0x0104L

#define DBC_NOFILEBUFFERED	0x0110L

#define DBC_CANTALLOCATEMEM	0x0200L

#define DBC_UNKNOWN			0xFFFFL


class DataBuffer
{
private:
	TCHAR szFile[MAX_PATH + 1];	// Filename
	HANDLE hFile;				// Handle to file
	bool bFileReadOnly;
	bool bBufferChange;			// BufferContent got altered
	BYTE Bufferhit( ULONG Offset, ULONG nBytes ); // Determines if the requested Data is (partially) Buffered

protected:
	DWORD dwBuffersize,			// Size of Buffer
		  dwFileSize,			// Size of the File
		  dwBufferFill,			// How much of Buffer is used
		  dwBufferIndex;		// absolute Offset of the Buffer-Content in the File

	BYTE *aBufferedData;		// the Buffer-Aray
	DWORD StoreBuffer();						// writes Buffer where it belongs
	DWORD LoadBuffer( ULONG Offset );			// loads from File to Buffer

public:
	DataBuffer( const TCHAR *szFileName = NULL, ULONG nBytes = DBC_DEFAULTBUFFERSIZE, bool bCreate = false, bool bFileReadOnly = false ); // Konstruktor and set Buffersize and File
	~DataBuffer();	// Destruktor

	DWORD SetBufferSize( ULONG nBytes );		// Sets size of the File-Buffer
	DWORD SetFile( const TCHAR *szFileName, bool bCreate = false, bool bFileReadOnly = false );	// Chooses File to Buffer
	DWORD CloseFile();							// Closes File
	DWORD ReadBFile( ULONG Offset, ULONG nBytes, void *Destination );	// Reads from File/Buffer
	DWORD WriteBFile( ULONG Offset, ULONG nBytes, void *Source );		// Writes to File/Buffer
	DWORD InsertBlock( ULONG Offset, ULONG nBytes, void *Source );		// Inserts nBytes at Offset. If Source is not NULL the Source will be written.
	DWORD RemoveBlock( ULONG Offset, DWORD nBytes );					// // Removes nBytes at Offset and truncates file

	DWORD ReadLine( ULONG Offset, TCHAR *szLine, int iSize); 
};



#endif // _DATABUFFERCLASS_
