#include <nds.h>
#include <nds/arm9/console.h>
#include <nds/system.h>
  
#include "console.h"
#include "sound.h"
#include "mediasrc.h"
 
#include "Event.h"
#include "StellaEvent.h"
#include "EventHandler.h"

#include <gbfs.h>

extern const GBFS_FILE data_gbfs;
 
Console* theConsole = (Console*) NULL;
Sound* theSound = (Sound*) NULL;

int menupos = 0;
bool oldUp = false;
bool oldDown = false;
 
void setuppalette();
void updateframebuffer();
void checkkeys();
void inittextmenu();
 
void WaitForVblank()
{
	while(DISP_Y!=192);
	while(DISP_Y==192);
}
 
int main(void)
{
	POWER_CR=POWER_ALL;
	WAIT_CR=0xe800;
 
	DISPLAY_CR=MODE_5_2D | DISPLAY_BG3_ACTIVE;
	VRAM_A_CR=VRAM_ENABLE | VRAM_A_MAIN_BG_0x6000000;

	BG3_CR = BG_BMP8_256x256;
	BG3_XDX = 171;
	BG3_YDY = 1 << 8;
  
	for(int i=0;i<256*128;i++)
		BG_GFX[i]=0;
		
	inittextmenu();
 
    theSound = new Sound();
    
    uInt32 bin_size;
	uInt8 *gbfsfile = (uInt8 *)gbfs_get_nth_obj(&data_gbfs, menupos, NULL, &bin_size);
	theConsole = new Console(gbfsfile, bin_size, "et.bin", *theSound);
 
	setuppalette();
 
	while(1)
	{
		checkkeys();
		theConsole->update();
		updateframebuffer();
	}
 
	return 0;
}

void inittextmenu()
{
	bool loop = true;

	lcdSwap();

	int counter = gbfs_count_objs(&data_gbfs);

	vramSetBankC(VRAM_C_SUB_BG); 
 	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	iprintf("StellaDS 0.4.5\n");
	iprintf("Ported By TheChuckster\n");
	iprintf("thechuckster.homelinux.com\n");
	iprintf("%d ROMs detected.\n\n", counter);
	
	char *romname;
	
	for(int i=0; i<counter; i++)
	{
		gbfs_get_nth_obj(&data_gbfs, i, romname, NULL);
		iprintf("  %s\n", romname);
	}
		
	while(loop == true)
	{
		scanKeys();
		
		if ((keysHeld() & (KEY_UP)) && !oldDown)
		{
			iprintf("\x1b[%d;0H ", menupos + 5);
			menupos--;
			if (menupos <= -1) menupos = 0;
		}

		if ((keysHeld() & (KEY_DOWN)) && !oldUp)
		{
			iprintf("\x1b[%d;0H ", menupos + 5);
			menupos++;
			
			if (menupos >= counter) menupos = counter - 1;
		}
		
		if (keysHeld() & (KEY_DOWN))
			oldUp = true;
		else
			oldUp = false;
			
		if (keysHeld() & (KEY_UP))
			oldDown = true;
		else
			oldDown = false;
		
		if (keysHeld() & (KEY_A))
		{
			iprintf("\x1b[2J");
			
			loop = false;
		}
		
		if (loop)
			iprintf("\x1b[%d;0H>", menupos + 5);
	}
}

void checkkeys()
{
    scanKeys();     
     
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_SPACE, keysHeld() & (KEY_A));
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_UP, keysHeld() & (KEY_UP));
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_DOWN, keysHeld() & (KEY_DOWN));
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_LEFT, keysHeld() & (KEY_LEFT));
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_RIGHT, keysHeld() & (KEY_RIGHT));
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_F1, keysHeld() & (KEY_L));
	theConsole->eventHandler().sendKeyEvent(StellaEvent::KCODE_F2, keysHeld() & (KEY_R));
}
 
void updateframebuffer()
{
	uInt8* currentFrame  = theConsole->myMediaSource->currentFrameBuffer();
 
	uInt32 width         = theConsole->myMediaSource->width();
	uInt32 height        = theConsole->myMediaSource->height();
 
	uInt32 y;
 
	WaitForVblank();
 
	for(y = 0; y < height; y++)
		dmaCopy(&currentFrame[y*width], &BG_GFX[y*128], width);
}
 
void setuppalette()
{
	const uInt32* gamePalette = theConsole->myMediaSource->palette();
 
	for(uInt32 i = 0; i < 256; i++)
	{
		uInt8 r, g, b;
 
		r = (uInt8) ((gamePalette[i] & 0x00ff0000) >> 19);
		g = (uInt8) ((gamePalette[i] & 0x0000ff00) >> 11);
		b = (uInt8) ((gamePalette[i] & 0x000000ff) >> 3);
 
		BG_PALETTE[i]=RGB15(r,g,b);
	}
}
