/* ScummVM - Scumm Interpreter
 * Copyright (C) 2001  Ludvig Strigeus
 * Copyright (C) 2001-2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/trunk/base/gameDetector.h $
 * $Id: gameDetector.h 21917 2006-04-15 21:20:16Z fingolfin $
 *
 */

#ifndef BASE_GAMEDETECTOR_H
#define BASE_GAMEDETECTOR_H

#include "common/str.h"
#include "common/config-manager.h"
#include "base/game.h"

class Plugin;


class GameDetector {
	typedef Common::String String;

public:
	GameDetector();

	static Common::String parseCommandLine(Common::StringMap &settings, int argc, char **argv);
	void processSettings(Common::String &target, Common::StringMap &settings);
	const Plugin *detectMain();

public:
	static GameDescriptor findGame(const String &gameName, const Plugin **plugin = NULL);

//protected:
	void setTarget(const String &name);	// TODO: This should be protected
};

#endif
