#ifndef _GBAMPSAVE_H_
#define _GBAMPSAVE_H_

#include "stdafx.h"
#include "system.h"

#define SAVE_BUFFER_SIZE 100000

class GBAMPSaveFile : public Common::SaveFile {
	FILE* handle;
	char buffer[SAVE_BUFFER_SIZE];
	int bufferPos;
	int saveSize;
	int flushed;

public:
	GBAMPSaveFile(char* name, bool saveOrLoad);
	~GBAMPSaveFile();
		
	virtual uint32 read(void *buf, uint32 size);
	virtual uint32 write(const void *buf, uint32 size);
	
	virtual bool eos() const;
	virtual void skip(uint32 bytes);
	
	void flushSaveBuffer();
	
	virtual bool isOpen() const {
		return true;
	}
};


class GBAMPSaveFileManager : public Common::SaveFileManager {

	
public:
	GBAMPSaveFileManager();
	~GBAMPSaveFileManager();
	
//	static GBAMPSaveFileManager* instance() { return instancePtr; }

	Common::SaveFile *openSavefile(const char *filename, bool saveOrLoad);
	
	virtual Common::OutSaveFile* openForSaving(const char* filename) { return openSavefile(filename, true); }
	virtual Common::InSaveFile* openForLoading(const char* filename) { return openSavefile(filename, false); }
	
	
	void listSavefiles(const char *prefix, bool *marks, int num);
	
	void deleteFile(char* name);
	void listFiles();
	
protected:
	Common::SaveFile *makeSaveFile(const char *filename, bool saveOrLoad);
};


#endif
