#ifndef _ZIPREADER_H_
#define _ZIPREADER_H_
#include "stdafx.h"
#include "portdefs.h"
#define ZF_SEARCH_START 0x08000000
#define ZF_SEARCH_END 0x09000000
#define ZF_SEARCH_STRIDE 16

class ZipFile {

	struct FileHeader {
		char magic[4];		// Header (0x04034B50)			0
		u16 minVersion;		// Version needed to extract	4
		u16 flags;			// Flags						6
		u16 comp;			// Compression method			8
		u16 modTime;		// Last modified file time		A
		u16 modDate;		// Last modified file data		C
		u32 crc32;			// CRC32						F
		u32 compSize;		// Compressed size
		u32 fileSize;		// Uncompressed file size
		u16 nameLength;		// Length of the filename
		u16 extraLength;	// Length of any extra data
	} __attribute__ ((packed));

	char* _zipFile;
	char _directory[128];
	
	bool _allFilesVisible;
	
	FileHeader* _currentFile;

public:
	ZipFile();
	~ZipFile();

	bool isReady();
	
	// These operations set the current file
	bool restartFile();
	bool skipFile();
	bool findFile(char* search);	

	// These return the file's data and information
	char* getFile();
	int getFileSize();
	void getFileName(char* name);
	bool isDirectory();
	
	// These set the current directory
	void changeDirectory(char* name);
	void changeToRoot();
	void setAllFilesVisible(bool state) { _allFilesVisible = state; }
	
	bool currentFileInFolder();
	
	u16 misaligned16(u16* v);
	u32 misaligned32(u32* v);

};


#endif
