/* ScummVM - Scumm Interpreter
 * Copyright (C) 2001  Ludvig Strigeus
 * Copyright (C) 2001-2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/trunk/common/system.cpp $
 * $Id: system.cpp 21557 2006-04-02 14:16:31Z fingolfin $
 *
 */

#include "common/stdafx.h"

#include "backends/intern.h"

#include "base/gameDetector.h"

#include "gui/message.h"

#include "common/config-manager.h"
#include "common/savefile.h"
#include "common/system.h"
#include "common/util.h"

OSystem *g_system = 0;

/*
OSystem *OSystem::makeInstance() {
	// Attention: Do not call parseGraphicsMode() here, nor any other function
	// which needs to access the OSystem instance, else you get stuck in an
	// endless loop.

#if defined(USE_NULL_DRIVER)
	return OSystem_NULL_create();
#elif defined(__DC__)
	return OSystem_Dreamcast_create();
#elif defined(X11_BACKEND)
	return OSystem_X11_create();
#elif defined(__MORPHOS__)
	return OSystem_MorphOS_create();
#elif defined(_WIN32_WCE)
	return OSystem_WINCE3_create();
#elif defined(__GP32__)	// ph0x
	return OSystem_GP32_create();
#elif defined(PALMOS_MODE) //chrilith
#	if defined(COMPILE_OS5)
	return OSystem_PalmOS5_create();
#	elif defined(COMPILE_ZODIAC)
	return OSystem_PalmZodiac_create();
#	else
	return OSystem_PALMOS_create();	// old backend
#	endif
#elif defined(__PLAYSTATION2__)
	return OSystem_PS2_create();
#elif defined(__PSP__)
	return OSystem_PSP_create();
#elif defined(__SYMBIAN32__) // SumthinWicked / Sprawl
	return OSystem_SymbianOS_create();
#elif defined(__DS__)
	return OSystem_DS_create();
#else
	// SDL is the default driver for now 
	return OSystem_SDL_create();
#endif
}
*/

bool OSystem::setGraphicsMode(const char *name) {
	if (!name)
		return false;

	// Special case for the 'default' filter
	if (!scumm_stricmp(name, "normal") || !scumm_stricmp(name, "default")) {
		return setGraphicsMode(getDefaultGraphicsMode());
	}

	const GraphicsMode *gm = getSupportedGraphicsModes();

	while (gm->name) {
		if (!scumm_stricmp(gm->name, name)) {
			return setGraphicsMode(gm->id);
		}
		gm++;
	}

	return false;
}

void OSystem::displayMessageOnOSD(const char *msg) {
	// Display the message for 1.5 seconds
	GUI::TimedMessageDialog dialog(msg, 1500);
	dialog.runModal();
}

Common::SaveFileManager *OSystem::getSavefileManager() {
	return new Common::DefaultSaveFileManager();
}
