
/* ScummVMDS - Scumm Interpreter DS Port
 * Copyright (C) 2002-2004 The ScummVM project and Neil Millstone
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "portdefs.h"
#include <string.h>
#include "nds/dma.h"
#include "osystem_ds.h"

time_t DS_time(time_t) {
	if (OSystem_DS::instance()) {
		return 0xABCD1234 + (OSystem_DS::instance()->getMillis() / 1000);
	} else {
		return 0xABCD1234;
	}
}

time_t DS_time(long* t) {
	if (OSystem_DS::instance()) {
		if (t) *t = 0xABCD1234 + (OSystem_DS::instance()->getMillis() / 1000);
		return 0xABCD1234 + (OSystem_DS::instance()->getMillis() / 1000);
	} else {
		if (t) *t = 0xABCD1234;
		return 0xABCD1234;
	}
}
/*
void* DS_memcpy(void* s1, void const* s2, size_t n) {
	/*if (n >= 16) {
		u8* realDest = (u8 *) s1;
		u8* realSrc = (u8 *) s2;
		
		u8* wordDest = realDest;
		wordDest = (u8 *) (((int) (wordDest)) & 0xFFFFFFFC);
		
		u8* wordSrc = realSrc;
		wordSrc = (u8 *) (((int) (wordSrc)) & 0xFFFFFFFC);
		
		int numWords = ((int) wordDest - (int) wordSrc) >> 2;

		for (int r = 0; r < 4; r++) {
			*(realDest + r) = *(realSrc + r);
		}
		
		//dmaCopyWords(3, wordSrc, wordDest, numWords << 2);
		
		for (int r = 0; r < numWords; r++) {
			*(((u32 *) (wordSrc)) + r) = *(((u32 *) (wordDest)) + r);
		}
		
		wordSrc += numWords << 2;
		wordDest += numWords << 2;
		
		int bytesLeft = n - (numWords << 2);
		
		for (int r = n - 4; r < n; r++) {
			*(realDest + r) = *(realSrc + r);
		}
		
	} else {
		return memcpy(s1, s2, n);
//	}
		
	return s1;
}
*/