#ifndef _DSMAIN_H
#define _DSMAIN_H

#include <nds.h>
#include "stdafx.h"
#include "system.h"
#include "scummconsole.h"
#include "nds/scummvm_ipc.h"

// Pen reading functions
void MT_penInit();
void MT_penUpdate();
bool MT_getPenDown();
bool MT_getPenHeld();
bool MT_getPenReleased();
int MT_getPenX();
int MT_getPenY();
GLvector MT_getPenPos();
void MT_consumePenEvents();

// Pad reading
int MT_getKeysHeld();
void MT_keysUpdate();
int MT_getKeysDown();
int MT_getKeysReleased();
void MT_consumeKeys();
int MT_leftHandedSwap(int keys);

// Video
void MT_displayMode8Bit();											// Switch to 8-bit mode5
void MT_displayMode16Bit();										// Switch to 16-bit mode5

// Flip double buffer
void MT_displayMode16BitFlipBuffer();

// Get address of current back buffer
u16* MT_get16BitBackBuffer();
u16* MT_get8BitBackBuffer();

void MT_setTalkPos(int x, int y);
void MT_setTopScreenTarget(int x, int y);

// Timers
void MT_setTimerCallback(OSystem::TimerProc proc, int interval);		// Setup a callback function at a regular interval
int MT_getMillis();													// Return the current runtime in milliseconds
void MT_doTimerCallback();												// Call callback function if required

// Sound
void MT_setSoundProc(OSystem::SoundProc proc, void* param);			// Setup a callback function for sound
void MT_doSoundCallback();												// Call function if sound buffers need more data
void MT_playSound(const void* data, u32 length, bool loop, bool adpcm = false, int rate = 22050);		// Start a sound
void MT_stopSound(int channel);

// Event queue
void MT_addEventsToQueue();
void MT_VBlankHandler();

// Sam and Max Stuff
void MT_setGameID(int id);
void MT_setCursorIcon(const u8* icon, uint w, uint h, byte keycolor);

// Shake
void MT_setShakePos(int shakePos);

// Reports
void MT_memoryReport();

// GBAMP
bool MT_isGBAMPAvailable();

// Sleep (I'd like some of that right now)
void MT_checkSleepMode();

// Virtual keyboard
void MT_setKeyboardIcon(bool enable);
bool MT_getKeyboardIcon();
void MT_setKeyboardEnable(bool en);
bool MT_getKeyboardEnable();

// Options
void MT_setLeftHanded(bool enable);
void MT_setTouchXOffset(int x);
void MT_setTouchYOffset(int y);
void MT_setUnscaledMode(bool enable);
void MT_setIndyFightState(bool st);
bool MT_getIndyFightState();

// Display
bool MT_getIsDisplayMode8Bit();
void MT_setGameSize(int width, int height);


#endif
