
#ifndef _DSFS_H
#define _DSFS_H


#include "stdafx.h"
#include "common/array.h"
#include "common/str.h"

//#include <NDS/ARM9/console.h>
#include "fs.h"
#include "zipreader.h"
#include "ramsave.h"
#include "scummconsole.h"
#include "gba_nds_fat.h"

// Fix name clash with FOTAQ engine, cutaway.h
#undef MAX_FILENAME_LENGTH
// This class is used when a Flash cart is in use

class DSFileSystemNode : public AbstractFilesystemNode {
protected:
	static ZipFile* _zipFile;

	typedef class Common::String String;

	String _displayName;
	bool _isDirectory;
	bool _isValid;
	String _path;
	int _refCountVal;
	
public:
	DSFileSystemNode();
	DSFileSystemNode(const String &path);
	DSFileSystemNode(const DSFileSystemNode *node);
	DSFileSystemNode(const String& path, bool isDir);
	
	virtual String displayName() const {  return _displayName; }
	virtual bool isValid() const { return _isValid; }
	virtual bool isDirectory() const { return _isDirectory; }
	virtual String path() const { return _path; }
	
	virtual FSList listDir(ListMode mode = kListDirectoriesOnly) const;
	virtual FilesystemNode *parent() const;
	virtual FilesystemNode *clone() const { return (FilesystemNode *) new DSFileSystemNode(this); }
	static ZipFile* getZip() { return _zipFile; }
};


// This class is used when the GBAMP (GBA Movie Player) is used with a CompactFlash card

class GBAMPFileSystemNode : public AbstractFilesystemNode {
protected:
	typedef class Common::String String;

	String _displayName;
	bool _isDirectory;
	bool _isValid;
	String _path;
	
	int _refCountVal;
	
public:
	GBAMPFileSystemNode();
	GBAMPFileSystemNode(const String &path);
	GBAMPFileSystemNode(const String &path, bool isDirectory);
	GBAMPFileSystemNode(const GBAMPFileSystemNode *node);

	virtual String displayName() const {  return _displayName; }
	virtual bool isValid() const { return _isValid; }
	virtual bool isDirectory() const { return _isDirectory; }
	virtual String path() const { return _path; }
	virtual FSList listDir(ListMode mode = kListDirectoriesOnly) const;
	virtual FilesystemNode *parent() const;
	virtual FilesystemNode *clone() const { return (FilesystemNode *) new GBAMPFileSystemNode(this); }
	
};


// File reading


struct fileHandle {
	int pos;
	bool used;
	char* data;
	int size;
	
	DSSaveFile* sramFile;
};

// These functions replease the standard library functions of the same name.
// As this header is included after the standard one, I have the chance to #define
// all of these to my own code.
//
// A #define is the only way, as redefinig the functions would cause linker errors.

// These functions need to be #undef'ed, as their definition is done with #includes
#undef feof
#undef stderr
#undef stdout
#undef stdin
#undef clearerr
#undef getc
#undef ferror

#define stdout ((fileHandle*) -1)
#define stderr ((fileHandle*) -2)
#define stdin ((fileHandle*) -3)

#define FILE fileHandle
//#define size_t int

//#define FAT_chdir FAT_CWD

// Only functions used in the ScummVM source have been defined here!
#define fopen(name, mode) 					DS_fopen(name, mode)
#define fclose(handle) 						DS_fclose(handle)
#define fread(ptr, size, items, file)		DS_fread(ptr, size, items, file)
#define fwrite(ptr, size, items, file)		DS_fwrite(ptr, size, items, file)
#define feof(handle)						DS_feof(handle)
//#define fprintf(file, fmt, ...)				DS_fprintf(file, fmt, ##__VA_ARGS__)
#define fprintf(file, fmt, ...)				{ char str[128]; sprintf(str, fmt, ##__VA_ARGS__); fwrite(str, strlen(str), 1, file); }
#define printf(fmt, ...)					consolePrintf(fmt, ##__VA_ARGS__)
#define fflush(file)						DS_fflush(file)
#define fgets(str, size, file)				DS_fgets(str, size, file)
#define ftell(handle)						DS_ftell(handle)
#define fseek(handle, offset, whence)		DS_fseek(handle, offset, whence)
#define clearerr(handle)					DS_clearerr(handle)
#define getc(handle)						DS_getc(handle)
#define getcwd(dir, dunno)					DS_getcwd(dir, dunno)
#define ferror(handle)						DS_ferror(handle)

FILE* DS_fopen(const char* name, const char* mode);
void DS_fclose(FILE* handle);
size_t DS_fread(const void* ptr, size_t size, size_t numItems, FILE* handle);
size_t DS_fwrite(const void* ptr, size_t size, size_t numItems, FILE* handle);
void DS_fprintf(FILE* handle, const char* fmt, ...);
bool DS_feof(FILE* handle);
void DS_fflush(FILE* handle);
char* DS_fgets(char* str, int size, FILE* file);
long int DS_ftell(FILE* handle);
int DS_fseek(FILE* handle, long int offset, int whence);
void DS_clearerr(FILE* handle);
int DS_getc(FILE* handle);
char* DS_getcwd(char* dir, int dunno);
void DS_cwd(char* dir);
int DS_ferror(FILE* handle);


#endif
