#ifndef PPU_MEMORYMAP_H
#define PPU_MEMORYMAP_H

BYTE __fastcall ppu_read_pt0a(register WORD); BYTE __fastcall ppu_read_pt0b(register WORD); BYTE __fastcall ppu_read_pt0c(register WORD); BYTE __fastcall ppu_read_pt0d(register WORD);
BYTE __fastcall ppu_read_pt1a(register WORD); BYTE __fastcall ppu_read_pt1b(register WORD); BYTE __fastcall ppu_read_pt1c(register WORD); BYTE __fastcall ppu_read_pt1d(register WORD);
BYTE __fastcall ppu_read_name0(register WORD); BYTE __fastcall ppu_read_name1(register WORD); BYTE __fastcall ppu_read_name2(register WORD); BYTE __fastcall ppu_read_name3(register WORD);

void __fastcall ppu_write_pt0a(register WORD,register BYTE); void __fastcall ppu_write_pt0b(register WORD,register BYTE); void __fastcall ppu_write_pt0c(register WORD,register BYTE); void __fastcall ppu_write_pt0d(register WORD,register BYTE);
void __fastcall ppu_write_pt1a(register WORD,register BYTE); void __fastcall ppu_write_pt1b(register WORD,register BYTE); void __fastcall ppu_write_pt1c(register WORD,register BYTE); void __fastcall ppu_write_pt1d(register WORD,register BYTE);
void __fastcall ppu_write_name0(register WORD,register BYTE); void __fastcall ppu_write_name1(register WORD,register BYTE); void __fastcall ppu_write_name2(register WORD,register BYTE); void __fastcall ppu_write_name3(register WORD,register BYTE);

BYTE __fastcall ppu_read_palette(register WORD);
void __fastcall ppu_write_palette(register WORD,register BYTE);


BYTE __fastcall ppu_read_pt0a_override(register WORD); BYTE __fastcall ppu_read_pt0b_override(register WORD); BYTE __fastcall ppu_read_pt0c_override(register WORD); BYTE __fastcall ppu_read_pt0d_override(register WORD);
BYTE __fastcall ppu_read_pt1a_override(register WORD); BYTE __fastcall ppu_read_pt1b_override(register WORD); BYTE __fastcall ppu_read_pt1c_override(register WORD); BYTE __fastcall ppu_read_pt1d_override(register WORD);
BYTE __fastcall ppu_read_name0_override(register WORD); BYTE __fastcall ppu_read_name1_override(register WORD); BYTE __fastcall ppu_read_name2_override(register WORD); BYTE __fastcall ppu_read_name3_override(register WORD);

void __fastcall ppu_write_pt0a_override(register WORD,register BYTE); void __fastcall ppu_write_pt0b_override(register WORD,register BYTE); void __fastcall ppu_write_pt0c_override(register WORD,register BYTE); void __fastcall ppu_write_pt0d_override(register WORD,register BYTE);
void __fastcall ppu_write_pt1a_override(register WORD,register BYTE); void __fastcall ppu_write_pt1b_override(register WORD,register BYTE); void __fastcall ppu_write_pt1c_override(register WORD,register BYTE); void __fastcall ppu_write_pt1d_override(register WORD,register BYTE);
void __fastcall ppu_write_name0_override(register WORD,register BYTE); void __fastcall ppu_write_name1_override(register WORD,register BYTE); void __fastcall ppu_write_name2_override(register WORD,register BYTE); void __fastcall ppu_write_name3_override(register WORD,register BYTE);

BYTE __fastcall ppu_read_palette_override(register WORD);
void __fastcall ppu_write_palette_override(register WORD,register BYTE);


void ppu_memmap_init(void);
void ppu_memmap_clean(void);

typedef __fastcall void(*fp_ppubusoverride)(register WORD);
void ppu_memmap_set_ppubusoverride(fp_ppubusoverride);

BYTE* ppu_memmap_get_buffer_ptr(void);
BYTE* ppu_memmap_get_palette_ptr(void);
BYTE** ppu_memmap_get_cur_name_ptr(void);
BYTE** ppu_memmap_get_name_ram_ptr(void);


#endif /* PPU_MEMORYMAP_H */
