#ifndef PALETTE_H
#define PALETTE_H

#define PALETTE_C_PRESET_STD 0
enum { PALETTE_C_PRESET_NTSC_ESTIMATE=PALETTE_C_PRESET_STD, PALETTE_C_PRESET_NTSC_J_ESTIMATE, PALETTE_C_PRESET_PAL_ESTIMATE, PALETTE_C_PRESET_NTSC_INDUSTRIAL, PALETTE_C_PRESET_TV };
enum { PALETTE_C_PRESET_TV_SONY_CXA2025AS_U=PALETTE_C_PRESET_TV, PALETTE_C_PRESET_TV_SONY_CXA2025AS_J, PALETTE_C_PRESET_TV_SONY_CXA2095S_U, PALETTE_C_PRESET_TV_SONY_CXA2095S_J, PALETTE_C_PRESET_HARDCODED };
enum { PALETTE_C_PRESET_HARDCODED_ASPIRINGSQUIRE=PALETTE_C_PRESET_HARDCODED, PALETTE_C_PRESET_HARDCODED_BMF54123, PALETTE_C_PRESET_HARDCODED_CHRIS_COVELL, PALETTE_C_PRESET_HARDCODED_LOOPY, PALETTE_C_PRESET_HARDCODED_MATTHEW_CONTE, PALETTE_C_PRESET_HARDCODED_SARDU, PALETTE_C_PRESET_HARDCODED_RP2C03B, PALETTE_C_PRESET_MAX };

#define PALETTE_Y_PRESET_STD 0
enum { PALETTE_Y_PRESET_ESTIMATE=PALETTE_Y_PRESET_STD, PALETTE_Y_PRESET_KEVIN_HORTON, PALETTE_Y_PRESET_MAX };


const char* palette_c_preset(BYTE);
const char* palette_y_preset(BYTE);
const char* get_palette_c_preset_name(BYTE);
const char* get_palette_y_preset_name(BYTE);

void palette_init(void);
void palette_clean(void);
void palette_calculate(void);
void palette_load(void);
void palette_save(void);

typedef struct {
	BYTE rgb[64][3];
	BYTE rgb_emphasis[8][64][3];
	
	double gamma;		/* zero=2.2, anything around it */
	double brightness;	/* -255 to 255 */

	double hue;		/* 0 to 360 */
	double saturation;	/* 0 to 1 */
	double step;		/* 0 to 360 */
	
	double cd[2][3];
	double y[3][4];
	
	BYTE c_type;
	BYTE y_type;
	
	BYTE hard;
	BYTE write_nesticle_padded_bytes;
} Palette;

Palette* palette;

#endif /* PALETTE_H */
