/* --- iNES mapper 5: MMC5/MMC5B(NES-EKROM/NES-ELROM/NES-ETROM/NES-EWROM) ---
	Castlevania III, some newer Koei war strategy games, etc. */

/* TODO:
	sound
	
	- Castlevania III (PAL): supposedly, part of the background should shine through during vertical scrolling */

#define MMC5_GET_PATDATA(x)	BYTE ret=*mapper.ppu_memmap_buffer_ptr; \
				if ((mapper.mmc5_exram_usage==1)&!*mapper.ppu_reading_sprites_ptr) { \
					*mapper.ppu_memmap_buffer_ptr=cartridge->vrom[((((mapper.mmc5_pat_high<<6)|(mapper.mmc5_exram[mapper.mmc5_nt_index]&BIN8(00111111)))<<2)|(x&3))&MAXVROM][address&0x3ff]; \
				} \
				else { \
					if (((*mapper.ppu_control1_ptr&BIT(5))!=0)&*mapper.ppu_rendering_ptr) {  /* 8*16 sprite mode */ \
						if (*mapper.ppu_reading_sprites_ptr) *mapper.ppu_memmap_buffer_ptr=cartridge->vrom[mapper.mmc5_pat[0][mapper.mmc5_patbs_mode][x]][address&0x3ff]; \
						else *mapper.ppu_memmap_buffer_ptr=cartridge->vrom[mapper.mmc5_pat[1][mapper.mmc5_patbs_mode][x]][address&0x3ff]; \
					} \
					else *mapper.ppu_memmap_buffer_ptr=cartridge->cur_patbank[x][address&0x3ff]; \
				} \
				if (mmc5_insplit()) { \
					if (mapper.mmc5_addressmode_split) { mapper.mmc5_addressmode_split=FALSE; *mapper.ppu_address_ptr=mapper.ppu_address_old; } \
					*mapper.ppu_memmap_buffer_ptr=cartridge->vrom[(mapper.mmc5_split_pat<<2|(x&3))&MAXVROM][address&0x3ff]; \
				} \
				return ret
#define MMC5_GET_NAMEDATA(x)	BYTE ret=*mapper.ppu_memmap_buffer_ptr; \
				if (mapper.mmc5_nt_mode[x]&1) { *mapper.ppu_memmap_buffer_ptr=0; return ret; } \
				if (mmc5_insplit()) { \
					if (!mapper.mmc5_addressmode_split) { \
						mapper.mmc5_addressmode_split=TRUE; \
						mapper.ppu_address_old=*mapper.ppu_address_ptr; \
						*mapper.ppu_address_ptr=((((*mapper.ppu_sc_ptr+mapper.mmc5_split_yscroll)<<12)|(mmc5_get_split_y()<<5))&BIN16(01110011,11100000))|(mapper.mmc5_split_offset>>3&BIN8(00011111)); /* cloak ppu address */ \
					} \
					if ((address&0x3ff)<0x3c0) *mapper.ppu_memmap_buffer_ptr=mapper.mmc5_exram[*mapper.ppu_address_ptr&BIN16(00000011,11111111)]; \
					else { \
						*mapper.ppu_memmap_buffer_ptr=mapper.mmc5_exram[address&0x3ff]; \
						if (mapper.mmc5_addressmode_split) { mapper.mmc5_addressmode_split=FALSE; *mapper.ppu_address_ptr=mapper.ppu_address_old; }; \
					} \
				} \
				else { \
					if (mapper.mmc5_nt_mode[x]&2) { \
						if ((address&0x3ff)<0x3c0) *mapper.ppu_memmap_buffer_ptr=mapper.mmc5_fillnt_ti; \
						else *mapper.ppu_memmap_buffer_ptr=mapper.mmc5_fillnt_at; \
					} \
					else *mapper.ppu_memmap_buffer_ptr=mapper.ppu_memmap_cur_name_ptr[x][address&0x3ff]; \
				} \
				if (mapper.mmc5_exram_usage==1) { \
					if ((address&0x3ff)<0x3c0) mapper.mmc5_nt_index=address&0x3ff; \
					else *mapper.ppu_memmap_buffer_ptr=(mapper.mmc5_exram[mapper.mmc5_nt_index]>>6)|(mapper.mmc5_exram[mapper.mmc5_nt_index]>>4&BIN8(00001100))|(mapper.mmc5_exram[mapper.mmc5_nt_index]>>2&BIN8(00110000))|(mapper.mmc5_exram[mapper.mmc5_nt_index]&BIN8(11000000)); \
				} \
				return ret
#define MMC5_SET_NAMEDATA(x)	if (mapper.mmc5_nt_mode[x]==0) ppu_write_name##x(address,data)

#define MMC5_WRAM_PROTECTION(x) mapper.mmc5_wram_protection[x]=data&3; cartridge->wram_writeenable=(mapper.mmc5_wram_protection[0]==2)&(mapper.mmc5_wram_protection[1]==1)
#define MMC5_BATTERY_64K FALSE

static void mmc5_new_frame(void);
static void mmc5_clean(void);
static void mmc5_mirroring(void);
static void mmc5_prgbs(void);
static BYTE mmc5_battery_load(void); static BYTE mmc5_battery_save(void);
static __inline__ void mmc5_patbs(void);
static __inline__ BYTE mmc5_insplit(void);
static __inline__ BYTE mmc5_get_split_y(void);

void mapinit_mmc5(void)
{
	int i,j,k;
	strcpy(mapper.mappername,"MMC5 NES-ExROM");
	mapclean=&mmc5_clean;
	cpu_set_write_io8000(mapio_mmc5_wpb,mapio_mmc5_wpb,mapio_mmc5_wpb,NULL);
	cpu_set_read_io4020(mapio_mmc5_r);
	cpu_set_write_io4020(mapio_mmc5_w);
	ppu_set_fpt(PPU_FPT_PT0,FALSE,mapper_mmc5_ppu_read_pt0a,mapper_mmc5_ppu_read_pt0b,mapper_mmc5_ppu_read_pt0c,mapper_mmc5_ppu_read_pt0d,NULL,NULL,NULL,NULL);
	ppu_set_fpt(PPU_FPT_PT1,FALSE,mapper_mmc5_ppu_read_pt1a,mapper_mmc5_ppu_read_pt1b,mapper_mmc5_ppu_read_pt1c,mapper_mmc5_ppu_read_pt1d,NULL,NULL,NULL,NULL);
	ppu_set_fpt(PPU_FPT_NT,FALSE,mapper_mmc5_ppu_read_name0,mapper_mmc5_ppu_read_name1,mapper_mmc5_ppu_read_name2,mapper_mmc5_ppu_read_name3,mapper_mmc5_ppu_write_name0,mapper_mmc5_ppu_write_name1,mapper_mmc5_ppu_write_name2,mapper_mmc5_ppu_write_name3);
	cpu_set_mapper_irq(mapirq_mmc5);
	mapnf=&mmc5_new_frame;
	if ((mapper.mmc5_exram=malloc(0x400))==NULL) { LOG(LOG_MISC|LOG_ERROR,"MMC5 EXRAM allocation error!\n"); exit(1); }
	LOG(LOG_VERBOSE,"MMC5 EXRAM allocated\n");
	memset(mapper.mmc5_exram,0,0x400);
	if ((mapper.mmc5_wram=malloc(0x10000))==NULL) { LOG(LOG_MISC|LOG_ERROR,"MMC5 WRAM allocation error!\n"); exit(1); }
	LOG(LOG_VERBOSE,"MMC5 WRAM allocated\n");
	memset(mapper.mmc5_wram,0,0x10000);
	cartridge->wram_isenabled=TRUE;
	cartridge->cur_wrambank=mapper.mmc5_wram;
	if (cartridge->battery) {
		cartridge->battery_size=0x10000;
		mapbatload=&mmc5_battery_load; mapbatsave=&mmc5_battery_save;
	}
	mapper.mmc5_pat_use=1;
	mapper.mmc5_prgbs_mode=3;
	for (j=0;j<4;j++) for (i=0;i<4;i++) { mapper.mmc5_prg[j][i]=MAXPRG|0x80; PRG_BS(i,MAXPRG); } /* prg banks: last 8k everywhere */
	for (k=0;k<2;k++) for (j=0;j<4;j++) for (i=0;i<8;i++) { mapper.mmc5_pat[k][j][i]=i; mapper.mmc5_pat[k][j][i]=i; }
	INIT_PATBANKS_FIRST();
	cartridge->mirroring=CARTRIDGE_MIRRORING_CUSTOM; RESET_MIRRORING();
}

static void mmc5_clean(void)
{
	if (mapper.mmc5_exram!=NULL) {
		free(mapper.mmc5_exram); mapper.mmc5_exram=NULL;
		LOG(LOG_VERBOSE,"MMC5 EXRAM deallocated\n");
	}
	if (mapper.mmc5_wram!=NULL) {
		free(mapper.mmc5_wram); mapper.mmc5_wram=NULL;
		LOG(LOG_VERBOSE,"MMC5 WRAM deallocated\n");
	}
}

static BYTE mmc5_battery_load(void)
{
	mapper.mmc5_wram_size=(file->size-1)>>13&7;
	return FALSE;
}
static BYTE mmc5_battery_save(void)
{
	if (!MMC5_BATTERY_64K) cartridge->battery_size=(mapper.mmc5_wram_size+1)<<13;
	cartridge->cur_wrambank=mapper.mmc5_wram;
	return FALSE;
}

/* ppu memmap overrides */
/* patterntable reads: PT0 */
BYTE __fastcall mapper_mmc5_ppu_read_pt0a(register WORD address) { MMC5_GET_PATDATA(0); } /* 0x0000-0x03ff */
BYTE __fastcall mapper_mmc5_ppu_read_pt0b(register WORD address) { MMC5_GET_PATDATA(1); } /* 0x0400-0x07ff */
BYTE __fastcall mapper_mmc5_ppu_read_pt0c(register WORD address) { MMC5_GET_PATDATA(2); } /* 0x0800-0x0bff */
BYTE __fastcall mapper_mmc5_ppu_read_pt0d(register WORD address) { MMC5_GET_PATDATA(3); } /* 0x0c00-0x0fff */
/* patterntable reads: PT1 */
BYTE __fastcall mapper_mmc5_ppu_read_pt1a(register WORD address) { MMC5_GET_PATDATA(4); } /* 0x1000-0x13ff */
BYTE __fastcall mapper_mmc5_ppu_read_pt1b(register WORD address) { MMC5_GET_PATDATA(5); } /* 0x1400-0x17ff */
BYTE __fastcall mapper_mmc5_ppu_read_pt1c(register WORD address) { MMC5_GET_PATDATA(6); } /* 0x1800-0x1bff */
BYTE __fastcall mapper_mmc5_ppu_read_pt1d(register WORD address) { MMC5_GET_PATDATA(7); } /* 0x1c00-0x1fff */
/* nametable reads */
BYTE __fastcall mapper_mmc5_ppu_read_name0(register WORD address) { MMC5_GET_NAMEDATA(0); } /* nametable 0: 0x2000-0x23ff */
BYTE __fastcall mapper_mmc5_ppu_read_name1(register WORD address) { MMC5_GET_NAMEDATA(1); } /* nametable 1: 0x2400-0x27ff */
BYTE __fastcall mapper_mmc5_ppu_read_name2(register WORD address) { MMC5_GET_NAMEDATA(2); } /* nametable 2: 0x2800-0x2bff */
BYTE __fastcall mapper_mmc5_ppu_read_name3(register WORD address) { MMC5_GET_NAMEDATA(3); } /* nametable 3: 0x2c00-0x2fff */
/* nametable writes */
void __fastcall mapper_mmc5_ppu_write_name0(register WORD address,register BYTE data) { MMC5_SET_NAMEDATA(0); } /* nametable 0: 0x2000-0x23ff */
void __fastcall mapper_mmc5_ppu_write_name1(register WORD address,register BYTE data) { MMC5_SET_NAMEDATA(1); } /* nametable 1: 0x2400-0x27ff */
void __fastcall mapper_mmc5_ppu_write_name2(register WORD address,register BYTE data) { MMC5_SET_NAMEDATA(2); } /* nametable 2: 0x2800-0x2bff */
void __fastcall mapper_mmc5_ppu_write_name3(register WORD address,register BYTE data) { MMC5_SET_NAMEDATA(3); } /* nametable 3: 0x2c00-0x2fff */
/* --- */

BYTE __fastcall mapio_mmc5_r(register WORD address)
{
	BYTE ret=address>>8;
	switch (address) {
		/* sound */
		case 0x5010: break; /* sound */
		case 0x5015: break; /* sound */
		
		/* other */
		case 0x5204: ret=mapper.mmc5_irq_status; mapper.mmc5_irq_status&=BIN8(01111111); cpu_acknowledge_interrupt(~IRQ_MAPPER); break; /* get irq status */
		case 0x5205: ret=(mapper.mmc5_mul[0]*mapper.mmc5_mul[1])&0xff; break; /* read multiplier result: low byte */
		case 0x5206: ret=(mapper.mmc5_mul[0]*mapper.mmc5_mul[1])>>8&0xff; break; /* get multiplier result: high byte */
		
		default:
			if (address>0x5bff) { /* read exram, only when enabled */
				if (mapper.mmc5_exram_usage&2) ret=mapper.mmc5_exram[address&0x3ff];
			}
			#if DEBUG_MAPPER
			else LOG(LOG_MAPPER,"%x\n",address);
			#endif
			break;
	}
	return ret;
}

void __fastcall mapio_mmc5_w(register WORD address,register BYTE bus,register BYTE data)
{
	int i,p;
	switch (address) {
		/* sound */
		case 0x5000: break; /* sound */
		case 0x5002: break; /* sound */
		case 0x5003: break; /* sound */
		case 0x5004: break; /* sound */
		case 0x5006: break; /* sound */
		case 0x5007: break; /* sound */
		case 0x5010: break; /* sound */
		case 0x5011: break; /* sound */
		case 0x5015: break; /* sound */
		
		/* bankswitching modes */
		case 0x5100: mapper.mmc5_prgbs_mode=data&3; mmc5_prgbs(); break; /* set prg bankswitch mode */
		case 0x5101: ppu_force_update(); mapper.mmc5_patbs_mode=data&3; mmc5_patbs(); break; /* set chr bankswitch mode */
		case 0x5102: MMC5_WRAM_PROTECTION(0); break; /* set wram protection (reg1) */
		case 0x5103: MMC5_WRAM_PROTECTION(1); break; /* set wram protection (reg2) */
		case 0x5104: ppu_force_update(); mapper.mmc5_exram_usage=data&3; mmc5_mirroring(); break; /* set exram usage */
		case 0x5105: mapper.mmc5_mirroring=data; mmc5_mirroring(); break; /* set nametable/mirroring */
		case 0x5106: ppu_force_update(); mapper.mmc5_fillnt_ti=data; break; /* set fill nametable tile index */
		case 0x5107: ppu_force_update(); mapper.mmc5_fillnt_at=((data&3)<<6)|((data&3)<<4)|((data&3)<<2)|(data&3); break; /* set fill nametable attribute data */
		
		/* prg banks */
		case 0x5113: /* select 8k ram for 0x6000 */
			p=data&7;
			if (p>mapper.mmc5_wram_size) mapper.mmc5_wram_size=p;
			cartridge->cur_wrambank=mapper.mmc5_wram+(p<<13);
			mmc5_prgbs();
			break;
		case 0x5114: /* select 8k prg bank for 0x8000-0x9fff */
			mapper.mmc5_prg[3][0]=data;
			mmc5_prgbs();
			break;
		case 0x5115: /* select 8/16k prg bank for x-0xbfff */
			mapper.mmc5_prg[3][1]=data; /* 3: 8k */
			data&=BIN8(11111110); mapper.mmc5_prg[1][0]=mapper.mmc5_prg[2][0]=data; mapper.mmc5_prg[1][1]=mapper.mmc5_prg[2][1]=data|1; /* 1/2: 16k */
			mmc5_prgbs();
			break;
		case 0x5116: /* select 8 prg bank for 0xc000-0xdfff */
			mapper.mmc5_prg[2][2]=mapper.mmc5_prg[3][2]=data; /* 2/3: 8k */
			mmc5_prgbs();
			break;
		case 0x5117: /* select 8/16/32k prg bank for x-0xffff */
			data=data|0x80;
			mapper.mmc5_prg[2][3]=mapper.mmc5_prg[3][3]=data; /* 2/3: 8k */
			data&=BIN8(11111110); mapper.mmc5_prg[1][2]=data; mapper.mmc5_prg[1][3]=data|1; /* 1: 16k */
			data&=BIN8(11111100); for (i=3;i>=0;i--) mapper.mmc5_prg[0][i]=data|i; /* 0: 32k */
			mmc5_prgbs();
			break;
		
		/* chr banks */
		case 0x5120: case 0x5121: case 0x5122: case 0x5123: case 0x5124: case 0x5125: case 0x5126: case 0x5127: /* sprite banks */
			ppu_force_update();
			mapper.mmc5_pat[0][3][address&7]=(data|(mapper.mmc5_pat_high<<8))&MAXVROM; /* 1k */
			if (address&1) { p=(data<<1)|(mapper.mmc5_pat_high<<9); mapper.mmc5_pat[0][2][(address&7)-1]=p&MAXVROM; mapper.mmc5_pat[0][2][address&7]=(p|1)&MAXVROM; } /* 2k */
			if ((address&3)==3) { p=data<<2; for (i=(address&7)-3;i<8;i++) mapper.mmc5_pat[0][1][i]=(p|(i&3))&MAXVROM; } /* 4k */
			if (address==0x5127) { p=data<<3; for (i=7;i>=0;i--) mapper.mmc5_pat[0][0][i]=(p|i)&MAXVROM; } /* 8k */
			mapper.mmc5_pat_use=0; mmc5_patbs();
			break;
		case 0x5128: case 0x5129: case 0x512a: case 0x512b: /* background banks */
			ppu_force_update();
			mapper.mmc5_pat[1][3][address&3]=mapper.mmc5_pat[1][3][(address&3)+4]=(data|(mapper.mmc5_pat_high<<8))&MAXVROM; /* 1+1k */
			if (address&1) { /* 2+2k */
				p=(data<<1)|(mapper.mmc5_pat_high<<9);
				mapper.mmc5_pat[1][2][(address&3)-1]=mapper.mmc5_pat[1][2][(address&3)+3]=p&MAXVROM;
				mapper.mmc5_pat[1][2][address&3]=mapper.mmc5_pat[1][2][(address&3)+4]=(p|1)&MAXVROM;
			}
			if (address==0x512b) {
				p=data<<2; for (i=3;i>=0;i--) mapper.mmc5_pat[1][1][i]=mapper.mmc5_pat[1][1][i+4]=(p|i)&MAXVROM; /* 4+4k */
				p=data<<3; for (i=7;i>=0;i--) mapper.mmc5_pat[1][0][i]=(p|i)&MAXVROM; /* 8k */
			}
			mapper.mmc5_pat_use=1; mmc5_patbs();
			break;
		case 0x5130: ppu_force_update(); mapper.mmc5_pat_high=data&3; break; /* high bits for small high banks selection */
		
		/* other */
		case 0x5200: /* set vertical screensplit enable, side, column position */
			ppu_force_update();
			mapper.mmc5_split_isenabled=data&0x80;
			mapper.mmc5_split_side=data&0x40;
			mapper.mmc5_split_pos=data<<3;
			break;
		case 0x5201: ppu_force_update(); mapper.mmc5_split_yscroll=data; break; /* set vertical screensplit y scroll value */
		case 0x5202: ppu_force_update(); mapper.mmc5_split_pat=data; break; /* set vertical screensplit patternbank */
		case 0x5203: mapper.mmc5_irq_scanline=data; break; /* set scanline for irq */
		case 0x5204: /* enable/disable irqs */
			mapper.mmc5_irq_isenabled=data&0x80;
			if (mapper.mmc5_irq_isenabled&mapper.mmc5_irq_status) cpu_set_interrupt(INTERRUPT_IRQ|IRQ_MAPPER);
			else cpu_acknowledge_interrupt(~IRQ_MAPPER);
			break;
		case 0x5205: mapper.mmc5_mul[0]=data; break; /* multiplier value 1 */
		case 0x5206: mapper.mmc5_mul[1]=data; break; /* multiplier value 2 */
		
		default:
			if (address>0x5bff) {
				switch (mapper.mmc5_exram_usage) {
					case 0: case 1:
						ppu_force_update();
						if (*mapper.ppu_enabled_ptr&!*mapper.ppu_vblank_ptr) mapper.mmc5_exram[address&0x3ff]=data;
						else mapper.mmc5_exram[address&0x3ff]=0;
						break;
					case 2: mapper.mmc5_exram[address&0x3ff]=data; break;
					default: break;
				}
			}
			#if DEBUG_MAPPER
			else LOG(LOG_MAPPER,"%x %x\n",address,data);
			#endif
			break;
	}
}

void __fastcall mapio_mmc5_wpb(register WORD address,register BYTE bus,register BYTE data) /* handler for writes to programbanks (in case of wram) */
{
	if (cartridge->wram_writeenable)
		if (cartridge->cur_prgbank_isram[address>>13&3])
			cartridge->cur_prgbank[address>>13&3][address&0x1fff]=data;
}

static void mmc5_new_frame(void) { mapper.sc=0; }
void __fastcall mapirq_mmc5(void) /* irq handler, based on scanlines */
{
	for (;;) {
		if (*mapper.cpu_cycles_ptr<crystal->sc[mapper.sc+1]) { /* new scanline */
			mapper.sc++;
			if (mapper.sc>241) return;
			else if (mapper.sc==241) { mapper.mmc5_irq_status&=0x80; return; } /* end of visible frame */
			if (*mapper.ppu_enabled_ptr) {
				if (mapper.sc==1) { mapper.mmc5_irq_status=0; cpu_acknowledge_interrupt(~IRQ_MAPPER); }
				else if (mapper.sc>1) {
					if (mapper.mmc5_irq_scanline+1==mapper.sc) mapper.mmc5_irq_status|=0x80;
					if (mapper.mmc5_irq_isenabled&mapper.mmc5_irq_status) cpu_set_interrupt(INTERRUPT_IRQ|IRQ_MAPPER);
					mapper.mmc5_irq_status|=0x40;
				}
			}
		}
		else break;
	}
}

static void mmc5_mirroring(void)
{
	int i;
	ppu_force_update();
	for (i=3;i>=0;i--) {
		switch ((mapper.mmc5_mirroring>>(i<<1))&3) {
			case 0: mapper.ppu_memmap_cur_name_ptr[i]=mapper.ppu_memmap_name_ram_ptr[0]; mapper.mmc5_nt_mode[i]=0; break;
			case 1: mapper.ppu_memmap_cur_name_ptr[i]=mapper.ppu_memmap_name_ram_ptr[1]; mapper.mmc5_nt_mode[i]=0; break;
			case 2:
				if (mapper.mmc5_exram_usage&2) mapper.mmc5_nt_mode[i]=1;
				else { mapper.ppu_memmap_cur_name_ptr[i]=mapper.mmc5_exram; mapper.mmc5_nt_mode[i]=0; }
				break;
			case 3: mapper.mmc5_nt_mode[i]=2; break;
			default: break;
		}
	}
}

static void mmc5_prgbs(void)
{
	BYTE b;
	int i=3;
	for (;i>=0;i--) {
		if(mapper.mmc5_prg[mapper.mmc5_prgbs_mode][i]&0x80) {
			PRG_BS(i,(mapper.mmc5_prg[mapper.mmc5_prgbs_mode][i]&BIN8(01111111))&MAXPRG);
			cartridge->cur_prgbank_isram[i]=FALSE;
		}
		else {
			b=mapper.mmc5_prg[mapper.mmc5_prgbs_mode][i]&7;
			if (b>mapper.mmc5_wram_size) mapper.mmc5_wram_size=b;
			cartridge->cur_prgbank[i]=mapper.mmc5_wram+(b<<13);
			cartridge->cur_prgbank_isram[i]=TRUE;
		}
	}
}

static __inline__ void mmc5_patbs(void)
{
	PAT_BS(0,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][0],vrom); PAT_BS(1,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][1],vrom);
	PAT_BS(2,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][2],vrom); PAT_BS(3,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][3],vrom);
	PAT_BS(4,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][4],vrom); PAT_BS(5,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][5],vrom);
	PAT_BS(6,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][6],vrom); PAT_BS(7,mapper.mmc5_pat[mapper.mmc5_pat_use][mapper.mmc5_patbs_mode][7],vrom);
}

static __inline__ BYTE mmc5_insplit(void)
{
	if (mapper.mmc5_split_isenabled)
		if (*mapper.ppu_rendering_ptr&!*mapper.ppu_reading_sprites_ptr&(((~mapper.mmc5_exram_usage)&2)>>1))
			if ((*mapper.ppu_scc_ptr<256)|((*mapper.ppu_scc_ptr>320)&(*mapper.ppu_scc_ptr<336))) { /* ignore bogus nametables */
				if (*mapper.ppu_hblank_ptr) mapper.mmc5_split_offset=*mapper.ppu_scc_ptr&8;
				else mapper.mmc5_split_offset=(*mapper.ppu_scc_ptr&BIN8(11111000))+16; /* +16 due to tile fetch cache */
				if (mapper.mmc5_split_side) return mapper.mmc5_split_offset>=mapper.mmc5_split_pos;
				else return mapper.mmc5_split_offset<=mapper.mmc5_split_pos;
			}
	return FALSE;
}

static __inline__ BYTE mmc5_get_split_y(void)
{
	BYTE split_y=(*mapper.ppu_sc_ptr+mapper.mmc5_split_yscroll)>>3;
	return split_y*(split_y<30);
}
