/* --- iNES mapper 1: MMC1:MMC1A/MMC1B1/MMC1B2/MMC1C(
		NES-SAROM/NES-SBROM/NES-SCROM/NES-SEROM/NES-SFROM/NES-SGROM/NES-SHROM/NES-SJROM/NES-SKROM/NES-SLROM/NES-SL1ROM/NES-SL2ROM/NES-SL3ROM/NES-SLRROM/NES-SNROM/
		NES-SOROM:16KB WRAM, bank 0 normal, bank 1 battery ? (won't do for FF1&2, so both are battery backed here)/
		NES-SUROM:512KB PRG ROM/
		NES-SVROM?:combination of the above 2) ---
	Legend of Zelda 1,2, Metroid, Turtles 1, Tetris, Megaman 2, Final Fantasy, Snake Rattle n Roll,
	Double Dragon, Chip n Dale 1,2, Castlevania 2, Ninja Gaiden, Dragon Warrior 1,2,3,4, etc.
   --- iNES mapper 155: MMC1 without WRAM protection
	Tatakae!! Rahmen Man - Sakuretsu Choujin 102 Gei, The Money Game */

/* TODO:
	- startup mirroring ?
	- SUROM high bank/SOROM WRAM bank can change on PPU addressbus accesses when used bits are unequal to eachother.
	  I'll add it when I see it's used somewhere (I doubt it), it'll cause a big speed decrease. */

enum { MMC1_TYPE_MMC1=0, MMC1_TYPE_SOROM, MMC1_TYPE_SUROM, MMC1_TYPE_NOWRAMPROT };
#define MMC1_TYPE_SVROM BIT(7)

#define MMC1_RESET()		mapper.mmc1_filltemp_count=0; mapper.mmc1_register[0]|=BIN8(00001100); mmc1_control()
#define MMC1_REG		address>>13&3
#define MMC1_PAT0BS(b,v)	if (mapper.mmc1_register[0]&BIN8(00010000)) { /* 4k */ \
					i=mapper.mmc1_register[1]<<2&b; \
					PAT_BS(0,i++,v); PAT_BS(1,i++,v); PAT_BS(2,i++,v); PAT_BS(3,i,v); \
				} \
				else { /* 8k */ \
					i=mapper.mmc1_register[1]<<2&BIN8(11111000)&b; \
					PAT_BS(0,i++,v); PAT_BS(1,i++,v); PAT_BS(2,i++,v); PAT_BS(3,i++,v); \
					PAT_BS(4,i++,v); PAT_BS(5,i++,v); PAT_BS(6,i++,v); PAT_BS(7,i,v); \
				}
#define MMC1_PAT1BS(b,v)	i=mapper.mmc1_register[2]<<2&b; \
				PAT_BS(4,i++,v); PAT_BS(5,i++,v); PAT_BS(6,i++,v); PAT_BS(7,i,v)
#define MMC1_256_BANK		((mapper.mmc1_register[1]|mapper.mmc1_register[2])<<1&BIN8(00100000))

static void mmc1_control(void); static void mmc1_pat0bs(void); static void mmc1_pat1bs(void); static void mmc1_prgbs(void);
static void mmc1_sorom_reg1(void);	static void mmc1_sorom_reg2(void);
static void mmc1_surom_reg1(void);	static void mmc1_surom_reg2(void);
static void mmc1_svrom_reg1(void);	static void mmc1_svrom_reg2(void);
static void mmc1_new_frame(void);
typedef void(*fpt_mmc1_io)(void);
static const fpt_mmc1_io mmc1_io_std[4]= { mmc1_control, mmc1_pat0bs, mmc1_pat1bs, mmc1_prgbs };
static fpt_mmc1_io mmc1_io[4];
static __inline__ void mmc1_sorom_wram_bs(void); static void mmc1_sorom_clean(void); static BYTE mmc1_sorom_battery_save(void);

void (*mmc1_wram_protection)(void);
static void mmc1_wram_protection_no(void); static void mmc1_wram_protection_no(void) { cartridge->wram_isenabled=TRUE; }
static void mmc1_wram_protection_yes(void); static void mmc1_wram_protection_yes(void) { cartridge->wram_isenabled=mapper.mmc1_register[3]>>4^1; }

void mapinit_mmc1(void)
{
	int i;
	mapnf=&mmc1_new_frame;
	mmc1_wram_protection=&mmc1_wram_protection_yes;
	for (i=0;i<4;i++) mmc1_io[i]=mmc1_io_std[i];
	cpu_set_write_io8000(mapio_mmc1,mapio_mmc1,mapio_mmc1,mapio_mmc1);
	INIT_PATBANKS_FIRST();
	
	if ((cartridge->crc32==CRC32_AOKI_OOKAMI_TO_SHIROKI_MEJIKA_GENGHIS_KHAN_J)|(cartridge->crc32==CRC32_BEST_PLAY_PRO_YAKYUU_SPECIAL_J)|(cartridge->crc32==CRC32_BEST_PLAY_PRO_YAKYUU_SPECIAL_J_A1)|(cartridge->crc32==CRC32_FINAL_FANTASY_I_AND_II_J)|(cartridge->crc32==CRC32_GENGHIS_KHAN_U)|(cartridge->crc32==CRC32_NOBUNAGA_NO_YABOU_ZENKOKU_HAN_J)|(cartridge->crc32==CRC32_NOBUNAGA_NO_YABOU_ZENKOKU_HAN_J_A1)|(cartridge->crc32==CRC32_NOBUNAGAS_AMBITION_U)|(cartridge->crc32==CRC32_ROMANCE_OF_THE_THREE_KINGDOMS_U)|(cartridge->crc32==CRC32_SANGOKUSHI_J)) { /* hello */
		mapper.mmc1_type=MMC1_TYPE_SOROM;
		if (MAXPRG>=63) mapper.mmc1_type|=MMC1_TYPE_SVROM;
	}
	else if (MAXPRG>=63) mapper.mmc1_type=MMC1_TYPE_SUROM;
	else if (cartridge->type==155) mapper.mmc1_type=MMC1_TYPE_NOWRAMPROT;
	else mapper.mmc1_type=MMC1_TYPE_MMC1;
	
	switch (mapper.mmc1_type&~BIT(7)) {
		case MMC1_TYPE_MMC1:
			strcpy(mapper.mappername,"MMC1 NES-SxROM");
			break;
		case MMC1_TYPE_SUROM:
			cartridge->battery=TRUE;
			mmc1_io[1]=mmc1_surom_reg1; mmc1_io[2]=mmc1_surom_reg2;
			strcpy(mapper.mappername,"MMC1 NES-SUROM");
			break;
		case MMC1_TYPE_SOROM:
			cartridge->battery=TRUE;
			mmc1_io[1]=mmc1_sorom_reg1; mmc1_io[2]=mmc1_sorom_reg2;
			mapclean=&mmc1_sorom_clean;
			if ((mapper.mmc1_sorom_wram=malloc(0x4000))==NULL) { LOG(LOG_MISC|LOG_ERROR,"MMC1 NES-SOROM WRAM allocation error!\n"); exit(1); }
			LOG(LOG_VERBOSE,"MMC1 NES-SOROM WRAM allocated\n");
			memset(mapper.mmc1_sorom_wram,0,0x4000);
			cartridge->battery_size=0x4000;
			cartridge->cur_wrambank=mapper.mmc1_sorom_wram;
			mapbatsave=&mmc1_sorom_battery_save;
			strcpy(mapper.mappername,"MMC1 NES-SOROM");
			break;
		case MMC1_TYPE_NOWRAMPROT:
			mmc1_wram_protection=&mmc1_wram_protection_no;
			strcpy(mapper.mappername,"MMC1 without WRAM protection");
			break;
	}
	if (mapper.mmc1_type&MMC1_TYPE_SVROM) {
		mmc1_io[1]=mmc1_svrom_reg1; mmc1_io[2]=mmc1_svrom_reg2;
		strcpy(mapper.mappername,"MMC1 NES-SVROM");
	}
	
	mapper.mmc1_register[0]=BIN8(00001110);
	cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING();
	mmc1_prgbs(); /* init prgbanks here instead */
}

static void mmc1_new_frame(void) { mapper.cycles_old=-crystal->frame; }

void __fastcall mapio_mmc1(register WORD address,register BYTE bus,register BYTE data)
{
	if (*mapper.cpu_cycles_ptr==mapper.cycles_old) return; /* delay: rmw ignore 2nd write */
	else mapper.cycles_old=*mapper.cpu_cycles_ptr;
	if (mapper.mmc1_registernum_old!=(MMC1_REG)) mapper.mmc1_filltemp_count=0;
	mapper.mmc1_registernum_old=MMC1_REG;
	mapper.mmc1_register_temp=mapper.mmc1_register_temp>>1|(data<<4&BIN8(00010000));
	mapper.mmc1_filltemp_count++;
	if (data&0x80) { MMC1_RESET(); }
	if (mapper.mmc1_filltemp_count==5) {
		mapper.mmc1_filltemp_count=0;
		mapper.mmc1_register[MMC1_REG]=mapper.mmc1_register_temp;
		mmc1_io[MMC1_REG]();
	}
}

/* registers */
static void mmc1_control(void) /* register 0: control register: 0x8000-0x9fff */
{
	ppu_force_update();
	if (~mapper.mmc1_register[0]&BIN8(00000010)) cartridge->mirroring=(mapper.mmc1_register[0]&1)?CARTRIDGE_MIRRORING_ONE_1:CARTRIDGE_MIRRORING_ONE_0;
	else cartridge->mirroring=(mapper.mmc1_register[0]&1)?CARTRIDGE_MIRRORING_HORIZONTAL:CARTRIDGE_MIRRORING_VERTICAL;
	RESET_MIRRORING();
	mmc1_prgbs(); mmc1_io[1](); mmc1_io[2]();
}
static void mmc1_pat0bs(void) /* register 1: pattern page 0 switch: 0xa000-0xbfff */
{
	int i;
	ppu_force_update();
	if (MAXVROM) { /* vrom */
		MMC1_PAT0BS(MAXVROM,vrom);
	}
	else { /* vram */
		MMC1_PAT0BS(7,vram);
	}
}
static void mmc1_pat1bs(void) /* register 2: pattern page 1 switch: 0xc000-0xdfff */
{
	int i;
	ppu_force_update();
	if (mapper.mmc1_register[0]&BIN8(00010000)) { /* 4k only */
		if (MAXVROM) { /* vrom */
			MMC1_PAT1BS(MAXVROM,vrom);
		}
		else { /* vram */
			MMC1_PAT1BS(7,vram);
		}
	}
}
static void mmc1_prgbs(void) /* register 3: prg switch: 0xe000-0xffff */
{
	int i;
	(*mmc1_wram_protection)();
	if (mapper.mmc1_register[0]&BIN8(00001000)) { /* 16k */
		i=((mapper.mmc1_register[3]<<1&0x1f)|MMC1_256_BANK)&MAXPRG;
		if (mapper.mmc1_register[0]&BIN8(00000100)) { /* at 0x8000 */
			PRG_BS(0,i++);	PRG_BS(1,i);
			PRG_BS(2,(((MAXPRG-1)&0x1f)|MMC1_256_BANK)&MAXPRG);
			PRG_BS(3,((MAXPRG&0x1f)|MMC1_256_BANK)&MAXPRG);
		}
		else { /* at 0xc000 */
			PRG_BS(0,0);	PRG_BS(1,1);	PRG_BS(2,i++);	PRG_BS(3,i);
		}
	}
	else { /* 32k */
		i=((mapper.mmc1_register[3]<<1&BIN8(11111100)&0x1f)|MMC1_256_BANK)&MAXPRG;
		PRG_BS(0,i++);	PRG_BS(1,i++);	PRG_BS(2,i++);	PRG_BS(3,i);
	}
}


/* MMC1 NES-SOROM */

static __inline__ void mmc1_sorom_wram_bs(void)
{
	/* 4K CHR?: bit 4 defines WRAM bank. 8K CHR?: bit 3, only reg 1 */
	if (mapper.mmc1_register[0]&BIN8(00010000)) cartridge->cur_wrambank=mapper.mmc1_sorom_wram+((mapper.mmc1_register[1]|mapper.mmc1_register[2])<<9&0x2000);
	else cartridge->cur_wrambank=mapper.mmc1_sorom_wram+(mapper.mmc1_register[1]<<10&0x2000);
}

static void mmc1_sorom_clean(void)
{
	if (mapper.mmc1_sorom_wram!=NULL) {
		free(mapper.mmc1_sorom_wram); mapper.mmc1_sorom_wram=NULL;
		LOG(LOG_VERBOSE,"MMC1 NES-SOROM WRAM deallocated\n");
	}
}

static BYTE mmc1_sorom_battery_save(void)
{
	cartridge->cur_wrambank=mapper.mmc1_sorom_wram;
	return FALSE;
}

/* registers */
static void mmc1_sorom_reg1(void) { mmc1_pat0bs(); mmc1_sorom_wram_bs(); }
static void mmc1_sorom_reg2(void) { mmc1_pat1bs(); mmc1_sorom_wram_bs(); }


/* MMC1 NES-SUROM */

/* registers */
static void mmc1_surom_reg1(void) { mmc1_prgbs(); }
static void mmc1_surom_reg2(void) { mmc1_prgbs(); }


/* MMC1 NES-SVROM */

/* registers */
static void mmc1_svrom_reg1(void) { mmc1_prgbs(); mmc1_sorom_wram_bs(); }
static void mmc1_svrom_reg2(void) { mmc1_prgbs(); mmc1_sorom_wram_bs(); }
