/* --- iNES mapper 34: AVE Nina-001/NES-BNROM ---
	Nina-001: Impossible Mission 2.
	BNROM: several hacks. (dunno if any official game used it) */

void mapinit_nina1(void)
{
	strcpy(mapper.mappername,"AVE Nina-001/NES-BNROM");
	cpu_set_write_io8000(mapio_bnrom,mapio_bnrom,mapio_bnrom,mapio_bnrom);
	cpu_set_write_io6000(mapio_nina1);
	INIT_PRGBANKS_FIRST(); /* first 32k prgbank */
	INIT_PATBANKS_FIRST();
	cartridge->wram_isenabled=TRUE; /* Nina-001 has RAM, BNROM does not */
}

void __fastcall mapio_nina1(register WORD address,register BYTE bus,register BYTE data)
{
	int i;
	cartridge->cur_wrambank[address&0x1fff]=data; /* standard wram */
	switch(address) {
		case 0x7ffd: /* select 32k prg bank */
			i=data<<2&MAXPRG;
			PRG_BS(0,i++); PRG_BS(1,i++); PRG_BS(2,i++); PRG_BS(3,i);
			break;
		case 0x7ffe: /* select 4k chr bank at 0x0 */
			ppu_force_update();
			i=data<<2&MAXVROM;
			PAT_BS(0,i++,vrom); PAT_BS(1,i++,vrom); PAT_BS(2,i++,vrom); PAT_BS(3,i,vrom);
			break;
		case 0x7fff: /* select 4k chr bank at 0x1000 */
			ppu_force_update();
			i=data<<2&MAXVROM;
			PAT_BS(4,i++,vrom); PAT_BS(5,i++,vrom); PAT_BS(6,i++,vrom); PAT_BS(7,i,vrom);
			break;
		default: break;
	}
}

void __fastcall mapio_bnrom(register WORD address,register BYTE bus,register BYTE data)
{
	/* all bits: select 32k prg bank */
	int prg=data<<2&MAXPRG;
	PRG_BS(0,prg++); PRG_BS(1,prg++); PRG_BS(2,prg++); PRG_BS(3,prg);
	
	#if DEBUG_MAPPER
	LOG(LOG_MAPPER,"=BN");
	#endif
}





/* --- iNES mapper 234: AVE D-1012 ---
	Maxi-15 */

/* TODO:
	some games don't work properly in 'Maxi 15 (NTSC) [p1][a1]', most likely a bad dump */

static __inline__ void aved1012_bs(void);

void mapinit_aved1012(void)
{
	strcpy(mapper.mappername,"AVE D-1012");
	cpu_set_write_io8000(NULL,NULL,NULL,mapio_aved1012);
	cpu_set_read_io8000(NULL,NULL,NULL,mapio_r_aved1012);
	
	cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING(); /* reg0=0 */
	
	INIT_PRGBANKS_FIRST(); /* first 32k prgbank */
	INIT_PATBANKS_FIRST(); /* first 8k vrom */
}

void __fastcall mapio_aved1012(register WORD address,register BYTE bus,register BYTE data)
{
	switch (address&0xfff8) {
		/* 0xff80-0xff9f: R1 */
		case 0xff80: case 0xff88: case 0xff90: case 0xff98:
			if (mapper.aved1012_register[0]==0) {
				ppu_force_update();
				if (data&BIT(7)) cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL; /* bit 7: change mirroring */
				else cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL;
				RESET_MIRRORING();
				mapper.aved1012_register[0]=data;
				aved1012_bs();
			}
			break;
		
		/* 0xffe8-0xfff7: R2 */
		case 0xffe8: case 0xfff0:
			mapper.aved1012_register[1]=data;
			aved1012_bs();
			break;
		
		/* ( 0xffc0-0xffdf: R3 (lockout chip related) ) */
		
		default: break;
	}
	
}

BYTE __fastcall mapio_r_aved1012(register WORD address)
{
	register BYTE bus=cartridge->cur_prgbank[3][address&0x1fff];
	mapio_aved1012(address,bus,bus);
	return bus;
}

static __inline__ void aved1012_bs(void)
{
	WORD prg,pat;
	if (mapper.aved1012_register[0]&BIT(6)) {
		prg=(mapper.aved1012_register[0]<<2&BIN8(00111000))|(mapper.aved1012_register[1]<<2&BIN8(00000100));
		pat=((mapper.aved1012_register[0]&BIN8(00001110))<<5)|(mapper.aved1012_register[1]>>1&BIN8(00111000));
	}
	else {
		prg=mapper.aved1012_register[0]<<2&BIN8(00111100);
		pat=((mapper.aved1012_register[0]&BIN8(00001111))<<5)|(mapper.aved1012_register[1]>>1&BIN8(00011000));
	}
	
	PRG_BS(0,prg++); PRG_BS(1,prg++); PRG_BS(2,prg++); PRG_BS(3,prg);
	
	ppu_force_update();
	PAT_BS(0,pat++,vrom); PAT_BS(1,pat++,vrom); PAT_BS(2,pat++,vrom); PAT_BS(3,pat++,vrom);
	PAT_BS(4,pat++,vrom); PAT_BS(5,pat++,vrom); PAT_BS(6,pat++,vrom); PAT_BS(7,pat,vrom);
}
