#ifndef MAPPER_H
#define MAPPER_H

#define MAPPER_BUS_CONFLICTS	FALSE	/* emulate bus conflicts on some mappers */


typedef void(*fp_init_mapper)(void);
void mapper_set_init(BYTE,fp_init_mapper);
void mapper_set_init_std(void);
void mapper_init(void);
void mapper_init_mapper(BYTE);
void mapinit_unsup(void);
void mapper_clean(void);
void mapper_clean_mapper(void);
BYTE mapper_supported(BYTE);
void mapper_kill_cycle(void);
BYTE mapper_battery_custom_load(void);
BYTE mapper_battery_custom_save(void);
void __fastcall mapppubus_nothing(register WORD);
void __fastcall mapio_nothing(register WORD,register BYTE,register BYTE);
BYTE __fastcall mapio_nothing_r(register WORD);
void __fastcall mapirq_nothing(void);
void mapper_new_frame(void);


/* ave */
void mapinit_nina1(void); void __fastcall mapio_nina1(register WORD,register BYTE,register BYTE); void __fastcall mapio_bnrom(register WORD,register BYTE,register BYTE); /* 34 */
void mapinit_aved1012(void); void __fastcall mapio_aved1012(register WORD,register BYTE,register BYTE); BYTE __fastcall mapio_r_aved1012(register WORD); /* 234 */

/* irem */
void mapinit_iremg101(void); void __fastcall mapio_iremg101(register WORD,register BYTE,register BYTE); /* 32 */
void mapinit_iremh3001(void); void __fastcall mapio_iremh3001(register WORD,register BYTE,register BYTE); void __fastcall mapirq_iremh3001(void); /* 65 */

/* mmc1 */
void mapinit_mmc1(void); void __fastcall mapio_mmc1(register WORD,register BYTE,register BYTE); /* 1,155 */

/* mmc2 */
void mapinit_mmc2(void); void __fastcall mapio_mmc2(register WORD,register BYTE,register BYTE); BYTE __fastcall mapper_mmc2_ppu_read_pt0d(register WORD); BYTE __fastcall mapper_mmc2_ppu_read_pt1d(register WORD); /* 9,10 */

/* mmc3 */
void mapinit_mmc3(void); void __fastcall mapio_mmc3(register WORD,register BYTE,register BYTE); void __fastcall mapirq_mmc3(void); void __fastcall mapppubus_mmc3(register WORD); /* 4,95,118,119 */
BYTE __fastcall mapio_mmc6_wram_handler_r(register WORD); void __fastcall mapio_mmc6_wram_handler_w(register WORD,register BYTE,register BYTE); void __fastcall mapirq_mmc6(void); void __fastcall mapppubus_mmc6(register WORD); /* 4 */

/* mmc5 */
void mapinit_mmc5(void); void __fastcall mapio_mmc5_w(register WORD,register BYTE,register BYTE); BYTE __fastcall mapio_mmc5_r(register WORD); void __fastcall mapio_mmc5_wpb(register WORD,register BYTE,register BYTE); BYTE __fastcall mapper_mmc5_ppu_read_pt0a(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt0b(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt0c(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt0d(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt1a(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt1b(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt1c(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_pt1d(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_name0(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_name1(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_name2(register WORD); BYTE __fastcall mapper_mmc5_ppu_read_name3(register WORD); void __fastcall mapper_mmc5_ppu_write_name0(register WORD,register BYTE); void __fastcall mapper_mmc5_ppu_write_name1(register WORD,register BYTE); void __fastcall mapper_mmc5_ppu_write_name2(register WORD,register BYTE); void __fastcall mapper_mmc5_ppu_write_name3(register WORD,register BYTE); void __fastcall mapirq_mmc5(void); /* 5 */

/* pirate */
void mapinit_smb2j(void); void __fastcall mapio_smb2j_8(register WORD,register BYTE,register BYTE); void __fastcall mapio_smb2j_a(register WORD,register BYTE,register BYTE); void __fastcall mapio_smb2j_e(register WORD,register BYTE,register BYTE); void __fastcall mapirq_smb2j(void); /* 40 */
void mapinit_mariobaby(void); void __fastcall mapio_mariobaby(register WORD,register BYTE,register BYTE); void __fastcall mapirq_mariobaby(void); /* 42 */

/* simple */
void mapinit_nrom(void); /* 0 */
void mapinit_unrom(void); void __fastcall mapio_unrom(register WORD,register BYTE,register BYTE); /* 2 */
void mapinit_cnrom(void); void __fastcall mapio_cnrom(register WORD,register BYTE,register BYTE); /* 3 */
void mapinit_aorom(void); void __fastcall mapio_aorom(register WORD,register BYTE,register BYTE); /* 7 */
void mapinit_colordreams(void); void __fastcall mapio_colordreams(register WORD,register BYTE,register BYTE); /* 11,144 */
void mapinit_cprom(void); void __fastcall mapio_cprom(register WORD,register BYTE,register BYTE); /* 13 */
void mapinit_gnrom(void); void __fastcall mapio_gnrom(register WORD,register BYTE,register BYTE); /* 66 */
void mapinit_bandai74161(void); void __fastcall mapio_bandai74161(register WORD,register BYTE,register BYTE); /* 70,152 */
void mapinit_camerica(void); void __fastcall mapio_camerica_ce(register WORD,register BYTE,register BYTE); /* 71 */
void __fastcall mapio_camerica_bf9097(register WORD,register BYTE,register BYTE); /* 71 */
void mapinit_jaleco74161(void); void __fastcall mapio_jaleco74161(register WORD,register BYTE,register BYTE); /* 87 */
void mapinit_sunsoft74161(void); void __fastcall mapio_sunsoft74161(register WORD,register BYTE,register BYTE); /* 93 */
void mapinit_capcom74161(void); void __fastcall mapio_capcom74161(register WORD,register BYTE,register BYTE); /* 94 */
void mapinit_irem74161(void); void __fastcall mapio_irem74161(register WORD,register BYTE,register BYTE); /* 97 */
void mapinit_cndis(void); void __fastcall mapio_cndis(register WORD,register BYTE,register BYTE); BYTE __fastcall mapper_cndis_ppu_read_pt0a(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt0b(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt0c(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt0d(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt1a(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt1b(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt1c(register WORD); BYTE __fastcall mapper_cndis_ppu_read_pt1d(register WORD); /*185 */
void mapinit_camerica_bf9096(void); void __fastcall mapio_camerica_bf9096_8a(register WORD,register BYTE,register BYTE); void __fastcall mapio_camerica_bf9096_ce(register WORD,register BYTE,register BYTE); /* 232 */

/* sunsoft */
void mapinit_sunsoft4(void); void __fastcall mapio_sunsoft4(register WORD,register BYTE,register BYTE); void __fastcall mapper_sunsoft4_ppu_write_name0(register WORD,register BYTE); void __fastcall mapper_sunsoft4_ppu_write_name1(register WORD,register BYTE); void __fastcall mapper_sunsoft4_ppu_write_name2(register WORD,register BYTE); void __fastcall mapper_sunsoft4_ppu_write_name3(register WORD,register BYTE); /* 68 */

/* taito */
void mapinit_taitotc0190(void); void __fastcall mapio_taitotc0190_8(register WORD,register BYTE,register BYTE); void __fastcall mapio_taitotc0190_a(register WORD,register BYTE,register BYTE); void __fastcall mapio_taitotc0350(register WORD,register BYTE,register BYTE); void __fastcall mapirq_taitotc0350(void); /* 33 */


#endif /* MAPPER_H */
