#ifndef FILE_H
#define FILE_H

#include "global.h"

#define FILE_PATCH_SHOW_SIZE	0x400	/* minimum size to show 'p'/'r'/'e' when applying an IPS patch, make large to disable */

typedef struct {
	char name[STRING_SIZE];
	char filename[STRING_SIZE];
	char filename_inzip[STRING_SIZE];
	char appdir[STRING_SIZE];
	char appname[STRING_SIZE];
	char batterydir[STRING_SIZE];
	char patchdir[STRING_SIZE];
	char palettedir[STRING_SIZE];
	
	DWORD crc32;
	DWORD size;

	int is_zip;
} File;

File* file;

void file_setfile(const char*,const char*);
int file_open(void);
int file_save(void);
int file_read(BYTE*,const int);
int file_write(const BYTE*,const int);
void file_close(void);
int file_locatedirectory(int,char*,const char*);
int file_patch_init(void);
void file_patch_close(void);

void file_init(void);
void file_clean(void);

#endif /* FILE_H */
