#include <ddraw.h>
#include <stdlib.h>
#include <windows.h>

#include "global.h"
#include "draw.h"
#include "log.h"

static struct {
	LPDIRECTDRAW ddraw;
} draw;	


int draw_init(HWND hwnd)
{
	memset(&draw,0,sizeof(draw));

	/* create it */
	if ((DirectDrawCreate(NULL,&draw.ddraw,NULL))!=DD_OK) {
		LOG(LOG_MISC|LOG_ERROR,"can't create DirectDraw!\n");
		draw_clean(); exit(1);
	}


	return 0;
}


void draw_clean(void)
{
	if (draw.ddraw) { IDirectDraw_Release(draw.ddraw); draw.ddraw=NULL; } /* free directdraw */
	
	LOG(LOG_VERBOSE,"draw cleaned\n");
}
