#ifndef CPU_MEMORYMAP_H
#define CPU_MEMORYMAP_H

#define CPU_RAM_INIT	0xff	/* fill CPU RAM with this on boot */

/*	confirmed behaviour: 0xff. CopyNES, and probably old FFE devices too?, empty RAM at start
	
	problems with 0x00:
	- Final Fantasy 1: Disch: problem with 'random' encounters (offset differs by 1: 0-ff=1)
	- Minna no Taabou no Nakayoshi Daisakusen: locks up at boot
	
	problems with 0xff:
	- Cybernoid: garbage graphics
	- pputime2: block moves to the right
	- Sayanoora: no sound ?
	- Scroll Demo (PD): won't work
	- Stars Demo (not SE): crashes
	- Super Mario Bros (several hacked versions): start at -1 world
*/

/* standard IO */
typedef __fastcall BYTE(*fp_cpu_read_io2000)(register WORD);
typedef __fastcall void(*fp_cpu_write_io2000)(register BYTE);
typedef __fastcall BYTE(*fp_cpu_read_io4000)(register WORD);
typedef __fastcall void(*fp_cpu_write_io4000)(register BYTE);
BYTE __fastcall cpu_read_io_nothing(register WORD);
void __fastcall cpu_write_io_nothing(register BYTE);
void cpu_set_io2000_std(void);
void cpu_set_io4000_std(void);
void cpu_set_read_io2000(WORD,fp_cpu_read_io2000);
void cpu_set_write_io2000(WORD,fp_cpu_write_io2000);
void cpu_set_read_io4000(WORD,fp_cpu_read_io4000);
void cpu_set_write_io4000(WORD,fp_cpu_write_io4000);

/* mapper IO functionpointers */
typedef __fastcall BYTE(*fp_cpu_read_io4020)(register WORD);
typedef __fastcall void(*fp_cpu_write_io4020)(register WORD,register BYTE,register BYTE);
typedef __fastcall BYTE(*fp_cpu_read_io6000)(register WORD);
typedef __fastcall void(*fp_cpu_write_io6000)(register WORD,register BYTE,register BYTE);
typedef __fastcall BYTE(*fp_cpu_read_io8000)(register WORD);
typedef __fastcall void(*fp_cpu_write_io8000)(register WORD,register BYTE,register BYTE);
void cpu_set_read_io4020(fp_cpu_read_io4020);
void cpu_set_write_io4020(fp_cpu_write_io4020);
void cpu_set_read_io6000(fp_cpu_read_io6000);
void cpu_set_write_io6000(fp_cpu_write_io6000);
void cpu_set_write_io8000(fp_cpu_write_io8000,fp_cpu_write_io8000,fp_cpu_write_io8000,fp_cpu_write_io8000);
void cpu_set_read_io8000(fp_cpu_read_io8000,fp_cpu_read_io8000,fp_cpu_read_io8000,fp_cpu_read_io8000);

/* memorymap read/write handlers: function declarations */
BYTE __fastcall cpu_read_ram(register WORD); BYTE __fastcall cpu_read_ppu(register WORD); BYTE __fastcall cpu_read_io(register WORD); BYTE __fastcall cpu_read_wram(register WORD); BYTE __fastcall cpu_read_prgbank1a(register WORD); BYTE __fastcall cpu_read_prgbank1b(register WORD); BYTE __fastcall cpu_read_prgbank2a(register WORD); BYTE __fastcall cpu_read_prgbank2b(register WORD);
void __fastcall cpu_write_ram(register WORD,register BYTE); void __fastcall cpu_write_ppu(register WORD,register BYTE); void __fastcall cpu_write_io(register WORD,register BYTE); void __fastcall cpu_write_wram(register WORD,register BYTE); void __fastcall cpu_write_prgbank1a(register WORD,register BYTE); void __fastcall cpu_write_prgbank1b(register WORD,register BYTE); void __fastcall cpu_write_prgbank2a(register WORD,register BYTE); void __fastcall cpu_write_prgbank2b(register WORD,register BYTE);

BYTE __fastcall cpu_read_wram_override(register WORD); void __fastcall cpu_write_wram_override(register WORD,register BYTE);
BYTE __fastcall cpu_read_prgbank1a_override(register WORD); BYTE __fastcall cpu_read_prgbank1b_override(register WORD); BYTE __fastcall cpu_read_prgbank2a_override(register WORD); BYTE __fastcall cpu_read_prgbank2b_override(register WORD);


void cpu_memmap_init(void);
void cpu_memmap_clean(void);

#endif /* CPU_MEMORYMAP_H */
