#ifndef PPU_H
#define PPU_H

enum { PPU_FPT_NORMAL=0, PPU_FPT_PT0, PPU_FPT_PT1, PPU_FPT_NT, PPU_FPT_CUSTOM };
#define PPU_FPT_ALL 8

typedef __fastcall BYTE(*fp_ppu_read_memorymap)(register WORD);
typedef __fastcall void(*fp_ppu_write_memorymap)(register WORD,register BYTE);
typedef __fastcall void(*fp_ppu_memcycle)(void);

/* write only */						/* 0x2000 */
/* write only */						/* 0x2001 */
BYTE __fastcall ppu_read_status(register WORD);			/* 0x2002 */
/* write only */						/* 0x2003 */
BYTE __fastcall ppu_read_sprite_memory_data(register WORD);	/* 0x2004 */
/* write only */						/* 0x2005 */
/* write only */						/* 0x2006 */
BYTE __fastcall ppu_read_memory_data(register WORD);		/* 0x2007 */
BYTE __fastcall ppu_read_openbus(register WORD);		/* for write-onlies */

void __fastcall ppu_write_control1(register BYTE);		/* 0x2000 */
void __fastcall ppu_write_control2(register BYTE);		/* 0x2001 */
/* read only */							/* 0x2002 */
void __fastcall ppu_write_sprite_memory_address(register BYTE);	/* 0x2003 */
void __fastcall ppu_write_sprite_memory_data(register BYTE);	/* 0x2004 */
void __fastcall ppu_write_scroll(register BYTE);		/* 0x2005 */
void __fastcall ppu_write_memory_address(register BYTE);	/* 0x2006 */
void __fastcall ppu_write_memory_data(register BYTE);		/* 0x2007 */

/* during warming-up */
void __fastcall ppu_write_control1_cold(register BYTE);
void __fastcall ppu_write_control2_cold(register BYTE);

void ppu_set_fpt (BYTE,BYTE,fp_ppu_read_memorymap,fp_ppu_read_memorymap,fp_ppu_read_memorymap,fp_ppu_read_memorymap,fp_ppu_write_memorymap,fp_ppu_write_memorymap,fp_ppu_write_memorymap,fp_ppu_write_memorymap);
void ppu_set_memcycle(fp_ppu_memcycle);
void ppu_init(void);
void ppu_clean(void);
void ppu_fill_palette_local(void);
void ppu_update_screen(void);
void ppu_new_frame(void);
void ppu_cold(void);
void ppu_warm(void);
__inline__ void ppu_force_update(void);

BYTE* ppu_get_enabled_ptr(void);
BYTE* ppu_get_valid_scanline_ptr(void);
BYTE* ppu_get_control1_ptr(void);
BYTE* ppu_get_control2_ptr(void);
BYTE* ppu_get_reading_sprites_ptr(void);
BYTE* ppu_get_rendering_ptr(void);
BYTE* ppu_get_vblank_ptr(void);
BYTE* ppu_get_hblank_ptr(void);
BYTE* ppu_get_sc_ptr(void);
WORD* ppu_get_scc_ptr(void);
WORD* ppu_get_address_ptr(void);
int* ppu_get_cycles_ptr(void);

#endif /* PPU_H */
