/* --- iNES mapper 33: Taito TC0190/TC0350: 2 types, different mirroring, irq ---
	Akira, Don Doko Don 1,2, etc. */

/* TODO:
	- register 3 of TC0350 ? (not irq related but chr mapping related ? )
	- IRQ handling is correct ? (use IRQs: Flintstones, Jetsons, Captain Saver) */

/* shared */

static void taitotc0350_new_frame(void);

#define TAITOTC0190_MIRRORING()	ppu_force_update(); \
				if (data&0x40) cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL; \
				else cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; \
				RESET_MIRRORING()

void mapinit_taitotc0190(void)
{
	strcpy(mapper.mappername,"Taito TC0190/TC0350");
	cpu_set_write_io8000(mapio_taitotc0190_8,mapio_taitotc0190_a,mapio_taitotc0350,mapio_taitotc0350);
	INIT_PRGBANKS_FIRSTLAST(); /* first 16k in 0x8000, last 16k in 0xc000 */
	/* no patbanks init */
	cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING();
	
	cpu_set_mapper_irq(mapirq_taitotc0350);
	mapnf=&taitotc0350_new_frame;
}

void __fastcall mapio_taitotc0190_8(register WORD address,register BYTE bus,register BYTE data)
{
	switch(address&3) {
		case 0: if (!mapper.taito_istc0350) { TAITOTC0190_MIRRORING(); } /* bit 6: set mirroring (only for TC0190) */
			PRG_BS(0,data&cartridge->prgbanks); break; /* select 8k prg bank at 0x8000 */
		case 1: PRG_BS(1,data&cartridge->prgbanks); break; /* select 8k prg bank at 0xc000 */
		case 2: case 3: /* 2: select 2k chr bank at 2:0x0/0x1000,3:0x800/0x1800 */
			ppu_force_update();
			PAT_BS(address<<1&2,data<<1&cartridge->vrombanks,vrom);
			PAT_BS((address<<1&2)|1,(data<<1&cartridge->vrombanks)|1,vrom);
			break;
	}
}

void __fastcall mapio_taitotc0190_a(register WORD address,register BYTE bus,register BYTE data)
{
	/* select 1k chr bank at 0:0x1000/0x0,1:0x1400/0x400,2:0x1800/0x800,3:0x1c00/0xc00 */
	ppu_force_update();
	PAT_BS((address&3)|4,data&cartridge->vrombanks,vrom);
}


/* TC0350-only */

void __fastcall mapio_taitotc0350(register WORD address,register BYTE bus,register BYTE data)
{
	switch (address&3) {
		case 0: /* >=e000: mirroring, else irq */
			if (address&0x2000) { mapper.taito_istc0350=TRUE; TAITOTC0190_MIRRORING(); }
			else { mapper.taitotc0350_irq_latch=mapper.taitotc0350_irq_count=data-1; }
			break;
		case 1: mapper.taitotc0350_irq_count=mapper.taitotc0350_irq_latch; break;
		case 2: mapper.taitotc0350_irq_isenabled=TRUE; break;
		case 3: cpu_acknowledge_interrupt(~IRQ_MAPPER); mapper.taitotc0350_irq_isenabled=FALSE; break;
	}
	
	#if DEBUG_MAPPER
	LOG(LOG_MAPPER,"%x %x\n",address,data);
	#endif
}

static void taitotc0350_new_frame(void) { mapper.sc=0; }
void __fastcall mapirq_taitotc0350(void) /* irq handler, based on scanlines */
{
	for (;;) {
		if (*mapper.cpu_cycles_ptr<crystal->sc[mapper.sc+1]) { /* new scanline */
			mapper.sc++;
			if (mapper.sc>239) return;
			if (*mapper.ppu_enabled_ptr&mapper.taitotc0350_irq_isenabled) {
				mapper.taitotc0350_irq_count++;
				if (mapper.taitotc0350_irq_count==0) {
					mapper.taitotc0350_irq_isenabled=FALSE;
					cpu_set_interrupt(INTERRUPT_IRQ|IRQ_MAPPER);
				}
			}
		}
		else break;
	}
}
