/* --- iNES mapper 68: Sunsoft 4 ---
	After Burner, After Burner 2, etc. */

#define SUNSOFT4_SET_NAMEDATA(x) if (!mapper.sunsoft4_ntvrom_isenabled) ppu_write_name##x(address,data)

static void sunsoft4_pat00bs(BYTE); static void sunsoft4_pat08bs(BYTE); static void sunsoft4_pat10bs(BYTE); static void sunsoft4_pat18bs(BYTE);
static void sunsoft4_nt0(BYTE); static void sunsoft4_nt1(BYTE); static void sunsoft4_mirroring(BYTE); static void sunsoft4_prgbs(BYTE);
typedef void(*fpt_sunsoft4_io)(BYTE);
static const fpt_sunsoft4_io sunsoft4_io[8]= { sunsoft4_pat00bs, sunsoft4_pat08bs, sunsoft4_pat10bs, sunsoft4_pat18bs, sunsoft4_nt0, sunsoft4_nt1, sunsoft4_mirroring, sunsoft4_prgbs };
static __inline__ void sunsoft4_nt(void);

void mapinit_sunsoft4(void)
{
	strcpy(mapper.mappername,"Sunsoft 4");
	cpu_set_write_io8000(mapio_sunsoft4,mapio_sunsoft4,mapio_sunsoft4,mapio_sunsoft4);
	ppu_set_fpt(PPU_FPT_NT,FALSE,NULL,NULL,NULL,NULL,mapper_sunsoft4_ppu_write_name0,mapper_sunsoft4_ppu_write_name1,mapper_sunsoft4_ppu_write_name2,mapper_sunsoft4_ppu_write_name3);
	INIT_PRGBANKS_FIRSTLAST(); /* 0x8000: first. 0xc000: last, hardwired */
	INIT_PATBANKS_FIRST();
	cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING();
	cartridge->wram_isenabled=TRUE;
}

/* ppu nametable writes */
void __fastcall mapper_sunsoft4_ppu_write_name0(register WORD address,register BYTE data) { SUNSOFT4_SET_NAMEDATA(0); } /* nametable 0: 0x2000-0x23ff */
void __fastcall mapper_sunsoft4_ppu_write_name1(register WORD address,register BYTE data) { SUNSOFT4_SET_NAMEDATA(1); } /* nametable 1: 0x2400-0x27ff */
void __fastcall mapper_sunsoft4_ppu_write_name2(register WORD address,register BYTE data) { SUNSOFT4_SET_NAMEDATA(2); } /* nametable 2: 0x2800-0x2bff */
void __fastcall mapper_sunsoft4_ppu_write_name3(register WORD address,register BYTE data) { SUNSOFT4_SET_NAMEDATA(3); } /* nametable 3: 0x2c00-0x2fff */
void __fastcall mapio_sunsoft4(register WORD address,register BYTE bus,register BYTE data) { sunsoft4_io[address>>12&7](data); } /* shortcuts: call one of the underneath functions */
/* --- */

static void sunsoft4_pat00bs(BYTE data) { int i=data<<1&MAXVROM; ppu_force_update(); PAT_BS(0,i++,vrom); PAT_BS(1,i,vrom); } /* select 2k chr bank in ppu 0x0000 */
static void sunsoft4_pat08bs(BYTE data) { int i=data<<1&MAXVROM; ppu_force_update(); PAT_BS(2,i++,vrom); PAT_BS(3,i,vrom); } /* select 2k chr bank in ppu 0x0800 */
static void sunsoft4_pat10bs(BYTE data) { int i=data<<1&MAXVROM; ppu_force_update(); PAT_BS(4,i++,vrom); PAT_BS(5,i,vrom); } /* select 2k chr bank in ppu 0x1000 */
static void sunsoft4_pat18bs(BYTE data) { int i=data<<1&MAXVROM; ppu_force_update(); PAT_BS(6,i++,vrom); PAT_BS(7,i,vrom); } /* select 2k chr bank in ppu 0x1800 */
static void sunsoft4_nt0(BYTE data) { mapper.sunsoft4_ntvrom_bank[0]=(data|0x80)&MAXVROM; sunsoft4_nt(); } /* select nametable 0 chr bank (from last 128) */
static void sunsoft4_nt1(BYTE data) { mapper.sunsoft4_ntvrom_bank[1]=(data|0x80)&MAXVROM; sunsoft4_nt(); } /* select nametable 1 chr bank (from last 128 ) */
static void sunsoft4_mirroring(BYTE data) /* set mirroring/nametable vram/vrom */
{
	ppu_force_update();
	mapper.sunsoft4_mirroring=data&3;
	mapper.sunsoft4_ntvrom_isenabled=data>>4&1;
	if (mapper.sunsoft4_ntvrom_isenabled) { sunsoft4_nt(); }
	else { /* standard (ppu internal vram) mirroring */
		switch (mapper.sunsoft4_mirroring) {
			case 0: cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; break;
			case 1: cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL; break;
			case 2: cartridge->mirroring=CARTRIDGE_MIRRORING_ONE_0; break;
			case 3: cartridge->mirroring=CARTRIDGE_MIRRORING_ONE_1; break;
			default: break;
		}
		RESET_MIRRORING();
	}
}
static void sunsoft4_prgbs(BYTE data) { int i=data<<1&MAXPRG; PRG_BS(0,i++); PRG_BS(1,i); } /* select 16k prg bank in 0x8000 */
static __inline__ void sunsoft4_nt(void) /* set mirroring/nametables */
{
	ppu_force_update();
	if (mapper.sunsoft4_ntvrom_isenabled) { /* set chr rom to nametable bank */
		switch (mapper.sunsoft4_mirroring) {
			case 0: mapper.ppu_memmap_cur_name_ptr[0]=mapper.ppu_memmap_cur_name_ptr[2]=cartridge->vrom[mapper.sunsoft4_ntvrom_bank[0]]; mapper.ppu_memmap_cur_name_ptr[1]=mapper.ppu_memmap_cur_name_ptr[3]=cartridge->vrom[mapper.sunsoft4_ntvrom_bank[1]]; break;
			case 1: mapper.ppu_memmap_cur_name_ptr[0]=mapper.ppu_memmap_cur_name_ptr[1]=cartridge->vrom[mapper.sunsoft4_ntvrom_bank[0]]; mapper.ppu_memmap_cur_name_ptr[2]=mapper.ppu_memmap_cur_name_ptr[3]=cartridge->vrom[mapper.sunsoft4_ntvrom_bank[1]]; break;
			case 2: mapper.ppu_memmap_cur_name_ptr[0]=mapper.ppu_memmap_cur_name_ptr[1]=mapper.ppu_memmap_cur_name_ptr[2]=mapper.ppu_memmap_cur_name_ptr[3]=cartridge->vrom[mapper.sunsoft4_ntvrom_bank[0]]; break;
			case 3: mapper.ppu_memmap_cur_name_ptr[0]=mapper.ppu_memmap_cur_name_ptr[1]=mapper.ppu_memmap_cur_name_ptr[2]=mapper.ppu_memmap_cur_name_ptr[3]=cartridge->vrom[mapper.sunsoft4_ntvrom_bank[1]]; break;
			default: break;
		}
	}
}
