/* --- iNES mapper 40: Super Mario Bros 2 (J) FDS pirate ---
	Super Mario Bros 2 (J) (The Lost Levels) (FDS->NES ROM hack). */

static void smb2j_new_frame(void);

void mapinit_smb2j(void)
{
	strcpy(mapper.mappername,"Super Mario Bros 2 (J) FDS pirate");
	cpu_set_write_io8000(mapio_smb2j_8,mapio_smb2j_a,NULL,mapio_smb2j_e);
	cpu_set_mapper_irq(mapirq_smb2j);
	mapnf=&smb2j_new_frame;
	mapper.smb2j_irq_hit=CYCLE_WRITE_DELAY+(4096*crystal->cycle); /* 0x1000 */

	INIT_PATBANKS_FIRST(); /* 8k vrom */
	
	/* prgbanks: 0=4, 1=5, 2=switchable, 3=7, 0x6000-0x7fff=6 */
	DEF_PRGBANK_6000();
	PRG_6000_BS(6);
	INIT_PRGBANKS_LAST();
}

void __fastcall mapio_smb2j_8(register WORD address,register BYTE bus,register BYTE data) { mapper.smb2j_irq_isenabled=mapper.smb2j_irq_count=0; cpu_acknowledge_interrupt(~IRQ_MAPPER); } /* 0x8000-0x9fff: disable irq */
void __fastcall mapio_smb2j_a(register WORD address,register BYTE bus,register BYTE data) { mapper.smb2j_irq_isenabled=TRUE; } /* 0xa000-0xbfff: enable irq */
void __fastcall mapio_smb2j_e(register WORD address,register BYTE bus,register BYTE data) { PRG_BS(2,data&MAXPRG); }  /* 0xe000-0xffff: prg bankswitch */

static void smb2j_new_frame(void) { mapper.cycles_old+=crystal->frame; }
void __fastcall mapirq_smb2j(void) /* irq handler, based on cpu cycles, irq generated after 4096 cycles */
{
	if (mapper.smb2j_irq_isenabled) {
		mapper.smb2j_irq_count+=(mapper.cycles_old-*mapper.cpu_cycles_ptr);
		if (mapper.smb2j_irq_count>=mapper.smb2j_irq_hit) { cpu_set_interrupt(INTERRUPT_IRQ|IRQ_MAPPER); mapper.smb2j_irq_count-=mapper.smb2j_irq_hit; }
	}
	mapper.cycles_old=*mapper.cpu_cycles_ptr;
}





/* --- iNES mapper 42: Bio Miracle Bokutte Upa FDS pirate
	Bio Miracle Bokutte Upa (aka Mario Baby) (FDS->NES ROM hack). */

/* TODO:
	IRQ handler is correct ? */

static void mariobaby_new_frame(void);

void mapinit_mariobaby(void)
{
	strcpy(mapper.mappername,"Bio Miracle Bokutte Upa FDS pirate");
	cpu_set_write_io8000(NULL,NULL,NULL,mapio_mariobaby);
	cpu_set_mapper_irq(mapirq_mariobaby);
	mapnf=&mariobaby_new_frame;
	mapper.mariobaby_irq_hit=CYCLE_WRITE_DELAY+(24576*crystal->cycle); /* 0x6000 */

	INIT_PATBANKS_FIRST(); /* 8k vram */
	
	/* prgbanks: 0=c, 1=d, 2=e, 3=f, 0x6000-0x7fff=switchable */
	DEF_PRGBANK_6000();
	INIT_PRGBANKS_LAST();
}

void __fastcall mapio_mariobaby(register WORD address,register BYTE bus,register BYTE data)
{
	switch (address&3) {
		case 0: PRG_6000_BS(data&MAXPRG); break; /* select 8k prgbank */
		case 1: /* set mirroring */
			ppu_force_update();
			if (data&BIN8(00001000)) cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL;
			else cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL;
			RESET_MIRRORING();
			break;
		case 2: /* enable/disable irq */
			mapper.mariobaby_irq_isenabled=data>>1&1;
			if (!mapper.mariobaby_irq_isenabled) { mapper.mariobaby_irq_count=0; cpu_acknowledge_interrupt(~IRQ_MAPPER); }
			break;
		case 3: break; /* nothing */
	}
}

static void mariobaby_new_frame(void) { mapper.cycles_old+=crystal->frame; }
void __fastcall mapirq_mariobaby(void) /* irq handler, based on cpu cycles, irq generated after 24576 cycles */
{
	cpu_acknowledge_interrupt(~IRQ_MAPPER); /* it seems to expect the irqline to go down after an irq */
	if (mapper.mariobaby_irq_isenabled) {
		mapper.mariobaby_irq_count+=(mapper.cycles_old-*mapper.cpu_cycles_ptr);
		if (mapper.mariobaby_irq_count>=mapper.mariobaby_irq_hit) { cpu_set_interrupt(INTERRUPT_IRQ|IRQ_MAPPER); mapper.mariobaby_irq_count-=mapper.mariobaby_irq_hit; }
	}
	mapper.cycles_old=*mapper.cpu_cycles_ptr;
}
