/* --- iNES mapper 9: MMC2(NES-PNROM/NES-PEEOROM) ---
	Punch Out
   --- iNES mapper 10: MMC4(HVC-FJROM): same as MMC2, except it can switch 16k prg instead of 8k, and has wram ---
	Famicom Wars, Fire Emblem, Fire Emblem Gaiden. */

#define MMC2_SETLATCH(r,l) ppu_force_update(); mapper.mmc2_register[r][l]=data<<2&MAXVROM; mmc2_bankswitch(l)
#define MMC2_GET_PATDATA(x) BYTE ret=*mapper.ppu_memmap_buffer_ptr; *mapper.ppu_memmap_buffer_ptr=cartridge->cur_patbank[x][address&0x3ff]
#define MMC2_LATCH_PAT(x) address&=BIN8(11111000); if ((address==0xd8)|(address==0xe8)) { mapper.mmc2_latch[x]=address; mmc2_bankswitch(x); } return ret

static void mmc2_nothing(BYTE);
static void mmc2_prgswitch(BYTE); static void mmc4_prgswitch(BYTE);
static void mmc2_bs0fd(BYTE); static void mmc2_bs0fe(BYTE); static void mmc2_bs1fd(BYTE); static void mmc2_bs1fe(BYTE);
static void mmc2_mirroring(BYTE);
static __inline__ void mmc2_bankswitch(register BYTE);
typedef void(*fpt_mmc2_io)(BYTE);
static fpt_mmc2_io mmc2_io[8]= { mmc2_nothing, mmc2_nothing, mmc2_nothing, mmc2_bs0fd, mmc2_bs0fe, mmc2_bs1fd, mmc2_bs1fe, mmc2_mirroring };

void mapinit_mmc2(void)
{
	cpu_set_write_io8000(NULL,mapio_mmc2,mapio_mmc2,mapio_mmc2);
	ppu_set_fpt(PPU_FPT_CUSTOM,0x0f,mapper_mmc2_ppu_read_pt0d,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
	ppu_set_fpt(PPU_FPT_CUSTOM,0x1f,mapper_mmc2_ppu_read_pt1d,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
	PRG_BS(2,MAXPRG-1); PRG_BS(3,MAXPRG);
	if (cartridge->type==9) { /* mmc2 */
		strcpy(mapper.mappername,"MMC2 NES-PxROM");
		PRG_BS(0,0); PRG_BS(1,MAXPRG-2); /* prgbanks: first 8k into 0x8000, last 3 from 0xa000 are fixed */
		mmc2_io[2]=mmc2_prgswitch;
	}
	else { /* mmc4 */
		strcpy(mapper.mappername,"MMC4 NES-FxROM");
		PRG_BS(0,0); PRG_BS(1,1); /* prgbanks: first 16k into 0x8000, last 16k from 0xc000 is fixed */
		mmc2_io[2]=mmc4_prgswitch;
		cartridge->wram_isenabled=TRUE;
	}
	/* no patbanks init */
	
	memset(mapper.mmc2_latch,0xe8,2);
	cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING();
}

BYTE __fastcall mapper_mmc2_ppu_read_pt0d(register WORD address) { MMC2_GET_PATDATA(3); MMC2_LATCH_PAT(0); } /* ppu patterntable read 0x0c00-0x0fff (0x0f00-0x0fff), same as normal, but including latch check */
BYTE __fastcall mapper_mmc2_ppu_read_pt1d(register WORD address) { MMC2_GET_PATDATA(7); MMC2_LATCH_PAT(1); } /* ppu patterntable read 0x1c00-0x1fff (0x1f00-0x1fff), same as normal, but including latch check */
void __fastcall mapio_mmc2(register WORD address,register BYTE bus,register BYTE data) { mmc2_io[address>>12&7](data); } /* shortcuts: call one of the underneath functions */
static void mmc2_nothing(BYTE data) { return; } /* won't be called */
static void mmc2_prgswitch(BYTE data) { PRG_BS(0,data&MAXPRG); } /* switch 8k prgbank in 0x8000 */
static void mmc4_prgswitch(BYTE data) { PRG_BS(0,data<<1&MAXPRG); PRG_BS(1,(1|data<<1)&MAXPRG); } /* switch 16k prgbank in 0x8000 */
static void mmc2_bs0fd(BYTE data) { MMC2_SETLATCH(0,0); } /* select pattern bank for 0xfd latch 0 */
static void mmc2_bs0fe(BYTE data) { MMC2_SETLATCH(1,0); } /* select pattern bank for 0xfe latch 0 */
static void mmc2_bs1fd(BYTE data) { MMC2_SETLATCH(0,1); } /* select pattern bank for 0xfd latch 0x1000 */
static void mmc2_bs1fe(BYTE data) { MMC2_SETLATCH(1,1); } /* select pattern bank for 0xfe latch 0x1000 */
static void mmc2_mirroring(BYTE data)
{
	/* bit 0: reset mirroring: 0=vertical, 1=horizontal */
	ppu_force_update();
	if (data&1) cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL;
	else cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL;
	RESET_MIRRORING();
}

static __inline__ void mmc2_bankswitch(register BYTE latch)
{
	register BYTE b=latch<<2;
	register int reg=mapper.mmc2_register[mapper.mmc2_latch[latch]>>5&1][latch];
	PAT_BS(b++,reg++,vrom); PAT_BS(b++,reg++,vrom); PAT_BS(b++,reg++,vrom); PAT_BS(b,reg,vrom);
}
