/* --- iNES mapper 32: Irem G-101, 2 types (different mirroring) ---
	Paaman 1,2, Kaiketsu Yanchamaru 2, etc. */

#define IREMG101_BS()	if (mapper.iremg101_bsb) { PRG_BS(0,MAXPRG-1); PRG_BS(2,mapper.iremg101_prg); } \
			else { PRG_BS(0,mapper.iremg101_prg); PRG_BS(2,MAXPRG-1); }

static void iremg101_prg8cbs(WORD,BYTE); static void iremg101_prgabs(WORD,BYTE); static void iremg101_reg(WORD,BYTE); static void iremg101_patbs(WORD,BYTE);
typedef void(*fpt_iremg101_io)(WORD,BYTE);
static const fpt_iremg101_io iremg101_io[4]= { iremg101_prg8cbs, iremg101_reg, iremg101_prgabs, iremg101_patbs };

void mapinit_iremg101(void)
{
	mapper.iremg101_type=(cartridge->crc32==CRC32_MAJOR_LEAGUE_J)<<6;
	if (mapper.iremg101_type) {
		strcpy(mapper.mappername,"Irem G-101 type 2");
		cartridge->mirroring=0; RESET_MIRRORING();
	}
	else {
		strcpy(mapper.mappername,"Irem G-101 type 1");
		cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING();
	}
	
	cpu_set_write_io8000(mapio_iremg101,mapio_iremg101,NULL,NULL);
	INIT_PRGBANKS_FIRSTLAST(); /* first 16k in 0x8000, last 16k in 0xc000 */
	/* no patbanks init */
	cartridge->wram_isenabled=TRUE; /* Image Fight */
}

void __fastcall mapio_iremg101(register WORD address,register BYTE bus,register BYTE data) { iremg101_io[address>>12&3](address,data); } /* 8, 9, a, b */

static void iremg101_prg8cbs(WORD address,BYTE data) { mapper.iremg101_prg=data&MAXPRG; IREMG101_BS(); } /* select 8k prg bank at 0x8000 or 0xc000 */
static void iremg101_prgabs(WORD address,BYTE data) { PRG_BS(1,data&MAXPRG); } /* select 8k prg bank at 0xa000 */
static void iremg101_patbs(WORD address,BYTE data) {
	ppu_force_update(); PAT_BS(address&7,data&MAXVROM,vrom); /* select 1k chr bank */
	if (data&mapper.iremg101_type) { cartridge->mirroring=~address&1; RESET_MIRRORING(); } /* type 2: bit 6: set custom mirroring */
}
static void iremg101_reg(WORD address,BYTE data) /* set mirroring and switch register */
{
	ppu_force_update();
	mapper.iremg101_bsb=data&2;
	IREMG101_BS();
	if (data&1) cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL;
	else cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL;
	RESET_MIRRORING();
}





/* iNES mapper 65: Irem H-3001 ---
	Daiku no Gen San 2, Kaiketsu Yanchamaru 3, Spartan X 2, etc? */

/* TODO:
	0x9000?: Spartan X 2 writes 0x40 to it, other games 0
	0x9002?
	IRQ handling is correct ? Spartan X 2 intro/Daiku no Gen San 2 titlescreen scroll */

static void iremh3001_new_frame(void);

void mapinit_iremh3001(void)
{
	strcpy(mapper.mappername,"Irem H-3001");
	cpu_set_mapper_irq(mapirq_iremh3001);
	mapnf=&iremh3001_new_frame;
	cpu_set_write_io8000(mapio_iremh3001,mapio_iremh3001,mapio_iremh3001,mapio_iremh3001);
	INIT_PRGBANKS_FIRSTLAST(); /* first 16k in 0x8000, last 16k in 0xc000 */
	/* no patbanks init */
	cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL; RESET_MIRRORING();
}

void __fastcall mapio_iremh3001(register WORD address,register BYTE bus,register BYTE data)
{
	switch (address) {
		case 0x8000: PRG_BS(0,data&MAXPRG); break; /* select 8k prg bank at 0x8000 */
		case 0x9001: /* set mirroring */
			ppu_force_update();
			if (data&0x80) cartridge->mirroring=CARTRIDGE_MIRRORING_HORIZONTAL;
			else cartridge->mirroring=CARTRIDGE_MIRRORING_VERTICAL;
			RESET_MIRRORING();
			break;
		case 0x9003: mapper.iremh3001_irq_isenabled=data&0x80; if (mapper.iremh3001_irq_isenabled==0) cpu_acknowledge_interrupt(~IRQ_MAPPER); break; /* enable/disable irqs */
		case 0x9004: mapper.iremh3001_irq_count=CYCLE_WRITE_DELAY+(mapper.iremh3001_irq_latch*crystal->cycle); break; /* set irq counter */
		case 0x9005: mapper.iremh3001_irq_latch=(mapper.iremh3001_irq_latch&0xff)|(data<<8); break; /* set irq latch: high byte */
		case 0x9006: mapper.iremh3001_irq_latch=(mapper.iremh3001_irq_latch&0xff00)|data; break; /* set irq latch: low byte */
		case 0xa000: PRG_BS(1,data&MAXPRG); break; /* select 8k prg bank at 0xa000 */
		case 0xb000: case 0xb001: case 0xb002: case 0xb003: case 0xb004: case 0xb005: case 0xb006: case 0xb007: /* select 1k chr bank */
			ppu_force_update(); PAT_BS(address&7,data&MAXVROM,vrom); break;
		case 0xc000: PRG_BS(2,data&MAXPRG); break; /* select 8k prg bank at 0xc000 */
		
		default:
			#if DEBUG_MAPPER
			LOG(LOG_MAPPER,"%x %x\n",address,data);
			#endif
			break;
	}
}

static void iremh3001_new_frame(void) { mapper.cycles_old+=crystal->frame; }
void __fastcall mapirq_iremh3001(void) /* irq handler, based on cpu cycles */
{
	if (mapper.iremh3001_irq_isenabled) {
		if (mapper.iremh3001_irq_count<=0) {
			cpu_set_interrupt(INTERRUPT_IRQ|IRQ_MAPPER);
			mapper.iremh3001_irq_isenabled=FALSE;
		}
		mapper.iremh3001_irq_count-=(mapper.cycles_old-*mapper.cpu_cycles_ptr);
	}
	mapper.cycles_old=*mapper.cpu_cycles_ptr;
}
