#include <windows.h>

#include "global.h"
#include "version.h"
#include "resource.h"
#include "crystal.h"
#include "cpu.h"
#include "ppu.h"
#include "cpu_memorymap.h"
#include "ppu_memorymap.h"
#include "cartridge.h"
#include "mapper.h"
#include "palette.h"
#include "input.h"
#include "log.h"
#include "file.h"
#include "sound.h"
#include "draw.h"
#include "apu.h"

#define TIMERMESSAGE (WM_APP+1)

static MMRESULT timer;
BITMAPINFO bmp_info;
HDC hdc, bitmaphdc;
HBITMAP hbitmap;
HWND hwnd;

int runrun=0;
int busy=0;
#define SIZMUL 1
#define YCLIP 0
#define XX 256
#define YY 240
const int winsizex=XX*SIZMUL;
const int winsizey=(YY-YCLIP*2)*SIZMUL;

LRESULT CALLBACK WndProc(HWND,UINT,WPARAM,LPARAM);		/* messages are sent to here */
void CALLBACK timer_timeout(UINT,UINT,DWORD,DWORD,DWORD);	/* this gets called by the timer at specific intervals */

void CALLBACK timer_timeout(UINT timer_ID, UINT timer_info, DWORD dwUser, DWORD dw1, DWORD dw2)
{
	PostMessage (hwnd, TIMERMESSAGE, 0, 0);
}






LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	
	switch(msg)
	{
		
		/* window is created */
		case WM_CREATE:
			
			break;
		
		/* window is repainted */
		case WM_PAINT:
			BeginPaint(hwnd,&ps);

			BitBlt(hdc,0,-YCLIP*2,XX*SIZMUL,YY*SIZMUL-YCLIP*2,bitmaphdc,0,0,SRCCOPY);
			
			EndPaint (hwnd,&ps);
			break;
			
		/* window is being closed */
		case WM_CLOSE:
			/* clean up */
			if (runrun) timeKillEvent(timer);
			DeleteObject(hbitmap);
			DeleteDC(bitmaphdc);
			ReleaseDC(hwnd,hdc);
			free(screen);
			
			if (runrun) cartridge_battery_save();
			if (runrun) ppu_clean();
			if (runrun) apu_clean();
			if (runrun) cpu_clean();
			if (runrun) cpu_memmap_clean();
			if (runrun) ppu_memmap_clean();
			if (runrun) palette_save();
			if (runrun) palette_clean();
			if (runrun) mapper_clean();
			
			cartridge_unload();
			cartridge_clean();
			file_clean();
			crystal_clean();
			
			input_clean();
			sound_clean();
			draw_clean();
			
			DestroyWindow(hwnd); /* calls WM_DESTROY too */
			break;
		
		/* window is really closed */
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		
		
		
		/* the timer: custom message, gets called 50 or 60 times a second */
		case TIMERMESSAGE:
			if (busy==0) {
				busy=1;

				/* new frame */
				crystal_new_frame();
				ppu_new_frame();
				cpu_new_frame();
				mapper_new_frame();
				if (crystal->odd_frame) {
					cpu_execute(crystal->sc[1]);
					ppu_force_update();
				}
				cpu_execute(crystal->vblank_trigger);
				ppu_force_update();
				cpu_do_vblank_nmi();
				/*ppu_update_screen();*/
				PostMessage(hwnd,WM_PAINT,0,0);

				/* vblank */
				input_read(hwnd);
				cpu_execute(0);

				busy=0;
			}
			break;
		default:
			return DefWindowProc(hwnd, msg, wParam, lParam);
	}
	return FALSE;
}



int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASSEX wc;
	MSG Msg;


	log_init();

	
	LOG(LOG_MISC,"Welcome to %s %s (%s), built on %s, %s\n",VERSION_NAME_S,VERSION_NUMBER_S,VERSION_STAGE_S,version_get(VERSION_TIME),version_get(VERSION_DATE));

	/* register the window class */
	wc.cbSize=sizeof(WNDCLASSEX);	/* struct size */
	wc.style=0;			/* class style */
	wc.lpfnWndProc=WndProc;		/* pointer to wndproc */
	wc.cbClsExtra=0;		/* extra allocated data */
	wc.cbWndExtra=0;		/* extra allocated memory */
	wc.hInstance=hInstance;		/* handle to app instance */
	wc.hIcon=LoadIcon(GetModuleHandle(NULL),MAKEINTRESOURCE(ID_ICON));			/* 32x32 icon (alt-tab */
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);			/* cursor when it's over the window */
	wc.hbrBackground=(HBRUSH)GetStockObject(WHITE_BRUSH);	/* bg colour */
	wc.lpszMenuName=NULL;		/* name of menu resource */
	wc.lpszClassName=VERSION_NAME_S;	/* class name */
	wc.hIconSm=LoadIcon(GetModuleHandle(NULL),MAKEINTRESOURCE(ID_ICON));		/* small icon (top left, file) */

	if(!RegisterClassEx(&wc)) { MessageBox(NULL, "Window registration failed!", "Error!",MB_ICONEXCLAMATION | MB_OK); exit(1); }
	
	/* create window */
	hwnd = CreateWindowEx (
			WS_EX_CLIENTEDGE,	/* extended style */
			VERSION_NAME_S,		/* kind of window: same as class */
			VERSION_NAME_S,		/* window title */
			WS_SYSMENU | WS_MINIMIZEBOX | WS_CAPTION | WS_VISIBLE,	/* window style */
			CW_USEDEFAULT,		/* x placement */
			CW_USEDEFAULT,		/* y placement */
			10+winsizex,		/* width */
			29+winsizey,		/* height */
			NULL,			/* parent window handle */
			NULL,			/* menu handle */
			hInstance,		/* app instance handle */
			NULL			/* pointer to window creation data */
	);

	if(hwnd == NULL) { MessageBox(NULL, "Window creation failed!", "Error!",MB_ICONEXCLAMATION | MB_OK); exit(1); }

	hdc=GetDC(hwnd);
	
	/* init BITMAPINFO */
	memset (&bmp_info,0,sizeof(bmp_info));
	bmp_info.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth=XX*SIZMUL;
	bmp_info.bmiHeader.biHeight=-YY*SIZMUL; /* should be negative for DI bitmaps */
	bmp_info.bmiHeader.biPlanes=1;
	bmp_info.bmiHeader.biBitCount=32;
	bmp_info.bmiHeader.biCompression=BI_RGB; /* no compression */
	bmp_info.bmiHeader.biClrUsed=0;
			
	/* create the vram/mono bmp */
	hbitmap = CreateDIBSection(
		hdc,		/* dc handle */
		&bmp_info,	/* location of bitmapinfo */
		DIB_RGB_COLORS,	/* colour mode */
		(void*)&screen,	/* pixel data pointer */
		NULL,		/* handle to file mapping object */
 		0		/* offset to bitmap bit values */
	);
	
	/*
	bitmaphdc=CreateCompatibleDC(hdc);
	SelectObject(bitmaphdc,hbitmap);
	*/
	
	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	draw_init(hwnd);
	sound_init(hwnd);
	input_init(hwnd);
	file_init();
	crystal_init();
	mapper_init();
	cartridge_init();
	file_setfile(lpCmdLine,".nes");
	
	if (cartridge_load()) {
	
	runrun=1;
	
	palette_init();
	ppu_memmap_init();
	cpu_memmap_init();
	crystal_set_mode(cartridge->mode);
	mapper_init_mapper(cartridge->type);
	cartridge_battery_load();
	
	cpu_init();
	apu_init();
	ppu_init();
	cpu_reset();


	

	crystal_new_frame();
	ppu_new_frame();
	cpu_new_frame();
	mapper_new_frame();
	
	ppu_cold();
	
	
	if (crystal->odd_frame) {
		cpu_execute(crystal->sc[1]);
		ppu_force_update();
	}
	cpu_execute(crystal->vblank_trigger);
	ppu_force_update();
	cpu_do_vblank_nmi();
	PostMessage(hwnd,WM_PAINT,0,0);

	input_read(hwnd);
	cpu_execute(0);
	
	ppu_warm();


	


	timer=timeSetEvent(
		17,	/* delay in milliseconds */
		0,		/* accuracy: lower=higher */
		(LPTIMECALLBACK)timer_timeout,	/* pointer to callback function */
		0,		/* custom callback data */
		TIME_PERIODIC	/* timer type: infinite */
	);
	
	}
	
	else {
		DeleteObject(hbitmap);
		hbitmap=LoadImage(GetModuleHandle(NULL),MAKEINTRESOURCE(ID_SPLASH),IMAGE_BITMAP,48,48,0);
		PostMessage(hwnd,WM_PAINT,0,0);
		
	}


	bitmaphdc=CreateCompatibleDC(hdc);
	SelectObject(bitmaphdc,hbitmap);




	/* messageloop */
	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
	return Msg.wParam;
}
