#ifndef LOG_H
#define LOG_H

#define LOG_MISC	0x1
#define LOG_CPU		0x2
#define LOG_PPU		0x3
#define LOG_CPU_MMAP	0x4
#define LOG_MAPPER	0x5
#define LOG_VERBOSE	0x6
#define LOG_WARNING	0x10
#define LOG_ERROR	0x20

#define DEBUG_CPU	FALSE	/* cpu opcodes */
#define DEBUG_CPU_MMAP	FALSE	/* cpu memory accesses */
#define DEBUG_PPU	FALSE	/* ppu scanline/hblank/vblank */
#define DEBUG_MAPPER	FALSE	/* various mapper related */
#define DEBUG_VERBOSE	FALSE	/* quite useless info */
#define DEBUG_MISC	TRUE	/* quite useful info, false: show only errors/warnings */

#define LOG_OVERFLOW_LENGTH 78	/* maximum width of 1 logged line */


void LOG(int,const char*,...);
void LOG_BIN(int,DWORD,const char*);
void log_init(void);
void log_set_frame_start(QWORD);

#endif /* LOG_H */
