#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "log.h"
#include "crystal.h"

static struct {
	QWORD frame_start;
} _log;


void log_init(void)
{
	memset(&_log,0,sizeof(_log));
}

void log_set_frame_start(QWORD f)
{
	_log.frame_start=f;
}


void LOG(int type,const char* text,...)
{
	int i,j,k,l,m,n,o,p;
	const char overflow_cut[]= { ' ', ',', '.', '!', '?', ':', '/', '\\', '\0' };
	const char overflow_add[]= { '\n', ' ', '\0' };
	const char overflow_skip[]={ ' ', '\t', '\0' };
	char buffer[STRING_SIZE+STRING_SIZE];
	char buffer_temp[STRING_SIZE];
	va_list ap;
	
	va_start(ap,text);
	vsprintf(buffer,text,ap);
	
	if (strlen(buffer)>LOG_OVERFLOW_LENGTH) {
		memcpy(buffer_temp,buffer,sizeof(char)*STRING_SIZE);
		i=1; l=0; m=0;
		for(;;) {
			overflow_start:
			for (j=(i*LOG_OVERFLOW_LENGTH)-LOG_OVERFLOW_LENGTH-l;j<(i*LOG_OVERFLOW_LENGTH)-l;j++) {
				buffer[j+m]=buffer_temp[j];
				if (buffer_temp[j]=='\n') { l--; goto overflow_start; }
				if (buffer_temp[j]=='\0') goto overflow_end;
			}
			for (j=(i*LOG_OVERFLOW_LENGTH)-1-l;j>(i*LOG_OVERFLOW_LENGTH)-LOG_OVERFLOW_LENGTH-l;j--)
				for (k=0;overflow_cut[k]!='\0';k++)
					if (buffer_temp[j]==overflow_cut[k]) {
						for (n=0;overflow_add[n]!='\0';n++) buffer[j+m+n+1]=overflow_add[n];
						m=m+n; n=0; p=0;
						for (o=0;overflow_skip[n]!='\0';o++)
							for (n=0;overflow_skip[n]!='\0';n++)
								if (buffer_temp[o+j+1]==overflow_skip[n]) { p++; m--; break; }
						l=l+((i*LOG_OVERFLOW_LENGTH)-1-l-j)-p;
						i++;
						goto overflow_start;
					}
			for (n=0;overflow_add[n]!='\0';n++) buffer[j+LOG_OVERFLOW_LENGTH+m+n]=overflow_add[n];
			m=m+n; n=0;
			for (o=0;overflow_skip[n]!='\0';o++)
				for (n=0;overflow_skip[n]!='\0';n++)
					if (buffer_temp[o+j+1]==overflow_skip[n]) { l--; m--; break; }
			i++;
		}
		overflow_end:
		;
	}
	
	if ((type&LOG_MISC)==LOG_MISC) { if ((DEBUG_MISC)|(type&(LOG_WARNING|LOG_ERROR))) printf(buffer); }
	else if ((type&LOG_VERBOSE)==LOG_VERBOSE) { if (DEBUG_VERBOSE) printf(buffer); }
	else if (_log.frame_start<=crystal->fc) printf(buffer);

	fflush(stdout);
	
	#define CRASH_PAUSE TRUE
	if (type&LOG_ERROR) {
		printf(":( I crashed. ");
		fflush(stdin);
		fflush(stdout);
		if (CRASH_PAUSE) system("PAUSE");
		else printf("\n");
	}
}

void LOG_BIN(int logtype,DWORD number,const char* c)
{
	int j,i=7;
	if (number&0xff00) i=15;
	if (number&0xffff0000) i=31;
	for (j=i;j>=0;j--) LOG(logtype,"%d",number>>j&1);
	LOG(logtype,c);
}
