#include <stdlib.h>
#include <stdio.h>
#include <string.h>
int stricmp (const char*, const char*);
#include <windows.h>

#include "unzip.h"

#include "global.h"
#include "log.h"
#include "file.h"
#include "crc32.h"

static struct {
	FILE* fd;
	unzFile zfd;
	
	char zipext[16];
} filedes;

static struct {
	FILE* fd;
	unzFile zfd;
	
	int offset;
	BYTE patching;
	BYTE rle;
	DWORD address;
	WORD bytes;
	BYTE* buffer;
	WORD buffer_offset;
} patch;

static DWORD crc32_lookuptable[256];

int file_open (void)
{
	int i;
	BYTE o;
	char fn[STRING_SIZE];
	int len=strlen(file->filename);
	unz_file_info info;
	file->is_zip=FALSE;
	
	if (len==0) return FALSE;
	if(len>3) if (stricmp(file->filename+len-4,".zip")==0) file->is_zip=TRUE;
	
	if (file->is_zip)
	{
		if ((filedes.zfd=unzOpen(file->filename))==NULL) return FALSE;
		unzGoToFirstFile(filedes.zfd);

		for (i=0;;i++)
		{
			memset(&info,0,sizeof(info));
			memset(fn,0,STRING_SIZE);
			unzGetCurrentFileInfo(
				filedes.zfd,	/* file */
				&info,		/* info */
				fn,		/* filename */
				sizeof(char)*STRING_SIZE,	/* filename size */
				NULL,0,		/* extra field, extra field size */
				NULL,0		/* comment, comment size */
			);
			len=strlen(fn);
			if (len>3) if (stricmp(fn+len-4,filedes.zipext)==0) break;
			
			if (unzGoToNextFile(filedes.zfd)!=0) { unzGoToFirstFile(filedes.zfd); break; }
		}
		
		unzOpenCurrentFile(filedes.zfd);
		file->crc32=(DWORD)info.crc;
		file->size=(DWORD)info.uncompressed_size;
		memcpy(file->filename_inzip,fn,STRING_SIZE);
	}
	else
	{
		if ((filedes.fd=fopen(file->filename,"rb"))==NULL) return FALSE;
		else {
			file->crc32=~0;
			file->size=0;
			for (;;) {
				if (!fread(&o,1,1,filedes.fd)) break;
				file->size++;
				o^=(file->crc32&0xff);
				file->crc32=file->crc32>>8^crc32_lookuptable[o];
			}
			file->crc32=~file->crc32;
			memset(file->filename_inzip,0,STRING_SIZE);
			clearerr(filedes.fd);
			fseek(filedes.fd,0,0);
		}
	}
	return TRUE;
}

int file_save(void)
{
	if ((filedes.fd=fopen(file->filename,"wb"))==NULL) return FALSE;
	return TRUE;
}

void file_close(void)
{
	if (filedes.fd!=NULL) { clearerr(filedes.fd); fclose(filedes.fd); filedes.fd=NULL; }
	if (filedes.zfd!=NULL) { unzCloseCurrentFile(filedes.zfd); unzClose(filedes.zfd); filedes.zfd=NULL; }
}

int file_patch_init(void)
{
	BYTE pc[5];

	LOG(LOG_MISC,"applying patch (%sIPS)\n",file->is_zip?"zipped ":"");
	memset(pc,0,5);
	if ((patch.buffer=malloc(0x10000))==NULL) { LOG(LOG_MISC|LOG_ERROR,"patch buffer allocation error!\n"); exit(1); }
	if (!file_read(pc,5)) { LOG(LOG_MISC|LOG_WARNING,"patch read error\n"); return FALSE; }
	if (memcmp(pc,"PATCH",5)!=0) { LOG(LOG_MISC|LOG_WARNING,"bad patch header\n"); return FALSE; }
	patch.fd=filedes.fd;
	patch.zfd=filedes.zfd;
	filedes.fd=filedes.zfd=NULL;
	patch.patching=TRUE;
	patch.bytes=patch.offset=0;
	
	return TRUE;
}

void file_patch_close(void)
{
	if (patch.buffer!=NULL) { free(patch.buffer); patch.buffer=NULL; }
	if (patch.fd!=NULL) { clearerr(patch.fd); fclose(patch.fd); patch.fd=NULL; }
	if (patch.zfd!=NULL) { unzCloseCurrentFile(patch.zfd); unzClose(patch.zfd); patch.zfd=NULL; }
	patch.patching=FALSE;
}

#define FILE_READ_DES(x,d,s)	c=TRUE; \
				if (x.fd!=NULL) { if (!fread(d,1,s,x.fd)) c=FALSE; } \
				else { if (!unzReadCurrentFile(x.zfd,d,s)) c=FALSE; }
int file_read (BYTE* dest,const int size)
{
	BYTE c;
	int o;
	const int offset_max=patch.offset+size;
	const int offset_old=patch.offset;
	if (patch.patching) {
		for (;patch.offset!=offset_max;) {
			if (patch.bytes) { /* get source data */
				o=offset_max-patch.offset;
				if (patch.address<=patch.offset) { /* patch */
					if (o>patch.bytes) o=patch.bytes;
					FILE_READ_DES(filedes,dest+patch.offset-offset_old,o); /* dummy read to increase file pointer. */
					if (patch.rle) {
						memset(dest+patch.offset-offset_old,patch.buffer[2],o);
						if (size>=FILE_PATCH_SHOW_SIZE) LOG(LOG_MISC,"r"); /* rle */
					}
					else {
						memcpy(dest+patch.offset-offset_old,patch.buffer+patch.buffer_offset,o);
						patch.buffer_offset+=o;
						if (size>=FILE_PATCH_SHOW_SIZE) LOG(LOG_MISC,"p"); /* patch */
					}
					patch.bytes-=o;
					patch.offset+=o;
				}
				else { /* normal read */
					if (o>patch.address-patch.offset) o=patch.address-patch.offset;
					FILE_READ_DES(filedes,dest+patch.offset-offset_old,o);
					if (!c) { /* no return on error: patched result size may be larger than source size */
						memset(dest+patch.offset-offset_old,0,o);
						if (size>=FILE_PATCH_SHOW_SIZE) LOG(LOG_MISC,"e"); /* extend */
					}
					patch.offset+=o;
				}
			}
			else { /* get patch data */
				memset(patch.buffer,0,5);
				FILE_READ_DES(patch,patch.buffer,5);
				if (!c) { LOG(LOG_MISC|LOG_WARNING,"patch read error at address fetch!\n"); return FALSE; }
				patch.address=patch.buffer[0]<<16|patch.buffer[1]<<8|patch.buffer[2]; /* next address/offset */
				patch.bytes=patch.buffer[3]<<8|patch.buffer[4]; /* #of bytes to patch */
				if ((patch.address&0x00ffffff)==0x454f46) { /* eof */
					patch.patching=FALSE;
					patch.bytes=1;
					patch.address=~0;
				}
				else {
					if (patch.address<patch.offset) { LOG(LOG_MISC|LOG_WARNING,"patch read error: recursive address!\n"); return FALSE; }
					if (patch.bytes==0) { /* 0=rle patching */
						patch.rle=TRUE;
						memset(patch.buffer,0,3);
						FILE_READ_DES(patch,patch.buffer,3);
						if (!c) { LOG(LOG_MISC|LOG_WARNING,"patch read error at RLE fetch!\n"); return FALSE; }
						patch.bytes=patch.buffer[0]<<8|patch.buffer[1];
						if (patch.bytes==0) { LOG(LOG_MISC|LOG_WARNING,"patch read error at RLE fetch: 0 bytes!\n"); return FALSE; }
					}
					else { /* normal patching */
						patch.buffer_offset=patch.rle=0;
						memset(patch.buffer,0,patch.bytes);
						FILE_READ_DES(patch,patch.buffer,patch.bytes);
						if (!c) { LOG(LOG_MISC|LOG_WARNING,"patch read error at bytes fetch!\n"); return FALSE; }
					}
				}
			}
		}
	}
	else { FILE_READ_DES(filedes,dest,size); return c; }
	return TRUE;
}

int file_write(const BYTE* source,const int size)
{
	if (!fwrite(source,1,size,filedes.fd)) return FALSE;
	return TRUE;
}

void file_init(void)
{
	int i;
	char temp[STRING_SIZE];
	DWORD crc32,c;
	
	if((file=malloc(sizeof(File)))==NULL) { LOG(LOG_MISC|LOG_ERROR,"file struct allocation error!\n"); exit(1); }
	memset(file,0,sizeof(File));
	memset(&filedes,0,sizeof(filedes));
	memset(&patch,0,sizeof(patch));
	
	/* precalculate crc32 polynomials, only for little endian */
	for (c=0;c<256;c++) {
		crc32=c;
		for (i=0;i<8;i++) {
			if (crc32&1) crc32=crc32>>1^0xEDB88320;
			else crc32>>=1;
		}
		crc32_lookuptable[c]=crc32;
	}
	
	/* get exe path */
	GetModuleFileName(NULL,file->appdir,STRING_SIZE);
	for (i=strlen(file->appdir)-1;(file->appdir[i]!='\\')&(file->appdir[i]!='/');i--) file->appdir[i]='\0'; file->appdir[i]='\0';
	
	/* get exe filename without extension */
	memset(temp,0,sizeof(char)*STRING_SIZE);
	GetModuleFileName(NULL,temp,STRING_SIZE);
	strcpy(file->appname,temp+i+1);
	for (i=strlen(file->appname)-1;(file->appname[i]!='.')&(i>0);i--) ;
	if (i>0) file->appname[i]='\0';
	
	if (SetCurrentDirectory(file->appdir)==FALSE) { LOG(LOG_MISC|LOG_ERROR,"couldn't locate application directory!\n"); exit(1); }
	
	/* locate/create standard dirs */
	file_locatedirectory(TRUE,file->batterydir,"sram");
	file_locatedirectory(TRUE,file->patchdir,"patch");
	file_locatedirectory(TRUE,file->palettedir,"palette");

	LOG(LOG_VERBOSE,"file I/O initialised\n");
}

void file_clean(void)
{
	file_close();
	if (file!=NULL) { free(file); file=NULL; }
	
	LOG(LOG_VERBOSE,"file I/O cleaned\n");
}

void file_setfile(const char* filename,const char* zipextension)
{
	int i;
	char temp[STRING_SIZE];
	if (filename!=NULL) {
		i=strlen(filename);
		if (i>STRING_SIZE) { LOG(LOG_MISC|LOG_ERROR,"filename too long!\n"); exit(1); }
		else {
			/* create filename without quotes */
			strcpy(temp,filename);
			if (temp[i-1]==34) temp[i-1]='\0';
			strcpy(file->filename,temp+(filename[0]==34));
			
			/* create name without path or extension */
			strcpy(temp,file->filename);
			for (i=strlen(temp)-1;(temp[i]!='.')&(i>0);i--) ;
			if (i) temp[i]='\0';
			for (i=strlen(temp)-1;(temp[i]!='\\')&(temp[i]!='/')&(i>0);i--) ;
			if (i) strcpy(file->name,temp+i+1);
			else strcpy(file->name,temp);
		}
	}
	else LOG(LOG_MISC|LOG_WARNING,"no file given!\n");
	if (zipextension!=NULL) strcpy(filedes.zipext,zipextension);
}

int file_locatedirectory(int create,char* dest,const char* dir)
{
	char temp[STRING_SIZE];
	int ret=TRUE;
	
	sprintf(dest,"%s\\%s",file->appdir,dir);
	if (create) {
		sprintf(temp,"%s\\",dest);
		SetLastError(2);
		CreateDirectory(temp,NULL);
		if (GetLastError()!=ERROR_ALREADY_EXISTS) LOG(LOG_MISC,"created %s directory: %s\n",dir,dest);
	}
	if (SetCurrentDirectory(dest)==FALSE) {
		LOG(LOG_MISC|LOG_WARNING,"couldn't locate %s directory!\n",dir);
		strcpy(dest,file->appdir);
		ret=FALSE;
	}
	SetCurrentDirectory(file->appdir);
	
	return ret;
}
