#ifndef CRYSTAL_H
#define CRYSTAL_H

#define CRYSTAL_PPU_CYCLE_FIXED	5

typedef struct {
	int lines;
	int cycle;
	int frame;
	int full_scanline;
	int hblank;
	int vblank_trigger;
	
	int ppu_scanline;
	int ppu_cycle;
	
	BYTE mode;
	int hc[313];		/* hblank counter: start of each hblank */
	int sc[313];		/* scanline counter: start of each scanline */
	
	BYTE odd_frame;
	QWORD fc;
} Crystal;

Crystal* crystal;

void crystal_set_mode(BYTE);
void crystal_new_frame(void);
void crystal_init(void);
void crystal_clean(void);

#endif /* CRYSTAL_H */
